#! /bin/sh

# Copyright 2000, 2001, 2014 by Martin Pool

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1 of
# the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


# This script generates everything necessary to build librsync from a bare
# source tree.  It is based on the file of the same name in glib.  It is not
# needed for distributed versions, because all the necessary files are included
# in the tarball by autoconf.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

ORIGDIR=`pwd`
cd $srcdir
PROJECT=librsync
TEST_TYPE=-f
FILE=librsync.h

DIE=0

cache="$srcdir/autom4te.cache"
test -d "$cache" && {
        echo "Deleting $cache"
        rm -Rf "$cache"
}

# ChangeLog is autogenerated, and must be deleted otherwise automake makes 
# assumptions about its existance.
changelog="$srcdir/ChangeLog"
test -f "$changelog" && {
        echo "Deleting $changelog"
        rm -Rf "$changelog"
}

(autoconf --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have autoconf installed to compile $PROJECT."
	echo "Download the appropriate package for your distribution,"
	echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
	DIE=1
}

(automake --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have automake installed to compile $PROJECT."
	echo "Download the appropriate package for your distribution,"
	echo "or get ftp://sourceware.cygnus.com/pub/automake/automake-1.4.tar.gz"
	echo "(or a newer version if it is available)"
	DIE=1
}

if [ -z "$LIBTOOLIZE" ]
then
        LIBTOOLIZE=libtoolize
fi

($LIBTOOLIZE --version) < /dev/null > /dev/null 2>&1 || {
	echo
	echo "You must have libtool installed to compile $PROJECT."
	echo "Download the appropriate package for your distribution,"
	echo "or go to http://www.gnu.org/software/libtool/"
	echo "You can set $LIBTOOLIZE."
	DIE=1
}

if test "$DIE" -eq 1; then
	exit 1
fi

test $TEST_TYPE $FILE || {
	echo "You must run this script in the top-level $PROJECT directory"
	exit 1
}

case $CC in
*xlc | *xlc\ * | *lcc | *lcc\ *) am_opt=--include-deps;;
esac

set -x
aclocal $ACLOCAL_FLAGS
$LIBTOOLIZE --force
autoheader
automake -a --foreign $am_opt
autoconf
set +x
cd $ORIGDIR
