; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-unknown-unknown | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64-unknown-unknown -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i64 @sub1_disguised_constant(i64 %x) {
; CHECK-SD-LABEL: sub1_disguised_constant:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    sub w8, w0, #1
; CHECK-SD-NEXT:    and w8, w0, w8
; CHECK-SD-NEXT:    and x0, x8, #0xffff
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sub1_disguised_constant:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #65535 // =0xffff
; CHECK-GI-NEXT:    and x9, x0, #0xffff
; CHECK-GI-NEXT:    add x8, x0, x8
; CHECK-GI-NEXT:    and x0, x9, x8
; CHECK-GI-NEXT:    ret
  %a1 = and i64 %x, 65535
  %a2 = add i64 %x, 65535
  %r = and i64 %a1, %a2
  ret i64 %r
}

define i8 @masked_sub_i8(i8 %x) {
; CHECK-SD-LABEL: masked_sub_i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #5 // =0x5
; CHECK-SD-NEXT:    and w8, w0, w8
; CHECK-SD-NEXT:    eor w0, w8, #0x7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: masked_sub_i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #5 // =0x5
; CHECK-GI-NEXT:    mov w9, #7 // =0x7
; CHECK-GI-NEXT:    and w8, w0, w8
; CHECK-GI-NEXT:    sub w0, w9, w8
; CHECK-GI-NEXT:    ret
  %a = and i8 %x, 5
  %m = sub i8 7, %a
  ret i8 %m
}

; Borrow from the MSB is ok.

define i8 @masked_sub_high_bit_mask_i8(i8 %x) {
; CHECK-SD-LABEL: masked_sub_high_bit_mask_i8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #-96 // =0xffffffa0
; CHECK-SD-NEXT:    and w8, w0, w8
; CHECK-SD-NEXT:    eor w0, w8, #0x3c
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: masked_sub_high_bit_mask_i8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #-96 // =0xffffffa0
; CHECK-GI-NEXT:    mov w9, #60 // =0x3c
; CHECK-GI-NEXT:    and w8, w0, w8
; CHECK-GI-NEXT:    sub w0, w9, w8
; CHECK-GI-NEXT:    ret
  %maskx = and i8 %x, 160 ; 0b10100000
  %s = sub i8 60, %maskx  ; 0b00111100
  ret i8 %s
}

define i8 @not_masked_sub_i8(i8 %x) {
; CHECK-LABEL: not_masked_sub_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #7 // =0x7
; CHECK-NEXT:    and w9, w0, #0x8
; CHECK-NEXT:    sub w0, w8, w9
; CHECK-NEXT:    ret
  %a = and i8 %x, 8
  %m = sub i8 7, %a
  ret i8 %m
}

define i32 @masked_sub_i32(i32 %x) {
; CHECK-SD-LABEL: masked_sub_i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #9 // =0x9
; CHECK-SD-NEXT:    and w8, w0, w8
; CHECK-SD-NEXT:    eor w0, w8, #0x1f
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: masked_sub_i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #9 // =0x9
; CHECK-GI-NEXT:    mov w9, #31 // =0x1f
; CHECK-GI-NEXT:    and w8, w0, w8
; CHECK-GI-NEXT:    sub w0, w9, w8
; CHECK-GI-NEXT:    ret
  %a = and i32 %x, 9
  %m = sub i32 31, %a
  ret i32 %m
}

define <4 x i32> @masked_sub_v4i32(<4 x i32> %x) {
; CHECK-SD-LABEL: masked_sub_v4i32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v1.4s, #42
; CHECK-SD-NEXT:    movi v2.4s, #1, msl #8
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    eor v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: masked_sub_v4i32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.4s, #42
; CHECK-GI-NEXT:    movi v2.4s, #1, msl #8
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    sub v0.4s, v2.4s, v0.4s
; CHECK-GI-NEXT:    ret
  %a = and <4 x i32> %x, <i32 42, i32 42, i32 42, i32 42>
  %m = sub <4 x i32> <i32 511, i32 511, i32 511, i32 511>, %a
  ret <4 x i32>  %m
}

define i32 @pr137254(i32 %0) {
; CHECK-LABEL: pr137254:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-2147483648 // =0x80000000
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, gt
; CHECK-NEXT:    ret
  %2 = sub nsw i32 %0, -2147483648
  %3 = icmp sgt i32 %2, 0
  %4 = select i1 %3, i32 1, i32 0
  ret i32 %4
}
