; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=gfx1150 -amdgpu-enable-vopd=0 < %s | FileCheck -check-prefix=GCN %s

define amdgpu_ps void @test_export_zeroes_f32() #0 {
; GCN-LABEL: test_export_zeroes_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    exp mrt0 off, off, off, off
; GCN-NEXT:    exp mrt0 off, off, off, off done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 0, i32 0, float 0.0, float 0.0, float 0.0, float 0.0, i1 false, i1 false)
  call void @llvm.amdgcn.exp.f32(i32 0, i32 0, float 0.0, float 0.0, float 0.0, float 0.0, i1 true, i1 false)
  ret void
}

define amdgpu_ps void @test_export_en_src0_f32() #0 {
; GCN-LABEL: test_export_en_src0_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    v_mov_b32_e32 v0, 4.0
; GCN-NEXT:    v_mov_b32_e32 v1, 0.5
; GCN-NEXT:    v_mov_b32_e32 v2, 2.0
; GCN-NEXT:    v_mov_b32_e32 v3, 1.0
; GCN-NEXT:    exp mrt0 v3, off, off, off done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 0, i32 1, float 1.0, float 2.0, float 0.5, float 4.0, i1 true, i1 false)
  ret void
}

define amdgpu_gs void @test_export_gs() #0 {
; GCN-LABEL: test_export_gs:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    v_mov_b32_e32 v0, 4.0
; GCN-NEXT:    v_mov_b32_e32 v1, 0.5
; GCN-NEXT:    v_mov_b32_e32 v2, 2.0
; GCN-NEXT:    v_mov_b32_e32 v3, 1.0
; GCN-NEXT:    exp mrt0 off, v2, off, off done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 0, i32 2, float 1.0, float 2.0, float 0.5, float 4.0, i1 true, i1 false)
  ret void
}

define amdgpu_hs void @test_export_hs() #0 {
; GCN-LABEL: test_export_hs:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    v_mov_b32_e32 v0, 4.0
; GCN-NEXT:    v_mov_b32_e32 v1, 0.5
; GCN-NEXT:    v_mov_b32_e32 v2, 2.0
; GCN-NEXT:    v_mov_b32_e32 v3, 1.0
; GCN-NEXT:    exp mrt0 off, v2, off, off done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 0, i32 2, float 1.0, float 2.0, float 0.5, float 4.0, i1 true, i1 false)
  ret void
}

define amdgpu_gfx void @test_export_gfx(float %v) #0 {
; GCN-LABEL: test_export_gfx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v1, 4.0
; GCN-NEXT:    v_mov_b32_e32 v2, 0.5
; GCN-NEXT:    v_mov_b32_e32 v3, 2.0
; GCN-NEXT:    exp mrt0 off, v3, off, off done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_waitcnt_expcnt null, 0x0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_waitcnt expcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  call void @llvm.amdgcn.exp.f32(i32 0, i32 2, float %v, float 2.0, float 0.5, float 4.0, i1 true, i1 false)
  ret void
}

define amdgpu_cs void @test_export_cs() #0 {
; GCN-LABEL: test_export_cs:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, 4.0
; GCN-NEXT:    v_mov_b32_e32 v1, 0.5
; GCN-NEXT:    v_mov_b32_e32 v2, 2.0
; GCN-NEXT:    v_mov_b32_e32 v3, 1.0
; GCN-NEXT:    exp mrt0 off, v2, off, off done
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 0, i32 2, float 1.0, float 2.0, float 0.5, float 4.0, i1 true, i1 false)
  ret void
}

define amdgpu_kernel void @test_export_kernel() #0 {
; GCN-LABEL: test_export_kernel:
; GCN:       ; %bb.0:
; GCN-NEXT:    v_mov_b32_e32 v0, 4.0
; GCN-NEXT:    v_mov_b32_e32 v1, 0.5
; GCN-NEXT:    v_mov_b32_e32 v2, 2.0
; GCN-NEXT:    v_mov_b32_e32 v3, 1.0
; GCN-NEXT:    exp mrt0 off, v2, off, off done
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 0, i32 2, float 1.0, float 2.0, float 0.5, float 4.0, i1 true, i1 false)
  ret void
}

define amdgpu_gfx void @test_no_export_gfx(float %v) #0 {
; GCN-LABEL: test_no_export_gfx:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  ret void
}

define amdgpu_ps void @test_no_export_ps(float %v) #0 {
; GCN-LABEL: test_no_export_ps:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_endpgm
  ret void
}

define amdgpu_ps void @test_if_export_f32(i32 %flag, float %x, float %y, float %z, float %w) #0 {
; GCN-LABEL: test_if_export_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_mov_b32 s0, exec_lo
; GCN-NEXT:    v_cmpx_ne_u32_e32 0, v0
; GCN-NEXT:    s_cbranch_execz .LBB9_2
; GCN-NEXT:  ; %bb.1: ; %exp
; GCN-NEXT:    exp mrt0 v1, v2, v3, v4
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_waitcnt_expcnt null, 0x0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:  .LBB9_2: ; %end
; GCN-NEXT:    s_endpgm
  %cc = icmp eq i32 %flag, 0
  br i1 %cc, label %end, label %exp

exp:
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %x, float %y, float %z, float %w, i1 false, i1 false)
  br label %end

end:
  ret void
}

define amdgpu_ps void @test_if_export_vm_f32(i32 %flag, float %x, float %y, float %z, float %w) #0 {
; GCN-LABEL: test_if_export_vm_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_mov_b32 s0, exec_lo
; GCN-NEXT:    v_cmpx_ne_u32_e32 0, v0
; GCN-NEXT:    s_cbranch_execz .LBB10_2
; GCN-NEXT:  ; %bb.1: ; %exp
; GCN-NEXT:    exp mrt0 v1, v2, v3, v4
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_waitcnt_expcnt null, 0x0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:  .LBB10_2: ; %end
; GCN-NEXT:    s_endpgm
  %cc = icmp eq i32 %flag, 0
  br i1 %cc, label %end, label %exp

exp:
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %x, float %y, float %z, float %w, i1 false, i1 true)
  br label %end

end:
  ret void
}

define amdgpu_ps void @test_if_export_done_f32(i32 %flag, float %x, float %y, float %z, float %w) #0 {
; GCN-LABEL: test_if_export_done_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_mov_b32 s0, exec_lo
; GCN-NEXT:    v_cmpx_ne_u32_e32 0, v0
; GCN-NEXT:    s_cbranch_execz .LBB11_2
; GCN-NEXT:  ; %bb.1: ; %exp
; GCN-NEXT:    exp mrt0 v1, v2, v3, v4 done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_waitcnt_expcnt null, 0x0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:  .LBB11_2: ; %end
; GCN-NEXT:    s_endpgm
  %cc = icmp eq i32 %flag, 0
  br i1 %cc, label %end, label %exp

exp:
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %x, float %y, float %z, float %w, i1 true, i1 false)
  br label %end

end:
  ret void
}

define amdgpu_ps void @test_if_export_vm_done_f32(i32 %flag, float %x, float %y, float %z, float %w) #0 {
; GCN-LABEL: test_if_export_vm_done_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_mov_b32 s0, exec_lo
; GCN-NEXT:    v_cmpx_ne_u32_e32 0, v0
; GCN-NEXT:    s_cbranch_execz .LBB12_2
; GCN-NEXT:  ; %bb.1: ; %exp
; GCN-NEXT:    exp mrt0 v1, v2, v3, v4 done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_waitcnt_expcnt null, 0x0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:  .LBB12_2: ; %end
; GCN-NEXT:    s_endpgm
  %cc = icmp eq i32 %flag, 0
  br i1 %cc, label %end, label %exp

exp:
  call void @llvm.amdgcn.exp.f32(i32 0, i32 15, float %x, float %y, float %z, float %w, i1 true, i1 true)
  br label %end

end:
  ret void
}

define amdgpu_ps void @test_export_pos_before_param_across_load(i32 %idx) #0 {
; GCN-LABEL: test_export_pos_before_param_across_load:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    buffer_load_b32 v0, v0, s[0:3], 0 offen
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    v_mov_b32_e32 v2, 1.0
; GCN-NEXT:    v_mov_b32_e32 v3, 0.5
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    exp pos0 v1, v1, v1, v0 done
; GCN-NEXT:    exp invalid_target_32 v2, v2, v2, v2
; GCN-NEXT:    exp invalid_target_33 v2, v2, v2, v3
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_endpgm
  call void @llvm.amdgcn.exp.f32(i32 32, i32 15, float 1.0, float 1.0, float 1.0, float 1.0, i1 false, i1 false)
  call void @llvm.amdgcn.exp.f32(i32 33, i32 15, float 1.0, float 1.0, float 1.0, float 0.5, i1 false, i1 false)
  %load = call float @llvm.amdgcn.raw.ptr.buffer.load.f32(ptr addrspace(8) poison, i32 %idx, i32 0, i32 0)
  call void @llvm.amdgcn.exp.f32(i32 12, i32 15, float 0.0, float 0.0, float 0.0, float %load, i1 true, i1 false)
  ret void
}

define amdgpu_ps void @test_export_across_store_load(i32 %idx, float %v) #0 {
; GCN-LABEL: test_export_across_store_load:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GCN-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GCN-NEXT:    v_cndmask_b32_e32 v0, 16, v2, vcc_lo
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    scratch_store_b32 v0, v1, off
; GCN-NEXT:    scratch_load_b32 v0, off, off
; GCN-NEXT:    v_mov_b32_e32 v1, 1.0
; GCN-NEXT:    exp pos0 v2, v2, v2, v1 done
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_waitcnt_expcnt null, 0x0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    exp invalid_target_32 v0, v2, v1, v2
; GCN-NEXT:    exp invalid_target_33 v0, v2, v1, v2
; GCN-NEXT:    s_setprio 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    s_endpgm
  %data0 = alloca <4 x float>, align 8, addrspace(5)
  %data1 = alloca <4 x float>, align 8, addrspace(5)
  %cmp = icmp eq i32 %idx, 1
  %data = select i1 %cmp, ptr addrspace(5) %data0, ptr addrspace(5) %data1
  store float %v, ptr addrspace(5) %data, align 8
  call void @llvm.amdgcn.exp.f32(i32 12, i32 15, float 0.0, float 0.0, float 0.0, float 1.0, i1 true, i1 false)
  %load0 = load float, ptr addrspace(5) %data0, align 8
  call void @llvm.amdgcn.exp.f32(i32 32, i32 15, float %load0, float 0.0, float 1.0, float 0.0, i1 false, i1 false)
  call void @llvm.amdgcn.exp.f32(i32 33, i32 15, float %load0, float 0.0, float 1.0, float 0.0, i1 false, i1 false)
  ret void
}

define amdgpu_ps void @test_export_in_callee(float %v) #0 {
; GCN-LABEL: test_export_in_callee:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_getpc_b64 s[0:1]
; GCN-NEXT:    s_add_u32 s0, s0, test_export_gfx@gotpcrel32@lo+4
; GCN-NEXT:    s_addc_u32 s1, s1, test_export_gfx@gotpcrel32@hi+12
; GCN-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GCN-NEXT:    s_mov_b32 s32, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GCN-NEXT:    s_endpgm
  %x = fadd float %v, 1.0
  call amdgpu_gfx void @test_export_gfx(float %x)
  ret void
}

define amdgpu_ps void @test_export_in_callee_prio(float %v) #0 {
; GCN-LABEL: test_export_in_callee_prio:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_mov_b32 s32, 0
; GCN-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GCN-NEXT:    s_setprio 2
; GCN-NEXT:    s_getpc_b64 s[0:1]
; GCN-NEXT:    s_add_u32 s0, s0, test_export_gfx@gotpcrel32@lo+4
; GCN-NEXT:    s_addc_u32 s1, s1, test_export_gfx@gotpcrel32@hi+12
; GCN-NEXT:    s_load_b64 s[0:1], s[0:1], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GCN-NEXT:    s_endpgm
  %x = fadd float %v, 1.0
  call void @llvm.amdgcn.s.setprio(i16 0)
  call amdgpu_gfx void @test_export_gfx(float %x)
  ret void
}

declare void @llvm.amdgcn.exp.f32(i32, i32, float, float, float, float, i1, i1) #1
declare void @llvm.amdgcn.exp.i32(i32, i32, i32, i32, i32, i32, i1, i1) #1
declare float @llvm.amdgcn.raw.ptr.buffer.load.f32(ptr addrspace(8), i32, i32, i32) #2
declare void @llvm.amdgcn.s.setprio(i16)

attributes #0 = { nounwind }
attributes #1 = { nounwind inaccessiblememonly }
attributes #2 = { nounwind readnone }
