; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -mattr=+zdinx -target-abi=ilp32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32FINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx -target-abi=lp64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64FINX %s

@gd = external global double

define double @constraint_r_double(double %a) nounwind {
; RV32FINX-LABEL: constraint_r_double:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a2, %hi(gd)
; RV32FINX-NEXT:    lw a3, %lo(gd+4)(a2)
; RV32FINX-NEXT:    lw a2, %lo(gd)(a2)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.d a0, a0, a2
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_r_double:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gd)
; RV64FINX-NEXT:    ld a1, %lo(gd)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.d a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm "fadd.d $0, $1, $2", "=r,r,r"(double %a, double %1)
  ret double %2
}

define double @constraint_cr_double(double %a) nounwind {
; RV32FINX-LABEL: constraint_cr_double:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a2, %hi(gd)
; RV32FINX-NEXT:    lw a3, %lo(gd+4)(a2)
; RV32FINX-NEXT:    lw a2, %lo(gd)(a2)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.d a0, a0, a2
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_cr_double:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gd)
; RV64FINX-NEXT:    ld a1, %lo(gd)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.d a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm "fadd.d $0, $1, $2", "=^cr,^cr,^cr"(double %a, double %1)
  ret double %2
}

define double @constraint_double_abi_name(double %a) nounwind {
; RV32FINX-LABEL: constraint_double_abi_name:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    addi sp, sp, -16
; RV32FINX-NEXT:    sw s0, 12(sp) # 4-byte Folded Spill
; RV32FINX-NEXT:    sw s1, 8(sp) # 4-byte Folded Spill
; RV32FINX-NEXT:    lui a2, %hi(gd)
; RV32FINX-NEXT:    lw s0, %lo(gd)(a2)
; RV32FINX-NEXT:    lw s1, %lo(gd+4)(a2)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.d t1, a0, s0
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    mv a0, t1
; RV32FINX-NEXT:    mv a1, t2
; RV32FINX-NEXT:    lw s0, 12(sp) # 4-byte Folded Reload
; RV32FINX-NEXT:    lw s1, 8(sp) # 4-byte Folded Reload
; RV32FINX-NEXT:    addi sp, sp, 16
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_double_abi_name:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    addi sp, sp, -16
; RV64FINX-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; RV64FINX-NEXT:    lui a1, %hi(gd)
; RV64FINX-NEXT:    ld s0, %lo(gd)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.d t1, a0, s0
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    mv a0, t1
; RV64FINX-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; RV64FINX-NEXT:    addi sp, sp, 16
; RV64FINX-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm "fadd.d $0, $1, $2", "={t1},{a0},{s0}"(double %a, double %1)
  ret double %2
}

define double @constraint_f_double(double %a) nounwind {
; RV32FINX-LABEL: constraint_f_double:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a2, %hi(gd)
; RV32FINX-NEXT:    lw a3, %lo(gd+4)(a2)
; RV32FINX-NEXT:    lw a2, %lo(gd)(a2)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.d a0, a0, a2
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_f_double:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gd)
; RV64FINX-NEXT:    ld a1, %lo(gd)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.d a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm "fadd.d $0, $1, $2", "=f,f,f"(double %a, double %1)
  ret double %2
}

define double @constraint_cf_double(double %a) nounwind {
; RV32FINX-LABEL: constraint_cf_double:
; RV32FINX:       # %bb.0:
; RV32FINX-NEXT:    lui a2, %hi(gd)
; RV32FINX-NEXT:    lw a3, %lo(gd+4)(a2)
; RV32FINX-NEXT:    lw a2, %lo(gd)(a2)
; RV32FINX-NEXT:    #APP
; RV32FINX-NEXT:    fadd.d a0, a0, a2
; RV32FINX-NEXT:    #NO_APP
; RV32FINX-NEXT:    ret
;
; RV64FINX-LABEL: constraint_cf_double:
; RV64FINX:       # %bb.0:
; RV64FINX-NEXT:    lui a1, %hi(gd)
; RV64FINX-NEXT:    ld a1, %lo(gd)(a1)
; RV64FINX-NEXT:    #APP
; RV64FINX-NEXT:    fadd.d a0, a0, a1
; RV64FINX-NEXT:    #NO_APP
; RV64FINX-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm "fadd.d $0, $1, $2", "=^cf,^cf,^cf"(double %a, double %1)
  ret double %2
}
