; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfh,+f,+d -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfh,+f,+d -verify-machineinstrs < %s | FileCheck %s

define void @fpext_v2f16_v2f32(ptr %x, ptr %y) {
; CHECK-LABEL: fpext_v2f16_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vse32.v v9, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x half>, ptr %x
  %d = fpext <2 x half> %a to <2 x float>
  store <2 x float> %d, ptr %y
  ret void
}

define void @fpext_v2f16_v2f64(ptr %x, ptr %y) {
; CHECK-LABEL: fpext_v2f16_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x half>, ptr %x
  %d = fpext <2 x half> %a to <2 x double>
  store <2 x double> %d, ptr %y
  ret void
}

define void @fpext_v8f16_v8f32(ptr %x, ptr %y) {
; CHECK-LABEL: fpext_v8f16_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %d = fpext <8 x half> %a to <8 x float>
  store <8 x float> %d, ptr %y
  ret void
}

define void @fpext_v8f16_v8f64(ptr %x, ptr %y) {
; CHECK-LABEL: fpext_v8f16_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x half>, ptr %x
  %d = fpext <8 x half> %a to <8 x double>
  store <8 x double> %d, ptr %y
  ret void
}

define void @fpround_v2f32_v2f16(ptr %x, ptr %y) {
; CHECK-LABEL: fpround_v2f32_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.f.w v9, v8
; CHECK-NEXT:    vse16.v v9, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x float>, ptr %x
  %d = fptrunc <2 x float> %a to <2 x half>
  store <2 x half> %d, ptr %y
  ret void
}

define void @fpround_v2f64_v2f16(ptr %x, ptr %y) {
; CHECK-LABEL: fpround_v2f64_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.rod.f.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, ptr %x
  %d = fptrunc <2 x double> %a to <2 x half>
  store <2 x half> %d, ptr %y
  ret void
}

define void @fpround_v8f32_v8f16(ptr %x, ptr %y) {
; CHECK-LABEL: fpround_v8f32_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfncvt.f.f.w v10, v8
; CHECK-NEXT:    vse16.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, ptr %x
  %d = fptrunc <8 x float> %a to <8 x half>
  store <8 x half> %d, ptr %y
  ret void
}

define void @fpround_v8f64_v8f16(ptr %x, ptr %y) {
; CHECK-LABEL: fpround_v8f64_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfncvt.rod.f.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    vse16.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, ptr %x
  %d = fptrunc <8 x double> %a to <8 x half>
  store <8 x half> %d, ptr %y
  ret void
}
