; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=zEC12 -verify-machineinstrs \
; RUN:   | FileCheck %s --check-prefix=NOVEC
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z16 -verify-machineinstrs \
; RUN:   | FileCheck %s  --check-prefix=VECTOR

; Add the <8 x half> argument with itself and return it.
define <8 x half> @fun0(<8 x half> %Op) {
; NOVEC-LABEL: fun0:
; NOVEC:       # %bb.0: # %entry
; NOVEC-NEXT:    stmg %r13, %r15, 104(%r15)
; NOVEC-NEXT:    .cfi_offset %r13, -56
; NOVEC-NEXT:    .cfi_offset %r14, -48
; NOVEC-NEXT:    .cfi_offset %r15, -40
; NOVEC-NEXT:    aghi %r15, -224
; NOVEC-NEXT:    .cfi_def_cfa_offset 384
; NOVEC-NEXT:    std %f8, 216(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f9, 208(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f10, 200(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f11, 192(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f12, 184(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f13, 176(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f14, 168(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f15, 160(%r15) # 8-byte Spill
; NOVEC-NEXT:    .cfi_offset %f8, -168
; NOVEC-NEXT:    .cfi_offset %f9, -176
; NOVEC-NEXT:    .cfi_offset %f10, -184
; NOVEC-NEXT:    .cfi_offset %f11, -192
; NOVEC-NEXT:    .cfi_offset %f12, -200
; NOVEC-NEXT:    .cfi_offset %f13, -208
; NOVEC-NEXT:    .cfi_offset %f14, -216
; NOVEC-NEXT:    .cfi_offset %f15, -224
; NOVEC-NEXT:    lgh %r0, 414(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f14, %r0
; NOVEC-NEXT:    lgh %r0, 406(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f12, %r0
; NOVEC-NEXT:    lgh %r0, 398(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f9, %r0
; NOVEC-NEXT:    lgh %r0, 390(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ler %f10, %f6
; NOVEC-NEXT:    ler %f11, %f4
; NOVEC-NEXT:    ler %f13, %f2
; NOVEC-NEXT:    ler %f15, %f0
; NOVEC-NEXT:    lgr %r13, %r2
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    # kill: def $f0h killed $f0h killed $f0d
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f8, %f0
; NOVEC-NEXT:    ler %f0, %f9
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f9, %f0
; NOVEC-NEXT:    ler %f0, %f12
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f12, %f0
; NOVEC-NEXT:    ler %f0, %f14
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f14, %f0
; NOVEC-NEXT:    ler %f0, %f15
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f15, %f0
; NOVEC-NEXT:    ler %f0, %f13
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f13, %f0
; NOVEC-NEXT:    ler %f0, %f11
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f11, %f0
; NOVEC-NEXT:    ler %f0, %f10
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    # kill: def $f0h killed $f0h def $f0d
; NOVEC-NEXT:    lgdr %r0, %f0
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 6(%r13)
; NOVEC-NEXT:    lgdr %r0, %f11
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 4(%r13)
; NOVEC-NEXT:    lgdr %r0, %f13
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 2(%r13)
; NOVEC-NEXT:    lgdr %r0, %f15
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 0(%r13)
; NOVEC-NEXT:    lgdr %r0, %f14
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 14(%r13)
; NOVEC-NEXT:    lgdr %r0, %f12
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 12(%r13)
; NOVEC-NEXT:    lgdr %r0, %f9
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 10(%r13)
; NOVEC-NEXT:    lgdr %r0, %f8
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 8(%r13)
; NOVEC-NEXT:    ld %f8, 216(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f9, 208(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f10, 200(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f11, 192(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f12, 184(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f13, 176(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f14, 168(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f15, 160(%r15) # 8-byte Reload
; NOVEC-NEXT:    lmg %r13, %r15, 328(%r15)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: fun0:
; VECTOR:       # %bb.0: # %entry
; VECTOR-NEXT:    stmg %r13, %r15, 104(%r15)
; VECTOR-NEXT:    .cfi_offset %r13, -56
; VECTOR-NEXT:    .cfi_offset %r14, -48
; VECTOR-NEXT:    .cfi_offset %r15, -40
; VECTOR-NEXT:    aghi %r15, -224
; VECTOR-NEXT:    .cfi_def_cfa_offset 384
; VECTOR-NEXT:    std %f8, 216(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f9, 208(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f10, 200(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f11, 192(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f12, 184(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f13, 176(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f14, 168(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f15, 160(%r15) # 8-byte Spill
; VECTOR-NEXT:    .cfi_offset %f8, -168
; VECTOR-NEXT:    .cfi_offset %f9, -176
; VECTOR-NEXT:    .cfi_offset %f10, -184
; VECTOR-NEXT:    .cfi_offset %f11, -192
; VECTOR-NEXT:    .cfi_offset %f12, -200
; VECTOR-NEXT:    .cfi_offset %f13, -208
; VECTOR-NEXT:    .cfi_offset %f14, -216
; VECTOR-NEXT:    .cfi_offset %f15, -224
; VECTOR-NEXT:    vlreph %v11, 414(%r15)
; VECTOR-NEXT:    vlreph %v12, 406(%r15)
; VECTOR-NEXT:    vlreph %v13, 398(%r15)
; VECTOR-NEXT:    vlreph %v14, 390(%r15)
; VECTOR-NEXT:    ldr %f8, %f6
; VECTOR-NEXT:    ldr %f9, %f4
; VECTOR-NEXT:    ldr %f10, %f2
; VECTOR-NEXT:    lgr %r13, %r2
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f15, %f0
; VECTOR-NEXT:    ldr %f0, %f10
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f10, %f0
; VECTOR-NEXT:    ldr %f0, %f9
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f9, %f0
; VECTOR-NEXT:    ldr %f0, %f8
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f8, %f0
; VECTOR-NEXT:    ldr %f0, %f14
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f14, %f0
; VECTOR-NEXT:    ldr %f0, %f13
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f13, %f0
; VECTOR-NEXT:    ldr %f0, %f12
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f12, %f0
; VECTOR-NEXT:    ldr %f0, %f11
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    vsteh %v0, 14(%r13), 0
; VECTOR-NEXT:    vsteh %v12, 12(%r13), 0
; VECTOR-NEXT:    vsteh %v13, 10(%r13), 0
; VECTOR-NEXT:    vsteh %v14, 8(%r13), 0
; VECTOR-NEXT:    vsteh %v8, 6(%r13), 0
; VECTOR-NEXT:    vsteh %v9, 4(%r13), 0
; VECTOR-NEXT:    vsteh %v10, 2(%r13), 0
; VECTOR-NEXT:    vsteh %v15, 0(%r13), 0
; VECTOR-NEXT:    ld %f8, 216(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f9, 208(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f10, 200(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f11, 192(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f12, 184(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f13, 176(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f14, 168(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f15, 160(%r15) # 8-byte Reload
; VECTOR-NEXT:    lmg %r13, %r15, 328(%r15)
; VECTOR-NEXT:    br %r14
entry:
  %Res = fadd <8 x half> %Op, %Op
  ret <8 x half> %Res
}

; Same, but with partial vector values.
define <4 x half> @fun1(<4 x half> %Op) {
; NOVEC-LABEL: fun1:
; NOVEC:       # %bb.0: # %entry
; NOVEC-NEXT:    stmg %r14, %r15, 112(%r15)
; NOVEC-NEXT:    .cfi_offset %r14, -48
; NOVEC-NEXT:    .cfi_offset %r15, -40
; NOVEC-NEXT:    aghi %r15, -192
; NOVEC-NEXT:    .cfi_def_cfa_offset 352
; NOVEC-NEXT:    std %f8, 184(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f9, 176(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f10, 168(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f11, 160(%r15) # 8-byte Spill
; NOVEC-NEXT:    .cfi_offset %f8, -168
; NOVEC-NEXT:    .cfi_offset %f9, -176
; NOVEC-NEXT:    .cfi_offset %f10, -184
; NOVEC-NEXT:    .cfi_offset %f11, -192
; NOVEC-NEXT:    ler %f8, %f6
; NOVEC-NEXT:    ler %f9, %f4
; NOVEC-NEXT:    ler %f10, %f2
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f11, %f0
; NOVEC-NEXT:    ler %f0, %f10
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f10, %f0
; NOVEC-NEXT:    ler %f0, %f9
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f9, %f0
; NOVEC-NEXT:    ler %f0, %f8
; NOVEC-NEXT:    brasl %r14, __extendhfsf2@PLT
; NOVEC-NEXT:    aebr %f0, %f0
; NOVEC-NEXT:    brasl %r14, __truncsfhf2@PLT
; NOVEC-NEXT:    ler %f6, %f0
; NOVEC-NEXT:    ler %f0, %f11
; NOVEC-NEXT:    ler %f2, %f10
; NOVEC-NEXT:    ler %f4, %f9
; NOVEC-NEXT:    ld %f8, 184(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f9, 176(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f10, 168(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f11, 160(%r15) # 8-byte Reload
; NOVEC-NEXT:    lmg %r14, %r15, 304(%r15)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: fun1:
; VECTOR:       # %bb.0: # %entry
; VECTOR-NEXT:    stmg %r14, %r15, 112(%r15)
; VECTOR-NEXT:    .cfi_offset %r14, -48
; VECTOR-NEXT:    .cfi_offset %r15, -40
; VECTOR-NEXT:    aghi %r15, -192
; VECTOR-NEXT:    .cfi_def_cfa_offset 352
; VECTOR-NEXT:    std %f8, 184(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f9, 176(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f10, 168(%r15) # 8-byte Spill
; VECTOR-NEXT:    std %f11, 160(%r15) # 8-byte Spill
; VECTOR-NEXT:    .cfi_offset %f8, -168
; VECTOR-NEXT:    .cfi_offset %f9, -176
; VECTOR-NEXT:    .cfi_offset %f10, -184
; VECTOR-NEXT:    .cfi_offset %f11, -192
; VECTOR-NEXT:    ldr %f8, %f6
; VECTOR-NEXT:    ldr %f9, %f4
; VECTOR-NEXT:    ldr %f10, %f2
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f11, %f0
; VECTOR-NEXT:    ldr %f0, %f10
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f10, %f0
; VECTOR-NEXT:    ldr %f0, %f9
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f9, %f0
; VECTOR-NEXT:    ldr %f0, %f8
; VECTOR-NEXT:    brasl %r14, __extendhfsf2@PLT
; VECTOR-NEXT:    aebr %f0, %f0
; VECTOR-NEXT:    brasl %r14, __truncsfhf2@PLT
; VECTOR-NEXT:    ldr %f6, %f0
; VECTOR-NEXT:    ldr %f0, %f11
; VECTOR-NEXT:    ldr %f2, %f10
; VECTOR-NEXT:    ldr %f4, %f9
; VECTOR-NEXT:    ld %f8, 184(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f9, 176(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f10, 168(%r15) # 8-byte Reload
; VECTOR-NEXT:    ld %f11, 160(%r15) # 8-byte Reload
; VECTOR-NEXT:    lmg %r14, %r15, 304(%r15)
; VECTOR-NEXT:    br %r14
entry:
  %Res = fadd <4 x half> %Op, %Op
  ret <4 x half> %Res
}

; Test a vector extension.
define <2 x half> @fun2(<2 x half> %Op) {
; NOVEC-LABEL: fun2:
; NOVEC:       # %bb.0: # %entry
; NOVEC-NEXT:    stmg %r14, %r15, 112(%r15)
; NOVEC-NEXT:    .cfi_offset %r14, -48
; NOVEC-NEXT:    .cfi_offset %r15, -40
; NOVEC-NEXT:    aghi %r15, -176
; NOVEC-NEXT:    .cfi_def_cfa_offset 336
; NOVEC-NEXT:    std %f8, 168(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f9, 160(%r15) # 8-byte Spill
; NOVEC-NEXT:    .cfi_offset %f8, -168
; NOVEC-NEXT:    .cfi_offset %f9, -176
; NOVEC-NEXT:    ler %f8, %f2
; NOVEC-NEXT:    brasl %r14, __extendhfdf2@PLT
; NOVEC-NEXT:    ldr %f9, %f0
; NOVEC-NEXT:    ler %f0, %f8
; NOVEC-NEXT:    brasl %r14, __extendhfdf2@PLT
; NOVEC-NEXT:    adbr %f9, %f9
; NOVEC-NEXT:    ldr %f8, %f0
; NOVEC-NEXT:    adbr %f8, %f0
; NOVEC-NEXT:    ldr %f0, %f9
; NOVEC-NEXT:    brasl %r14, __truncdfhf2@PLT
; NOVEC-NEXT:    ler %f9, %f0
; NOVEC-NEXT:    ldr %f0, %f8
; NOVEC-NEXT:    brasl %r14, __truncdfhf2@PLT
; NOVEC-NEXT:    ler %f2, %f0
; NOVEC-NEXT:    ler %f0, %f9
; NOVEC-NEXT:    ld %f8, 168(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f9, 160(%r15) # 8-byte Reload
; NOVEC-NEXT:    lmg %r14, %r15, 288(%r15)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: fun2:
; VECTOR:       # %bb.0: # %entry
; VECTOR-NEXT:    stmg %r14, %r15, 112(%r15)
; VECTOR-NEXT:    .cfi_offset %r14, -48
; VECTOR-NEXT:    .cfi_offset %r15, -40
; VECTOR-NEXT:    aghi %r15, -184
; VECTOR-NEXT:    .cfi_def_cfa_offset 344
; VECTOR-NEXT:    std %f8, 176(%r15) # 8-byte Spill
; VECTOR-NEXT:    .cfi_offset %f8, -168
; VECTOR-NEXT:    ldr %f8, %f0
; VECTOR-NEXT:    ldr %f0, %f2
; VECTOR-NEXT:    brasl %r14, __extendhfdf2@PLT
; VECTOR-NEXT:    # kill: def $f0d killed $f0d def $v0
; VECTOR-NEXT:    vst %v0, 160(%r15), 3 # 16-byte Spill
; VECTOR-NEXT:    ldr %f0, %f8
; VECTOR-NEXT:    brasl %r14, __extendhfdf2@PLT
; VECTOR-NEXT:    vl %v1, 160(%r15), 3 # 16-byte Reload
; VECTOR-NEXT:    # kill: def $f0d killed $f0d def $v0
; VECTOR-NEXT:    vmrhg %v0, %v0, %v1
; VECTOR-NEXT:    vfadb %v0, %v0, %v0
; VECTOR-NEXT:    vst %v0, 160(%r15), 3 # 16-byte Spill
; VECTOR-NEXT:    # kill: def $f0d killed $f0d killed $v0
; VECTOR-NEXT:    brasl %r14, __truncdfhf2@PLT
; VECTOR-NEXT:    ldr %f8, %f0
; VECTOR-NEXT:    vl %v0, 160(%r15), 3 # 16-byte Reload
; VECTOR-NEXT:    vrepg %v0, %v0, 1
; VECTOR-NEXT:    # kill: def $f0d killed $f0d killed $v0
; VECTOR-NEXT:    brasl %r14, __truncdfhf2@PLT
; VECTOR-NEXT:    ldr %f2, %f0
; VECTOR-NEXT:    ldr %f0, %f8
; VECTOR-NEXT:    ld %f8, 176(%r15) # 8-byte Reload
; VECTOR-NEXT:    lmg %r14, %r15, 296(%r15)
; VECTOR-NEXT:    br %r14
entry:
  %E = fpext <2 x half> %Op to <2 x double>
  %Add = fadd <2 x double> %E, %E
  %Res = fptrunc <2 x double> %Add to <2 x half>
  ret <2 x half> %Res
}

; Load and store an <8 x half> vector.
define void @fun3(ptr %Src, ptr %Dst) {
; NOVEC-LABEL: fun3:
; NOVEC:       # %bb.0: # %entry
; NOVEC-NEXT:    lgh %r0, 0(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    lgh %r0, 2(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f1, %r0
; NOVEC-NEXT:    lgh %r0, 4(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f2, %r0
; NOVEC-NEXT:    lgh %r0, 6(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f3, %r0
; NOVEC-NEXT:    lgh %r0, 8(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f4, %r0
; NOVEC-NEXT:    lgh %r0, 10(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f5, %r0
; NOVEC-NEXT:    lgh %r0, 12(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f6, %r0
; NOVEC-NEXT:    lgh %r0, 14(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f7, %r0
; NOVEC-NEXT:    lgdr %r0, %f7
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 14(%r3)
; NOVEC-NEXT:    lgdr %r0, %f6
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 12(%r3)
; NOVEC-NEXT:    lgdr %r0, %f5
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 10(%r3)
; NOVEC-NEXT:    lgdr %r0, %f4
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 8(%r3)
; NOVEC-NEXT:    lgdr %r0, %f3
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 6(%r3)
; NOVEC-NEXT:    lgdr %r0, %f2
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 4(%r3)
; NOVEC-NEXT:    lgdr %r0, %f1
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 2(%r3)
; NOVEC-NEXT:    lgdr %r0, %f0
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 0(%r3)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: fun3:
; VECTOR:       # %bb.0: # %entry
; VECTOR-NEXT:    vlreph %v0, 0(%r2)
; VECTOR-NEXT:    vlreph %v1, 2(%r2)
; VECTOR-NEXT:    vlreph %v2, 4(%r2)
; VECTOR-NEXT:    vlreph %v3, 6(%r2)
; VECTOR-NEXT:    vlreph %v4, 8(%r2)
; VECTOR-NEXT:    vlreph %v5, 10(%r2)
; VECTOR-NEXT:    vlreph %v6, 12(%r2)
; VECTOR-NEXT:    vlreph %v7, 14(%r2)
; VECTOR-NEXT:    vsteh %v7, 14(%r3), 0
; VECTOR-NEXT:    vsteh %v6, 12(%r3), 0
; VECTOR-NEXT:    vsteh %v5, 10(%r3), 0
; VECTOR-NEXT:    vsteh %v4, 8(%r3), 0
; VECTOR-NEXT:    vsteh %v3, 6(%r3), 0
; VECTOR-NEXT:    vsteh %v2, 4(%r3), 0
; VECTOR-NEXT:    vsteh %v1, 2(%r3), 0
; VECTOR-NEXT:    vsteh %v0, 0(%r3), 0
; VECTOR-NEXT:    br %r14
entry:
  %L = load <8 x half>, ptr %Src
  store <8 x half> %L, ptr %Dst
  ret void
}

; Call a function with <8 x half> argument and return values.
declare <8 x half> @foo(<8 x half>)
define void @fun4(ptr %Src, ptr %Dst) {
; NOVEC-LABEL: fun4:
; NOVEC:       # %bb.0: # %entry
; NOVEC-NEXT:    stmg %r13, %r15, 104(%r15)
; NOVEC-NEXT:    .cfi_offset %r13, -56
; NOVEC-NEXT:    .cfi_offset %r14, -48
; NOVEC-NEXT:    .cfi_offset %r15, -40
; NOVEC-NEXT:    aghi %r15, -208
; NOVEC-NEXT:    .cfi_def_cfa_offset 368
; NOVEC-NEXT:    lgh %r0, 0(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    lgh %r0, 2(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f2, %r0
; NOVEC-NEXT:    # kill: def $f0h killed $f0h killed $f0d
; NOVEC-NEXT:    # kill: def $f2h killed $f2h killed $f2d
; NOVEC-NEXT:    lgh %r0, 4(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f4, %r0
; NOVEC-NEXT:    # kill: def $f4h killed $f4h killed $f4d
; NOVEC-NEXT:    lgh %r0, 6(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f6, %r0
; NOVEC-NEXT:    # kill: def $f6h killed $f6h killed $f6d
; NOVEC-NEXT:    lgh %r0, 8(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f1, %r0
; NOVEC-NEXT:    lgh %r0, 10(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f3, %r0
; NOVEC-NEXT:    lgh %r0, 12(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f5, %r0
; NOVEC-NEXT:    lgh %r0, 14(%r2)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f7, %r0
; NOVEC-NEXT:    lgdr %r0, %f7
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 190(%r15)
; NOVEC-NEXT:    lgdr %r0, %f5
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 182(%r15)
; NOVEC-NEXT:    lgdr %r0, %f3
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 174(%r15)
; NOVEC-NEXT:    lgdr %r0, %f1
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    la %r2, 192(%r15)
; NOVEC-NEXT:    lgr %r13, %r3
; NOVEC-NEXT:    sth %r0, 166(%r15)
; NOVEC-NEXT:    brasl %r14, foo@PLT
; NOVEC-NEXT:    lgh %r0, 192(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f0, %r0
; NOVEC-NEXT:    lgh %r0, 194(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f1, %r0
; NOVEC-NEXT:    lgh %r0, 196(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f2, %r0
; NOVEC-NEXT:    lgh %r0, 198(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f3, %r0
; NOVEC-NEXT:    lgh %r0, 200(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f4, %r0
; NOVEC-NEXT:    lgh %r0, 202(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f5, %r0
; NOVEC-NEXT:    lgh %r0, 204(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f6, %r0
; NOVEC-NEXT:    lgh %r0, 206(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f7, %r0
; NOVEC-NEXT:    lgdr %r0, %f7
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 14(%r13)
; NOVEC-NEXT:    lgdr %r0, %f6
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 12(%r13)
; NOVEC-NEXT:    lgdr %r0, %f5
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 10(%r13)
; NOVEC-NEXT:    lgdr %r0, %f4
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 8(%r13)
; NOVEC-NEXT:    lgdr %r0, %f3
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 6(%r13)
; NOVEC-NEXT:    lgdr %r0, %f2
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 4(%r13)
; NOVEC-NEXT:    lgdr %r0, %f1
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 2(%r13)
; NOVEC-NEXT:    lgdr %r0, %f0
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 0(%r13)
; NOVEC-NEXT:    lmg %r13, %r15, 312(%r15)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: fun4:
; VECTOR:       # %bb.0: # %entry
; VECTOR-NEXT:    stmg %r13, %r15, 104(%r15)
; VECTOR-NEXT:    .cfi_offset %r13, -56
; VECTOR-NEXT:    .cfi_offset %r14, -48
; VECTOR-NEXT:    .cfi_offset %r15, -40
; VECTOR-NEXT:    aghi %r15, -208
; VECTOR-NEXT:    .cfi_def_cfa_offset 368
; VECTOR-NEXT:    vlreph %v6, 6(%r2)
; VECTOR-NEXT:    vlreph %v4, 4(%r2)
; VECTOR-NEXT:    vlreph %v2, 2(%r2)
; VECTOR-NEXT:    vlreph %v0, 0(%r2)
; VECTOR-NEXT:    vlreph %v1, 8(%r2)
; VECTOR-NEXT:    vlreph %v3, 10(%r2)
; VECTOR-NEXT:    vlreph %v5, 12(%r2)
; VECTOR-NEXT:    vlreph %v7, 14(%r2)
; VECTOR-NEXT:    la %r2, 192(%r15)
; VECTOR-NEXT:    lgr %r13, %r3
; VECTOR-NEXT:    vsteh %v7, 190(%r15), 0
; VECTOR-NEXT:    vsteh %v5, 182(%r15), 0
; VECTOR-NEXT:    vsteh %v3, 174(%r15), 0
; VECTOR-NEXT:    vsteh %v1, 166(%r15), 0
; VECTOR-NEXT:    brasl %r14, foo@PLT
; VECTOR-NEXT:    vlreph %v0, 192(%r15)
; VECTOR-NEXT:    vlreph %v1, 194(%r15)
; VECTOR-NEXT:    vlreph %v2, 196(%r15)
; VECTOR-NEXT:    vlreph %v3, 198(%r15)
; VECTOR-NEXT:    vlreph %v4, 200(%r15)
; VECTOR-NEXT:    vlreph %v5, 202(%r15)
; VECTOR-NEXT:    vlreph %v6, 204(%r15)
; VECTOR-NEXT:    vlreph %v7, 206(%r15)
; VECTOR-NEXT:    vsteh %v7, 14(%r13), 0
; VECTOR-NEXT:    vsteh %v6, 12(%r13), 0
; VECTOR-NEXT:    vsteh %v5, 10(%r13), 0
; VECTOR-NEXT:    vsteh %v4, 8(%r13), 0
; VECTOR-NEXT:    vsteh %v3, 6(%r13), 0
; VECTOR-NEXT:    vsteh %v2, 4(%r13), 0
; VECTOR-NEXT:    vsteh %v1, 2(%r13), 0
; VECTOR-NEXT:    vsteh %v0, 0(%r13), 0
; VECTOR-NEXT:    lmg %r13, %r15, 312(%r15)
; VECTOR-NEXT:    br %r14
entry:
  %arg = load <8 x half>, ptr %Src
  %Res = call <8 x half> @foo(<8 x half> %arg)
  store <8 x half> %Res, ptr %Dst
  ret void
}

; Receive and pass argument fully on stack.
declare void @foo2(<4 x half> %dummy, <8 x half> %Arg5)
define void @fun5(<4 x half> %dummy, <8 x half> %Arg5) {
; NOVEC-LABEL: fun5:
; NOVEC:       # %bb.0:
; NOVEC-NEXT:    stmg %r14, %r15, 112(%r15)
; NOVEC-NEXT:    .cfi_offset %r14, -48
; NOVEC-NEXT:    .cfi_offset %r15, -40
; NOVEC-NEXT:    aghi %r15, -256
; NOVEC-NEXT:    .cfi_def_cfa_offset 416
; NOVEC-NEXT:    std %f8, 248(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f9, 240(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f10, 232(%r15) # 8-byte Spill
; NOVEC-NEXT:    std %f11, 224(%r15) # 8-byte Spill
; NOVEC-NEXT:    .cfi_offset %f8, -168
; NOVEC-NEXT:    .cfi_offset %f9, -176
; NOVEC-NEXT:    .cfi_offset %f10, -184
; NOVEC-NEXT:    .cfi_offset %f11, -192
; NOVEC-NEXT:    lgh %r0, 422(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f1, %r0
; NOVEC-NEXT:    lgh %r0, 430(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f3, %r0
; NOVEC-NEXT:    lgh %r0, 438(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f5, %r0
; NOVEC-NEXT:    lgh %r0, 446(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f7, %r0
; NOVEC-NEXT:    lgh %r0, 454(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f8, %r0
; NOVEC-NEXT:    lgh %r0, 462(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f9, %r0
; NOVEC-NEXT:    lgh %r0, 470(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f10, %r0
; NOVEC-NEXT:    lgh %r0, 478(%r15)
; NOVEC-NEXT:    sllg %r0, %r0, 48
; NOVEC-NEXT:    ldgr %f11, %r0
; NOVEC-NEXT:    lgdr %r0, %f11
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 222(%r15)
; NOVEC-NEXT:    lgdr %r0, %f10
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 214(%r15)
; NOVEC-NEXT:    lgdr %r0, %f9
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 206(%r15)
; NOVEC-NEXT:    lgdr %r0, %f8
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 198(%r15)
; NOVEC-NEXT:    lgdr %r0, %f7
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 190(%r15)
; NOVEC-NEXT:    lgdr %r0, %f5
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 182(%r15)
; NOVEC-NEXT:    lgdr %r0, %f3
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 174(%r15)
; NOVEC-NEXT:    lgdr %r0, %f1
; NOVEC-NEXT:    srlg %r0, %r0, 48
; NOVEC-NEXT:    sth %r0, 166(%r15)
; NOVEC-NEXT:    brasl %r14, foo2@PLT
; NOVEC-NEXT:    ld %f8, 248(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f9, 240(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f10, 232(%r15) # 8-byte Reload
; NOVEC-NEXT:    ld %f11, 224(%r15) # 8-byte Reload
; NOVEC-NEXT:    lmg %r14, %r15, 368(%r15)
; NOVEC-NEXT:    br %r14
;
; VECTOR-LABEL: fun5:
; VECTOR:       # %bb.0:
; VECTOR-NEXT:    stmg %r14, %r15, 112(%r15)
; VECTOR-NEXT:    .cfi_offset %r14, -48
; VECTOR-NEXT:    .cfi_offset %r15, -40
; VECTOR-NEXT:    aghi %r15, -224
; VECTOR-NEXT:    .cfi_def_cfa_offset 384
; VECTOR-NEXT:    vlreph %v1, 390(%r15)
; VECTOR-NEXT:    vlreph %v3, 398(%r15)
; VECTOR-NEXT:    vlreph %v5, 406(%r15)
; VECTOR-NEXT:    vlreph %v7, 414(%r15)
; VECTOR-NEXT:    vlreph %v16, 422(%r15)
; VECTOR-NEXT:    vlreph %v17, 430(%r15)
; VECTOR-NEXT:    vlreph %v18, 438(%r15)
; VECTOR-NEXT:    vlreph %v19, 446(%r15)
; VECTOR-NEXT:    vsteh %v19, 222(%r15), 0
; VECTOR-NEXT:    vsteh %v18, 214(%r15), 0
; VECTOR-NEXT:    vsteh %v17, 206(%r15), 0
; VECTOR-NEXT:    vsteh %v16, 198(%r15), 0
; VECTOR-NEXT:    vsteh %v7, 190(%r15), 0
; VECTOR-NEXT:    vsteh %v5, 182(%r15), 0
; VECTOR-NEXT:    vsteh %v3, 174(%r15), 0
; VECTOR-NEXT:    vsteh %v1, 166(%r15), 0
; VECTOR-NEXT:    brasl %r14, foo2@PLT
; VECTOR-NEXT:    lmg %r14, %r15, 336(%r15)
; VECTOR-NEXT:    br %r14
  call void @foo2(<4 x half> %dummy, <8 x half> %Arg5)
  ret void
}
