; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=-bmi,+sse2 | FileCheck %s -check-prefixes=NOBMI
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+sse2 | FileCheck %s -check-prefixes=BMI,SSE2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+sse4.2 | FileCheck %s -check-prefixes=BMI,SSE42
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+avx | FileCheck %s -check-prefixes=BMI,AVX1
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+avx2 | FileCheck %s -check-prefixes=BMI,AVX2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+avx512f | FileCheck %s -check-prefixes=BMI,AVX512,AVX512F
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+avx512vl,+avx512bw,+avx512dq | FileCheck %s -check-prefixes=BMI,AVX512,AVX512BW
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+avx512vl,+avx512vpopcntdq | FileCheck %s -check-prefixes=BMI,AVX512,AVX512VPOPCNT
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+bmi,+avx512vl,+avx512bitalg | FileCheck %s -check-prefixes=BMI,AVX512,AVX512BITALG

; Verify the cost of scalar trailing zero count instructions.

declare i64 @llvm.cttz.i64(i64, i1)
declare i32 @llvm.cttz.i32(i32, i1)
declare i16 @llvm.cttz.i16(i16, i1)
declare  i8 @llvm.cttz.i8(i8, i1)

define i64 @var_cttz_i64(i64 %a) {
; NOBMI-LABEL: 'var_cttz_i64'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %cttz = call i64 @llvm.cttz.i64(i64 %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %cttz
;
; BMI-LABEL: 'var_cttz_i64'
; BMI-NEXT:  Cost Model: Found costs of 1 for: %cttz = call i64 @llvm.cttz.i64(i64 %a, i1 false)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %cttz
;
  %cttz = call i64 @llvm.cttz.i64(i64 %a, i1 0)
  ret i64 %cttz
}

define i64 @var_cttz_i64u(i64 %a) {
; NOBMI-LABEL: 'var_cttz_i64u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %cttz = call i64 @llvm.cttz.i64(i64 %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %cttz
;
; BMI-LABEL: 'var_cttz_i64u'
; BMI-NEXT:  Cost Model: Found costs of 1 for: %cttz = call i64 @llvm.cttz.i64(i64 %a, i1 true)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %cttz
;
  %cttz = call i64 @llvm.cttz.i64(i64 %a, i1 1)
  ret i64 %cttz
}

define i32 @var_cttz_i32(i32 %a) {
; NOBMI-LABEL: 'var_cttz_i32'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %cttz = call i32 @llvm.cttz.i32(i32 %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %cttz
;
; BMI-LABEL: 'var_cttz_i32'
; BMI-NEXT:  Cost Model: Found costs of 1 for: %cttz = call i32 @llvm.cttz.i32(i32 %a, i1 false)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %cttz
;
  %cttz = call i32 @llvm.cttz.i32(i32 %a, i1 0)
  ret i32 %cttz
}

define i32 @var_cttz_i32u(i32 %a) {
; NOBMI-LABEL: 'var_cttz_i32u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:2 for: %cttz = call i32 @llvm.cttz.i32(i32 %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %cttz
;
; BMI-LABEL: 'var_cttz_i32u'
; BMI-NEXT:  Cost Model: Found costs of 1 for: %cttz = call i32 @llvm.cttz.i32(i32 %a, i1 true)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %cttz
;
  %cttz = call i32 @llvm.cttz.i32(i32 %a, i1 1)
  ret i32 %cttz
}

define i16 @var_cttz_i16(i16 %a) {
; NOBMI-LABEL: 'var_cttz_i16'
; NOBMI-NEXT:  Cost Model: Found costs of 2 for: %cttz = call i16 @llvm.cttz.i16(i16 %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %cttz
;
; BMI-LABEL: 'var_cttz_i16'
; BMI-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cttz = call i16 @llvm.cttz.i16(i16 %a, i1 false)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %cttz
;
  %cttz = call i16 @llvm.cttz.i16(i16 %a, i1 0)
  ret i16 %cttz
}

define i16 @var_cttz_i16u(i16 %a) {
; NOBMI-LABEL: 'var_cttz_i16u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %cttz = call i16 @llvm.cttz.i16(i16 %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %cttz
;
; BMI-LABEL: 'var_cttz_i16u'
; BMI-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cttz = call i16 @llvm.cttz.i16(i16 %a, i1 true)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %cttz
;
  %cttz = call i16 @llvm.cttz.i16(i16 %a, i1 1)
  ret i16 %cttz
}

define i8 @var_cttz_i8(i8 %a) {
; NOBMI-LABEL: 'var_cttz_i8'
; NOBMI-NEXT:  Cost Model: Found costs of 2 for: %cttz = call i8 @llvm.cttz.i8(i8 %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %cttz
;
; BMI-LABEL: 'var_cttz_i8'
; BMI-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cttz = call i8 @llvm.cttz.i8(i8 %a, i1 false)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %cttz
;
  %cttz = call i8 @llvm.cttz.i8(i8 %a, i1 0)
  ret i8 %cttz
}

define i8 @var_cttz_i8u(i8 %a) {
; NOBMI-LABEL: 'var_cttz_i8u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:2 SizeLat:2 for: %cttz = call i8 @llvm.cttz.i8(i8 %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %cttz
;
; BMI-LABEL: 'var_cttz_i8u'
; BMI-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %cttz = call i8 @llvm.cttz.i8(i8 %a, i1 true)
; BMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %cttz
;
  %cttz = call i8 @llvm.cttz.i8(i8 %a, i1 1)
  ret i8 %cttz
}

; Verify the cost of vector trailing zero count instructions.

declare <2 x i64> @llvm.cttz.v2i64(<2 x i64>, i1)
declare <4 x i32> @llvm.cttz.v4i32(<4 x i32>, i1)
declare <8 x i16> @llvm.cttz.v8i16(<8 x i16>, i1)
declare <16 x i8> @llvm.cttz.v16i8(<16 x i8>, i1)

declare <4 x i64> @llvm.cttz.v4i64(<4 x i64>, i1)
declare <8 x i32> @llvm.cttz.v8i32(<8 x i32>, i1)
declare <16 x i16> @llvm.cttz.v16i16(<16 x i16>, i1)
declare <32 x i8> @llvm.cttz.v32i8(<32 x i8>, i1)

declare <8 x i64> @llvm.cttz.v8i64(<8 x i64>, i1)
declare <16 x i32> @llvm.cttz.v16i32(<16 x i32>, i1)
declare <32 x i16> @llvm.cttz.v32i16(<32 x i16>, i1)
declare <64 x i8> @llvm.cttz.v64i8(<64 x i8>, i1)

define <2 x i64> @var_cttz_v2i64(<2 x i64> %a) {
; NOBMI-LABEL: 'var_cttz_v2i64'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:28 SizeLat:21 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; SSE2-LABEL: 'var_cttz_v2i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:28 SizeLat:21 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; SSE42-LABEL: 'var_cttz_v2i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:15 Lat:25 SizeLat:22 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; AVX1-LABEL: 'var_cttz_v2i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:13 Lat:19 SizeLat:17 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; AVX2-LABEL: 'var_cttz_v2i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:13 Lat:11 SizeLat:13 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; AVX512-LABEL: 'var_cttz_v2i64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:13 Lat:11 SizeLat:13 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
  %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 0)
  ret <2 x i64> %cttz
}

define <2 x i64> @var_cttz_v2i64u(<2 x i64> %a) {
; NOBMI-LABEL: 'var_cttz_v2i64u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:28 SizeLat:21 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; SSE2-LABEL: 'var_cttz_v2i64u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:19 Lat:28 SizeLat:21 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; SSE42-LABEL: 'var_cttz_v2i64u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:15 Lat:25 SizeLat:22 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; AVX1-LABEL: 'var_cttz_v2i64u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:13 Lat:19 SizeLat:17 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; AVX2-LABEL: 'var_cttz_v2i64u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:13 Lat:11 SizeLat:13 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
; AVX512-LABEL: 'var_cttz_v2i64u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:13 Lat:11 SizeLat:13 for: %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %cttz
;
  %cttz = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 1)
  ret <2 x i64> %cttz
}

define <4 x i64> @var_cttz_v4i64(<4 x i64> %a) {
; NOBMI-LABEL: 'var_cttz_v4i64'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:56 SizeLat:42 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; SSE2-LABEL: 'var_cttz_v4i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:56 SizeLat:42 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; SSE42-LABEL: 'var_cttz_v4i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:30 Lat:50 SizeLat:44 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; AVX1-LABEL: 'var_cttz_v4i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:24 Lat:22 SizeLat:33 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; AVX2-LABEL: 'var_cttz_v4i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:13 Lat:11 SizeLat:20 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; AVX512-LABEL: 'var_cttz_v4i64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:13 Lat:11 SizeLat:20 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
  %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 0)
  ret <4 x i64> %cttz
}

define <4 x i64> @var_cttz_v4i64u(<4 x i64> %a) {
; NOBMI-LABEL: 'var_cttz_v4i64u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:56 SizeLat:42 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; SSE2-LABEL: 'var_cttz_v4i64u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:38 Lat:56 SizeLat:42 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; SSE42-LABEL: 'var_cttz_v4i64u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:30 Lat:50 SizeLat:44 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; AVX1-LABEL: 'var_cttz_v4i64u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:24 Lat:22 SizeLat:33 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; AVX2-LABEL: 'var_cttz_v4i64u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:13 Lat:11 SizeLat:20 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
; AVX512-LABEL: 'var_cttz_v4i64u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:13 Lat:11 SizeLat:20 for: %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %cttz
;
  %cttz = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 1)
  ret <4 x i64> %cttz
}

define <8 x i64> @var_cttz_v8i64(<8 x i64> %a) {
; NOBMI-LABEL: 'var_cttz_v8i64'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:76 Lat:112 SizeLat:84 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; SSE2-LABEL: 'var_cttz_v8i64'
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:76 Lat:112 SizeLat:84 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; SSE42-LABEL: 'var_cttz_v8i64'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:60 Lat:100 SizeLat:88 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; AVX1-LABEL: 'var_cttz_v8i64'
; AVX1-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:48 Lat:44 SizeLat:66 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; AVX2-LABEL: 'var_cttz_v8i64'
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:26 Lat:22 SizeLat:40 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; AVX512-LABEL: 'var_cttz_v8i64'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:8 SizeLat:7 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
  %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 0)
  ret <8 x i64> %cttz
}

define <8 x i64> @var_cttz_v8i64u(<8 x i64> %a) {
; NOBMI-LABEL: 'var_cttz_v8i64u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:76 Lat:112 SizeLat:84 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; SSE2-LABEL: 'var_cttz_v8i64u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:76 Lat:112 SizeLat:84 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; SSE42-LABEL: 'var_cttz_v8i64u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:60 Lat:100 SizeLat:88 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; AVX1-LABEL: 'var_cttz_v8i64u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:48 Lat:44 SizeLat:66 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; AVX2-LABEL: 'var_cttz_v8i64u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:26 Lat:22 SizeLat:40 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
; AVX512-LABEL: 'var_cttz_v8i64u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:8 SizeLat:7 for: %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i64> %cttz
;
  %cttz = call <8 x i64> @llvm.cttz.v8i64(<8 x i64> %a, i1 1)
  ret <8 x i64> %cttz
}

define <4 x i32> @var_cttz_v4i32(<4 x i32> %a) {
; NOBMI-LABEL: 'var_cttz_v4i32'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:24 Lat:31 SizeLat:26 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; SSE2-LABEL: 'var_cttz_v4i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:24 Lat:31 SizeLat:26 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; SSE42-LABEL: 'var_cttz_v4i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:19 Lat:26 SizeLat:25 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; AVX1-LABEL: 'var_cttz_v4i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:17 Lat:24 SizeLat:21 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; AVX2-LABEL: 'var_cttz_v4i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:14 SizeLat:17 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; AVX512-LABEL: 'var_cttz_v4i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:14 SizeLat:17 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
  %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 0)
  ret <4 x i32> %cttz
}

define <4 x i32> @var_cttz_v4i32u(<4 x i32> %a) {
; NOBMI-LABEL: 'var_cttz_v4i32u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:24 Lat:31 SizeLat:26 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; SSE2-LABEL: 'var_cttz_v4i32u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:24 Lat:31 SizeLat:26 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; SSE42-LABEL: 'var_cttz_v4i32u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:19 Lat:26 SizeLat:25 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; AVX1-LABEL: 'var_cttz_v4i32u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:17 Lat:24 SizeLat:21 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; AVX2-LABEL: 'var_cttz_v4i32u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:14 SizeLat:17 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
; AVX512-LABEL: 'var_cttz_v4i32u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:14 SizeLat:17 for: %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %cttz
;
  %cttz = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 1)
  ret <4 x i32> %cttz
}

define <8 x i32> @var_cttz_v8i32(<8 x i32> %a) {
; NOBMI-LABEL: 'var_cttz_v8i32'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:48 Lat:62 SizeLat:52 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; SSE2-LABEL: 'var_cttz_v8i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:48 Lat:62 SizeLat:52 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; SSE42-LABEL: 'var_cttz_v8i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:38 Lat:52 SizeLat:50 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; AVX1-LABEL: 'var_cttz_v8i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:32 Lat:27 SizeLat:41 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; AVX2-LABEL: 'var_cttz_v8i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:15 SizeLat:24 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; AVX512-LABEL: 'var_cttz_v8i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:15 SizeLat:24 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
  %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 0)
  ret <8 x i32> %cttz
}

define <8 x i32> @var_cttz_v8i32u(<8 x i32> %a) {
; NOBMI-LABEL: 'var_cttz_v8i32u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:48 Lat:62 SizeLat:52 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; SSE2-LABEL: 'var_cttz_v8i32u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:48 Lat:62 SizeLat:52 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; SSE42-LABEL: 'var_cttz_v8i32u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:38 Lat:52 SizeLat:50 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; AVX1-LABEL: 'var_cttz_v8i32u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:32 Lat:27 SizeLat:41 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; AVX2-LABEL: 'var_cttz_v8i32u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:15 SizeLat:24 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
; AVX512-LABEL: 'var_cttz_v8i32u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:17 Lat:15 SizeLat:24 for: %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %cttz
;
  %cttz = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 1)
  ret <8 x i32> %cttz
}

define <16 x i32> @var_cttz_v16i32(<16 x i32> %a) {
; NOBMI-LABEL: 'var_cttz_v16i32'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:96 Lat:124 SizeLat:104 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; SSE2-LABEL: 'var_cttz_v16i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:96 Lat:124 SizeLat:104 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; SSE42-LABEL: 'var_cttz_v16i32'
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:76 Lat:104 SizeLat:100 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; AVX1-LABEL: 'var_cttz_v16i32'
; AVX1-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:64 Lat:54 SizeLat:82 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; AVX2-LABEL: 'var_cttz_v16i32'
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:34 Lat:30 SizeLat:48 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; AVX512-LABEL: 'var_cttz_v16i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:8 SizeLat:7 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
  %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 0)
  ret <16 x i32> %cttz
}

define <16 x i32> @var_cttz_v16i32u(<16 x i32> %a) {
; NOBMI-LABEL: 'var_cttz_v16i32u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:96 Lat:124 SizeLat:104 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; SSE2-LABEL: 'var_cttz_v16i32u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:96 Lat:124 SizeLat:104 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; SSE42-LABEL: 'var_cttz_v16i32u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:76 Lat:104 SizeLat:100 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; AVX1-LABEL: 'var_cttz_v16i32u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:64 Lat:54 SizeLat:82 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; AVX2-LABEL: 'var_cttz_v16i32u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:34 Lat:30 SizeLat:48 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
; AVX512-LABEL: 'var_cttz_v16i32u'
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:8 SizeLat:7 for: %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i32> %cttz
;
  %cttz = call <16 x i32> @llvm.cttz.v16i32(<16 x i32> %a, i1 1)
  ret <16 x i32> %cttz
}

define <8 x i16> @var_cttz_v8i16(<8 x i16> %a) {
; NOBMI-LABEL: 'var_cttz_v8i16'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:21 Lat:27 SizeLat:23 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; SSE2-LABEL: 'var_cttz_v8i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:21 Lat:27 SizeLat:23 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; SSE42-LABEL: 'var_cttz_v8i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:17 Lat:20 SizeLat:23 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX1-LABEL: 'var_cttz_v8i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:14 Lat:21 SizeLat:18 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX2-LABEL: 'var_cttz_v8i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512F-LABEL: 'var_cttz_v8i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v8i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v8i16'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v8i16'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
  %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 0)
  ret <8 x i16> %cttz
}

define <8 x i16> @var_cttz_v8i16u(<8 x i16> %a) {
; NOBMI-LABEL: 'var_cttz_v8i16u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:21 Lat:27 SizeLat:23 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; SSE2-LABEL: 'var_cttz_v8i16u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:21 Lat:27 SizeLat:23 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; SSE42-LABEL: 'var_cttz_v8i16u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:17 Lat:20 SizeLat:23 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX1-LABEL: 'var_cttz_v8i16u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:14 Lat:21 SizeLat:18 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX2-LABEL: 'var_cttz_v8i16u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512F-LABEL: 'var_cttz_v8i16u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v8i16u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v8i16u'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v8i16u'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 true)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %cttz
;
  %cttz = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 1)
  ret <8 x i16> %cttz
}

define <16 x i16> @var_cttz_v16i16(<16 x i16> %a) {
; NOBMI-LABEL: 'var_cttz_v16i16'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:42 Lat:54 SizeLat:46 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; SSE2-LABEL: 'var_cttz_v16i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:42 Lat:54 SizeLat:46 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; SSE42-LABEL: 'var_cttz_v16i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:34 Lat:40 SizeLat:46 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX1-LABEL: 'var_cttz_v16i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:27 Lat:24 SizeLat:36 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX2-LABEL: 'var_cttz_v16i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:9 SizeLat:24 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512F-LABEL: 'var_cttz_v16i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:9 SizeLat:24 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v16i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v16i16'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:9 SizeLat:24 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v16i16'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
  %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 0)
  ret <16 x i16> %cttz
}

define <16 x i16> @var_cttz_v16i16u(<16 x i16> %a) {
; NOBMI-LABEL: 'var_cttz_v16i16u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:42 Lat:54 SizeLat:46 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; SSE2-LABEL: 'var_cttz_v16i16u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:42 Lat:54 SizeLat:46 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; SSE42-LABEL: 'var_cttz_v16i16u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:34 Lat:40 SizeLat:46 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX1-LABEL: 'var_cttz_v16i16u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:27 Lat:24 SizeLat:36 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX2-LABEL: 'var_cttz_v16i16u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:9 SizeLat:24 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512F-LABEL: 'var_cttz_v16i16u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:9 SizeLat:24 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v16i16u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v16i16u'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:9 SizeLat:24 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v16i16u'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:9 SizeLat:14 for: %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 true)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %cttz
;
  %cttz = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 1)
  ret <16 x i16> %cttz
}

define <32 x i16> @var_cttz_v32i16(<32 x i16> %a) {
; NOBMI-LABEL: 'var_cttz_v32i16'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:84 Lat:108 SizeLat:92 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; SSE2-LABEL: 'var_cttz_v32i16'
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:84 Lat:108 SizeLat:92 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; SSE42-LABEL: 'var_cttz_v32i16'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:68 Lat:80 SizeLat:92 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX1-LABEL: 'var_cttz_v32i16'
; AVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:54 Lat:48 SizeLat:72 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX2-LABEL: 'var_cttz_v32i16'
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:18 SizeLat:48 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512F-LABEL: 'var_cttz_v32i16'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:27 Lat:17 SizeLat:27 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v32i16'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:10 SizeLat:16 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v32i16'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:27 Lat:17 SizeLat:27 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v32i16'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:10 SizeLat:16 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 false)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
  %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 0)
  ret <32 x i16> %cttz
}

define <32 x i16> @var_cttz_v32i16u(<32 x i16> %a) {
; NOBMI-LABEL: 'var_cttz_v32i16u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:84 Lat:108 SizeLat:92 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; SSE2-LABEL: 'var_cttz_v32i16u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:84 Lat:108 SizeLat:92 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; SSE42-LABEL: 'var_cttz_v32i16u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:68 Lat:80 SizeLat:92 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX1-LABEL: 'var_cttz_v32i16u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:54 Lat:48 SizeLat:72 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX2-LABEL: 'var_cttz_v32i16u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:18 SizeLat:48 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512F-LABEL: 'var_cttz_v32i16u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:27 Lat:17 SizeLat:27 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v32i16u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:10 SizeLat:16 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v32i16u'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:27 Lat:17 SizeLat:27 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v32i16u'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:14 Lat:10 SizeLat:16 for: %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 true)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i16> %cttz
;
  %cttz = call <32 x i16> @llvm.cttz.v32i16(<32 x i16> %a, i1 1)
  ret <32 x i16> %cttz
}

define <16 x i8> @var_cttz_v16i8(<16 x i8> %a) {
; NOBMI-LABEL: 'var_cttz_v16i8'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:17 Lat:23 SizeLat:19 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; SSE2-LABEL: 'var_cttz_v16i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:17 Lat:23 SizeLat:19 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; SSE42-LABEL: 'var_cttz_v16i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:13 Lat:16 SizeLat:19 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX1-LABEL: 'var_cttz_v16i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:11 Lat:16 SizeLat:15 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX2-LABEL: 'var_cttz_v16i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512F-LABEL: 'var_cttz_v16i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v16i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v16i8'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v16i8'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
  %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 0)
  ret <16 x i8> %cttz
}

define <16 x i8> @var_cttz_v16i8u(<16 x i8> %a) {
; NOBMI-LABEL: 'var_cttz_v16i8u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:17 Lat:23 SizeLat:19 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; SSE2-LABEL: 'var_cttz_v16i8u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:17 Lat:23 SizeLat:19 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; SSE42-LABEL: 'var_cttz_v16i8u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:13 Lat:16 SizeLat:19 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX1-LABEL: 'var_cttz_v16i8u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:11 Lat:16 SizeLat:15 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX2-LABEL: 'var_cttz_v16i8u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512F-LABEL: 'var_cttz_v16i8u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v16i8u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v16i8u'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v16i8u'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 true)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %cttz
;
  %cttz = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 1)
  ret <16 x i8> %cttz
}

define <32 x i8> @var_cttz_v32i8(<32 x i8> %a) {
; NOBMI-LABEL: 'var_cttz_v32i8'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:34 Lat:46 SizeLat:38 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; SSE2-LABEL: 'var_cttz_v32i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:34 Lat:46 SizeLat:38 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; SSE42-LABEL: 'var_cttz_v32i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:26 Lat:32 SizeLat:38 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX1-LABEL: 'var_cttz_v32i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:21 Lat:18 SizeLat:30 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX2-LABEL: 'var_cttz_v32i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:11 Lat:7 SizeLat:18 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512F-LABEL: 'var_cttz_v32i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:11 Lat:7 SizeLat:18 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v32i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v32i8'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:11 Lat:7 SizeLat:18 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v32i8'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
  %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 0)
  ret <32 x i8> %cttz
}

define <32 x i8> @var_cttz_v32i8u(<32 x i8> %a) {
; NOBMI-LABEL: 'var_cttz_v32i8u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:34 Lat:46 SizeLat:38 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; SSE2-LABEL: 'var_cttz_v32i8u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:34 Lat:46 SizeLat:38 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; SSE42-LABEL: 'var_cttz_v32i8u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:22 CodeSize:26 Lat:32 SizeLat:38 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX1-LABEL: 'var_cttz_v32i8u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:21 Lat:18 SizeLat:30 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX2-LABEL: 'var_cttz_v32i8u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:11 Lat:7 SizeLat:18 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512F-LABEL: 'var_cttz_v32i8u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:11 Lat:7 SizeLat:18 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v32i8u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v32i8u'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:11 Lat:7 SizeLat:18 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v32i8u'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:11 Lat:6 SizeLat:11 for: %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 true)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %cttz
;
  %cttz = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 1)
  ret <32 x i8> %cttz
}

define <64 x i8> @var_cttz_v64i8(<64 x i8> %a) {
; NOBMI-LABEL: 'var_cttz_v64i8'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:68 Lat:92 SizeLat:76 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; SSE2-LABEL: 'var_cttz_v64i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:68 Lat:92 SizeLat:76 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; SSE42-LABEL: 'var_cttz_v64i8'
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:52 Lat:64 SizeLat:76 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX1-LABEL: 'var_cttz_v64i8'
; AVX1-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:42 Lat:36 SizeLat:60 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX2-LABEL: 'var_cttz_v64i8'
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:22 Lat:14 SizeLat:36 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512F-LABEL: 'var_cttz_v64i8'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:21 Lat:13 SizeLat:21 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v64i8'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:13 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v64i8'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:21 Lat:13 SizeLat:21 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v64i8'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:13 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 false)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
  %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 0)
  ret <64 x i8> %cttz
}

define <64 x i8> @var_cttz_v64i8u(<64 x i8> %a) {
; NOBMI-LABEL: 'var_cttz_v64i8u'
; NOBMI-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:68 Lat:92 SizeLat:76 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; NOBMI-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; SSE2-LABEL: 'var_cttz_v64i8u'
; SSE2-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:68 Lat:92 SizeLat:76 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; SSE42-LABEL: 'var_cttz_v64i8u'
; SSE42-NEXT:  Cost Model: Found costs of RThru:44 CodeSize:52 Lat:64 SizeLat:76 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX1-LABEL: 'var_cttz_v64i8u'
; AVX1-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:42 Lat:36 SizeLat:60 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX2-LABEL: 'var_cttz_v64i8u'
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:22 Lat:14 SizeLat:36 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512F-LABEL: 'var_cttz_v64i8u'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:21 Lat:13 SizeLat:21 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512BW-LABEL: 'var_cttz_v64i8u'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:13 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512VPOPCNT-LABEL: 'var_cttz_v64i8u'
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:21 Lat:13 SizeLat:21 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; AVX512VPOPCNT-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
; AVX512BITALG-LABEL: 'var_cttz_v64i8u'
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:11 Lat:7 SizeLat:13 for: %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 true)
; AVX512BITALG-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <64 x i8> %cttz
;
  %cttz = call <64 x i8> @llvm.cttz.v64i8(<64 x i8> %a, i1 1)
  ret <64 x i8> %cttz
}
