; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64--linux-gnu | FileCheck %s

define <8 x i8> @sel_v8i8(<8 x i8> %v0, <8 x i8> %v1) {
; CHECK-LABEL: sel_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi d2, #0xff00ff00ff00ff
; CHECK-NEXT:    bif v0.8b, v1.8b, v2.8b
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <8 x i8> %v0, <8 x i8> %v1, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x i8> %tmp0
}

define <16 x i8> @sel_v16i8(<16 x i8> %v0, <16 x i8> %v1) {
; CHECK-LABEL: sel_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0xff00ff00ff00ff
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <16 x i8> %v0, <16 x i8> %v1, <16 x i32> <i32 0, i32 17, i32 2, i32 19, i32 4, i32 21, i32 6, i32 23, i32 8, i32 25, i32 10, i32 27, i32 12, i32 29, i32 14, i32 31>
  ret <16 x i8> %tmp0
}

define <16 x i8> @sel_v16i8_poison(<16 x i8> %v0, <16 x i8> %v1) {
; CHECK-LABEL: sel_v16i8_poison:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI2_0
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI2_0]
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <16 x i8> %v0, <16 x i8> %v1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 22, i32 23, i32 24, i32 25, i32 26, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison>
  ret <16 x i8> %tmp0
}

define <16 x i8> @sel_v16i8_unregular(<16 x i8> %v0, <16 x i8> %v1) {
; CHECK-LABEL: sel_v16i8_unregular:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI3_0
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI3_0]
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <16 x i8> %v0, <16 x i8> %v1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %tmp0
}

define <4 x i16> @sel_v4i16(<4 x i16> %v0, <4 x i16> %v1) {
; CHECK-LABEL: sel_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev32 v0.4h, v0.4h
; CHECK-NEXT:    trn2 v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <4 x i16> %v0, <4 x i16> %v1, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x i16> %tmp0
}

define <8 x i16> @sel_v8i16(<8 x i16> %v0, <8 x i16> %v1) {
; CHECK-LABEL: sel_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <8 x i16> %v0, <8 x i16> %v1, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x i16> %tmp0
}

define <2 x i32> @sel_v2i32(<2 x i32> %v0, <2 x i32> %v1) {
; CHECK-LABEL: sel_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mov v0.s[1], v1.s[1]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <2 x i32> %v0, <2 x i32> %v1, <2 x i32> <i32 0, i32 3>
  ret <2 x i32> %tmp0
}

define <4 x i32> @sel_v4i32(<4 x i32> %v0, <4 x i32> %v1) {
; CHECK-LABEL: sel_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev64 v0.4s, v0.4s
; CHECK-NEXT:    trn2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <4 x i32> %v0, <4 x i32> %v1, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x i32> %tmp0
}

define <2 x i64> @sel_v2i64(<2 x i64> %v0, <2 x i64> %v1) {
; CHECK-LABEL: sel_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[1], v1.d[1]
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <2 x i64> %v0, <2 x i64> %v1, <2 x i32> <i32 0, i32 3>
  ret <2 x i64> %tmp0
}

define <4 x half> @sel_v4f16(<4 x half> %v0, <4 x half> %v1) {
; CHECK-LABEL: sel_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev32 v0.4h, v0.4h
; CHECK-NEXT:    trn2 v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <4 x half> %v0, <4 x half> %v1, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x half> %tmp0
}

define <8 x half> @sel_v8f16(<8 x half> %v0, <8 x half> %v1) {
; CHECK-LABEL: sel_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-NEXT:    bif v0.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <8 x half> %v0, <8 x half> %v1, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x half> %tmp0
}

define <2 x float> @sel_v2f32(<2 x float> %v0, <2 x float> %v1) {
; CHECK-LABEL: sel_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mov v0.s[1], v1.s[1]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <2 x float> %v0, <2 x float> %v1, <2 x i32> <i32 0, i32 3>
  ret <2 x float> %tmp0
}

define <4 x float> @sel_v4f32(<4 x float> %v0, <4 x float> %v1) {
; CHECK-LABEL: sel_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev64 v0.4s, v0.4s
; CHECK-NEXT:    trn2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <4 x float> %v0, <4 x float> %v1, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x float> %tmp0
}

define <2 x double> @sel_v2f64(<2 x double> %v0, <2 x double> %v1) {
; CHECK-LABEL: sel_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.d[1], v1.d[1]
; CHECK-NEXT:    ret
  %tmp0 = shufflevector <2 x double> %v0, <2 x double> %v1, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %tmp0
}
