      SUBROUTINE OTPUTP(N,NUMPAT,CL,FACV,CLX,X,XNP1)
C
C OTPUTP  POSTPROCESSES THE ENDPOINTS OF THE PATHS, UNTRANSFORMING
C AND UNSCALING THEM.
C
C ON INPUT:
C
C N  IS THE NUMBER OF EQUATIONS AND VARIABLES.
C
C NUMPAT  IS THE CURRENT PATH NUMBER.
C
C CL  IS THE ARRAY THAT DEFINES THE PROJECTIVE TRANSFORMATION.
C
C FACV  CONTAINS THE VARIABLE SCALING FACTORS.
C
C X  IS THE ENDPOINT OF THE PATH, POSSIBLY TRANSFORMED AND/OR SCALED
C   DEPENDING ON THE  POLSYS  INPUT FLAG  IFLG1.
C
C CLX  IS WORKSPACE.
C
C ON OUTPUT:
C
C N, NUMPAT, CL, AND  FACV  ARE UNCHANGED.
C
C X  IS THE UNTRANSFORMED AND UNSCALED VERSION OF X.
C
C XNP1  IS THE PROJECTIVE COORDINATE "X(N+1)".  XNP1  EQUALS UNITY IF
C   THE PROJECTIVE TRANSFORMATION IS NOT SPECIFIED.
C
C DECLARATIONS OF INPUT, WORKSPACE, AND OUTPUT:
      INTEGER N,NUMPAT
      DOUBLE PRECISION CL,FACV,CLX,X,XNP1
      DIMENSION CL(2,N+1),FACV(N),CLX(2,N),X(2,N),XNP1(2)
C
C DECLARATION OF VARIABLES
      INTEGER I,IERR,J,NP1
      DOUBLE PRECISION D1MACH,FAC,TEMP
      DIMENSION TEMP(2)
C
      NP1=N+1
C COMPUTE XNP1
      DO 1 J=1,N
        CALL MULP(CL(1,J),X(1,J),CLX(1,J))
 1    CONTINUE
      DO 2  I=1,2
        XNP1(I)=CL(I,NP1)
        DO 2  J=1,N
          XNP1(I) = XNP1(I) + CLX(I,J)
  2   CONTINUE
C UNTRANSFORM VARIABLES
      DO 10  J=1,N
        CALL DIVP(X(1,J),XNP1,TEMP,IERR)
        X(1,J)=TEMP(1)
        X(2,J)=TEMP(2)
  10  CONTINUE
C UNSCALE VARIABLES
      TEMP(1)=D1MACH(2)
      DO 30 J=1,N
        FAC=10.**FACV(J)
        DO 30 I=1,2
          IF( (ABS(X(I,J))/TEMP(1))*FAC .LT. 1.0 ) X(I,J)=FAC*X(I,J)
  30  CONTINUE
      RETURN
      END
