# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# This file is generated by wxPython's PI generator.  Do not edit by hand.
#
# The *.pyi files are used by PyCharm and other development tools to provide
# more information, such as PEP 484 type hints, than it is able to glean from
# introspection of extension types and methods.  They are not intended to be
# imported, executed or used for any other purpose other than providing info
# to the tools. If you don't use use a tool that makes use of .pyi files then
# you can safely ignore this file.
#
# See: https://www.python.org/dev/peps/pep-0484/
#      https://www.jetbrains.com/help/pycharm/2016.1/type-hinting-in-pycharm.html
#
# Copyright: (c) 2020 by Total Control Software
# License:   wxWindows License
#---------------------------------------------------------------------------


"""
The Grid and related classes in this module provide functionality similar to a
spreadsheet, where the application can display rows and columns of data of
various types, which the user can edit and otherwise interact with.
"""
#-- begin-_grid --#

import wx
#-- end-_grid --#
#-- begin-grid --#
GridNameStr = ""
GRID_AUTOSIZE = 0
GRID_FLOAT_FORMAT_FIXED = 0
GRID_FLOAT_FORMAT_SCIENTIFIC = 0
GRID_FLOAT_FORMAT_COMPACT = 0
GRID_FLOAT_FORMAT_UPPER = 0
GRID_FLOAT_FORMAT_DEFAULT = 0
GRIDTABLE_NOTIFY_ROWS_INSERTED = 0
GRIDTABLE_NOTIFY_ROWS_APPENDED = 0
GRIDTABLE_NOTIFY_ROWS_DELETED = 0
GRIDTABLE_NOTIFY_COLS_INSERTED = 0
GRIDTABLE_NOTIFY_COLS_APPENDED = 0
GRIDTABLE_NOTIFY_COLS_DELETED = 0
GRID_DRAW_ROWS_HEADER = 0
GRID_DRAW_COLS_HEADER = 0
GRID_DRAW_CELL_LINES = 0
GRID_DRAW_BOX_RECT = 0
GRID_DRAW_SELECTION = 0
GRID_DRAW_DEFAULT = 0
wxEVT_GRID_CELL_LEFT_CLICK = 0
wxEVT_GRID_CELL_RIGHT_CLICK = 0
wxEVT_GRID_CELL_LEFT_DCLICK = 0
wxEVT_GRID_CELL_RIGHT_DCLICK = 0
wxEVT_GRID_LABEL_LEFT_CLICK = 0
wxEVT_GRID_LABEL_RIGHT_CLICK = 0
wxEVT_GRID_LABEL_LEFT_DCLICK = 0
wxEVT_GRID_LABEL_RIGHT_DCLICK = 0
wxEVT_GRID_ROW_SIZE = 0
wxEVT_GRID_COL_SIZE = 0
wxEVT_GRID_COL_AUTO_SIZE = 0
wxEVT_GRID_RANGE_SELECTING = 0
wxEVT_GRID_RANGE_SELECTED = 0
wxEVT_GRID_CELL_CHANGING = 0
wxEVT_GRID_CELL_CHANGED = 0
wxEVT_GRID_SELECT_CELL = 0
wxEVT_GRID_EDITOR_SHOWN = 0
wxEVT_GRID_EDITOR_HIDDEN = 0
wxEVT_GRID_EDITOR_CREATED = 0
wxEVT_GRID_CELL_BEGIN_DRAG = 0
wxEVT_GRID_COL_MOVE = 0
wxEVT_GRID_COL_SORT = 0
wxEVT_GRID_TABBING = 0

class GridCellCoords(object):
    """
    GridCellCoords()
    GridCellCoords(row, col)
    
    Represents coordinates of a grid cell.
    """

    def __init__(self, *args, **kw):
        """
        GridCellCoords()
        GridCellCoords(row, col)
        
        Represents coordinates of a grid cell.
        """

    def GetRow(self):
        """
        GetRow() -> int
        
        Return the row of the coordinate.
        """

    def SetRow(self, n):
        """
        SetRow(n)
        
        Set the row of the coordinate.
        """

    def GetCol(self):
        """
        GetCol() -> int
        
        Return the column of the coordinate.
        """

    def SetCol(self, n):
        """
        SetCol(n)
        
        Set the column of the coordinate.
        """

    def Set(self, row, col):
        """
        Set(row, col)
        
        Set the row and column of the coordinate.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """
    Col = property(None, None)
    Row = property(None, None)

    def Get(self):
        """
        Get() -> (row,col)
        
        Return the row and col properties as a tuple.
        """

    def GetIM(self):
        """
        Returns an immutable representation of the ``wx.GridCellCoords`` object, based on ``namedtuple``.
        
        This new object is hashable and can be used as a dictionary key,
        be added to sets, etc.  It can be converted back into a real ``wx.GridCellCoords``
        with a simple statement like this: ``obj = wx.GridCellCoords(imObj)``.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """

    def __len__(self):
        """
        
        """

    def __nonzero__(self):
        """
        
        """

    def __bool__(self):
        """
        
        """

    def __reduce__(self):
        """
        
        """

    def __getitem__(self, idx):
        """
        
        """

    def __setitem__(self, idx, val):
        """
        
        """

    __safe_for_unpickling__ = True
# end of class GridCellCoords


class GridBlockCoords(object):
    """
    GridBlockCoords()
    GridBlockCoords(topRow, leftCol, bottomRow, rightCol)
    
    Represents coordinates of a block of cells in the grid.
    """

    def __init__(self, *args, **kw):
        """
        GridBlockCoords()
        GridBlockCoords(topRow, leftCol, bottomRow, rightCol)
        
        Represents coordinates of a block of cells in the grid.
        """

    def GetTopRow(self):
        """
        GetTopRow() -> int
        
        Return the row of the left top corner.
        """

    def SetTopRow(self, row):
        """
        SetTopRow(row)
        
        Set the row of the left top corner.
        """

    def GetLeftCol(self):
        """
        GetLeftCol() -> int
        
        Return the column of the left top corner.
        """

    def SetLeftCol(self, col):
        """
        SetLeftCol(col)
        
        Set the column of the left top corner.
        """

    def GetBottomRow(self):
        """
        GetBottomRow() -> int
        
        Return the row of the bottom right corner.
        """

    def SetBottomRow(self, row):
        """
        SetBottomRow(row)
        
        Set the row of the bottom right corner.
        """

    def GetRightCol(self):
        """
        GetRightCol() -> int
        
        Return the column of the bottom right corner.
        """

    def SetRightCol(self, col):
        """
        SetRightCol(col)
        
        Set the column of the bottom right corner.
        """

    def GetTopLeft(self):
        """
        GetTopLeft() -> GridCellCoords
        
        Return the coordinates of the top left corner.
        """

    def GetBottomRight(self):
        """
        GetBottomRight() -> GridCellCoords
        
        Return the coordinates of the bottom right corner.
        """

    def Canonicalize(self):
        """
        Canonicalize() -> GridBlockCoords
        
        Return the canonicalized block where top left coordinates is less then
        bottom right coordinates.
        """

    def Intersects(self, other):
        """
        Intersects(other) -> bool
        
        Whether the blocks intersect.
        """

    def Contains(self, *args, **kw):
        """
        Contains(cell) -> bool
        Contains(other) -> bool
        
        Check whether this block contains the given cell.
        """

    def Difference(self, other, splitOrientation):
        """
        Difference(other, splitOrientation) -> GridBlockDiffResult
        
        Calculates the result blocks by subtracting the other block from this
        block.
        """

    def SymDifference(self, other):
        """
        SymDifference(other) -> GridBlockDiffResult
        
        Calculates the symmetric difference of the blocks.
        """

    def __eq__(self):
        """
        """

    def __ne__(self):
        """
        """
    BottomRight = property(None, None)
    BottomRow = property(None, None)
    LeftCol = property(None, None)
    RightCol = property(None, None)
    TopLeft = property(None, None)
    TopRow = property(None, None)

    def __bool__(self):
        """
        __bool__() -> int
        """

    def Get(self):
        """
        Get() -> (topRow, leftCol, bottomRow, rightCol)
        
        Return the block coordinants as a tuple.
        """

    def __str__(self):
        """
        
        """

    def __repr__(self):
        """
        
        """
# end of class GridBlockCoords


class GridBlockDiffResult(object):
    """
    The helper struct uses as a result type for difference functions of
    wxGridBlockCoords class.
    """

    def _getParts(self):
        """
        _getParts() -> PyObject
        """
    m_parts = property(None, None)
# end of class GridBlockDiffResult


class GridBlocks(object):
    """
    Represents a collection of grid blocks that can be iterated over.
    """

    class iterator(object):
        """
        Read-only forward iterator type.
        """
    # end of class iterator


    def begin(self):
        """
        begin() -> iterator
        
        Return iterator corresponding to the beginning of the range.
        """

    def end(self):
        """
        end() -> iterator
        
        Return iterator corresponding to the end of the range.
        """

    def __iter__(self):
        """
        Returns a Python iterator for accessing the collection of grid blocks.
        """

    class PyGridBlocksIterator(object):
        "A Python iterator for GridBlocks objects"
        def __init__(self, blocks):
            self._blocks = blocks
            self._iterator = self._blocks.begin()
    
        def __next__(self):
            if self._iterator == self._blocks.end():
                raise StopIteration
            obj = self._iterator._get()
            self._iterator = self._iterator._next()
            return obj
# end of class GridBlocks


class GridCellRenderer(wx.ClientDataContainer, wx.RefCounter):
    """
    GridCellRenderer()
    
    This class is responsible for actually drawing the cell in the grid.
    """

    def __init__(self):
        """
        GridCellRenderer()
        
        This class is responsible for actually drawing the cell in the grid.
        """

    def Clone(self):
        """
        Clone() -> GridCellRenderer
        
        This function must be implemented in derived classes to return a copy
        of itself.
        """

    def Draw(self, grid, attr, dc, rect, row, col, isSelected):
        """
        Draw(grid, attr, dc, rect, row, col, isSelected)
        
        Draw the given cell on the provided DC inside the given rectangle
        using the style specified by the attribute and the default or selected
        state corresponding to the isSelected value.
        """

    def GetBestSize(self, grid, attr, dc, row, col):
        """
        GetBestSize(grid, attr, dc, row, col) -> wx.Size
        
        Get the preferred size of the cell for its contents.
        """

    def GetBestHeight(self, grid, attr, dc, row, col, width):
        """
        GetBestHeight(grid, attr, dc, row, col, width) -> int
        
        Get the preferred height of the cell at the given width.
        """

    def GetBestWidth(self, grid, attr, dc, row, col, height):
        """
        GetBestWidth(grid, attr, dc, row, col, height) -> int
        
        Get the preferred width of the cell at the given height.
        """

    def GetMaxBestSize(self, grid, attr, dc):
        """
        GetMaxBestSize(grid, attr, dc) -> wx.Size
        
        Get the maximum possible size for a cell using this renderer, if
        possible.
        """
# end of class GridCellRenderer


class GridCellStringRenderer(GridCellRenderer):
    """
    GridCellStringRenderer()
    
    This class may be used to format string data in a cell; it is the
    default for string cells.
    """

    def __init__(self):
        """
        GridCellStringRenderer()
        
        This class may be used to format string data in a cell; it is the
        default for string cells.
        """
# end of class GridCellStringRenderer


class GridCellAutoWrapStringRenderer(GridCellStringRenderer):
    """
    GridCellAutoWrapStringRenderer()
    
    This class may be used to format string data in a cell.
    """

    def __init__(self):
        """
        GridCellAutoWrapStringRenderer()
        
        This class may be used to format string data in a cell.
        """
# end of class GridCellAutoWrapStringRenderer


class GridCellBoolRenderer(GridCellRenderer):
    """
    GridCellBoolRenderer()
    
    This class may be used to format boolean data in a cell.
    """

    def __init__(self):
        """
        GridCellBoolRenderer()
        
        This class may be used to format boolean data in a cell.
        """
# end of class GridCellBoolRenderer


class GridCellDateRenderer(GridCellStringRenderer):
    """
    GridCellDateRenderer(outformat="")
    
    This class may be used to show a date, without time, in a cell.
    """

    def __init__(self, outformat=""):
        """
        GridCellDateRenderer(outformat="")
        
        This class may be used to show a date, without time, in a cell.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        Sets the strftime()-like format string which will be used to render
        the date.
        """
# end of class GridCellDateRenderer


class GridCellDateTimeRenderer(GridCellDateRenderer):
    """
    GridCellDateTimeRenderer(outformat=wx.DefaultDateTimeFormat, informat=wx.DefaultDateTimeFormat)
    
    This class may be used to format a date/time data in a cell.
    """

    def __init__(self, outformat=wx.DefaultDateTimeFormat, informat=wx.DefaultDateTimeFormat):
        """
        GridCellDateTimeRenderer(outformat=wx.DefaultDateTimeFormat, informat=wx.DefaultDateTimeFormat)
        
        This class may be used to format a date/time data in a cell.
        """
# end of class GridCellDateTimeRenderer


class GridCellEnumRenderer(GridCellStringRenderer):
    """
    GridCellEnumRenderer(choices=wx.EmptyString)
    
    This class may be used to render in a cell a number as a textual
    equivalent.
    """

    def __init__(self, choices=wx.EmptyString):
        """
        GridCellEnumRenderer(choices=wx.EmptyString)
        
        This class may be used to render in a cell a number as a textual
        equivalent.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        Sets the comma separated string content of the enum.
        """
# end of class GridCellEnumRenderer


class GridCellFloatRenderer(GridCellStringRenderer):
    """
    GridCellFloatRenderer(width=-1, precision=-1, format=GRID_FLOAT_FORMAT_DEFAULT)
    
    This class may be used to format floating point data in a cell.
    """

    def __init__(self, width=-1, precision=-1, format=GRID_FLOAT_FORMAT_DEFAULT):
        """
        GridCellFloatRenderer(width=-1, precision=-1, format=GRID_FLOAT_FORMAT_DEFAULT)
        
        This class may be used to format floating point data in a cell.
        """

    def GetFormat(self):
        """
        GetFormat() -> int
        
        Returns the specifier used to format the data to string.
        """

    def GetPrecision(self):
        """
        GetPrecision() -> int
        
        Returns the precision.
        """

    def GetWidth(self):
        """
        GetWidth() -> int
        
        Returns the width.
        """

    def SetFormat(self, format):
        """
        SetFormat(format)
        
        Set the format to use for display the number.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        The parameters string format is "width[,precision[,format]]" where
        format should be chosen between f|e|g|E|G (f is used by default)
        """

    def SetPrecision(self, precision):
        """
        SetPrecision(precision)
        
        Sets the precision.
        """

    def SetWidth(self, width):
        """
        SetWidth(width)
        
        Sets the width.
        """
    Format = property(None, None)
    Precision = property(None, None)
    Width = property(None, None)
# end of class GridCellFloatRenderer


class GridCellNumberRenderer(GridCellStringRenderer):
    """
    GridCellNumberRenderer()
    
    This class may be used to format integer data in a cell.
    """

    def __init__(self):
        """
        GridCellNumberRenderer()
        
        This class may be used to format integer data in a cell.
        """
# end of class GridCellNumberRenderer


class GridActivationResult(object):
    """
    Represents the result of wxGridCellEditor::TryActivate().
    """

    @staticmethod
    def DoNothing():
        """
        DoNothing() -> GridActivationResult
        
        Indicate that nothing should be done and the cell shouldn't be edited
        at all.
        """

    @staticmethod
    def DoChange(newval):
        """
        DoChange(newval) -> GridActivationResult
        
        Indicate that activating the cell is possible and would change its
        value to the given one.
        """

    @staticmethod
    def DoEdit():
        """
        DoEdit() -> GridActivationResult
        
        Indicate that the editor control should be shown and the cell should
        be edited normally.
        """
# end of class GridActivationResult


class GridActivationSource(object):
    """
    Represents a source of cell activation, which may be either a user
    event (mouse or keyboard) or the program itself.
    """
    Program = 0
    Key = 0
    Mouse = 0

    def GetOrigin(self):
        """
        GetOrigin() -> Origin
        
        Get the origin of the activation.
        """

    def GetKeyEvent(self):
        """
        GetKeyEvent() -> wx.KeyEvent
        
        Get the key event corresponding to the key press activating the cell.
        """

    def GetMouseEvent(self):
        """
        GetMouseEvent() -> wx.MouseEvent
        
        Get the mouse event corresponding to the click activating the cell.
        """
    KeyEvent = property(None, None)
    MouseEvent = property(None, None)
# end of class GridActivationSource


class GridCellEditor(wx.ClientDataContainer, wx.RefCounter):
    """
    GridCellEditor()
    
    This class is responsible for providing and manipulating the in-place
    edit controls for the grid.
    """

    def __init__(self):
        """
        GridCellEditor()
        
        This class is responsible for providing and manipulating the in-place
        edit controls for the grid.
        """

    def BeginEdit(self, row, col, grid):
        """
        BeginEdit(row, col, grid)
        
        Fetch the value from the table and prepare the edit control to begin
        editing.
        """

    def Clone(self):
        """
        Clone() -> GridCellEditor
        
        Create a new object which is the copy of this one.
        """

    def Create(self, parent, id, evtHandler):
        """
        Create(parent, id, evtHandler)
        
        Creates the actual edit control.
        """

    def Destroy(self):
        """
        Destroy()
        
        Final cleanup.
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """

    def ApplyEdit(self, row, col, grid):
        """
        ApplyEdit(row, col, grid)
        
        Effectively save the changes in the grid.
        """

    def HandleReturn(self, event):
        """
        HandleReturn(event)
        
        Some types of controls on some platforms may need some help with the
        Return key.
        """

    def IsCreated(self):
        """
        IsCreated() -> bool
        
        Returns true if the edit control has been created.
        """

    def PaintBackground(self, dc, rectCell, attr):
        """
        PaintBackground(dc, rectCell, attr)
        
        Draws the part of the cell not occupied by the control: the base class
        version just fills it with background colour from the attribute.
        """

    def Reset(self):
        """
        Reset()
        
        Reset the value in the control back to its starting value.
        """

    def SetSize(self, rect):
        """
        SetSize(rect)
        
        Size and position the edit control.
        """

    def Show(self, show, attr=None):
        """
        Show(show, attr=None)
        
        Show or hide the edit control, use the specified attributes to set
        colours/fonts for it.
        """

    def StartingClick(self):
        """
        StartingClick()
        
        If the editor is enabled by clicking on the cell, this method will be
        called.
        """

    def StartingKey(self, event):
        """
        StartingKey(event)
        
        If the editor is enabled by pressing keys on the grid, this will be
        called to let the editor do something about that first key if desired.
        """

    def IsAcceptedKey(self, event):
        """
        IsAcceptedKey(event) -> bool
        
        Return true to allow the given key to start editing: the base class
        version only checks that the event has no modifiers.
        """

    def GetValue(self):
        """
        GetValue() -> String
        
        Returns the value currently in the editor control.
        """

    def GetWindow(self):
        """
        GetWindow() -> wx.Window
        
        Get the edit window used by this editor.
        """

    def SetWindow(self, window):
        """
        SetWindow(window)
        
        Set the wxWindow that will be used by this cell editor for editing the
        value.
        """

    def GetControl(self):
        """
        GetControl() -> wx.Control
        
        Get the wxControl used by this editor.
        """

    def SetControl(self, control):
        """
        SetControl(control)
        
        Set the wxControl that will be used by this cell editor for editing
        the value.
        """

    def TryActivate(self, row, col, grid, actSource):
        """
        TryActivate(row, col, grid, actSource) -> GridActivationResult
        
        Function allowing to create an "activatable" editor.
        """

    def DoActivate(self, row, col, grid):
        """
        DoActivate(row, col, grid)
        
        Function which must be overridden for "activatable" editors.
        """
    Control = property(None, None)
    Value = property(None, None)
    Window = property(None, None)
# end of class GridCellEditor


class GridCellActivatableEditor(GridCellEditor):
    """
    Base class for activatable editors.
    """

    def TryActivate(self, row, col, grid, actSource):
        """
        TryActivate(row, col, grid, actSource) -> GridActivationResult
        
        Same method as in wxGridCellEditor, but pure virtual.
        """

    def DoActivate(self, row, col, grid):
        """
        DoActivate(row, col, grid)
        
        Same method as in wxGridCellEditor, but pure virtual.
        """
# end of class GridCellActivatableEditor


class GridCellTextEditor(GridCellEditor):
    """
    GridCellTextEditor(maxChars=0)
    
    Grid cell editor for string/text data.
    """

    def __init__(self, maxChars=0):
        """
        GridCellTextEditor(maxChars=0)
        
        Grid cell editor for string/text data.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        The parameters string format is "n" where n is a number representing
        the maximum width.
        """

    def SetValidator(self, validator):
        """
        SetValidator(validator)
        
        Set validator to validate user input.
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellTextEditor


class GridCellDateEditor(GridCellEditor):
    """
    GridCellDateEditor(format="")
    
    Grid cell editor for dates.
    """

    def __init__(self, format=""):
        """
        GridCellDateEditor(format="")
        
        Grid cell editor for dates.
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellDateEditor


class GridCellAutoWrapStringEditor(GridCellTextEditor):
    """
    GridCellAutoWrapStringEditor()
    
    Grid cell editor for wrappable string/text data.
    """

    def __init__(self):
        """
        GridCellAutoWrapStringEditor()
        
        Grid cell editor for wrappable string/text data.
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellAutoWrapStringEditor


class GridCellBoolEditor(GridCellEditor):
    """
    GridCellBoolEditor()
    
    Grid cell editor for boolean data.
    """

    def __init__(self):
        """
        GridCellBoolEditor()
        
        Grid cell editor for boolean data.
        """

    @staticmethod
    def IsTrueValue(value):
        """
        IsTrueValue(value) -> bool
        
        Returns true if the given value is equal to the string representation
        of the truth value we currently use (see UseStringValues()).
        """

    @staticmethod
    def UseStringValues(valueTrue="1", valueFalse=wx.EmptyString):
        """
        UseStringValues(valueTrue="1", valueFalse=wx.EmptyString)
        
        This method allows you to customize the values returned by GetValue()
        for the cell using this editor.
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellBoolEditor


class GridCellChoiceEditor(GridCellEditor):
    """
    GridCellChoiceEditor(choices, allowOthers=False)
    
    Grid cell editor for string data providing the user a choice from a
    list of strings.
    """

    def __init__(self, choices, allowOthers=False):
        """
        GridCellChoiceEditor(choices, allowOthers=False)
        
        Grid cell editor for string data providing the user a choice from a
        list of strings.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        Parameters string format is "item1[,item2[...,itemN]]".
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellChoiceEditor


class GridCellEnumEditor(GridCellChoiceEditor):
    """
    GridCellEnumEditor(choices=wx.EmptyString)
    
    Grid cell editor which displays an enum number as a textual equivalent
    (e.g.
    """

    def __init__(self, choices=wx.EmptyString):
        """
        GridCellEnumEditor(choices=wx.EmptyString)
        
        Grid cell editor which displays an enum number as a textual equivalent
        (e.g.
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellEnumEditor


class GridCellFloatEditor(GridCellTextEditor):
    """
    GridCellFloatEditor(width=-1, precision=-1, format=GRID_FLOAT_FORMAT_DEFAULT)
    
    The editor for floating point numbers data.
    """

    def __init__(self, width=-1, precision=-1, format=GRID_FLOAT_FORMAT_DEFAULT):
        """
        GridCellFloatEditor(width=-1, precision=-1, format=GRID_FLOAT_FORMAT_DEFAULT)
        
        The editor for floating point numbers data.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        The parameters string format is "width[,precision[,format]]" where
        format should be chosen between f|e|g|E|G (f is used by default)
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellFloatEditor


class GridCellNumberEditor(GridCellTextEditor):
    """
    GridCellNumberEditor(min=-1, max=-1)
    
    Grid cell editor for numeric integer data.
    """

    def __init__(self, min=-1, max=-1):
        """
        GridCellNumberEditor(min=-1, max=-1)
        
        Grid cell editor for numeric integer data.
        """

    def SetParameters(self, params):
        """
        SetParameters(params)
        
        Parameters string format is "min,max".
        """

    def EndEdit(self, row, col, grid, oldval):
        """
        EndEdit(row, col, grid, oldval)
        
        End editing the cell.
        
        This function must check if the current value of the editing cell
        is valid and different from the original value in its string
        form. If not then simply return None.  If it has changed then
        this method should save the new value so that ApplyEdit can
        apply it later and the string representation of the new value
        should be returned.
        
        Notice that this method shoiuld not modify the grid as the
        change could still be vetoed.
        """
# end of class GridCellNumberEditor


class GridFitMode(object):
    """
    GridFitMode()
    
    Allows to specify the behaviour when the cell contents doesn't fit
    into its allotted space.
    """

    def __init__(self):
        """
        GridFitMode()
        
        Allows to specify the behaviour when the cell contents doesn't fit
        into its allotted space.
        """

    def IsSpecified(self):
        """
        IsSpecified() -> bool
        
        Return true if the object specifies some particular behaviour.
        """

    def IsClip(self):
        """
        IsClip() -> bool
        
        Return true if the object specifies clipping behaviour.
        """

    def IsOverflow(self):
        """
        IsOverflow() -> bool
        
        Return true if the object specifies overflow behaviour.
        """

    def GetEllipsizeMode(self):
        """
        GetEllipsizeMode() -> EllipsizeMode
        
        Return ellipsize mode, possibly wxELLIPSIZE_NONE.
        """

    @staticmethod
    def Clip():
        """
        Clip() -> GridFitMode
        
        Pseudo-constructor for object specifying clipping behaviour.
        """

    @staticmethod
    def Overflow():
        """
        Overflow() -> GridFitMode
        
        Pseudo-constructor for object specifying overflow behaviour.
        """

    @staticmethod
    def Ellipsize(ellipsize=wx.ELLIPSIZE_END):
        """
        Ellipsize(ellipsize=wx.ELLIPSIZE_END) -> GridFitMode
        
        Pseudo-constructor for object specifying ellipsize behaviour.
        """
    EllipsizeMode = property(None, None)
# end of class GridFitMode


class GridCellAttr(wx.ClientDataContainer, wx.RefCounter):
    """
    GridCellAttr(attrDefault=None)
    GridCellAttr(colText, colBack, font, hAlign, vAlign)
    
    This class can be used to alter the cells' appearance in the grid by
    changing their attributes from the defaults.
    """
    Any = 0
    Cell = 0
    Row = 0
    Col = 0
    Default = 0
    Merged = 0

    def __init__(self, *args, **kw):
        """
        GridCellAttr(attrDefault=None)
        GridCellAttr(colText, colBack, font, hAlign, vAlign)
        
        This class can be used to alter the cells' appearance in the grid by
        changing their attributes from the defaults.
        """

    def Clone(self):
        """
        Clone() -> GridCellAttr
        
        Creates a new copy of this object.
        """

    def DecRef(self):
        """
        DecRef()
        
        This class is reference counted: it is created with ref count of 1, so
        calling DecRef() once will delete it.
        """

    def GetAlignment(self):
        """
        GetAlignment() -> (hAlign, vAlign)
        
        Get the alignment to use for the cell with the given attribute.
        """

    def GetBackgroundColour(self):
        """
        GetBackgroundColour() -> wx.Colour
        
        Returns the background colour.
        """

    def GetEditor(self, grid, row, col):
        """
        GetEditor(grid, row, col) -> GridCellEditor
        
        Returns the cell editor.
        """

    def GetEditorPtr(self, grid, row, col):
        """
        GetEditorPtr(grid, row, col) -> GridCellEditorPtr
        
        Returns the cell editor.
        """

    def GetFont(self):
        """
        GetFont() -> wx.Font
        
        Returns the font.
        """

    def GetNonDefaultAlignment(self):
        """
        GetNonDefaultAlignment() -> (hAlign, vAlign)
        
        Get the alignment defined by this attribute.
        """

    def GetRenderer(self, grid, row, col):
        """
        GetRenderer(grid, row, col) -> GridCellRenderer
        
        Returns the cell renderer.
        """

    def GetRendererPtr(self, grid, row, col):
        """
        GetRendererPtr(grid, row, col) -> GridCellRendererPtr
        
        Returns the cell editor.
        """

    def GetTextColour(self):
        """
        GetTextColour() -> wx.Colour
        
        Returns the text colour.
        """

    def HasAlignment(self):
        """
        HasAlignment() -> bool
        
        Returns true if this attribute has a valid alignment set.
        """

    def HasBackgroundColour(self):
        """
        HasBackgroundColour() -> bool
        
        Returns true if this attribute has a valid background colour set.
        """

    def HasEditor(self):
        """
        HasEditor() -> bool
        
        Returns true if this attribute has a valid cell editor set.
        """

    def HasFont(self):
        """
        HasFont() -> bool
        
        Returns true if this attribute has a valid font set.
        """

    def HasRenderer(self):
        """
        HasRenderer() -> bool
        
        Returns true if this attribute has a valid cell renderer set.
        """

    def HasTextColour(self):
        """
        HasTextColour() -> bool
        
        Returns true if this attribute has a valid text colour set.
        """

    def IncRef(self):
        """
        IncRef()
        
        This class is reference counted: it is created with ref count of 1, so
        calling DecRef() once will delete it.
        """

    def IsReadOnly(self):
        """
        IsReadOnly() -> bool
        
        Returns true if this cell is set as read-only.
        """

    def SetAlignment(self, hAlign, vAlign):
        """
        SetAlignment(hAlign, vAlign)
        
        Sets the alignment.
        """

    def SetBackgroundColour(self, colBack):
        """
        SetBackgroundColour(colBack)
        
        Sets the background colour.
        """

    def SetDefAttr(self, defAttr):
        """
        SetDefAttr(defAttr)
        """

    def SetEditor(self, editor):
        """
        SetEditor(editor)
        
        Sets the editor to be used with the cells with this attribute.
        """

    def SetFont(self, font):
        """
        SetFont(font)
        
        Sets the font.
        """

    def SetReadOnly(self, isReadOnly=True):
        """
        SetReadOnly(isReadOnly=True)
        
        Sets the cell as read-only.
        """

    def SetRenderer(self, renderer):
        """
        SetRenderer(renderer)
        
        Sets the renderer to be used for cells with this attribute.
        """

    def SetTextColour(self, colText):
        """
        SetTextColour(colText)
        
        Sets the text colour.
        """

    def MergeWith(self, mergefrom):
        """
        MergeWith(mergefrom)
        """

    def SetSize(self, num_rows, num_cols):
        """
        SetSize(num_rows, num_cols)
        """

    def SetFitMode(self, fitMode):
        """
        SetFitMode(fitMode)
        
        Specifies the behaviour of the cell contents if it doesn't fit into
        the available space.
        """

    def SetOverflow(self, allow=True):
        """
        SetOverflow(allow=True)
        
        Specifies if cells using this attribute should overflow or clip their
        contents.
        """

    def SetKind(self, kind):
        """
        SetKind(kind)
        """

    def HasReadWriteMode(self):
        """
        HasReadWriteMode() -> bool
        """

    def HasOverflowMode(self):
        """
        HasOverflowMode() -> bool
        """

    def HasSize(self):
        """
        HasSize() -> bool
        """

    def GetSize(self):
        """
        GetSize() -> (num_rows, num_cols)
        """

    def GetFitMode(self):
        """
        GetFitMode() -> GridFitMode
        
        Returns the fitting mode for the cells using this attribute.
        """

    def GetOverflow(self):
        """
        GetOverflow() -> bool
        
        Returns true if the cells using this attribute overflow into the
        neighbouring cells.
        """

    def CanOverflow(self):
        """
        CanOverflow() -> bool
        
        Returns true if the cell will draw an overflowed text into the
        neighbouring cells.
        """

    def GetKind(self):
        """
        GetKind() -> AttrKind
        """
    BackgroundColour = property(None, None)
    FitMode = property(None, None)
    Font = property(None, None)
    Kind = property(None, None)
    Overflow = property(None, None)
    TextColour = property(None, None)
# end of class GridCellAttr


class GridCornerHeaderRenderer(GridHeaderLabelsRenderer):
    """
    Base class for corner header renderer.
    """
# end of class GridCornerHeaderRenderer


class GridHeaderLabelsRenderer(object):
    """
    Base class for header cells renderers.
    """

    def DrawBorder(self, grid, dc, rect):
        """
        DrawBorder(grid, dc, rect)
        
        Called by the grid to draw the border around the cell header.
        """

    def DrawLabel(self, grid, dc, value, rect, horizAlign, vertAlign, textOrientation):
        """
        DrawLabel(grid, dc, value, rect, horizAlign, vertAlign, textOrientation)
        
        Called by the grid to draw the specified label.
        """
# end of class GridHeaderLabelsRenderer


class GridRowHeaderRenderer(GridHeaderLabelsRenderer):
    """
    Base class for row headers renderer.
    """
# end of class GridRowHeaderRenderer


class GridColumnHeaderRenderer(GridHeaderLabelsRenderer):
    """
    Base class for column headers renderer.
    """
# end of class GridColumnHeaderRenderer


class GridRowHeaderRendererDefault(GridRowHeaderRenderer):
    """
    Default row header renderer.
    """

    def DrawBorder(self, grid, dc, rect):
        """
        DrawBorder(grid, dc, rect)
        
        Implement border drawing for the row labels.
        """
# end of class GridRowHeaderRendererDefault


class GridColumnHeaderRendererDefault(GridColumnHeaderRenderer):
    """
    Default column header renderer.
    """

    def DrawBorder(self, grid, dc, rect):
        """
        DrawBorder(grid, dc, rect)
        
        Implement border drawing for the column labels.
        """
# end of class GridColumnHeaderRendererDefault


class GridCornerHeaderRendererDefault(GridCornerHeaderRenderer):
    """
    Default corner window renderer.
    """

    def DrawBorder(self, grid, dc, rect):
        """
        DrawBorder(grid, dc, rect)
        
        Implement border drawing for the corner window.
        """
# end of class GridCornerHeaderRendererDefault


class GridCellAttrProvider(wx.ClientDataContainer):
    """
    GridCellAttrProvider()
    
    Class providing attributes to be used for the grid cells.
    """

    def __init__(self):
        """
        GridCellAttrProvider()
        
        Class providing attributes to be used for the grid cells.
        """

    def SetAttr(self, attr, row, col):
        """
        SetAttr(attr, row, col)
        
        Set attribute for the specified cell.
        """

    def SetRowAttr(self, attr, row):
        """
        SetRowAttr(attr, row)
        
        Set attribute for the specified row.
        """

    def SetColAttr(self, attr, col):
        """
        SetColAttr(attr, col)
        
        Set attribute for the specified column.
        """

    def GetColumnHeaderRenderer(self, col):
        """
        GetColumnHeaderRenderer(col) -> GridColumnHeaderRenderer
        
        Return the renderer used for drawing column headers.
        """

    def GetRowHeaderRenderer(self, row):
        """
        GetRowHeaderRenderer(row) -> GridRowHeaderRenderer
        
        Return the renderer used for drawing row headers.
        """

    def GetCornerRenderer(self):
        """
        GetCornerRenderer() -> GridCornerHeaderRenderer
        
        Return the renderer used for drawing the corner window.
        """

    def GetAttr(self, row, col, kind):
        """
        GetAttr(row, col, kind) -> GridCellAttr
        
        Get the attribute to use for the specified cell.
        """

    def GetAttrPtr(self, row, col, kind):
        """
        GetAttrPtr(row, col, kind) -> GridCellAttrPtr
        
        Get the attribute to use for the specified cell.
        """
    CornerRenderer = property(None, None)
# end of class GridCellAttrProvider


class GridTableBase(wx.Object):
    """
    GridTableBase()
    
    The almost abstract base class for grid tables.
    """

    def __init__(self):
        """
        GridTableBase()
        
        The almost abstract base class for grid tables.
        """

    def IsEmptyCell(self, row, col):
        """
        IsEmptyCell(row, col) -> bool
        
        May be overridden to implement testing for empty cells.
        """

    def IsEmpty(self, coords):
        """
        IsEmpty(coords) -> bool
        
        Same as IsEmptyCell() but taking wxGridCellCoords.
        """

    def GetValue(self, row, col):
        """
        GetValue(row, col) -> PyObject
        
        Must be overridden to implement accessing the table values as text.
        """

    def SetValue(self, row, col, value):
        """
        SetValue(row, col, value)
        
        Must be overridden to implement setting the table values as text.
        """

    def GetTypeName(self, row, col):
        """
        GetTypeName(row, col) -> String
        
        Returns the type of the value in the given cell.
        """

    def CanGetValueAs(self, row, col, typeName):
        """
        CanGetValueAs(row, col, typeName) -> bool
        
        Returns true if the value of the given cell can be accessed as if it
        were of the specified type.
        """

    def CanSetValueAs(self, row, col, typeName):
        """
        CanSetValueAs(row, col, typeName) -> bool
        
        Returns true if the value of the given cell can be set as if it were
        of the specified type.
        """

    def GetValueAsLong(self, row, col):
        """
        GetValueAsLong(row, col) -> long
        
        Returns the value of the given cell as a long.
        """

    def GetValueAsDouble(self, row, col):
        """
        GetValueAsDouble(row, col) -> double
        
        Returns the value of the given cell as a double.
        """

    def GetValueAsBool(self, row, col):
        """
        GetValueAsBool(row, col) -> bool
        
        Returns the value of the given cell as a boolean.
        """

    def SetValueAsLong(self, row, col, value):
        """
        SetValueAsLong(row, col, value)
        
        Sets the value of the given cell as a long.
        """

    def SetValueAsDouble(self, row, col, value):
        """
        SetValueAsDouble(row, col, value)
        
        Sets the value of the given cell as a double.
        """

    def SetValueAsBool(self, row, col, value):
        """
        SetValueAsBool(row, col, value)
        
        Sets the value of the given cell as a boolean.
        """

    def Clear(self):
        """
        Clear()
        
        Clear the table contents.
        """

    def InsertRows(self, pos=0, numRows=1):
        """
        InsertRows(pos=0, numRows=1) -> bool
        
        Insert additional rows into the table.
        """

    def AppendRows(self, numRows=1):
        """
        AppendRows(numRows=1) -> bool
        
        Append additional rows at the end of the table.
        """

    def DeleteRows(self, pos=0, numRows=1):
        """
        DeleteRows(pos=0, numRows=1) -> bool
        
        Delete rows from the table.
        """

    def InsertCols(self, pos=0, numCols=1):
        """
        InsertCols(pos=0, numCols=1) -> bool
        
        Exactly the same as InsertRows() but for columns.
        """

    def AppendCols(self, numCols=1):
        """
        AppendCols(numCols=1) -> bool
        
        Exactly the same as AppendRows() but for columns.
        """

    def DeleteCols(self, pos=0, numCols=1):
        """
        DeleteCols(pos=0, numCols=1) -> bool
        
        Exactly the same as DeleteRows() but for columns.
        """

    def GetRowLabelValue(self, row):
        """
        GetRowLabelValue(row) -> String
        
        Return the label of the specified row.
        """

    def GetColLabelValue(self, col):
        """
        GetColLabelValue(col) -> String
        
        Return the label of the specified column.
        """

    def GetCornerLabelValue(self):
        """
        GetCornerLabelValue() -> String
        
        Return the label of the grid's corner.
        """

    def SetRowLabelValue(self, row, label):
        """
        SetRowLabelValue(row, label)
        
        Set the given label for the specified row.
        """

    def SetColLabelValue(self, col, label):
        """
        SetColLabelValue(col, label)
        
        Exactly the same as SetRowLabelValue() but for columns.
        """

    def SetCornerLabelValue(self):
        """
        SetCornerLabelValue()
        
        Set the given label for the grid's corner.
        """

    def SetAttrProvider(self, attrProvider):
        """
        SetAttrProvider(attrProvider)
        
        Associate this attributes provider with the table.
        """

    def GetAttrProvider(self):
        """
        GetAttrProvider() -> GridCellAttrProvider
        
        Returns the attribute provider currently being used.
        """

    def GetAttr(self, row, col, kind):
        """
        GetAttr(row, col, kind) -> GridCellAttr
        
        Return the attribute for the given cell.
        """

    def GetAttrPtr(self, row, col, kind):
        """
        GetAttrPtr(row, col, kind) -> GridCellAttrPtr
        
        Return the attribute for the given cell.
        """

    def SetAttr(self, attr, row, col):
        """
        SetAttr(attr, row, col)
        
        Set attribute of the specified cell.
        """

    def SetRowAttr(self, attr, row):
        """
        SetRowAttr(attr, row)
        
        Set attribute of the specified row.
        """

    def SetColAttr(self, attr, col):
        """
        SetColAttr(attr, col)
        
        Set attribute of the specified column.
        """

    def GetNumberRows(self):
        """
        GetNumberRows() -> int
        
        Must be overridden to return the number of rows in the table.
        """

    def GetNumberCols(self):
        """
        GetNumberCols() -> int
        
        Must be overridden to return the number of columns in the table.
        """

    def GetRowsCount(self):
        """
        GetRowsCount() -> int
        
        Return the number of rows in the table.
        """

    def GetColsCount(self):
        """
        GetColsCount() -> int
        
        Return the number of columns in the table.
        """

    def SetView(self, grid):
        """
        SetView(grid)
        
        Called by the grid when the table is associated with it.
        """

    def GetView(self):
        """
        GetView() -> Grid
        
        Returns the last grid passed to SetView().
        """

    def CanHaveAttributes(self):
        """
        CanHaveAttributes() -> bool
        
        Returns true if this table supports attributes or false otherwise.
        """

    def CanMeasureColUsingSameAttr(self, col):
        """
        CanMeasureColUsingSameAttr(col) -> bool
        
        Override to return true if the same attribute can be used for
        measuring all cells in the given column.
        """

    def GetValueAsLong(self, row, col):
        """
        
        """

    def GetValueAsDouble(self, row, col):
        """
        
        """

    def GetValueAsBool(self, row, col):
        """
        
        """

    def SetValueAsLong(self, row, col, value):
        """
        
        """

    def SetValueAsDouble(self, row, col, value):
        """
        
        """

    def SetValueAsBool(self, row, col, value):
        """
        
        """
    AttrProvider = property(None, None)
    ColsCount = property(None, None)
    CornerLabelValue = property(None, None)
    NumberCols = property(None, None)
    NumberRows = property(None, None)
    RowsCount = property(None, None)
    View = property(None, None)
# end of class GridTableBase


class GridTableMessage(object):
    """
    GridTableMessage()
    GridTableMessage(table, id, comInt1=-1, comInt2=-1)
    
    Message class used by the grid table to send requests and
    notifications to the grid view.
    """

    def __init__(self, *args, **kw):
        """
        GridTableMessage()
        GridTableMessage(table, id, comInt1=-1, comInt2=-1)
        
        Message class used by the grid table to send requests and
        notifications to the grid view.
        """

    def SetTableObject(self, table):
        """
        SetTableObject(table)
        
        Sets the table object.
        """

    def GetTableObject(self):
        """
        GetTableObject() -> GridTableBase
        
        Gets the table object.
        """

    def SetId(self, id):
        """
        SetId(id)
        
        Sets an id.
        """

    def GetId(self):
        """
        GetId() -> int
        
        Gets an id.
        """

    def SetCommandInt(self, comInt1):
        """
        SetCommandInt(comInt1)
        
        Set the position after which the insertion/deletion occur.
        """

    def GetCommandInt(self):
        """
        GetCommandInt() -> int
        
        Get the position after which the insertion/deletion occur.
        """

    def SetCommandInt2(self, comInt2):
        """
        SetCommandInt2(comInt2)
        
        Set the number of rows to be inserted/deleted.
        """

    def GetCommandInt2(self):
        """
        GetCommandInt2() -> int
        
        Get the number of rows to be inserted/deleted.
        """
    CommandInt = property(None, None)
    CommandInt2 = property(None, None)
    Id = property(None, None)
    TableObject = property(None, None)
# end of class GridTableMessage


class GridStringTable(object):
    """
    GridStringTable()
    GridStringTable(numRows, numCols)
    
    Simplest type of data table for a grid for small tables of strings
    that are stored in memory.
    """

    def __init__(self, *args, **kw):
        """
        GridStringTable()
        GridStringTable(numRows, numCols)
        
        Simplest type of data table for a grid for small tables of strings
        that are stored in memory.
        """

    def GetNumberRows(self):
        """
        GetNumberRows() -> int
        """

    def GetNumberCols(self):
        """
        GetNumberCols() -> int
        """

    def GetValue(self, row, col):
        """
        GetValue(row, col) -> String
        """

    def SetValue(self, row, col, s):
        """
        SetValue(row, col, s)
        """

    def Clear(self):
        """
        Clear()
        """

    def InsertRows(self, pos=0, numRows=1):
        """
        InsertRows(pos=0, numRows=1) -> bool
        """

    def AppendRows(self, numRows=1):
        """
        AppendRows(numRows=1) -> bool
        """

    def DeleteRows(self, pos=0, numRows=1):
        """
        DeleteRows(pos=0, numRows=1) -> bool
        """

    def InsertCols(self, pos=0, numCols=1):
        """
        InsertCols(pos=0, numCols=1) -> bool
        """

    def AppendCols(self, numCols=1):
        """
        AppendCols(numCols=1) -> bool
        """

    def DeleteCols(self, pos=0, numCols=1):
        """
        DeleteCols(pos=0, numCols=1) -> bool
        """

    def SetRowLabelValue(self, row, ):
        """
        SetRowLabelValue(row, )
        """

    def SetColLabelValue(self, col, ):
        """
        SetColLabelValue(col, )
        """

    def SetCornerLabelValue(self):
        """
        SetCornerLabelValue()
        """

    def GetRowLabelValue(self, row):
        """
        GetRowLabelValue(row) -> String
        """

    def GetColLabelValue(self, col):
        """
        GetColLabelValue(col) -> String
        """

    def GetCornerLabelValue(self):
        """
        GetCornerLabelValue() -> String
        """
    CornerLabelValue = property(None, None)
    NumberCols = property(None, None)
    NumberRows = property(None, None)
# end of class GridStringTable


class GridSizesInfo(object):
    """
    GridSizesInfo()
    GridSizesInfo(defSize, allSizes)
    
    wxGridSizesInfo stores information about sizes of all wxGrid rows or
    columns.
    """

    def __init__(self, *args, **kw):
        """
        GridSizesInfo()
        GridSizesInfo(defSize, allSizes)
        
        wxGridSizesInfo stores information about sizes of all wxGrid rows or
        columns.
        """
    m_sizeDefault = property(None, None)

    def GetSize(self, pos):
        """
        GetSize(pos) -> int
        
        Get the element size.
        """
# end of class GridSizesInfo


class Grid(wx.ScrolledCanvas):
    """
    Grid()
    Grid(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.WANTS_CHARS, name=GridNameStr)
    
    wxGrid and its related classes are used for displaying and editing
    tabular data.
    """
    GridSelectCells = 0
    GridSelectRows = 0
    GridSelectColumns = 0
    GridSelectRowsOrColumns = 0
    GridSelectNone = 0
    CellSpan_Inside = 0
    CellSpan_None = 0
    CellSpan_Main = 0
    Tab_Stop = 0
    Tab_Wrap = 0
    Tab_Leave = 0

    def __init__(self, *args, **kw):
        """
        Grid()
        Grid(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.WANTS_CHARS, name=GridNameStr)
        
        wxGrid and its related classes are used for displaying and editing
        tabular data.
        """

    def Create(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.WANTS_CHARS, name=GridNameStr):
        """
        Create(parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.WANTS_CHARS, name=GridNameStr) -> bool
        
        Creates the grid window for an object initialized using the default
        constructor.
        """

    def CreateGrid(self, numRows, numCols, selmode=GridSelectCells):
        """
        CreateGrid(numRows, numCols, selmode=GridSelectCells) -> bool
        
        Creates a grid with the specified initial number of rows and columns.
        """

    def _SetTable(self, table, takeOwnership=False, selmode=GridSelectCells):
        """
        _SetTable(table, takeOwnership=False, selmode=GridSelectCells) -> bool
        
        Passes a pointer to a custom grid table to be used by the grid.
        """

    def AssignTable(self, table, selmode=GridSelectCells):
        """
        AssignTable(table, selmode=GridSelectCells)
        
        Assigns a pointer to a custom grid table to be used by the grid.
        """

    def ProcessTableMessage(self, msg):
        """
        ProcessTableMessage(msg) -> bool
        
        Receive and handle a message from the table.
        """

    def EnableGridLines(self, enable=True):
        """
        EnableGridLines(enable=True)
        
        Turns the drawing of grid lines on or off.
        """

    def GetColGridLinePen(self, col):
        """
        GetColGridLinePen(col) -> wx.Pen
        
        Returns the pen used for vertical grid lines.
        """

    def GetDefaultGridLinePen(self):
        """
        GetDefaultGridLinePen() -> wx.Pen
        
        Returns the pen used for grid lines.
        """

    def GetGridLineColour(self):
        """
        GetGridLineColour() -> wx.Colour
        
        Returns the colour used for grid lines.
        """

    def GetRowGridLinePen(self, row):
        """
        GetRowGridLinePen(row) -> wx.Pen
        
        Returns the pen used for horizontal grid lines.
        """

    def GridLinesEnabled(self):
        """
        GridLinesEnabled() -> bool
        
        Returns true if drawing of grid lines is turned on, false otherwise.
        """

    def SetGridLineColour(self, colour):
        """
        SetGridLineColour(colour)
        
        Sets the colour used to draw grid lines.
        """

    def GetColLabelAlignment(self):
        """
        GetColLabelAlignment() -> (horiz, vert)
        
        Sets the arguments to the current column label alignment values.
        """

    def GetColLabelTextOrientation(self):
        """
        GetColLabelTextOrientation() -> int
        
        Returns the orientation of the column labels (either wxHORIZONTAL or
        wxVERTICAL).
        """

    def GetColLabelValue(self, col):
        """
        GetColLabelValue(col) -> String
        
        Returns the specified column label.
        """

    def GetCornerLabelAlignment(self, horiz, vert):
        """
        GetCornerLabelAlignment(horiz, vert)
        
        Sets the arguments to the current corner label alignment values.
        """

    def GetCornerLabelTextOrientation(self):
        """
        GetCornerLabelTextOrientation() -> int
        
        Returns the orientation of the corner label (either wxHORIZONTAL or
        wxVERTICAL).
        """

    def GetCornerLabelValue(self):
        """
        GetCornerLabelValue() -> String
        
        Returns the (top-left) corner label.
        """

    def GetLabelBackgroundColour(self):
        """
        GetLabelBackgroundColour() -> wx.Colour
        
        Returns the colour used for the background of row and column labels.
        """

    def GetLabelFont(self):
        """
        GetLabelFont() -> wx.Font
        
        Returns the font used for row and column labels.
        """

    def GetLabelTextColour(self):
        """
        GetLabelTextColour() -> wx.Colour
        
        Returns the colour used for row and column label text.
        """

    def GetRowLabelAlignment(self):
        """
        GetRowLabelAlignment() -> (horiz, vert)
        
        Returns the alignment used for row labels.
        """

    def GetRowLabelValue(self, row):
        """
        GetRowLabelValue(row) -> String
        
        Returns the specified row label.
        """

    def HideColLabels(self):
        """
        HideColLabels()
        
        Hides the column labels by calling SetColLabelSize() with a size of 0.
        """

    def HideRowLabels(self):
        """
        HideRowLabels()
        
        Hides the row labels by calling SetRowLabelSize() with a size of 0.
        """

    def SetColLabelAlignment(self, horiz, vert):
        """
        SetColLabelAlignment(horiz, vert)
        
        Sets the horizontal and vertical alignment of column label text.
        """

    def SetColLabelTextOrientation(self, textOrientation):
        """
        SetColLabelTextOrientation(textOrientation)
        
        Sets the orientation of the column labels (either wxHORIZONTAL or
        wxVERTICAL).
        """

    def SetColLabelValue(self, col, value):
        """
        SetColLabelValue(col, value)
        
        Set the value for the given column label.
        """

    def SetCornerLabelAlignment(self, horiz, vert):
        """
        SetCornerLabelAlignment(horiz, vert)
        
        Sets the horizontal and vertical alignment of the (top-left) corner
        label text.
        """

    def SetCornerLabelTextOrientation(self, textOrientation):
        """
        SetCornerLabelTextOrientation(textOrientation)
        
        Sets the orientation of the (top-left) corner label (either
        wxHORIZONTAL or wxVERTICAL).
        """

    def SetCornerLabelValue(self):
        """
        SetCornerLabelValue()
        
        Set the value for the (top-left) corner label.
        """

    def SetLabelBackgroundColour(self, colour):
        """
        SetLabelBackgroundColour(colour)
        
        Sets the background colour for row and column labels.
        """

    def SetLabelFont(self, font):
        """
        SetLabelFont(font)
        
        Sets the font for row and column labels.
        """

    def SetLabelTextColour(self, colour):
        """
        SetLabelTextColour(colour)
        
        Sets the colour for row and column label text.
        """

    def SetRowLabelAlignment(self, horiz, vert):
        """
        SetRowLabelAlignment(horiz, vert)
        
        Sets the horizontal and vertical alignment of row label text.
        """

    def SetRowLabelValue(self, row, value):
        """
        SetRowLabelValue(row, value)
        
        Sets the value for the given row label.
        """

    def SetUseNativeColLabels(self, native=True):
        """
        SetUseNativeColLabels(native=True)
        
        Call this in order to make the column labels use a native look by
        using wxRendererNative::DrawHeaderButton() internally.
        """

    def UseNativeColHeader(self, native=True):
        """
        UseNativeColHeader(native=True) -> bool
        
        Enable the use of native header window for column labels.
        """

    def GetCellAlignment(self, row, col):
        """
        GetCellAlignment(row, col) -> (horiz, vert)
        
        Sets the arguments to the horizontal and vertical text alignment
        values for the grid cell at the specified location.
        """

    def GetCellBackgroundColour(self, row, col):
        """
        GetCellBackgroundColour(row, col) -> wx.Colour
        
        Returns the background colour of the cell at the specified location.
        """

    def GetCellFont(self, row, col):
        """
        GetCellFont(row, col) -> wx.Font
        
        Returns the font for text in the grid cell at the specified location.
        """

    def GetCellTextColour(self, row, col):
        """
        GetCellTextColour(row, col) -> wx.Colour
        
        Returns the text colour for the grid cell at the specified location.
        """

    def GetDefaultCellAlignment(self):
        """
        GetDefaultCellAlignment() -> (horiz, vert)
        
        Returns the default cell alignment.
        """

    def GetDefaultCellBackgroundColour(self):
        """
        GetDefaultCellBackgroundColour() -> wx.Colour
        
        Returns the current default background colour for grid cells.
        """

    def GetDefaultCellFont(self):
        """
        GetDefaultCellFont() -> wx.Font
        
        Returns the current default font for grid cell text.
        """

    def GetDefaultCellTextColour(self):
        """
        GetDefaultCellTextColour() -> wx.Colour
        
        Returns the current default colour for grid cell text.
        """

    def SetCellAlignment(self, row, col, horiz, vert):
        """
        SetCellAlignment(row, col, horiz, vert)
        
        Sets the horizontal and vertical alignment for grid cell text at the
        specified location.
        """

    def SetCellBackgroundColour(self, row, col, colour):
        """
        SetCellBackgroundColour(row, col, colour)
        
        Set the background colour for the given cell or all cells by default.
        """

    def SetCellFont(self, row, col, font):
        """
        SetCellFont(row, col, font)
        
        Sets the font for text in the grid cell at the specified location.
        """

    def SetCellTextColour(self, row, col, colour):
        """
        SetCellTextColour(row, col, colour)
        
        Sets the text colour for the given cell.
        """

    def SetDefaultCellAlignment(self, horiz, vert):
        """
        SetDefaultCellAlignment(horiz, vert)
        
        Sets the default horizontal and vertical alignment for grid cell text.
        """

    def SetDefaultCellBackgroundColour(self, colour):
        """
        SetDefaultCellBackgroundColour(colour)
        
        Sets the default background colour for grid cells.
        """

    def SetDefaultCellFont(self, font):
        """
        SetDefaultCellFont(font)
        
        Sets the default font to be used for grid cell text.
        """

    def SetDefaultCellTextColour(self, colour):
        """
        SetDefaultCellTextColour(colour)
        
        Sets the current default colour for grid cell text.
        """

    def CanEnableCellControl(self):
        """
        CanEnableCellControl() -> bool
        
        Returns true if the in-place edit control for the current grid cell
        can be used and false otherwise.
        """

    def DisableCellEditControl(self):
        """
        DisableCellEditControl()
        
        Disables in-place editing of grid cells.
        """

    def EnableCellEditControl(self, enable=True):
        """
        EnableCellEditControl(enable=True)
        
        Enables or disables in-place editing of grid cell data.
        """

    def EnableEditing(self, edit):
        """
        EnableEditing(edit)
        
        Makes the grid globally editable or read-only.
        """

    def GetCellEditor(self, row, col):
        """
        GetCellEditor(row, col) -> GridCellEditor
        
        Returns a pointer to the editor for the cell at the specified
        location.
        """

    def GetCellRenderer(self, row, col):
        """
        GetCellRenderer(row, col) -> GridCellRenderer
        
        Returns a pointer to the renderer for the grid cell at the specified
        location.
        """

    def GetCellValue(self, *args, **kw):
        """
        GetCellValue(row, col) -> String
        GetCellValue(coords) -> String
        
        Returns the string contained in the cell at the specified location.
        """

    def GetDefaultEditor(self):
        """
        GetDefaultEditor() -> GridCellEditor
        
        Returns a pointer to the current default grid cell editor.
        """

    def GetDefaultEditorForCell(self, *args, **kw):
        """
        GetDefaultEditorForCell(row, col) -> GridCellEditor
        GetDefaultEditorForCell(c) -> GridCellEditor
        
        Returns the default editor for the specified cell.
        """

    def GetDefaultEditorForType(self, typeName):
        """
        GetDefaultEditorForType(typeName) -> GridCellEditor
        
        Returns the default editor for the cells containing values of the
        given type.
        """

    def GetDefaultRenderer(self):
        """
        GetDefaultRenderer() -> GridCellRenderer
        
        Returns a pointer to the current default grid cell renderer.
        """

    def GetDefaultRendererForCell(self, row, col):
        """
        GetDefaultRendererForCell(row, col) -> GridCellRenderer
        
        Returns the default renderer for the given cell.
        """

    def GetDefaultRendererForType(self, typeName):
        """
        GetDefaultRendererForType(typeName) -> GridCellRenderer
        
        Returns the default renderer for the cell containing values of the
        given type.
        """

    def HideCellEditControl(self):
        """
        HideCellEditControl()
        
        Hides the in-place cell edit control.
        """

    def IsCellEditControlEnabled(self):
        """
        IsCellEditControlEnabled() -> bool
        
        Returns true if the in-place edit control is currently enabled.
        """

    def IsCellEditControlShown(self):
        """
        IsCellEditControlShown() -> bool
        
        Returns true if the in-place edit control is currently shown.
        """

    def IsCurrentCellReadOnly(self):
        """
        IsCurrentCellReadOnly() -> bool
        
        Returns true if the current cell is read-only.
        """

    def IsEditable(self):
        """
        IsEditable() -> bool
        
        Returns false if the whole grid has been set as read-only or true
        otherwise.
        """

    def IsReadOnly(self, row, col):
        """
        IsReadOnly(row, col) -> bool
        
        Returns true if the cell at the specified location can't be edited.
        """

    def RegisterDataType(self, typeName, renderer, editor):
        """
        RegisterDataType(typeName, renderer, editor)
        
        Register a new data type.
        """

    def SaveEditControlValue(self):
        """
        SaveEditControlValue()
        
        Sets the value of the current grid cell to the current in-place edit
        control value.
        """

    def SetCellEditor(self, row, col, editor):
        """
        SetCellEditor(row, col, editor)
        
        Sets the editor for the grid cell at the specified location.
        """

    def SetCellRenderer(self, row, col, renderer):
        """
        SetCellRenderer(row, col, renderer)
        
        Sets the renderer for the grid cell at the specified location.
        """

    def SetCellValue(self, *args, **kw):
        """
        SetCellValue(row, col, s)
        SetCellValue(coords, s)
        
        Sets the string value for the cell at the specified location.
        """

    def SetColFormatBool(self, col):
        """
        SetColFormatBool(col)
        
        Sets the specified column to display boolean values.
        """

    def SetColFormatCustom(self, col, typeName):
        """
        SetColFormatCustom(col, typeName)
        
        Sets the specified column to display data in a custom format.
        """

    def SetColFormatFloat(self, col, width=-1, precision=-1):
        """
        SetColFormatFloat(col, width=-1, precision=-1)
        
        Sets the specified column to display floating point values with the
        given width and precision.
        """

    def SetColFormatNumber(self, col):
        """
        SetColFormatNumber(col)
        
        Sets the specified column to display integer values.
        """

    def SetColFormatDate(self, col, format=""):
        """
        SetColFormatDate(col, format="")
        
        Sets the specified column to display date values.
        """

    def SetDefaultEditor(self, editor):
        """
        SetDefaultEditor(editor)
        
        Sets the default editor for grid cells.
        """

    def SetDefaultRenderer(self, renderer):
        """
        SetDefaultRenderer(renderer)
        
        Sets the default renderer for grid cells.
        """

    def SetReadOnly(self, row, col, isReadOnly=True):
        """
        SetReadOnly(row, col, isReadOnly=True)
        
        Makes the cell at the specified location read-only or editable.
        """

    def ShowCellEditControl(self):
        """
        ShowCellEditControl()
        
        Displays the active in-place cell edit control for the current cell
        after it was hidden.
        """

    def AutoSize(self):
        """
        AutoSize()
        
        Automatically sets the height and width of all rows and columns to fit
        their contents.
        """

    def AutoSizeColLabelSize(self, col):
        """
        AutoSizeColLabelSize(col)
        
        Automatically adjusts width of the column to fit its label.
        """

    def AutoSizeColumn(self, col, setAsMin=True):
        """
        AutoSizeColumn(col, setAsMin=True)
        
        Automatically sizes the column to fit its contents.
        """

    def AutoSizeColumns(self, setAsMin=True):
        """
        AutoSizeColumns(setAsMin=True)
        
        Automatically sizes all columns to fit their contents.
        """

    def AutoSizeRow(self, row, setAsMin=True):
        """
        AutoSizeRow(row, setAsMin=True)
        
        Automatically sizes the row to fit its contents.
        """

    def AutoSizeRowLabelSize(self, col):
        """
        AutoSizeRowLabelSize(col)
        
        Automatically adjusts height of the row to fit its label.
        """

    def AutoSizeRows(self, setAsMin=True):
        """
        AutoSizeRows(setAsMin=True)
        
        Automatically sizes all rows to fit their contents.
        """

    def GetCellFitMode(self, row, col):
        """
        GetCellFitMode(row, col) -> GridFitMode
        
        Returns the cell fitting mode.
        """

    def GetCellOverflow(self, row, col):
        """
        GetCellOverflow(row, col) -> bool
        
        Returns true if the cell value can overflow.
        """

    def GetColLabelSize(self):
        """
        GetColLabelSize() -> int
        
        Returns the current height of the column labels.
        """

    def GetColMinimalAcceptableWidth(self):
        """
        GetColMinimalAcceptableWidth() -> int
        
        Returns the minimal width to which a column may be resized.
        """

    def GetColSize(self, col):
        """
        GetColSize(col) -> int
        
        Returns the width of the specified column.
        """

    def IsColShown(self, col):
        """
        IsColShown(col) -> bool
        
        Returns true if the specified column is not currently hidden.
        """

    def GetDefaultCellFitMode(self):
        """
        GetDefaultCellFitMode() -> GridFitMode
        
        Returns the default cell fitting mode.
        """

    def GetDefaultCellOverflow(self):
        """
        GetDefaultCellOverflow() -> bool
        
        Returns true if the cells can overflow by default.
        """

    def GetDefaultColLabelSize(self):
        """
        GetDefaultColLabelSize() -> int
        
        Returns the default height for column labels.
        """

    def GetDefaultColSize(self):
        """
        GetDefaultColSize() -> int
        
        Returns the current default width for grid columns.
        """

    def GetDefaultRowLabelSize(self):
        """
        GetDefaultRowLabelSize() -> int
        
        Returns the default width for the row labels.
        """

    def GetDefaultRowSize(self):
        """
        GetDefaultRowSize() -> int
        
        Returns the current default height for grid rows.
        """

    def GetRowMinimalAcceptableHeight(self):
        """
        GetRowMinimalAcceptableHeight() -> int
        
        Returns the minimal size to which rows can be resized.
        """

    def GetRowLabelSize(self):
        """
        GetRowLabelSize() -> int
        
        Returns the current width of the row labels.
        """

    def GetRowSize(self, row):
        """
        GetRowSize(row) -> int
        
        Returns the height of the specified row.
        """

    def IsRowShown(self, row):
        """
        IsRowShown(row) -> bool
        
        Returns true if the specified row is not currently hidden.
        """

    def SetCellFitMode(self, row, col, fitMode):
        """
        SetCellFitMode(row, col, fitMode)
        
        Specifies the behaviour of the cell contents if it doesn't fit into
        the available space.
        """

    def SetCellOverflow(self, row, col, allow):
        """
        SetCellOverflow(row, col, allow)
        
        Sets the overflow permission of the cell.
        """

    def SetColLabelSize(self, height):
        """
        SetColLabelSize(height)
        
        Sets the height of the column labels.
        """

    def SetColMinimalAcceptableWidth(self, width):
        """
        SetColMinimalAcceptableWidth(width)
        
        Sets the minimal width to which the user can resize columns.
        """

    def SetColMinimalWidth(self, col, width):
        """
        SetColMinimalWidth(col, width)
        
        Sets the minimal width for the specified column col.
        """

    def SetColSize(self, col, width):
        """
        SetColSize(col, width)
        
        Sets the width of the specified column.
        """

    def HideCol(self, col):
        """
        HideCol(col)
        
        Hides the specified column.
        """

    def ShowCol(self, col):
        """
        ShowCol(col)
        
        Shows the previously hidden column by resizing it to non-0 size.
        """

    def SetDefaultCellFitMode(self, fitMode):
        """
        SetDefaultCellFitMode(fitMode)
        
        Specifies the default behaviour of the cell contents if it doesn't fit
        into the available space.
        """

    def SetDefaultCellOverflow(self, allow):
        """
        SetDefaultCellOverflow(allow)
        
        Sets the default overflow permission of the cells.
        """

    def SetDefaultColSize(self, width, resizeExistingCols=False):
        """
        SetDefaultColSize(width, resizeExistingCols=False)
        
        Sets the default width for columns in the grid.
        """

    def SetDefaultRowSize(self, height, resizeExistingRows=False):
        """
        SetDefaultRowSize(height, resizeExistingRows=False)
        
        Sets the default height for rows in the grid.
        """

    def SetRowLabelSize(self, width):
        """
        SetRowLabelSize(width)
        
        Sets the width of the row labels.
        """

    def SetRowMinimalAcceptableHeight(self, height):
        """
        SetRowMinimalAcceptableHeight(height)
        
        Sets the minimal row height used by default.
        """

    def SetRowMinimalHeight(self, row, height):
        """
        SetRowMinimalHeight(row, height)
        
        Sets the minimal height for the specified row.
        """

    def SetRowSize(self, row, height):
        """
        SetRowSize(row, height)
        
        Sets the height of the specified row.
        """

    def HideRow(self, col):
        """
        HideRow(col)
        
        Hides the specified row.
        """

    def ShowRow(self, col):
        """
        ShowRow(col)
        
        Shows the previously hidden row.
        """

    def GetColSizes(self):
        """
        GetColSizes() -> GridSizesInfo
        
        Get size information for all columns at once.
        """

    def GetRowSizes(self):
        """
        GetRowSizes() -> GridSizesInfo
        
        Get size information for all row at once.
        """

    def SetColSizes(self, sizeInfo):
        """
        SetColSizes(sizeInfo)
        
        Restore all columns sizes.
        """

    def SetRowSizes(self, sizeInfo):
        """
        SetRowSizes(sizeInfo)
        
        Restore all rows sizes.
        """

    def SetCellSize(self, row, col, num_rows, num_cols):
        """
        SetCellSize(row, col, num_rows, num_cols)
        
        Set the size of the cell.
        """

    def GetCellSize(self, *args, **kw):
        """
        GetCellSize(row, col, num_rows, num_cols) -> CellSpan
        GetCellSize(coords) -> wx.Size
        
        Get the size of the cell in number of cells covered by it.
        """

    def CanDragCell(self):
        """
        CanDragCell() -> bool
        
        Return true if the dragging of cells is enabled or false otherwise.
        """

    def CanDragColMove(self):
        """
        CanDragColMove() -> bool
        
        Returns true if columns can be moved by dragging with the mouse.
        """

    def CanDragColSize(self, col):
        """
        CanDragColSize(col) -> bool
        
        Returns true if the given column can be resized by dragging with the
        mouse.
        """

    def CanDragGridColEdges(self):
        """
        CanDragGridColEdges() -> bool
        
        Return true if column edges inside the grid can be dragged to resize
        the rows.
        """

    def CanDragGridRowEdges(self):
        """
        CanDragGridRowEdges() -> bool
        
        Return true if row edges inside the grid can be dragged to resize the
        rows.
        """

    def CanDragGridSize(self):
        """
        CanDragGridSize() -> bool
        
        Return true if the dragging of grid lines to resize rows and columns
        is enabled or false otherwise.
        """

    def CanDragRowSize(self, row):
        """
        CanDragRowSize(row) -> bool
        
        Returns true if the given row can be resized by dragging with the
        mouse.
        """

    def CanHideColumns(self):
        """
        CanHideColumns() -> bool
        
        Returns true if columns can be hidden from the popup menu of the
        native header.
        """

    def DisableColResize(self, col):
        """
        DisableColResize(col)
        
        Disable interactive resizing of the specified column.
        """

    def DisableRowResize(self, row):
        """
        DisableRowResize(row)
        
        Disable interactive resizing of the specified row.
        """

    def DisableDragColMove(self):
        """
        DisableDragColMove()
        
        Disables column moving by dragging with the mouse.
        """

    def DisableDragColSize(self):
        """
        DisableDragColSize()
        
        Disables column sizing by dragging with the mouse.
        """

    def DisableDragGridSize(self):
        """
        DisableDragGridSize()
        
        Disable mouse dragging of grid lines to resize rows and columns.
        """

    def DisableDragRowSize(self):
        """
        DisableDragRowSize()
        
        Disables row sizing by dragging with the mouse.
        """

    def DisableHidingColumns(self):
        """
        DisableHidingColumns()
        
        Disables column hiding from the header popup menu.
        """

    def EnableDragCell(self, enable=True):
        """
        EnableDragCell(enable=True)
        
        Enables or disables cell dragging with the mouse.
        """

    def EnableDragColMove(self, enable=True):
        """
        EnableDragColMove(enable=True) -> bool
        
        Enables or disables column moving by dragging with the mouse.
        """

    def EnableDragColSize(self, enable=True):
        """
        EnableDragColSize(enable=True)
        
        Enables or disables column sizing by dragging with the mouse.
        """

    def EnableDragGridSize(self, enable=True):
        """
        EnableDragGridSize(enable=True)
        
        Enables or disables row and column resizing by dragging gridlines with
        the mouse.
        """

    def EnableDragRowSize(self, enable=True):
        """
        EnableDragRowSize(enable=True)
        
        Enables or disables row sizing by dragging with the mouse.
        """

    def EnableHidingColumns(self, enable=True):
        """
        EnableHidingColumns(enable=True) -> bool
        
        Enables or disables column hiding from the header popup menu.
        """

    def GetColAt(self, colPos):
        """
        GetColAt(colPos) -> int
        
        Returns the column ID of the specified column position.
        """

    def GetColPos(self, colID):
        """
        GetColPos(colID) -> int
        
        Returns the position of the specified column.
        """

    def SetColPos(self, colID, newPos):
        """
        SetColPos(colID, newPos)
        
        Sets the position of the specified column.
        """

    def SetColumnsOrder(self, order):
        """
        SetColumnsOrder(order)
        
        Sets the positions of all columns at once.
        """

    def ResetColPos(self):
        """
        ResetColPos()
        
        Resets the position of the columns to the default.
        """

    def GetGridCursorCoords(self):
        """
        GetGridCursorCoords() -> GridCellCoords
        
        Returns the current grid cursor position.
        """

    def GetGridCursorCol(self):
        """
        GetGridCursorCol() -> int
        
        Returns the current grid cell column position.
        """

    def GetGridCursorRow(self):
        """
        GetGridCursorRow() -> int
        
        Returns the current grid cell row position.
        """

    def GoToCell(self, *args, **kw):
        """
        GoToCell(row, col)
        GoToCell(coords)
        
        Make the given cell current and ensure it is visible.
        """

    def MoveCursorDown(self, expandSelection):
        """
        MoveCursorDown(expandSelection) -> bool
        
        Moves the grid cursor down by one row.
        """

    def MoveCursorDownBlock(self, expandSelection):
        """
        MoveCursorDownBlock(expandSelection) -> bool
        
        Moves the grid cursor down in the current column such that it skips to
        the beginning or end of a block of non-empty cells.
        """

    def MoveCursorLeft(self, expandSelection):
        """
        MoveCursorLeft(expandSelection) -> bool
        
        Moves the grid cursor left by one column.
        """

    def MoveCursorLeftBlock(self, expandSelection):
        """
        MoveCursorLeftBlock(expandSelection) -> bool
        
        Moves the grid cursor left in the current row such that it skips to
        the beginning or end of a block of non-empty cells.
        """

    def MoveCursorRight(self, expandSelection):
        """
        MoveCursorRight(expandSelection) -> bool
        
        Moves the grid cursor right by one column.
        """

    def MoveCursorRightBlock(self, expandSelection):
        """
        MoveCursorRightBlock(expandSelection) -> bool
        
        Moves the grid cursor right in the current row such that it skips to
        the beginning or end of a block of non-empty cells.
        """

    def MoveCursorUp(self, expandSelection):
        """
        MoveCursorUp(expandSelection) -> bool
        
        Moves the grid cursor up by one row.
        """

    def MoveCursorUpBlock(self, expandSelection):
        """
        MoveCursorUpBlock(expandSelection) -> bool
        
        Moves the grid cursor up in the current column such that it skips to
        the beginning or end of a block of non-empty cells.
        """

    def MovePageDown(self):
        """
        MovePageDown() -> bool
        
        Moves the grid cursor down by some number of rows so that the previous
        bottom visible row becomes the top visible row.
        """

    def MovePageUp(self):
        """
        MovePageUp() -> bool
        
        Moves the grid cursor up by some number of rows so that the previous
        top visible row becomes the bottom visible row.
        """

    def SetGridCursor(self, *args, **kw):
        """
        SetGridCursor(row, col)
        SetGridCursor(coords)
        
        Set the grid cursor to the specified cell.
        """

    def SetTabBehaviour(self, behaviour):
        """
        SetTabBehaviour(behaviour)
        
        Set the grid's behaviour when the user presses the TAB key.
        """

    def ClearSelection(self):
        """
        ClearSelection()
        
        Deselects all cells that are currently selected.
        """

    def DeselectRow(self, row):
        """
        DeselectRow(row)
        
        Deselects a row of cells.
        """

    def DeselectCol(self, col):
        """
        DeselectCol(col)
        
        Deselects a column of cells.
        """

    def DeselectCell(self, row, col):
        """
        DeselectCell(row, col)
        
        Deselects a cell.
        """

    def GetSelectedBlocks(self):
        """
        GetSelectedBlocks() -> GridBlocks
        
        Returns a range of grid selection blocks.
        """

    def GetSelectedRowBlocks(self):
        """
        GetSelectedRowBlocks() -> PyObject
        
        Returns an ordered range of non-overlapping selected rows.
        """

    def GetSelectedColBlocks(self):
        """
        GetSelectedColBlocks() -> PyObject
        
        Returns an ordered range of non-overlapping selected columns.
        """

    def GetSelectedCells(self):
        """
        GetSelectedCells() -> GridCellCoordsArray
        
        Returns an array of individually selected cells.
        """

    def GetSelectedCols(self):
        """
        GetSelectedCols() -> ArrayInt
        
        Returns an array of selected columns.
        """

    def GetSelectedRows(self):
        """
        GetSelectedRows() -> ArrayInt
        
        Returns an array of selected rows.
        """

    def GetSelectionBackground(self):
        """
        GetSelectionBackground() -> wx.Colour
        
        Returns the colour used for drawing the selection background.
        """

    def GetSelectionBlockBottomRight(self):
        """
        GetSelectionBlockBottomRight() -> GridCellCoordsArray
        
        Returns an array of the bottom right corners of blocks of selected
        cells.
        """

    def GetSelectionBlockTopLeft(self):
        """
        GetSelectionBlockTopLeft() -> GridCellCoordsArray
        
        Returns an array of the top left corners of blocks of selected cells.
        """

    def GetSelectionForeground(self):
        """
        GetSelectionForeground() -> wx.Colour
        
        Returns the colour used for drawing the selection foreground.
        """

    def GetSelectionMode(self):
        """
        GetSelectionMode() -> GridSelectionModes
        
        Returns the current selection mode.
        """

    def IsInSelection(self, *args, **kw):
        """
        IsInSelection(row, col) -> bool
        IsInSelection(coords) -> bool
        
        Returns true if the given cell is selected.
        """

    def IsSelection(self):
        """
        IsSelection() -> bool
        
        Returns true if there are currently any selected cells, rows, columns
        or blocks.
        """

    def SelectAll(self):
        """
        SelectAll()
        
        Selects all cells in the grid.
        """

    def SelectBlock(self, *args, **kw):
        """
        SelectBlock(topRow, leftCol, bottomRow, rightCol, addToSelected=False)
        SelectBlock(topLeft, bottomRight, addToSelected=False)
        
        Selects a rectangular block of cells.
        """

    def SelectCol(self, col, addToSelected=False):
        """
        SelectCol(col, addToSelected=False)
        
        Selects the specified column.
        """

    def SelectRow(self, row, addToSelected=False):
        """
        SelectRow(row, addToSelected=False)
        
        Selects the specified row.
        """

    def SetSelectionBackground(self, c):
        """
        SetSelectionBackground(c)
        
        Set the colour to be used for drawing the selection background.
        """

    def SetSelectionForeground(self, c):
        """
        SetSelectionForeground(c)
        
        Set the colour to be used for drawing the selection foreground.
        """

    def SetSelectionMode(self, selmode):
        """
        SetSelectionMode(selmode)
        
        Set the selection behaviour of the grid.
        """

    def GetScrollLineX(self):
        """
        GetScrollLineX() -> int
        
        Returns the number of pixels per horizontal scroll increment.
        """

    def GetScrollLineY(self):
        """
        GetScrollLineY() -> int
        
        Returns the number of pixels per vertical scroll increment.
        """

    def IsVisible(self, *args, **kw):
        """
        IsVisible(row, col, wholeCellVisible=True) -> bool
        IsVisible(coords, wholeCellVisible=True) -> bool
        
        Returns true if a cell is either entirely or at least partially
        visible in the grid window.
        """

    def MakeCellVisible(self, *args, **kw):
        """
        MakeCellVisible(row, col)
        MakeCellVisible(coords)
        
        Brings the specified cell into the visible grid cell area with minimal
        scrolling.
        """

    def GetFirstFullyVisibleRow(self):
        """
        GetFirstFullyVisibleRow() -> int
        
        Returns the topmost row of the current visible area.
        """

    def GetFirstFullyVisibleColumn(self):
        """
        GetFirstFullyVisibleColumn() -> int
        
        Returns the leftmost column of the current visible area.
        """

    def SetScrollLineX(self, x):
        """
        SetScrollLineX(x)
        
        Sets the number of pixels per horizontal scroll increment.
        """

    def SetScrollLineY(self, y):
        """
        SetScrollLineY(y)
        
        Sets the number of pixels per vertical scroll increment.
        """

    def BlockToDeviceRect(self, topLeft, bottomRight, gridWindow=None):
        """
        BlockToDeviceRect(topLeft, bottomRight, gridWindow=None) -> wx.Rect
        
        Convert grid cell coordinates to grid window pixel coordinates.
        """

    def CellToRect(self, *args, **kw):
        """
        CellToRect(row, col) -> wx.Rect
        CellToRect(coords) -> wx.Rect
        
        Return the rectangle corresponding to the grid cell's size and
        position in logical coordinates.
        """

    def CellToGridWindow(self, *args, **kw):
        """
        CellToGridWindow(row, col) -> GridWindow
        CellToGridWindow(coords) -> GridWindow
        
        Returns the grid window that contains the cell.
        """

    def DevicePosToGridWindow(self, *args, **kw):
        """
        DevicePosToGridWindow(pos) -> GridWindow
        DevicePosToGridWindow(x, y) -> GridWindow
        
        Returns the grid window that includes the input coordinates.
        """

    def GetGridWindowOffset(self, gridWindow):
        """
        GetGridWindowOffset(gridWindow) -> wx.Point
        """

    def CalcGridWindowUnscrolledPosition(self, *args, **kw):
        """
        CalcGridWindowUnscrolledPosition(x, y, xx, yy, gridWindow)
        CalcGridWindowUnscrolledPosition(pt, gridWindow) -> wx.Point
        
        Translates the device coordinates to the logical ones, taking into
        account the grid window type.
        """

    def CalcGridWindowScrolledPosition(self, *args, **kw):
        """
        CalcGridWindowScrolledPosition(x, y, xx, yy, gridWindow)
        CalcGridWindowScrolledPosition(pt, gridWindow) -> wx.Point
        
        Translates the logical coordinates to the device ones, taking into
        account the grid window type.
        """

    def XToCol(self, x, clipToMinMax=False, gridWindow=None):
        """
        XToCol(x, clipToMinMax=False, gridWindow=None) -> int
        
        Returns the column at the given pixel position depending on the
        window.
        """

    def XToEdgeOfCol(self, x):
        """
        XToEdgeOfCol(x) -> int
        
        Returns the column whose right hand edge is close to the given logical
        x position.
        """

    def XYToCell(self, *args, **kw):
        """
        XYToCell(x, y, gridWindow=None) -> GridCellCoords
        XYToCell(pos, gridWindow=None) -> GridCellCoords
        
        Translates logical pixel coordinates to the grid cell coordinates.
        """

    def YToEdgeOfRow(self, y):
        """
        YToEdgeOfRow(y) -> int
        
        Returns the row whose bottom edge is close to the given logical y
        position.
        """

    def YToRow(self, y, clipToMinMax=False, gridWindow=None):
        """
        YToRow(y, clipToMinMax=False, gridWindow=None) -> int
        
        Returns the grid row that corresponds to the logical y coordinate.
        """

    def AppendCols(self, numCols=1, updateLabels=True):
        """
        AppendCols(numCols=1, updateLabels=True) -> bool
        
        Appends one or more new columns to the right of the grid.
        """

    def AppendRows(self, numRows=1, updateLabels=True):
        """
        AppendRows(numRows=1, updateLabels=True) -> bool
        
        Appends one or more new rows to the bottom of the grid.
        """

    def AreHorzGridLinesClipped(self):
        """
        AreHorzGridLinesClipped() -> bool
        
        Return true if the horizontal grid lines stop at the last column
        boundary or false if they continue to the end of the window.
        """

    def AreVertGridLinesClipped(self):
        """
        AreVertGridLinesClipped() -> bool
        
        Return true if the vertical grid lines stop at the last row boundary
        or false if they continue to the end of the window.
        """

    def BeginBatch(self):
        """
        BeginBatch()
        
        Increments the grid's batch count.
        """

    def ClearGrid(self):
        """
        ClearGrid()
        
        Clears all data in the underlying grid table and repaints the grid.
        """

    def ClipHorzGridLines(self, clip):
        """
        ClipHorzGridLines(clip)
        
        Change whether the horizontal grid lines are clipped by the end of the
        last column.
        """

    def ClipVertGridLines(self, clip):
        """
        ClipVertGridLines(clip)
        
        Change whether the vertical grid lines are clipped by the end of the
        last row.
        """

    def DeleteCols(self, pos=0, numCols=1, updateLabels=True):
        """
        DeleteCols(pos=0, numCols=1, updateLabels=True) -> bool
        
        Deletes one or more columns from a grid starting at the specified
        position.
        """

    def DeleteRows(self, pos=0, numRows=1, updateLabels=True):
        """
        DeleteRows(pos=0, numRows=1, updateLabels=True) -> bool
        
        Deletes one or more rows from a grid starting at the specified
        position.
        """

    def FreezeTo(self, *args, **kw):
        """
        FreezeTo(row, col) -> bool
        FreezeTo(coords) -> bool
        
        Sets or resets the frozen columns and rows.
        """

    def EndBatch(self):
        """
        EndBatch()
        
        Decrements the grid's batch count.
        """

    def Fit(self):
        """
        Fit()
        
        Overridden wxWindow method.
        """

    def ForceRefresh(self):
        """
        ForceRefresh()
        
        Causes immediate repainting of the grid.
        """

    def GetBatchCount(self):
        """
        GetBatchCount() -> int
        
        Returns the number of times that BeginBatch() has been called without
        (yet) matching calls to EndBatch().
        """

    def GetNumberCols(self):
        """
        GetNumberCols() -> int
        
        Returns the total number of grid columns.
        """

    def GetNumberRows(self):
        """
        GetNumberRows() -> int
        
        Returns the total number of grid rows.
        """

    def GetNumberFrozenCols(self):
        """
        GetNumberFrozenCols() -> int
        
        Returns the number of frozen grid columns.
        """

    def GetNumberFrozenRows(self):
        """
        GetNumberFrozenRows() -> int
        
        Returns the number of frozen grid rows.
        """

    def GetOrCreateCellAttr(self, row, col):
        """
        GetOrCreateCellAttr(row, col) -> GridCellAttr
        
        Returns the attribute for the given cell creating one if necessary.
        """

    def GetOrCreateCellAttrPtr(self, row, col):
        """
        GetOrCreateCellAttrPtr(row, col) -> GridCellAttrPtr
        
        Returns the attribute for the given cell creating one if necessary.
        """

    def GetTable(self):
        """
        GetTable() -> GridTableBase
        
        Returns a base pointer to the current table object.
        """

    def InsertCols(self, pos=0, numCols=1, updateLabels=True):
        """
        InsertCols(pos=0, numCols=1, updateLabels=True) -> bool
        
        Inserts one or more new columns into a grid with the first new column
        at the specified position.
        """

    def InsertRows(self, pos=0, numRows=1, updateLabels=True):
        """
        InsertRows(pos=0, numRows=1, updateLabels=True) -> bool
        
        Inserts one or more new rows into a grid with the first new row at the
        specified position.
        """

    def RefreshAttr(self, row, col):
        """
        RefreshAttr(row, col)
        
        Invalidates the cached attribute for the given cell.
        """

    def Render(self, dc, pos=wx.DefaultPosition, size=wx.DefaultSize, topLeft=GridCellCoords(-1,-1), bottomRight=GridCellCoords(-1,-1), style=GRID_DRAW_DEFAULT):
        """
        Render(dc, pos=wx.DefaultPosition, size=wx.DefaultSize, topLeft=GridCellCoords(-1,-1), bottomRight=GridCellCoords(-1,-1), style=GRID_DRAW_DEFAULT)
        
        Draws part or all of a wxGrid on a wxDC for printing or display.
        """

    def SetAttr(self, row, col, attr):
        """
        SetAttr(row, col, attr)
        
        Sets the cell attributes for the specified cell.
        """

    def SetColAttr(self, col, attr):
        """
        SetColAttr(col, attr)
        
        Sets the cell attributes for all cells in the specified column.
        """

    def SetMargins(self, extraWidth, extraHeight):
        """
        SetMargins(extraWidth, extraHeight)
        
        Sets the extra margins used around the grid area.
        """

    def SetRowAttr(self, row, attr):
        """
        SetRowAttr(row, attr)
        
        Sets the cell attributes for all cells in the specified row.
        """

    def CalcRowLabelsExposed(self, reg, gridWindow=None):
        """
        CalcRowLabelsExposed(reg, gridWindow=None) -> ArrayInt
        
        Appends one or more new columns to the right of the grid.
        """

    def CalcColLabelsExposed(self, reg, gridWindow=None):
        """
        CalcColLabelsExposed(reg, gridWindow=None) -> ArrayInt
        
        Appends one or more new columns to the right of the grid.
        """

    def CalcCellsExposed(self, reg, gridWindow=None):
        """
        CalcCellsExposed(reg, gridWindow=None) -> GridCellCoordsArray
        
        Appends one or more new columns to the right of the grid.
        """

    def GetSortingColumn(self):
        """
        GetSortingColumn() -> int
        
        Return the column in which the sorting indicator is currently
        displayed.
        """

    def IsSortingBy(self, col):
        """
        IsSortingBy(col) -> bool
        
        Return true if this column is currently used for sorting.
        """

    def IsSortOrderAscending(self):
        """
        IsSortOrderAscending() -> bool
        
        Return true if the current sorting order is ascending or false if it
        is descending.
        """

    def SetSortingColumn(self, col, ascending=True):
        """
        SetSortingColumn(col, ascending=True)
        
        Set the column to display the sorting indicator in and its direction.
        """

    def UnsetSortingColumn(self):
        """
        UnsetSortingColumn()
        
        Remove any currently shown sorting indicator.
        """

    def GetGridWindow(self):
        """
        GetGridWindow() -> wx.Window
        
        Return the main grid window containing the grid cells.
        """

    def GetFrozenCornerGridWindow(self):
        """
        GetFrozenCornerGridWindow() -> wx.Window
        
        Return the corner grid window containing frozen cells.
        """

    def GetFrozenRowGridWindow(self):
        """
        GetFrozenRowGridWindow() -> wx.Window
        
        Return the rows grid window containing row frozen cells.
        """

    def GetFrozenColGridWindow(self):
        """
        GetFrozenColGridWindow() -> wx.Window
        
        Return the columns grid window containing column frozen cells.
        """

    def GetGridRowLabelWindow(self):
        """
        GetGridRowLabelWindow() -> wx.Window
        
        Return the row labels window.
        """

    def GetGridColLabelWindow(self):
        """
        GetGridColLabelWindow() -> wx.Window
        
        Return the column labels window.
        """

    def GetGridCornerLabelWindow(self):
        """
        GetGridCornerLabelWindow() -> wx.Window
        
        Return the window in the top left grid corner.
        """

    def GetGridColHeader(self):
        """
        GetGridColHeader() -> wx.HeaderCtrl
        
        Return the header control used for column labels display.
        """

    def IsUsingNativeHeader(self):
        """
        IsUsingNativeHeader() -> bool
        
        Return true if native header control is currently being used.
        """

    def DrawCellHighlight(self, dc, attr):
        """
        DrawCellHighlight(dc, attr)
        """

    def DrawRowLabels(self, dc, rows):
        """
        DrawRowLabels(dc, rows)
        """

    def DrawRowLabel(self, dc, row):
        """
        DrawRowLabel(dc, row)
        """

    def DrawColLabels(self, dc, cols):
        """
        DrawColLabels(dc, cols)
        """

    def DrawColLabel(self, dc, col):
        """
        DrawColLabel(dc, col)
        """

    def DrawCornerLabel(self, dc):
        """
        DrawCornerLabel(dc)
        """

    def DrawTextRectangle(self, *args, **kw):
        """
        DrawTextRectangle(dc, text, rect, horizontalAlignment=wx.ALIGN_LEFT, verticalAlignment=wx.ALIGN_TOP, textOrientation=wx.HORIZONTAL)
        DrawTextRectangle(dc, lines, rect, horizontalAlignment=wx.ALIGN_LEFT, verticalAlignment=wx.ALIGN_TOP, textOrientation=wx.HORIZONTAL)
        """

    def GetCellHighlightColour(self):
        """
        GetCellHighlightColour() -> wx.Colour
        """

    def GetCellHighlightPenWidth(self):
        """
        GetCellHighlightPenWidth() -> int
        """

    def GetCellHighlightROPenWidth(self):
        """
        GetCellHighlightROPenWidth() -> int
        """

    def SetCellHighlightColour(self):
        """
        SetCellHighlightColour()
        """

    def SetCellHighlightPenWidth(self, width):
        """
        SetCellHighlightPenWidth(width)
        """

    def SetCellHighlightROPenWidth(self, width):
        """
        SetCellHighlightROPenWidth(width)
        """

    def SetGridFrozenBorderColour(self):
        """
        SetGridFrozenBorderColour()
        """

    def SetGridFrozenBorderPenWidth(self, width):
        """
        SetGridFrozenBorderPenWidth(width)
        """

    @staticmethod
    def GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL):
        """
        GetClassDefaultAttributes(variant=wx.WINDOW_VARIANT_NORMAL) -> wx.VisualAttributes
        """

    def SetTable(self, table, takeOwnership=False, selmode=GridSelectCells):
        """
        Set the Grid Table to be used by this grid.
        """

    SelectCells = GridSelectCells
    SelectRows = GridSelectRows
    SelectColumns = GridSelectColumns
    SelectRowsOrColumns = GridSelectRowsOrColumns
    BatchCount = property(None, None)
    CellHighlightColour = property(None, None)
    CellHighlightPenWidth = property(None, None)
    CellHighlightROPenWidth = property(None, None)
    ColLabelSize = property(None, None)
    ColLabelTextOrientation = property(None, None)
    ColMinimalAcceptableWidth = property(None, None)
    ColSizes = property(None, None)
    CornerLabelTextOrientation = property(None, None)
    CornerLabelValue = property(None, None)
    DefaultCellBackgroundColour = property(None, None)
    DefaultCellFitMode = property(None, None)
    DefaultCellFont = property(None, None)
    DefaultCellOverflow = property(None, None)
    DefaultCellTextColour = property(None, None)
    DefaultColLabelSize = property(None, None)
    DefaultColSize = property(None, None)
    DefaultEditor = property(None, None)
    DefaultGridLinePen = property(None, None)
    DefaultRenderer = property(None, None)
    DefaultRowLabelSize = property(None, None)
    DefaultRowSize = property(None, None)
    FirstFullyVisibleColumn = property(None, None)
    FirstFullyVisibleRow = property(None, None)
    FrozenColGridWindow = property(None, None)
    FrozenCornerGridWindow = property(None, None)
    FrozenRowGridWindow = property(None, None)
    GridColHeader = property(None, None)
    GridColLabelWindow = property(None, None)
    GridCornerLabelWindow = property(None, None)
    GridCursorCol = property(None, None)
    GridCursorCoords = property(None, None)
    GridCursorRow = property(None, None)
    GridLineColour = property(None, None)
    GridRowLabelWindow = property(None, None)
    GridWindow = property(None, None)
    LabelBackgroundColour = property(None, None)
    LabelFont = property(None, None)
    LabelTextColour = property(None, None)
    NumberCols = property(None, None)
    NumberFrozenCols = property(None, None)
    NumberFrozenRows = property(None, None)
    NumberRows = property(None, None)
    RowLabelSize = property(None, None)
    RowMinimalAcceptableHeight = property(None, None)
    RowSizes = property(None, None)
    ScrollLineX = property(None, None)
    ScrollLineY = property(None, None)
    SelectedBlocks = property(None, None)
    SelectedCells = property(None, None)
    SelectedColBlocks = property(None, None)
    SelectedCols = property(None, None)
    SelectedRowBlocks = property(None, None)
    SelectedRows = property(None, None)
    SelectionBackground = property(None, None)
    SelectionBlockBottomRight = property(None, None)
    SelectionBlockTopLeft = property(None, None)
    SelectionForeground = property(None, None)
    SelectionMode = property(None, None)
    SortingColumn = property(None, None)
    Table = property(None, None)

    def CanHaveAttributes(self):
        """
        CanHaveAttributes() -> bool
        
        Returns true if this grid has support for cell attributes.
        """

    def GetColMinimalWidth(self, col):
        """
        GetColMinimalWidth(col) -> int
        
        Get the minimal width of the given column/row.
        """

    def GetColRight(self, col):
        """
        GetColRight(col) -> int
        
        Returns the coordinate of the right border specified column.
        """

    def GetColLeft(self, col):
        """
        GetColLeft(col) -> int
        
        Returns the coordinate of the left border specified column.
        """

    def GetRowMinimalHeight(self, col):
        """
        GetRowMinimalHeight(col) -> int
        
        Returns the minimal size for the given column.
        """
# end of class Grid


class GridUpdateLocker(object):
    """
    GridUpdateLocker(grid=None)
    
    This small class can be used to prevent wxGrid from redrawing during
    its lifetime by calling wxGrid::BeginBatch() in its constructor and
    wxGrid::EndBatch() in its destructor.
    """

    def __init__(self, grid=None):
        """
        GridUpdateLocker(grid=None)
        
        This small class can be used to prevent wxGrid from redrawing during
        its lifetime by calling wxGrid::BeginBatch() in its constructor and
        wxGrid::EndBatch() in its destructor.
        """

    def Create(self, grid):
        """
        Create(grid)
        
        This method can be called if the object had been constructed using the
        default constructor.
        """

    def __enter__(self):
        """
        
        """

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        
        """
# end of class GridUpdateLocker


class GridEvent(wx.NotifyEvent):
    """
    GridEvent()
    GridEvent(id, type, obj, row=-1, col=-1, x=-1, y=-1, sel=True, kbd=wx.KeyboardState())
    
    This event class contains information about various grid events.
    """

    def __init__(self, *args, **kw):
        """
        GridEvent()
        GridEvent(id, type, obj, row=-1, col=-1, x=-1, y=-1, sel=True, kbd=wx.KeyboardState())
        
        This event class contains information about various grid events.
        """

    def AltDown(self):
        """
        AltDown() -> bool
        
        Returns true if the Alt key was down at the time of the event.
        """

    def ControlDown(self):
        """
        ControlDown() -> bool
        
        Returns true if the Control key was down at the time of the event.
        """

    def GetCol(self):
        """
        GetCol() -> int
        
        Column at which the event occurred.
        """

    def GetPosition(self):
        """
        GetPosition() -> wx.Point
        
        Position in pixels at which the event occurred.
        """

    def GetRow(self):
        """
        GetRow() -> int
        
        Row at which the event occurred.
        """

    def MetaDown(self):
        """
        MetaDown() -> bool
        
        Returns true if the Meta key was down at the time of the event.
        """

    def Selecting(self):
        """
        Selecting() -> bool
        
        Returns true if the user is selecting grid cells, or false if
        deselecting.
        """

    def ShiftDown(self):
        """
        ShiftDown() -> bool
        
        Returns true if the Shift key was down at the time of the event.
        """
    Col = property(None, None)
    Position = property(None, None)
    Row = property(None, None)
# end of class GridEvent


class GridSizeEvent(wx.NotifyEvent):
    """
    GridSizeEvent()
    GridSizeEvent(id, type, obj, rowOrCol=-1, x=-1, y=-1, kbd=wx.KeyboardState())
    
    This event class contains information about a row/column resize event.
    """

    def __init__(self, *args, **kw):
        """
        GridSizeEvent()
        GridSizeEvent(id, type, obj, rowOrCol=-1, x=-1, y=-1, kbd=wx.KeyboardState())
        
        This event class contains information about a row/column resize event.
        """

    def AltDown(self):
        """
        AltDown() -> bool
        
        Returns true if the Alt key was down at the time of the event.
        """

    def ControlDown(self):
        """
        ControlDown() -> bool
        
        Returns true if the Control key was down at the time of the event.
        """

    def GetPosition(self):
        """
        GetPosition() -> wx.Point
        
        Position in pixels at which the event occurred.
        """

    def GetRowOrCol(self):
        """
        GetRowOrCol() -> int
        
        Row or column at that was resized.
        """

    def MetaDown(self):
        """
        MetaDown() -> bool
        
        Returns true if the Meta key was down at the time of the event.
        """

    def ShiftDown(self):
        """
        ShiftDown() -> bool
        
        Returns true if the Shift key was down at the time of the event.
        """
    Position = property(None, None)
    RowOrCol = property(None, None)
# end of class GridSizeEvent


class GridRangeSelectEvent(wx.NotifyEvent):
    """
    GridRangeSelectEvent()
    GridRangeSelectEvent(id, type, obj, topLeft, bottomRight, sel=True, kbd=wx.KeyboardState())
    
    Events of this class notify about a range of cells being selected.
    """

    def __init__(self, *args, **kw):
        """
        GridRangeSelectEvent()
        GridRangeSelectEvent(id, type, obj, topLeft, bottomRight, sel=True, kbd=wx.KeyboardState())
        
        Events of this class notify about a range of cells being selected.
        """

    def AltDown(self):
        """
        AltDown() -> bool
        
        Returns true if the Alt key was down at the time of the event.
        """

    def ControlDown(self):
        """
        ControlDown() -> bool
        
        Returns true if the Control key was down at the time of the event.
        """

    def GetBottomRightCoords(self):
        """
        GetBottomRightCoords() -> GridCellCoords
        
        Top left corner of the rectangular area that was (de)selected.
        """

    def GetBottomRow(self):
        """
        GetBottomRow() -> int
        
        Bottom row of the rectangular area that was (de)selected.
        """

    def GetLeftCol(self):
        """
        GetLeftCol() -> int
        
        Left column of the rectangular area that was (de)selected.
        """

    def GetRightCol(self):
        """
        GetRightCol() -> int
        
        Right column of the rectangular area that was (de)selected.
        """

    def GetTopLeftCoords(self):
        """
        GetTopLeftCoords() -> GridCellCoords
        
        Top left corner of the rectangular area that was (de)selected.
        """

    def GetTopRow(self):
        """
        GetTopRow() -> int
        
        Top row of the rectangular area that was (de)selected.
        """

    def MetaDown(self):
        """
        MetaDown() -> bool
        
        Returns true if the Meta key was down at the time of the event.
        """

    def Selecting(self):
        """
        Selecting() -> bool
        
        Returns true if the area was selected, false otherwise.
        """

    def ShiftDown(self):
        """
        ShiftDown() -> bool
        
        Returns true if the Shift key was down at the time of the event.
        """
    BottomRightCoords = property(None, None)
    BottomRow = property(None, None)
    LeftCol = property(None, None)
    RightCol = property(None, None)
    TopLeftCoords = property(None, None)
    TopRow = property(None, None)
# end of class GridRangeSelectEvent


class GridEditorCreatedEvent(wx.CommandEvent):
    """
    GridEditorCreatedEvent()
    GridEditorCreatedEvent(id, type, obj, row, col, ctrl)
    """

    def __init__(self, *args, **kw):
        """
        GridEditorCreatedEvent()
        GridEditorCreatedEvent(id, type, obj, row, col, ctrl)
        """

    def GetCol(self):
        """
        GetCol() -> int
        
        Returns the column at which the event occurred.
        """

    def GetControl(self):
        """
        GetControl() -> wx.Control
        
        Returns the edit control.
        """

    def GetRow(self):
        """
        GetRow() -> int
        
        Returns the row at which the event occurred.
        """

    def GetWindow(self):
        """
        GetWindow() -> wx.Window
        
        Returns the edit window.
        """

    def SetCol(self, col):
        """
        SetCol(col)
        
        Sets the column at which the event occurred.
        """

    def SetControl(self, ctrl):
        """
        SetControl(ctrl)
        
        Sets the edit control.
        """

    def SetRow(self, row):
        """
        SetRow(row)
        
        Sets the row at which the event occurred.
        """

    def SetWindow(self, window):
        """
        SetWindow(window)
        
        Sets the edit window.
        """
    Col = property(None, None)
    Control = property(None, None)
    Row = property(None, None)
    Window = property(None, None)
# end of class GridEditorCreatedEvent


GRID_VALUE_STRING =    "string"
GRID_VALUE_BOOL =      "bool"
GRID_VALUE_NUMBER =    "long"
GRID_VALUE_FLOAT =     "double"
GRID_VALUE_CHOICE =    "choice"
GRID_VALUE_DATE =      "date"
GRID_VALUE_TEXT =      "string"
GRID_VALUE_LONG =      "long"
GRID_VALUE_CHOICEINT = "choiceint"
GRID_VALUE_DATETIME =  "datetime"

GRIDTABLE_REQUEST_VIEW_GET_VALUES = 2000
GRIDTABLE_REQUEST_VIEW_SEND_VALUES = 2001

from collections import namedtuple
_im_GridCellCoords = namedtuple('_im_GridCellCoords', ['Row', 'Col'])
del namedtuple

PyGridCellRenderer = wx.deprecated(GridCellRenderer, 'Use GridCellRenderer instead.')

PyGridCellEditor = wx.deprecated(GridCellEditor, 'Use GridCellEditor instead.')

PyGridCellAttrProvider = wx.deprecated(GridCellAttrProvider, 'Use GridCellAttrProvider instead.')

PyGridTableBase = wx.deprecated(GridTableBase, 'Use GridTableBase instead.')

EVT_GRID_CELL_LEFT_CLICK = wx.PyEventBinder( wxEVT_GRID_CELL_LEFT_CLICK )
EVT_GRID_CELL_RIGHT_CLICK = wx.PyEventBinder( wxEVT_GRID_CELL_RIGHT_CLICK )
EVT_GRID_CELL_LEFT_DCLICK = wx.PyEventBinder( wxEVT_GRID_CELL_LEFT_DCLICK )
EVT_GRID_CELL_RIGHT_DCLICK = wx.PyEventBinder( wxEVT_GRID_CELL_RIGHT_DCLICK )
EVT_GRID_LABEL_LEFT_CLICK = wx.PyEventBinder( wxEVT_GRID_LABEL_LEFT_CLICK )
EVT_GRID_LABEL_RIGHT_CLICK = wx.PyEventBinder( wxEVT_GRID_LABEL_RIGHT_CLICK )
EVT_GRID_LABEL_LEFT_DCLICK = wx.PyEventBinder( wxEVT_GRID_LABEL_LEFT_DCLICK )
EVT_GRID_LABEL_RIGHT_DCLICK = wx.PyEventBinder( wxEVT_GRID_LABEL_RIGHT_DCLICK )
EVT_GRID_ROW_SIZE = wx.PyEventBinder( wxEVT_GRID_ROW_SIZE )
EVT_GRID_COL_SIZE = wx.PyEventBinder( wxEVT_GRID_COL_SIZE )
EVT_GRID_RANGE_SELECTING = wx.PyEventBinder( wxEVT_GRID_RANGE_SELECTING )
EVT_GRID_RANGE_SELECTED = wx.PyEventBinder( wxEVT_GRID_RANGE_SELECTED )
EVT_GRID_CELL_CHANGING = wx.PyEventBinder( wxEVT_GRID_CELL_CHANGING )
EVT_GRID_CELL_CHANGED = wx.PyEventBinder( wxEVT_GRID_CELL_CHANGED )
EVT_GRID_SELECT_CELL = wx.PyEventBinder( wxEVT_GRID_SELECT_CELL )
EVT_GRID_EDITOR_SHOWN = wx.PyEventBinder( wxEVT_GRID_EDITOR_SHOWN )
EVT_GRID_EDITOR_HIDDEN = wx.PyEventBinder( wxEVT_GRID_EDITOR_HIDDEN )
EVT_GRID_EDITOR_CREATED = wx.PyEventBinder( wxEVT_GRID_EDITOR_CREATED )
EVT_GRID_CELL_BEGIN_DRAG = wx.PyEventBinder( wxEVT_GRID_CELL_BEGIN_DRAG )
EVT_GRID_COL_MOVE = wx.PyEventBinder( wxEVT_GRID_COL_MOVE )
EVT_GRID_COL_SORT = wx.PyEventBinder( wxEVT_GRID_COL_SORT )
EVT_GRID_TABBING = wx.PyEventBinder( wxEVT_GRID_TABBING )

# The same as above but with the ability to specify an identifier
EVT_GRID_CMD_CELL_LEFT_CLICK =     wx.PyEventBinder( wxEVT_GRID_CELL_LEFT_CLICK,    1 )
EVT_GRID_CMD_CELL_RIGHT_CLICK =    wx.PyEventBinder( wxEVT_GRID_CELL_RIGHT_CLICK,   1 )
EVT_GRID_CMD_CELL_LEFT_DCLICK =    wx.PyEventBinder( wxEVT_GRID_CELL_LEFT_DCLICK,   1 )
EVT_GRID_CMD_CELL_RIGHT_DCLICK =   wx.PyEventBinder( wxEVT_GRID_CELL_RIGHT_DCLICK,  1 )
EVT_GRID_CMD_LABEL_LEFT_CLICK =    wx.PyEventBinder( wxEVT_GRID_LABEL_LEFT_CLICK,   1 )
EVT_GRID_CMD_LABEL_RIGHT_CLICK =   wx.PyEventBinder( wxEVT_GRID_LABEL_RIGHT_CLICK,  1 )
EVT_GRID_CMD_LABEL_LEFT_DCLICK =   wx.PyEventBinder( wxEVT_GRID_LABEL_LEFT_DCLICK,  1 )
EVT_GRID_CMD_LABEL_RIGHT_DCLICK =  wx.PyEventBinder( wxEVT_GRID_LABEL_RIGHT_DCLICK, 1 )
EVT_GRID_CMD_ROW_SIZE =            wx.PyEventBinder( wxEVT_GRID_ROW_SIZE,           1 )
EVT_GRID_CMD_COL_SIZE =            wx.PyEventBinder( wxEVT_GRID_COL_SIZE,           1 )
EVT_GRID_CMD_RANGE_SELECTING =     wx.PyEventBinder( wxEVT_GRID_RANGE_SELECTING,    1 )
EVT_GRID_CMD_RANGE_SELECTED =      wx.PyEventBinder( wxEVT_GRID_RANGE_SELECTED,     1 )
EVT_GRID_CMD_CELL_CHANGING =       wx.PyEventBinder( wxEVT_GRID_CELL_CHANGING,      1 )
EVT_GRID_CMD_CELL_CHANGED =        wx.PyEventBinder( wxEVT_GRID_CELL_CHANGED,       1 )
EVT_GRID_CMD_SELECT_CELL =         wx.PyEventBinder( wxEVT_GRID_SELECT_CELL,        1 )
EVT_GRID_CMD_EDITOR_SHOWN =        wx.PyEventBinder( wxEVT_GRID_EDITOR_SHOWN,       1 )
EVT_GRID_CMD_EDITOR_HIDDEN =       wx.PyEventBinder( wxEVT_GRID_EDITOR_HIDDEN,      1 )
EVT_GRID_CMD_EDITOR_CREATED =      wx.PyEventBinder( wxEVT_GRID_EDITOR_CREATED,     1 )
EVT_GRID_CMD_CELL_BEGIN_DRAG =     wx.PyEventBinder( wxEVT_GRID_CELL_BEGIN_DRAG,    1 )
EVT_GRID_CMD_COL_MOVE =            wx.PyEventBinder( wxEVT_GRID_COL_MOVE,           1 )
EVT_GRID_CMD_COL_SORT =            wx.PyEventBinder( wxEVT_GRID_COL_SORT,           1 )
EVT_GRID_CMD_TABBING =             wx.PyEventBinder( wxEVT_GRID_TABBING,            1 )

# Just for compatibility, remove them in a future release
EVT_GRID_RANGE_SELECT =            EVT_GRID_RANGE_SELECTED
EVT_GRID_CMD_RANGE_SELECT =        EVT_GRID_CMD_RANGE_SELECTED
#-- end-grid --#
