/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBeforeLoadEvent.h"

#include "BeforeLoadEvent.h"
#include "JSDictionary.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSBeforeLoadEventTableValues[] =
{
    { "url", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeLoadEventUrl), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeLoadEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSBeforeLoadEventTable = { 4, 3, JSBeforeLoadEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSBeforeLoadEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSBeforeLoadEventConstructorTable = { 1, 0, JSBeforeLoadEventConstructorTableValues, 0 };
const ClassInfo JSBeforeLoadEventConstructor::s_info = { "BeforeLoadEventConstructor", &Base::s_info, &JSBeforeLoadEventConstructorTable, 0, CREATE_METHOD_TABLE(JSBeforeLoadEventConstructor) };

JSBeforeLoadEventConstructor::JSBeforeLoadEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSBeforeLoadEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSBeforeLoadEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSBeforeLoadEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBeforeLoadEventConstructor, JSDOMWrapper>(exec, &JSBeforeLoadEventConstructorTable, jsCast<JSBeforeLoadEventConstructor*>(cell), propertyName, slot);
}

bool JSBeforeLoadEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBeforeLoadEventConstructor, JSDOMWrapper>(exec, &JSBeforeLoadEventConstructorTable, jsCast<JSBeforeLoadEventConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSBeforeLoadEventConstructor::constructJSBeforeLoadEvent(ExecState* exec)
{
    JSBeforeLoadEventConstructor* jsConstructor = jsCast<JSBeforeLoadEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    BeforeLoadEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillBeforeLoadEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<BeforeLoadEvent> event = BeforeLoadEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillBeforeLoadEventInit(BeforeLoadEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("url", eventInit.url))
        return false;
    return true;
}

ConstructType JSBeforeLoadEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSBeforeLoadEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSBeforeLoadEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSBeforeLoadEventPrototypeTable = { 1, 0, JSBeforeLoadEventPrototypeTableValues, 0 };
const ClassInfo JSBeforeLoadEventPrototype::s_info = { "BeforeLoadEventPrototype", &Base::s_info, &JSBeforeLoadEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSBeforeLoadEventPrototype) };

JSObject* JSBeforeLoadEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBeforeLoadEvent>(exec, globalObject);
}

const ClassInfo JSBeforeLoadEvent::s_info = { "BeforeLoadEvent", &Base::s_info, &JSBeforeLoadEventTable, 0 , CREATE_METHOD_TABLE(JSBeforeLoadEvent) };

JSBeforeLoadEvent::JSBeforeLoadEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<BeforeLoadEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSBeforeLoadEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSBeforeLoadEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSBeforeLoadEventPrototype::create(exec->globalData(), globalObject, JSBeforeLoadEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSBeforeLoadEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSBeforeLoadEvent* thisObject = jsCast<JSBeforeLoadEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSBeforeLoadEvent, Base>(exec, &JSBeforeLoadEventTable, thisObject, propertyName, slot);
}

bool JSBeforeLoadEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSBeforeLoadEvent* thisObject = jsCast<JSBeforeLoadEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSBeforeLoadEvent, Base>(exec, &JSBeforeLoadEventTable, thisObject, propertyName, descriptor);
}

JSValue jsBeforeLoadEventUrl(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSBeforeLoadEvent* castedThis = jsCast<JSBeforeLoadEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    BeforeLoadEvent* impl = static_cast<BeforeLoadEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->url());
    return result;
}


JSValue jsBeforeLoadEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSBeforeLoadEvent* domObject = jsCast<JSBeforeLoadEvent*>(asObject(slotBase));
    return JSBeforeLoadEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSBeforeLoadEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBeforeLoadEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
