/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "KURL.h"
#include "MutationEvent.h"
#include "Node.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMutationEventTableValues[] =
{
    { "relatedNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventRelatedNode), (intptr_t)0, NoIntrinsic },
    { "prevValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventPrevValue), (intptr_t)0, NoIntrinsic },
    { "newValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventNewValue), (intptr_t)0, NoIntrinsic },
    { "attrName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventAttrName), (intptr_t)0, NoIntrinsic },
    { "attrChange", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventAttrChange), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMutationEventTable = { 17, 15, JSMutationEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMutationEventConstructorTableValues[] =
{
    { "MODIFICATION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventMODIFICATION), (intptr_t)0, NoIntrinsic },
    { "ADDITION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventADDITION), (intptr_t)0, NoIntrinsic },
    { "REMOVAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventREMOVAL), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMutationEventConstructorTable = { 8, 7, JSMutationEventConstructorTableValues, 0 };

COMPILE_ASSERT(1 == MutationEvent::MODIFICATION, MutationEventEnumMODIFICATIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == MutationEvent::ADDITION, MutationEventEnumADDITIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == MutationEvent::REMOVAL, MutationEventEnumREMOVALIsWrongUseDoNotCheckConstants);

const ClassInfo JSMutationEventConstructor::s_info = { "MutationEventConstructor", &Base::s_info, &JSMutationEventConstructorTable, 0, CREATE_METHOD_TABLE(JSMutationEventConstructor) };

JSMutationEventConstructor::JSMutationEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMutationEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMutationEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMutationEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMutationEventConstructor, JSDOMWrapper>(exec, &JSMutationEventConstructorTable, jsCast<JSMutationEventConstructor*>(cell), propertyName, slot);
}

bool JSMutationEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMutationEventConstructor, JSDOMWrapper>(exec, &JSMutationEventConstructorTable, jsCast<JSMutationEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMutationEventPrototypeTableValues[] =
{
    { "MODIFICATION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventMODIFICATION), (intptr_t)0, NoIntrinsic },
    { "ADDITION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventADDITION), (intptr_t)0, NoIntrinsic },
    { "REMOVAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationEventREMOVAL), (intptr_t)0, NoIntrinsic },
    { "initMutationEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsMutationEventPrototypeFunctionInitMutationEvent), (intptr_t)8, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMutationEventPrototypeTable = { 8, 7, JSMutationEventPrototypeTableValues, 0 };
const ClassInfo JSMutationEventPrototype::s_info = { "MutationEventPrototype", &Base::s_info, &JSMutationEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSMutationEventPrototype) };

JSObject* JSMutationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMutationEvent>(exec, globalObject);
}

bool JSMutationEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMutationEventPrototype* thisObject = jsCast<JSMutationEventPrototype*>(cell);
    return getStaticPropertySlot<JSMutationEventPrototype, JSObject>(exec, &JSMutationEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSMutationEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMutationEventPrototype* thisObject = jsCast<JSMutationEventPrototype*>(object);
    return getStaticPropertyDescriptor<JSMutationEventPrototype, JSObject>(exec, &JSMutationEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMutationEvent::s_info = { "MutationEvent", &Base::s_info, &JSMutationEventTable, 0 , CREATE_METHOD_TABLE(JSMutationEvent) };

JSMutationEvent::JSMutationEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MutationEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSMutationEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMutationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMutationEventPrototype::create(exec->globalData(), globalObject, JSMutationEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSMutationEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMutationEvent* thisObject = jsCast<JSMutationEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMutationEvent, Base>(exec, &JSMutationEventTable, thisObject, propertyName, slot);
}

bool JSMutationEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMutationEvent* thisObject = jsCast<JSMutationEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMutationEvent, Base>(exec, &JSMutationEventTable, thisObject, propertyName, descriptor);
}

JSValue jsMutationEventRelatedNode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMutationEvent* castedThis = jsCast<JSMutationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MutationEvent* impl = static_cast<MutationEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->relatedNode()));
    return result;
}


JSValue jsMutationEventPrevValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMutationEvent* castedThis = jsCast<JSMutationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MutationEvent* impl = static_cast<MutationEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->prevValue());
    return result;
}


JSValue jsMutationEventNewValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMutationEvent* castedThis = jsCast<JSMutationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MutationEvent* impl = static_cast<MutationEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->newValue());
    return result;
}


JSValue jsMutationEventAttrName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMutationEvent* castedThis = jsCast<JSMutationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MutationEvent* impl = static_cast<MutationEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->attrName());
    return result;
}


JSValue jsMutationEventAttrChange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMutationEvent* castedThis = jsCast<JSMutationEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MutationEvent* impl = static_cast<MutationEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->attrChange());
    return result;
}


JSValue jsMutationEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMutationEvent* domObject = jsCast<JSMutationEvent*>(asObject(slotBase));
    return JSMutationEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMutationEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMutationEventPrototypeFunctionInitMutationEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMutationEvent::s_info))
        return throwVMTypeError(exec);
    JSMutationEvent* castedThis = jsCast<JSMutationEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSMutationEvent::s_info);
    MutationEvent* impl = static_cast<MutationEvent*>(castedThis->impl());
    const String& type(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Node* relatedNode(toNode(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& prevValue(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& newValue(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& attrName(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned short attrChange(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initMutationEvent(type, canBubble, cancelable, relatedNode, prevValue, newValue, attrName, attrChange);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsMutationEventMODIFICATION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsMutationEventADDITION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsMutationEventREMOVAL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}


}
