/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTestTypedefs.h"

#include "DOMStringList.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMStringList.h"
#include "JSSVGPoint.h"
#include "JSSerializedScriptValue.h"
#include "JSTestCallback.h"
#include "JSTestSubObj.h"
#include "KURL.h"
#include "SVGPoint.h"
#include "SerializedScriptValue.h"
#include "TestTypedefs.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTestTypedefsTableValues[] =
{
    { "unsignedLongLongAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsUnsignedLongLongAttr), (intptr_t)setJSTestTypedefsUnsignedLongLongAttr, NoIntrinsic },
    { "immutableSerializedScriptValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsImmutableSerializedScriptValue), (intptr_t)setJSTestTypedefsImmutableSerializedScriptValue, NoIntrinsic },
    { "attrWithGetterException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsAttrWithGetterException), (intptr_t)setJSTestTypedefsAttrWithGetterException, NoIntrinsic },
    { "attrWithSetterException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsAttrWithSetterException), (intptr_t)setJSTestTypedefsAttrWithSetterException, NoIntrinsic },
    { "stringAttrWithGetterException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsStringAttrWithGetterException), (intptr_t)setJSTestTypedefsStringAttrWithGetterException, NoIntrinsic },
    { "stringAttrWithSetterException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsStringAttrWithSetterException), (intptr_t)setJSTestTypedefsStringAttrWithSetterException, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTestTypedefsTable = { 18, 15, JSTestTypedefsTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTestTypedefsConstructorTableValues[] =
{
    { "TestSubObj", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestTypedefsConstructorTestSubObj), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTestTypedefsConstructorTable = { 1, 0, JSTestTypedefsConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSTestTypedefsConstructor::constructJSTestTypedefs(ExecState* exec)
{
    JSTestTypedefsConstructor* castedThis = jsCast<JSTestTypedefsConstructor*>(exec->callee());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& hello(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (exec->argumentCount() <= 1 || !exec->argument(1).isFunction())
        return throwVMTypeError(exec);
    RefPtr<TestCallback> testCallback = JSTestCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    RefPtr<TestTypedefs> object = TestTypedefs::create(hello, testCallback);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSTestTypedefsConstructor::s_info = { "TestTypedefsConstructor", &Base::s_info, &JSTestTypedefsConstructorTable, 0, CREATE_METHOD_TABLE(JSTestTypedefsConstructor) };

JSTestTypedefsConstructor::JSTestTypedefsConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTestTypedefsConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTestTypedefsPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSTestTypedefsConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTestTypedefsConstructor, JSDOMWrapper>(exec, &JSTestTypedefsConstructorTable, jsCast<JSTestTypedefsConstructor*>(cell), propertyName, slot);
}

bool JSTestTypedefsConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTestTypedefsConstructor, JSDOMWrapper>(exec, &JSTestTypedefsConstructorTable, jsCast<JSTestTypedefsConstructor*>(object), propertyName, descriptor);
}

ConstructType JSTestTypedefsConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSTestTypedefs;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSTestTypedefsPrototypeTableValues[] =
{
    { "func", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionFunc), (intptr_t)0, NoIntrinsic },
    { "setShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionSetShadow), (intptr_t)3, NoIntrinsic },
    { "methodWithSequenceArg", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionMethodWithSequenceArg), (intptr_t)1, NoIntrinsic },
    { "nullableArrayArg", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionNullableArrayArg), (intptr_t)1, NoIntrinsic },
    { "funcWithClamp", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionFuncWithClamp), (intptr_t)1, NoIntrinsic },
    { "immutablePointFunction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionImmutablePointFunction), (intptr_t)0, NoIntrinsic },
    { "stringArrayFunction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionStringArrayFunction), (intptr_t)1, NoIntrinsic },
    { "stringArrayFunction2", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionStringArrayFunction2), (intptr_t)1, NoIntrinsic },
    { "methodWithException", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTestTypedefsPrototypeFunctionMethodWithException), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTestTypedefsPrototypeTable = { 33, 31, JSTestTypedefsPrototypeTableValues, 0 };
const ClassInfo JSTestTypedefsPrototype::s_info = { "TestTypedefsPrototype", &Base::s_info, &JSTestTypedefsPrototypeTable, 0, CREATE_METHOD_TABLE(JSTestTypedefsPrototype) };

JSObject* JSTestTypedefsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTestTypedefs>(exec, globalObject);
}

bool JSTestTypedefsPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTestTypedefsPrototype* thisObject = jsCast<JSTestTypedefsPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTestTypedefsPrototypeTable, thisObject, propertyName, slot);
}

bool JSTestTypedefsPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTestTypedefsPrototype* thisObject = jsCast<JSTestTypedefsPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTestTypedefsPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTestTypedefs::s_info = { "TestTypedefs", &Base::s_info, &JSTestTypedefsTable, 0 , CREATE_METHOD_TABLE(JSTestTypedefs) };

JSTestTypedefs::JSTestTypedefs(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TestTypedefs> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTestTypedefs::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTestTypedefs::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTestTypedefsPrototype::create(exec->vm(), globalObject, JSTestTypedefsPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTestTypedefs::destroy(JSC::JSCell* cell)
{
    JSTestTypedefs* thisObject = static_cast<JSTestTypedefs*>(cell);
    thisObject->JSTestTypedefs::~JSTestTypedefs();
}

JSTestTypedefs::~JSTestTypedefs()
{
    releaseImplIfNotNull();
}

bool JSTestTypedefs::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTestTypedefs* thisObject = jsCast<JSTestTypedefs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTestTypedefs, Base>(exec, &JSTestTypedefsTable, thisObject, propertyName, slot);
}

bool JSTestTypedefs::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTestTypedefs* thisObject = jsCast<JSTestTypedefs*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTestTypedefs, Base>(exec, &JSTestTypedefsTable, thisObject, propertyName, descriptor);
}

JSValue jsTestTypedefsUnsignedLongLongAttr(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    JSValue result = jsNumber(impl->unsignedLongLongAttr());
    return result;
}


JSValue jsTestTypedefsImmutableSerializedScriptValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    JSValue result = impl->immutableSerializedScriptValue() ? impl->immutableSerializedScriptValue()->deserialize(exec, castedThis->globalObject(), 0) : jsNull();
    return result;
}


JSValue jsTestTypedefsConstructorTestSubObj(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    return JSTestSubObj::getConstructor(exec, castedThis->globalObject());
}


JSValue jsTestTypedefsAttrWithGetterException(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    ExceptionCode ec = 0;
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->attrWithGetterException(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsTestTypedefsAttrWithSetterException(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    JSValue result = jsNumber(impl->attrWithSetterException());
    return result;
}


JSValue jsTestTypedefsStringAttrWithGetterException(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    ExceptionCode ec = 0;
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    JSC::JSValue result = jsStringWithCache(exec, impl->stringAttrWithGetterException(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsTestTypedefsStringAttrWithSetterException(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->stringAttrWithSetterException());
    return result;
}


JSValue jsTestTypedefsConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTestTypedefs* domObject = jsCast<JSTestTypedefs*>(asObject(slotBase));
    return JSTestTypedefs::getConstructor(exec, domObject->globalObject());
}

void JSTestTypedefs::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSTestTypedefs* thisObject = jsCast<JSTestTypedefs*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSTestTypedefs, Base>(exec, propertyName, value, &JSTestTypedefsTable, thisObject, slot);
}

void setJSTestTypedefsUnsignedLongLongAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(thisObject);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    unsigned long long nativeValue(toUInt64(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setUnsignedLongLongAttr(nativeValue);
}


void setJSTestTypedefsImmutableSerializedScriptValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(thisObject);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    RefPtr<SerializedScriptValue> nativeValue(SerializedScriptValue::create(exec, value, 0, 0));
    if (exec->hadException())
        return;
    impl->setImmutableSerializedScriptValue(nativeValue);
}


void setJSTestTypedefsAttrWithGetterException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(thisObject);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setAttrWithGetterException(nativeValue);
}


void setJSTestTypedefsAttrWithSetterException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(thisObject);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    ExceptionCode ec = 0;
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setAttrWithSetterException(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSTestTypedefsStringAttrWithGetterException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(thisObject);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setStringAttrWithGetterException(nativeValue);
}


void setJSTestTypedefsStringAttrWithSetterException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(thisObject);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setStringAttrWithSetterException(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSTestTypedefs::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTestTypedefsConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionFunc(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        impl->func();
        return JSValue::encode(jsUndefined());
    }

    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSlong[]::s_info))
        return throwVMTypeError(exec);
    Vector<int> x(toNativeArray<int>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->func(x);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionSetShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float width(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float blur(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 3) {
        impl->setShadow(width, height, blur);
        return JSValue::encode(jsUndefined());
    }

    const String& color(exec->argument(3).isEmpty() ? String() : exec->argument(3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 4) {
        impl->setShadow(width, height, blur, color);
        return JSValue::encode(jsUndefined());
    }

    float alpha(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadow(width, height, blur, color, alpha);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionMethodWithSequenceArg(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Vector<RefPtr<SerializedScriptValue>> sequenceArg((toRefPtrNativeArray<SerializedScriptValue, JSSerializedScriptValue>(exec, exec->argument(0), &toSerializedScriptValue)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->methodWithSequenceArg(sequenceArg));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionNullableArrayArg(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Vector<String> arrayArg(toNativeArray<String>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->nullableArrayArg(arrayArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionFuncWithClamp(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned long long arg1 = 0;
    double arg1NativeValue = exec->argument(0).toNumber(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    if (!std::isnan(arg1NativeValue))
        arg1 = clampTo<unsigned long long>(arg1NativeValue);


    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->funcWithClamp(arg1);
        return JSValue::encode(jsUndefined());
    }

    unsigned long long arg2 = 0;
    double arg2NativeValue = exec->argument(1).toNumber(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    if (!std::isnan(arg2NativeValue))
        arg2 = clampTo<unsigned long long>(arg2NativeValue);

    impl->funcWithClamp(arg1, arg2);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionImmutablePointFunction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGPoint>::create(impl->immutablePointFunction())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionStringArrayFunction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Vector<String> values(toNativeArray<String>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->stringArrayFunction(values, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionStringArrayFunction2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Vector<String> values(toNativeArray<String>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->stringArrayFunction2(values, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestTypedefsPrototypeFunctionMethodWithException(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestTypedefs::s_info))
        return throwVMTypeError(exec);
    JSTestTypedefs* castedThis = jsCast<JSTestTypedefs*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTestTypedefs::s_info);
    TestTypedefs* impl = static_cast<TestTypedefs*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->methodWithException(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSTestTypedefs* jsTestTypedefs)
{
    if (jsTestTypedefs->hasCustomProperties())
        return true;
    return false;
}

bool JSTestTypedefsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTestTypedefs* jsTestTypedefs = jsCast<JSTestTypedefs*>(handle.get().asCell());
    if (!isObservable(jsTestTypedefs))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTestTypedefsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTestTypedefs* jsTestTypedefs = jsCast<JSTestTypedefs*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTestTypedefs->impl(), jsTestTypedefs);
    jsTestTypedefs->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TestTypedefs@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12TestTypedefsE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TestTypedefs* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTestTypedefs>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7TestTypedefs@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12TestTypedefsE[2];
#if COMPILER(CLANG)
    // If this fails TestTypedefs does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(TestTypedefs), TestTypedefs_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // TestTypedefs has subclasses. If TestTypedefs has subclasses that get passed
    // to toJS() we currently require TestTypedefs you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<TestTypedefs>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTestTypedefs>(exec, globalObject, impl);
}

TestTypedefs* toTestTypedefs(JSC::JSValue value)
{
    return value.inherits(&JSTestTypedefs::s_info) ? jsCast<JSTestTypedefs*>(asObject(value))->impl() : 0;
}

}
