(* Unison file synchronizer: src/pixmaps.ml *)
(* Copyright 1999-2016, Benjamin C. Pierce

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*)


let copyAB color = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #" ^ color;
(* pixels *)
"............................";
"............................";
"............................";
"......................#.....";
".....................###....";
"......................####..";
"..##########################";
"..##########################";
"......................####..";
".....................###....";
"......................#.....";
"............................";
"............................";
"............................"
|]

let copyBA color = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #" ^ color;
(* pixels *)
"............................";
"............................";
"............................";
".....#......................";
"....###.....................";
"..####......................";
"##########################..";
"##########################..";
"..####......................";
"....###.....................";
".....#......................";
"............................";
"............................";
"............................"
|]

let mergeLogo color = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #" ^ color;
(* pixels *)
"............................";
"............................";
".........##......##.........";
".........###....###.........";
".........####..####.........";
".........##.####.##.........";
".........##..##..##.........";
".........##......##.........";
".........##......##.........";
".........##......##.........";
".........##......##.........";
".........##......##.........";
"............................";
"............................"
|]

let ignore color = [|
(* width height num_colors chars_per_pixel *)
"    20    14        2            1";
(* colors *)
"  c None";
"* c #" ^ color;
(* pixels *)
"                    ";
"       *****        ";
"      **   **       ";
"      **   **       ";
"           **       ";
"          **        ";
"          **        ";
"         **         ";
"        **          ";
"                    ";
"                    ";
"        **          ";
"        **          ";
"                    "
|]

let success = [|
(* width height num_colors chars_per_pixel *)
"    20    14        2            1";
(* colors *)
"  c None";
"* c #00dd00";
(* pixels *)
"                    ";
"                    ";
"             ***    ";
"           ******   ";
"          ***** *   ";
"         ****       ";
"   ***   ***        ";
"    *** **          ";
"    ******          ";
"      ***           ";
"       **           ";
"       **           ";
"       *            ";
"                    "
|]

let failure = [|
(* width height num_colors chars_per_pixel *)
"    20    14        2            1";
(* colors *)
"  c None";
"* c #ff0000";
(* pixels *)
"     *        *     ";
"    ***      **     ";
"     ***    ***     ";
"      **    **      ";
"       **  **       ";
"       *****        ";
"        ****        ";
"        ***         ";
"       *****        ";
"       ** **        ";
"      **   **       ";
"     **    ***      ";
"    ***     **      ";
"   ***              "
|]


(***********************************************************************)
(*        Some alternative arrow shapes (not currently used)...        *)
(***********************************************************************)

let copyAB_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #3cf834";
(* pixels *)
"............................";
"............................";
"............................";
".......................#....";
"......................###...";
".......................####.";
"..##########################";
"..##########################";
".........................##.";
".......................####.";
"......................###...";
"............................";
"............................";
"............................"
|]

let copyABblack_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #000000";
(* pixels *)
"............................";
"............................";
"............................";
".......................#....";
"......................###...";
".......................####.";
"..##########################";
"..##########################";
".........................##.";
".......................####.";
"......................###...";
"............................";
"............................";
"............................"
|]

let copyBA_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #3cf834";
(* pixels *)
"............................";
"............................";
"............................";
".....#......................";
"....###.....................";
"..####......................";
"##########################..";
"##########################..";
"..##........................";
"..####......................";
"....###.....................";
"............................";
"............................";
"............................"
|]

let copyBAblack_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #000000";
(* pixels *)
"............................";
"............................";
"............................";
".....#......................";
"....###.....................";
"..####......................";
"##########################..";
"##########################..";
"..##........................";
"..####......................";
"....###.....................";
"............................";
"............................";
"............................"
|]

(***********************************************************************)
(*                      Busy-Interactive mous pointer                  *)
(***********************************************************************)

let left_ptr_watch = "\
\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\
\x0c\x00\x00\x00\x1c\x00\x00\x00\x3c\x00\x00\x00\
\x7c\x00\x00\x00\xfc\x00\x00\x00\xfc\x01\x00\x00\
\xfc\x3b\x00\x00\x7c\x38\x00\x00\x6c\x54\x00\x00\
\xc4\xdc\x00\x00\xc0\x44\x00\x00\x80\x39\x00\x00\
\x80\x39\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00"


(***********************************************************************)
(*                          Unison icon                                *)
(***********************************************************************)

let icon_data =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\001\019\020\006\134\
 \000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\
 \019\020\006\134\000\000\000\001\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\00022\016\152\1594\
 12\016\153\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\00022\016\156\
 \159412\016\148\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000/0\015w9R\
 :00\016x\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\00000\016|;\
 R8//\015s\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 *+\014V\145\1470RR\
 R\145\1470**\014V\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000+,\014Z\149\1511R\
 RR\141\143.()\013Q\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\030\031\n6\
 rt%RRR\
 RRsu&\030\030\n6\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \"#\011:vx'RR\
 RRRop$\
 \029\029\t2\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\015\015\005\030XZ\029\
 RRRR\
 RRRYZ\029\
 \015\015\005\030\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\014\014\004 \
 \\]\030RRR\
 RRRQ\
 VW\028\008\008\003\027\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\014FG\023P\
 RRRR\
 RRRP\
 GH\023\000\000\000\014\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\015IJ\024\
 PRRR\
 RRRR\
 NEF\022\000\000\000\012\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\005;<\019LR\
 RRRR\
 RRRR\
 L;<\019\000\000\000\005\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\006<=\019L\
 QQQP\
 PPPP\
 PI99\018\000\000\000\004\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 45\017GRR\
 RRRR\
 RRRR\
 RG45\017\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\00155\017FP\
 POOO\
 OOON\
 NNB42\016\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\020\020\006\133\
 IJ\024~\128)~\128)A\
 RRQQ\
 QQQ<\
 ~~(}}(II\023\020\020\006\134\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \020\020\006\138KI\023}{'}z'\
 ?NMM\
 MMMM\
 6}x&}x&FC\021\
 \020\019\006\129\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\014\
 \000\000\000\015\000\000\000\015\000\000\000\028}}(\
 PPOO\
 OOOdb \
 \000\000\000\015\000\000\000\015\000\000\000\015\000\000\000\014\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\014\000\000\000\015\000\000\000\015\000\000\000 \
 \131}(LKK\
 KKKK\
 ^Y\028\000\000\000\015\000\000\000\015\000\000\000\015\
 \000\000\000\013\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014}z'\
 NNMM\
 MMMdb\031\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \130{'JII\
 IIII\
 _Y\028\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014}x'\
 MMLL\
 LLLd_\031\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \130x&IHH\
 HHHH\
 _W\027\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014|v&\
 KKJJ\
 JJJd]\030\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \130v%GFF\
 FFFF\
 _U\027\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014|t%\
 IIHH\
 HHHd\\\029\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \130s$EDD\
 DDDD\
 _T\026\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014|q$\
 GGFF\
 FFFdZ\028\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \129q#CBB\
 BBBB\
 ^R\025\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014|o#\
 FFEE\
 EEEdX\028\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \129o#BAA\
 AAAA\
 ^P\025\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014{m\"\
 DDCC\
 CCCcV\027\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \129l\"@??\
 ????\
 ^N\024\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014{j!\
 BBAA\
 AAAcU\026\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \129j!>==\
 ====\
 ^L\023\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014{h \
 @@??\
 ???cR\026\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \128g\031<;;\
 ;;;;\
 ^K\022\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014{f \
 ?>>>\
 >>=cP\025\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \128e\030::9\
 9999\
 ^I\022\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014{d\031\
 ==<<\
 <<<cO\024\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \128c\030988\
 8888\
 ^G\021\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014za\030\
 ;;::\
 :::bM\024\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \128`\029766\
 6666\
 ]E\020\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014z_\029\
 9988\
 888bL\023\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \127^\028544\
 4444\
 ]C\020\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014z]\028\
 7766\
 666bJ\022\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 \127[\027322\
 2222\
 ]B\019\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014zZ\027\
 6655\
 555bH\022\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 ~Y\026211\
 1111\
 ]@\018\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014yX\026\
 4433\
 333bF\021\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 ~W\0250//\
 ////\
 \\>\018\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014yV\025\
 2211\
 111bD\020\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 ~T\024.\159-\159-\
 \158-\158-\157-\157-\
 \\<\017\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\014yT\024\
 00//\
 ///aB\019\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 ~R\023\156,\155+\155+\
 \154+\154+\153+\153+\
 \\;\016\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\012uO\023\
 /...\
 .\159.\159-b@\018\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\019\
 }O\022\151*\150*\150*\
 \149*\149)\148)\147)\
 [7\016\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\003jE\020\
 \157-\156,\156,\155,\
 \155,\154,\154,b?\018\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\027\
 \134R\023\144'\143'\142'\
 \141&\140&\140&\139%\
 W3\014\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000d@\018\
 \152+\152+\152*\151*\
 \151*\150*\150*d>\017\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000)\
 \151V\023\135$\134$\133#\
 \132#\131#\130\"\129\"\
 U.\012\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000a<\017\
 \147)\146)\145(\144(\
 \144(\143'\142'd<\016\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\0008\
 Y\023} | { \
 {\031z\031y\031x\030\
 R)\n\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000^7\015\
 \138%\137%\136$\135$\
 \134$\133#\132#h:\015\
 \000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\016\008\002L\
 Z\023s\028s\028r\028\
 q\027p\027o\027n\026\
 O$\t\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000Z1\013\
 \129!\128!\127 ~ \
 } |\031{\031\129C\017\
 \000\000\000\023\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\"\016\004d\
 Y\021j\024j\024i\024\
 h\023g\023f\023e\022\
 K \007\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000M'\n\
 w\030v\030u\029t\029\
 s\029r\028q\028\158L\019\
 \000\000\0002\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000*\018\004z\
 W\020`\021`\021_\021\
 ^\020]\020\\\020[\019\
 >\024\005\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000;\028\007\
 n\026m\026l\025k\025\
 j\025i\024h\024a\022\
 3\022\005\158\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000/\018\004\
 U\017W\017W\017V\017\
 U\016T\016S\016P\015\
 /\016\003\153\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000-\020\004\139\
 ]\021c\022b\021a\021\
 a\021`\020_\020^\020\
 ]%\008\000\000\000\014\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\006X\030\005\
 O\014N\013M\013L\013\
 L\012K\012J\012>\t\
 %\012\002l\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\017\007\001N\
 F\015Z\019Y\018X\018\
 W\018V\017U\017U\017\
 N\0159\020\004\000\000\000\016\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\002&\012\002=\n\
 E\011D\nD\nC\n\
 B\tA\t@\t\155*\005\
 \004\001\0005\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\n\
 _!\006Q\015P\014O\014\
 N\014M\013L\013L\013\
 K\012F\011<\019\003\016\005\001X\
 \000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \008\002\000\0261\013\0025\006=\007\
 <\007;\006;\006:\006\
 9\0058\0057\005O\019\001\
 \000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 2\016\002D\nF\011E\n\
 E\nD\tC\tB\t\
 A\008@\008?\0080\005\
 5\014\0026\014\002.\012\001\157(\n\001w\
 \030\007\001^-\011\001\142.\011\001N\019\002\
 \139!\0025\0045\0044\003\
 3\0032\0021\0020\002\
 0\001/\001+\001/\t\000\148\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \t\002\000\024X\024\003=\007<\006\
 ;\006:\0069\0059\005\
 8\0057\0046\0045\004\
 4\0033\0032\003+\002\
 '\002-\002/\001.\001\
 -\001,\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000T\016\000\000\000\000\020\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000%\008\001U\153#\0023\003\
 2\0031\0020\002/\001\
 /\001.\001-\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000\145\027\000%\007\000U\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\0003\n\000p\128\024\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 \152\029\0006\n\000y\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\030\006\000J\
 j\020\000*\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000x\022\000\
 &\007\000_\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\0211\t\000k\020\000(\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 )\000w\022\0007\n\000\017\003\000$\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\n4\n\000\147\
 G\013\000_\018\000ݣ\031\000&\000\
 +\000+\000+\000+\000\
 +\000+\000+\000+\000\
 (\000!\000o\021\000O\015\000\
 9\011\000\000\000\000\018\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\002\003\001\000<)\008\000z\
 -\t\000\1502\t\000:\011\000B\012\000\
 H\014\000@\012\0009\011\000.\t\000\
 ,\008\000\136\004\001\000L\000\000\000\007\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
 \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
