###########################################################################
#  db_mysql.sql                     rlm_sql - FreeRADIUS SQL Module       #
#                                                                         #
#     Database schema for MySQL rlm_sql module                            #
#                                                                         #
#     To load:                                                            #
#         mysql -uroot -prootpass radius < db_mysql.sql                   #
#                                                                         #
#                                   Mike Machado <mike@innercite.com>     #
###########################################################################
#
# Table structure for table 'radacct'
#

CREATE TABLE radacct (
  RadAcctId bigint(21) NOT NULL auto_increment,
  AcctSessionId varchar(32) NOT NULL default '',
  AcctUniqueId varchar(32) NOT NULL default '',
  UserName varchar(64) NOT NULL default '',
  Realm varchar(64) default '',
  NASIPAddress varchar(15) NOT NULL default '',
  NASPortId varchar(15) default NULL,
  NASPortType varchar(32) default NULL,
  AcctStartTime datetime NOT NULL default '0000-00-00 00:00:00',
  AcctStopTime datetime NOT NULL default '0000-00-00 00:00:00',
  AcctSessionTime int(12) default NULL,
  AcctAuthentic varchar(32) default NULL,
  ConnectInfo_start varchar(50) default NULL,
  ConnectInfo_stop varchar(50) default NULL,
  AcctInputOctets bigint(12) default NULL,
  AcctOutputOctets bigint(12) default NULL,
  CalledStationId varchar(50) NOT NULL default '',
  CallingStationId varchar(50) NOT NULL default '',
  AcctTerminateCause varchar(32) NOT NULL default '',
  ServiceType varchar(32) default NULL,
  FramedProtocol varchar(32) default NULL,
  FramedIPAddress varchar(15) NOT NULL default '',
  AcctStartDelay int(12) default NULL,
  AcctStopDelay int(12) default NULL,
  PRIMARY KEY  (RadAcctId),
  KEY UserName (UserName),
  KEY FramedIPAddress (FramedIPAddress),
  KEY AcctSessionId (AcctSessionId),
  KEY AcctUniqueId (AcctUniqueId),
  KEY AcctStartTime (AcctStartTime),
  KEY AcctStopTime (AcctStopTime),
  KEY NASIPAddress (NASIPAddress)
) ;

#
# Table structure for table 'radcheck'
#

CREATE TABLE radcheck (
  id int(11) unsigned NOT NULL auto_increment,
  UserName varchar(64) NOT NULL default '',
  Attribute varchar(32)  NOT NULL default '',
  op char(2) NOT NULL DEFAULT '==',
  Value varchar(253) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY UserName (UserName(32))
) ;

#
# Table structure for table 'radgroupcheck'
#

CREATE TABLE radgroupcheck (
  id int(11) unsigned NOT NULL auto_increment,
  GroupName varchar(64) NOT NULL default '',
  Attribute varchar(32)  NOT NULL default '',
  op char(2) NOT NULL DEFAULT '==',
  Value varchar(253)  NOT NULL default '',
  PRIMARY KEY  (id),
  KEY GroupName (GroupName(32))
) ;

#
# Table structure for table 'radgroupreply'
#

CREATE TABLE radgroupreply (
  id int(11) unsigned NOT NULL auto_increment,
  GroupName varchar(64) NOT NULL default '',
  Attribute varchar(32)  NOT NULL default '',
  op char(2) NOT NULL DEFAULT '=',
  Value varchar(253)  NOT NULL default '',
  PRIMARY KEY  (id),
  KEY GroupName (GroupName(32))
) ;

#
# Table structure for table 'radreply'
#

CREATE TABLE radreply (
  id int(11) unsigned NOT NULL auto_increment,
  UserName varchar(64) NOT NULL default '',
  Attribute varchar(32) NOT NULL default '',
  op char(2) NOT NULL DEFAULT '=',
  Value varchar(253) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY UserName (UserName(32))
) ;


#
# Table structure for table 'usergroup'
#

CREATE TABLE usergroup (
  UserName varchar(64) NOT NULL default '',
  GroupName varchar(64) NOT NULL default '',
  priority int(11) NOT NULL default '1',
  KEY UserName (UserName(32))
) ;

#
# Table structure for table 'radpostauth'
#

CREATE TABLE radpostauth (
  id int(11) NOT NULL auto_increment,
  user varchar(64) NOT NULL default '',
  pass varchar(64) NOT NULL default '',
  reply varchar(32) NOT NULL default '',
  date timestamp(14) NOT NULL,
  PRIMARY KEY  (id)
) ;

######################################################################
#
#  The next table is commented out because it is not
#  currently used in the server.
#

#
# Table structure for table 'dictionary'
#
#CREATE TABLE dictionary (
#  id int(10) DEFAULT '0' NOT NULL auto_increment,
#  Type varchar(30),
#  Attribute varchar(64),
#  Value varchar(64),
#  Format varchar(20),
#  Vendor varchar(32),
#  PRIMARY KEY (id)
#);

#
# Table structure for table 'nas'
#
CREATE TABLE nas (
  id int(10) NOT NULL auto_increment,
  nasname varchar(128) NOT NULL,
  shortname varchar(32),
  type varchar(30) DEFAULT 'other',
  ports int(5),
  secret varchar(60) DEFAULT 'secret' NOT NULL,
  community varchar(50),
  description varchar(200) DEFAULT 'RADIUS Client',
  PRIMARY KEY (id),
  KEY nasname (nasname)
);
-- phpMyAdmin SQL Dump
-- version 2.6.3-pl1
-- http://www.phpmyadmin.net
-- 
-- Host: localhost
-- Generation Time: Jun 07, 2006 at 03:50 PM
-- Server version: 4.1.14
-- PHP Version: 5.0.5
-- 
-- Database: `radius`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `securelogin_table`
-- 

CREATE TABLE IF NOT EXISTS `securelogin_table` (
  `securelogin_id` int(11) NOT NULL auto_increment,
  `securelogin_login` varchar(100) NOT NULL default '',
  `securelogin_pass` varchar(100) NOT NULL default '',
  `securelogin_string` varchar(250) NOT NULL default '',
  `securelogin_signupdate` varchar(200) NOT NULL default '',
  `securelogin_pass_readable` varchar(100) NOT NULL default '',
  `securelogin_isadmin` varchar(5) NOT NULL default 'no',
  PRIMARY KEY  (`securelogin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

-- 
-- Dumping data for table `securelogin_table`
-- 

INSERT INTO `securelogin_table` VALUES (1, 'admin', 'f6fdffe48c908deb0f4c3bd36c032e72', '47b490e4c650ff5767b13d9831396bd5', '2006-06-07 15-47-30', '', 'yes');

-- --------------------------------------------------------

-- 
-- Table structure for table `sitepages`
-- 

CREATE TABLE IF NOT EXISTS `sitepages` (
  `pageid` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `page` text NOT NULL,
  `date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`pageid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

-- 
-- Dumping data for table `sitepages`
-- 

INSERT INTO `sitepages` VALUES (1, 'Main Page', 'Welcome to our Wireless HotSpot.  Here you can purchase time to browse the internet, check your email, securly connect to your office by VPN.  <BR>\r\n<BR>\r\nChoose your time below, and happy surfing!', '2006-06-06');

-- --------------------------------------------------------

-- 
-- Table structure for table `tcat`
-- 

CREATE TABLE IF NOT EXISTS `tcat` (
  `tcat` tinyint(4) NOT NULL auto_increment,
  `label` text NOT NULL,
  PRIMARY KEY  (`tcat`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

-- 
-- Dumping data for table `tcat`
-- 

INSERT INTO `tcat` VALUES (1, 'Daily');
INSERT INTO `tcat` VALUES (3, 'Weekly');
INSERT INTO `tcat` VALUES (4, 'Monthly');

-- --------------------------------------------------------

-- 
-- Table structure for table `timeoptions`
-- 

CREATE TABLE IF NOT EXISTS `timeoptions` (
  `timeid` int(11) NOT NULL auto_increment,
  `tcat` tinyint(4) NOT NULL default '0',
  `label` text NOT NULL,
  `tavail` text NOT NULL,
  `cost` varchar(11) NOT NULL default '0',
  `publish` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`timeid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=11 ;

-- 
-- Dumping data for table `timeoptions`
-- 

INSERT INTO `timeoptions` VALUES (1, 1, 'Half Hour', '1800', '2', 1);
INSERT INTO `timeoptions` VALUES (2, 1, '1 Hour', '3600', '3.50', 1);
INSERT INTO `timeoptions` VALUES (5, 3, '1 Day', '86400', '10', 1);
INSERT INTO `timeoptions` VALUES (4, 1, '2 Hours', '7200', '7', 1);
INSERT INTO `timeoptions` VALUES (6, 3, '3 Days', '259200', '15', 1);
INSERT INTO `timeoptions` VALUES (7, 3, '7 Days', '604800', '20', 1);
INSERT INTO `timeoptions` VALUES (8, 4, '30 Days', '7257600', '35', 1);
INSERT INTO `timeoptions` VALUES (9, 4, 'Monthly Subscription', '7257600', '30', 1);
INSERT INTO `timeoptions` VALUES (10, 1, 'Local Browsing', '0', '0', 0);


create table billing(
transid varchar(32),
transdate datetime,
buyer_fname varchar(32),
buyer_lname varchar(32),
package varchar(64),
buyer_email varchar(64),
minutesbought int,
amountpaid numeric(15,2),
userid varchar(32));

create unique index bind1 on billing(transdate,transid);



create table heartbeat(
mac varchar(20),
hostname varchar(128),
ssid varchar(32),
wanip varchar(16),
realip varchar(16),
thetime datetime);

create unique index hbind1 on heartbeat(realip,mac);

GRANT ALL ON radius.* to freeradius@localhost IDENTIFIED BY 'ddwrt';
