<?php
/*
	Copyright (c) InterAKT Online 2000-2005
*/

/**
 * Send Email trigger class.
 * This is also the base class for tNG_EmailRecordset
 * @access public
 */
class tNG_Email 
{
	/**
	 * transaction in which the trigger will be executed;
	 * @var string
	 * @access public
	 */	
	var $tNG;
	
	/**
	 * from whom the email is send;
	 * @var string
	 * @access public
	 */		 		
	var $from;
	
	/**
	 * to whom send the email;
	 * @var string
	 * @access public
	 */	
	var $to;	
	
	/**
	 * copy carbon mail;
	 * @var string
	 * @access public
	 */	
	var $cc; 
	
	/**
	 * blind copy carbon mail;
	 * @var string
	 * @access public
	 */	
	var $bcc;
	
	/**
	 * subject of the email;
	 * @var string
	 * @access public
	 */	
	var $subject;
	
	/**
	 * body of the email;
	 * @var string
	 * @access public
	 */	
	var $content;
	
	/**
	 * the file from which the content is read and sent;
	 * @var string
	 * @access public
	 */	
	var $contentFile;
	
	/**
	 * the file from which the content is read and sent if is set setContentFile
	 * or the __FILE__;
	 * @var string
	 * @access protected
	 */	
	var $file;
	
	/**
	 * encoding type;
	 * @var string
	 * @access public
	 */	
	var $encoding;
	
	/**
	 * format of the email: text or html/text;
	 * @var string
	 * @access public
	 */	
	var $format;
	
	/**
	 * importance of the email: Normal, Low, High;
	 * @var string
	 * @access public
	 */	
	var $importance;	
	
	/**
	 * escap method to use in KT_dynamicvalue() default 'none';
	 * @var string
	 * @access privat
	 */	
	var $escapeMethod;
	
	/**
	 * if it must be used the saveData or not;
	 * @var boolean
	 * @access privat
	 */	
	var $useSavedData;	
	
	/**
	 * Constructor. Set transaction.
	 * @param object $tNG the transaction
	 * @access public
	 */
	function tNG_Email(&$tNG)
	{
		$this->tNG = &$tNG;
		$this->from = '';
		$this->to = '';
		$this->cc = '';
		$this->bcc = '';
		$this->subject = '';
		$this->content = '';
		$this->contentFile = '';
		$this->file = basename(KT_getUri());
		$this->encoding = '';
		$this->priority = 3;
		$this->escapeMethod = 'none';
	}
	
	/**
	 * Setter. Set from.
	 * @param string $from the from string to use in header
	 * @access public
	 */
	function setFrom($from) 
	{
		$this->from = $from;
	}
	
	/**
	 * Setter. Set to.
	 * @param string $to the string from which to retrieve the email to which the email is send;
	 * @access public
	 */
	function setTo($to) 
	{
		$this->to = $to;
	}
	
	/**
	 * Setter. Set cc.
	 * @param string $cc the carbon copy string from which to retrieve the email address
	 * @access public
	 */
	function setCC($cc) 
	{
		$this->cc = $cc;
	}
	
	/**
	 * Setter. Set bcc.
	 * @param string $bcc the blind carbon copy string from which to retrieve the email address
	 * @access public
	 */
	function setBCC($bcc) 
	{
		$this->bcc = $bcc;
	}
	
	/**
	 * Setter. Set subject.
	 * @param string $subject set the subject of the email or the string from which to retrieve the subject
	 * @access public
	 */
	function setSubject($subject) 
	{
		$this->subject = $subject;
	}
	
	/**
	 * Setter. Set content.
	 * @param string $content set the content from which the body of the email will be retrieved.
	 * @access public
	 */
	function setContent($content) 
	{
		$this->content = $content;
	}
	
	/**
	 * Setter. Set contentFile.
	 * @param string $contentFile the file from which the email body is retrieved.
	 * @access public
	 */
	function setContentFile($contentFile) 
	{
		$this->file = $contentFile;
		$this->contentFile = KT_DynamicData($contentFile, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array());
	}
	
	/**
	 * Setter. encoding.
	 * @param string $encoding the encoding to use for encoding the email;
	 * @access public
	 */
	function setEncoding($encoding) 
	{
		$this->encoding = $encoding;
	}
	
	/**
	 * Setter. Set format.
	 * @param string $format the format text or html/text of the email
	 * @access public
	 */
	function setFormat($format) 
	{
		$this->format = strtolower($format);
	}
	
	/**
	 * Setter. Set importance.
	 * @param string $importance set the importance of the email: Normal, High or Low;
	 * @access public
	 */
	function setImportance($importance) 
	{
		$this->importance = strtolower($importance);
	}
	
	/**
	 * Getter. Get tNG object.
	 * @return object transaction object
	 * @access public
	 */
	function getTng()
	{
		return $this->tNG;	
	}
	
	/**
	 * Getter. Get From.
	 * @return string
	 * @access public
	 */
	function getFrom()
	{
		return KT_DynamicData($this->from, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array('KT_defaultSender'=>$GLOBALS['tNG_email_defaultFrom']));	
	}
	
	/**
	 * Getter. Get to.
	 * @return string
	 * @access public
	 */
	function getTo()
	{
		return KT_DynamicData($this->to, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array('KT_defaultSender'=>$GLOBALS['tNG_email_defaultFrom'])); 
	}
	
	/**
	 * Getter. Get cc.
	 * @return string
	 * @access public
	 */
	function getCc()
	{
		return KT_DynamicData($this->cc, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array('KT_defaultSender'=>$GLOBALS['tNG_email_defaultFrom'])); 
	}
	
	/**
	 * Getter. Get bcc.
	 * @return string
	 * @access public
	 */
	function getBcc()
	{
		return KT_DynamicData($this->bcc, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array('KT_defaultSender'=>$GLOBALS['tNG_email_defaultFrom'])); 
	}
	
	/**
	 * Getter. Get subject.
	 * @return string
	 * @access public
	 */
	function getSubject()
	{
		return KT_DynamicData($this->subject, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array('KT_defaultSender'=>$GLOBALS['tNG_email_defaultFrom']));
	}
	
	/**
	 * Getter. Get encoding.
	 * @return string
	 * @access public
	 */
	function getEncoding()
	{
		return $this->encoding;	
	}
	
	/**
	 * Getter. Get textBody.
	 * @return string the text body of the email, stripped by all html tags;
	 * @access protected
	 */
	function getTextBody()
	{	
		$content = KT_DynamicData($this->content, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array(), false);
		$content = $this->removeScript($content);
		$content = $this->removeStyle($content);
		return trim(strip_tags($content));
	}
	
	/**
	 * Getter. Get htmlBody.
	 * @return string the content of the email (can have any html tags but <script>)
	 * @access protected
	 */
	function getHtmlBody()
	{
		if ($this->format!='text') {
			$text = KT_DynamicData($this->content, $this->getTng(), $this->escapeMethod, $this->getUseSavedData(), array(), false);
			$text = $this->removeScript($text);
			return KT_transformsPaths(KT_makeIncludedURL($this->file), $text);
		} else {
			return ;
		}	
	}
	
	
	/**
	 * Remove the <script></script> or <script > tags from the 
	 * @param string $text the text to be stripped
	 * @return string the stripped text
	 * @access protected
	 */
	function removeScript($text)
	{
		preg_match_all("/<\s*script[^>]*>(.*)<\s*\/\s*script\s*>/ims", $text, $matches);
		if (is_array($matches) && !empty($matches[0])) {
			foreach ($matches[0] as $key => $val) {
				$text = str_replace($val, '', $text);
			}
		}
		preg_match_all("/<\s*script[^>]*>/ims", $text, $matches);
		if (is_array($matches) && !empty($matches[0])) {
			foreach ($matches[0] as $key => $val) {
				$text = str_replace($val, '', $text);
			}
		}
		return $text;
	}
	
	/**
	 * remove the <style> tags from the text;
	 * @param string $text the text to be stripped
	 * @return string the text without <style> tags
	 * @access private
	 */
	function removeStyle($text)
	{
		preg_match_all("/<\s*style[^>]*>(.*)<\s*\/\s*style\s*>/ims", $text, $matches);
		if (is_array($matches) && !empty($matches[0])) {
			foreach ($matches[0] as $key => $val) {
				$text = str_replace($val, '', $text);
			}
		}
		return $text;
	}
	
	/**
	 * Getter. Get useSavedData.
	 * @return boolean true if the transaction was a delete one;
	 * @access protected
	 */
	function getUseSavedData()
	{
		if (!isset($this->useSavedData)) {
			if ($this->tNG->getTransactionType()=='_delete' || $this->tNG->getTransactionType()=='_multipleDelete') {
				$this->useSavedData = true;
			} else {
				$this->useSavedData = false;
			}
		}	
		return $this->useSavedData;	
	}
	
	/**
	 * the main method, execute the code of the class;
	 * @access public
	 */
	function Execute() 
	{
		if ($this->contentFile!='' && file_exists($this->contentFile) && $fp = fopen($this->contentFile, 'r')) {
			$this->content = fread($fp, filesize($this->contentFile));
			fclose($fp);
		} else if ($this->contentFile!='') {
			return new tNG_error('EMAIL_NO_TEMPLATE', array(), array());
		}
		
		$email = new KT_Email();
		$email->setPriority($this->importance);
		$email->sendEmail($GLOBALS['tNG_email_host'], $GLOBALS['tNG_email_port'], $GLOBALS['tNG_email_user'], $GLOBALS['tNG_email_password'], $this->getFrom(), $this->getTo(), $this->getCc(), $this->getBcc(), $this->getSubject(), $this->getEncoding(), $this->getTextBody(), $this->getHtmlBody());
		if ($email->hasError()) {
			$arr = $email->getError();
			return new tNG_error('EMAIL_FAILED', array(''), array($arr[1]));
		} 
	}
			
}

?>