<?php

class KT_tNG_login extends KT_tNG_base {
	//login table in database
	var $loginTable;
	//user name field (the name of the user name column in the login table)
	var $userNameField;
	//password field (the name of the password column in the login table)
	var $passwordField;
	//the level Field (the name of the authorization level column in the login table)
	var $levelField;
	//Unique Key Field
	var $uniqueKey;
	//user name value
	var $userName;
	//password value
	var $password;
	//show if password is crypted in database
	var $pswdIsCrypted;
	//the crypt key
	var $cryptKey;
	
	
	//the following variables are used to select the encryption algorithm
	//the portion of the salt than can be chaged
	var $utilSaltLength;
	//total salt length
	var $totalSaltLength;
	//salt pattern that will be used to generate the final salt that will be passed to crypt function
	var $saltPattern;
	//the salt
	var $salt;
	
	
	
	
	//Constructor
	function KT_tNG_login() {
		$this->initCrypting();
	}
	
	
	// **************
	// public methods
	// **************
	

	/*
	NAME:
	setLoginTable()
	DESCRIPTION:
	Sets the login table name
	PARAMETERS:
		$loginTable - string
	RETURN:
		- none
	*/
	function setLoginTable($loginTable) {
		$this->loginTable = $loginTable;
	}

	/*
	NAME:
	passwordIsCryptedInDatabase()
	DESCRIPTION:
	Specifies if the password will be crypted in database
	PARAMETERS:
		$pswdIsCrypted - boolean
	RETURN:
		- none
	*/
	function passwordIsCryptedInDatabase($pswdIsCrypted) {
		$this->pswdIsCrypted = $pswdIsCrypted;
	}

	/*
	NAME:
	setFields()
	DESCRIPTION:
	Sets the primaryKey,user name, password and level columns name
	PARAMETERS:
		$uniqueKey - string
		$userNameField - string
		$passwordField - string
		$levelField - string - optional
	RETURN:
		- none
	*/
	function setFields($uniqueKey, $userNameField, $passwordField, $levelField=null) {
		$this->uniqueKey = $uniqueKey;
		$this->userNameField = $userNameField;
		$this->passwordField = $passwordField;
		$this->levelField = $levelField;
	}

	/*
	NAME:
	setValues()
	DESCRIPTION:
	Sets the user name and password values
	PARAMETERS:
		$userName - string
		$password - string
	RETURN:
		- none
	*/
	function setValues($userName, $password) {
		$this->userName = $userName;
		$this->password = $password;
	}
	
	
	/**
	NAME:
	executeTransaction
	DESCRIPTION:
	Execute the transaction 
		Reimplement default method to generate the SQL if it's  autogenerate
	PARAMETERS:
		- none
	RETURN
		- none
	**/
	function executeTransaction() {
		$this->generateLoginSQL();
		parent::executeTransaction();
	}

	
	/*
	NAME:
	generateSalt()
	DESCRIPTION:
		generate the final crypting salt from the cryptKey based
	on crypt algorithm choosed in initCrypting.
		The salt will be generated by taken first $utilSaltLength chars from
	the $cryptKey and adding(sprintf) it to the pattern
	PARAMETERS:
		- $cryptKey - string - base key for salt generation
	RETURN:
		- none
	*/
	function generateSalt($cryptKey) {
		$this->cryptKey = $cryptKey;
		$this->salt = sprintf($this->saltPattern,substr($this->cryptKey,0,$this->utilSaltLength));
	}
	


	// ****************
	// private methods
	// ****************
	/*
	NAME:
	generateLoginSQL()
	DESCRIPTION:
	generate the login "select" SQL
	PARAMETERS:
		- none
	RETURN:
		- none
	*/
	function generateLoginSQL() {
		$tmSQL = sprintf('select * from %s where %s=\'%s\' and %s=\'%s\'',
													$this->loginTable,
													$this->userNameField,
													$this->userName,
													$this->passwordField,
													$this->cryptString($this->password));
		$this->setSQL($tmSQL);
	}

	/*
	NAME:
	initCrypting()
	DESCRIPTION:
	initialize the crypt engine
	PARAMETERS:
		- none
	RETURN:
		- none
	*/
	function initCrypting() {
		if (CRYPT_MD5) {
			$this->utilSaltLength = 8;
			$this->totalSaltLength = 12;
			$this->saltPattern = '$1$%s$';
			return;
		}
		if (CRYPT_EXT_DES) {
			$this->utilSaltLength = 9;
			$this->totalSaltLength = 9;
			$this->saltPattern = '%s';
			return;
		}
		if (CRYPT_STD_DES) {
			$this->utilSaltLength = 2;
			$this->totalSaltLength = 2;
			$this->saltPattern = '%s';
			return;
		}
	}
	
	/*
	NAME:
	cryptString()
	DESCRIPTION:
		if the pswdIsCrypted is set then crypt a string using the generated salt
	return the crypted string without the salt (which is automatically 
	inserted by PHP:crypt at the begining of the crypted string)
	PARAMETERS:
		- $string - string - 
	RETURN:
		- string
	*/
	function cryptString($string, $forceCrypt=false) {
		if ($this->pswdIsCrypted || $forceCrypt) {
			$tmCrypt = crypt($string, $this->salt);
			return substr($tmCrypt, strlen($this->salt), strlen($tmCrypt));
		} else {
			return $string;
		}
	}

}
?>