#!/usr/bin/perl

# chilli - ChilliSpot.org. A Wireless LAN Access Point Controller
# Copyright (C) 2003, 2004 Mondru AB.
#
# The contents of this file may be used under the terms of the GNU
# General Public License Version 2, provided that the above copyright
# notice and this permission notice is included in all copies or
# substantial portions of the software.


# Shared secret used to encrypt challenge with. Prevents dictionary attacks.
# You should change this to your own shared secret.
#$uamsecret = "ht2eb8ej6s4et3rg1ulp";

# Uncomment the following line if you want to use ordinary user-password
# for radius authentication. Must be used together with $uamsecret.
#$userpassword=1;

# Our own path
$loginpath = "/cgi-bin/hotspotlogin.cgi";

use Digest::MD5  qw(md5 md5_hex md5_base64);

# Make sure that the form parameters are clean
$OK_CHARS='-a-zA-Z0-9_.@&=%!';
$_ = $input = <STDIN>;
s/[^$OK_CHARS]/_/go;
$input = $_;

# Make sure that the get query parameters are clean
$OK_CHARS='-a-zA-Z0-9_.@&=%!';
$_ = $query=$ENV{QUERY_STRING};
s/[^$OK_CHARS]/_/go;
$query = $_;


# If she did use https tell her that it was wrong.
if (!($ENV{HTTPS} =~ /^on$/)) {
    print "Content-type: text/html\n\n
<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
  <title>HotSpot Login Failed</title>
  <meta http-equiv=\"Cache-control\" content=\"no-cache\">
  <meta http-equiv=\"Pragma\" content=\"no-cache\">
</head>
<body>
  <h1 style=\"text-align: center;\">HotSpot Login Failed</h1>
  <center>
    Login must use encrypted connection.
  </center>
</body>
</html>
";
    exit(0);
}


#Read form parameters which we care about
@array = split('&',$input);
foreach $var ( @array )
{
    @array2 = split('=',$var);
    if ($array2[0] =~ /^uid$/) { $uid = $array2[1]; }
    if ($array2[0] =~ /^pwd$/) { $pwd = $array2[1]; }
    if ($array2[0] =~ /^chal$/) { $chal = $array2[1]; }
    if ($array2[0] =~ /^login$/) { $login = $array2[1]; }
    if ($array2[0] =~ /^logout$/) { $logout = $array2[1]; }
    if ($array2[0] =~ /^prelogin$/) { $prelogin = $array2[1]; }
    if ($array2[0] =~ /^res$/) { $res = $array2[1]; }
    if ($array2[0] =~ /^uamip$/) { $uamip = $array2[1]; }
    if ($array2[0] =~ /^uamport$/) { $uamport = $array2[1]; }
}

#Read query parameters which we care about
@array = split('&',$query);
foreach $var ( @array )
{
    @array2 = split('=',$var);
    if ($array2[0] =~ /^res$/)       { $res = $array2[1]; }
    if ($array2[0] =~ /^challenge$/) { $challenge = $array2[1]; }
    if ($array2[0] =~ /^uamip$/)     { $uamip = $array2[1]; }
    if ($array2[0] =~ /^uamport$/)   { $uamport = $array2[1]; }
    if ($array2[0] =~ /^reply$/)     { $reply = $array2[1]; }
}


$reply =~ s/\+/ /g;
$reply =~s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/seg;

$result = 0;
# 0: It was not a form request
# 1: Login successful
# 2: Login failed
# 3: Logged out
# 4: Tried to login while already logged in
# 5: (unused)
# 6: Not logged in yet

# If attempt to login
if ($login =~ /^login$/) {
    $hexchal  = pack "H32", $chal;
    if (defined $uamsecret) {
	$newchal  = md5($hexchal, $uamsecret);
    }
    else {
	$newchal  = $hexchal;
    }
    $response = md5_hex("\0", $pwd, $newchal);
    $password = unpack "H32", ($pwd ^ $newchal);
    
print "Content-type: text/html\n\n";
print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
  <title>HotSpot Login</title>
  <meta http-equiv=\"Cache-control\" content=\"no-cache\">
  <meta http-equiv=\"Pragma\" content=\"no-cache\">";
    if ((defined $uamsecret) && defined($userpassword)) {
	print "  <meta http-equiv=\"refresh\" content=\"0;url=http://$uamip:$uamport/logon?username=$uid&password=$password\">";
    } else {
	print "  <meta http-equiv=\"refresh\" content=\"0;url=http://$uamip:$uamport/logon?username=$uid&response=$response\">";
    }
print "</head>
<body>";
  print "<h1 style=\"text-align: center;\">Logging in to HotSpot</h1>";
  print "
  <center>
    Please wait......
  </center>
</body>
</html>
";
    exit(0);
}



# If login successful
if ($res =~ /^success$/) { 
    $result = 1;
}

# If login failed 
if ($res =~ /^failed$/) { 
    $result = 2;
}

# If logout successful
if ($res =~ /^logoff$/) { 
    $result = 3;
}

# If tried to login while already logged in
if ($res =~ /^already$/) { 
    $result = 4;
}

# If requested a pop up window
if ($res =~ /^popup$/) { 
    $result = 5;
}

# If not logged in yet 
if ($res =~ /^logon$/) { 
    $result = 6;
}

# Otherwise it was not a form request
# Send out an error message
if ($result == 0) {
    print "Content-type: text/html\n\n
<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
  <title>HotSpot Login Failed</title>
  <meta http-equiv=\"Cache-control\" content=\"no-cache\">
  <meta http-equiv=\"Pragma\" content=\"no-cache\">
</head>
<body>
  <h1 style=\"text-align: center;\">HotSpot Login Failed</h1>
  <center>
    Login must be performed through ChilliSpot daemon.
  </center>
</body>
</html>
";
    exit(0);
}

#Generate the output
print "Content-type: text/html\n\n
<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<head>
  <title>HotSpot Login</title>
  <meta http-equiv=\"Cache-control\" content=\"no-cache\">
  <meta http-equiv=\"Pragma\" content=\"no-cache\">";

if ($result == 1) {
print "
  <SCRIPT LANGUAGE=\"JavaScript\">
    function popUp(URL) {
      date = new Date();
      time = date.getTime();
      eval(\"page\" + time + \" = window.open(URL, 'hotspotpopup', 'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=0,width=400,height=200');\");
    }
  </script>
</head>
<body onLoad=\"javascript:popUp('$loginpath?res=popup&uamip=$uamip&uamport=$uamport')\">";
}
else {
print "
</head>
<body>";
}


#print "THE INPUT: $input";
#foreach $key (sort (keys %ENV)) {
#	print $key, ' = ', $ENV{$key}, "<br>\n";
#}

if ($result == 2) {
    print "
  <h1 style=\"text-align: center;\">HotSpot Login Failed</h1>";
    if ($reply) {
	print "<center>$reply </BR></BR></center>";
    }
}

if ($result == 6) {
    print "
  <h1 style=\"text-align: center;\">Logged out from HotSpot</h1>";
}

if ($result == 2 || $result == 6) {
  print "
  <form method=\"post\" action=\"$loginpath\">
  <INPUT TYPE=\"hidden\" NAME=\"chal\" VALUE=\"$challenge\">
  <INPUT TYPE=\"hidden\" NAME=\"uamip\" VALUE=\"$uamip\">
  <INPUT TYPE=\"hidden\" NAME=\"uamport\" VALUE=\"$uamport\">
  <center>
  <table border=\"0\" cellpadding=\"5\" cellspacing=\"0\" style=\"width: 217px;\">
    <tbody>
      <tr>
        <td align=\"right\">Login:</td>
        <td><input type=\"text\" name=\"uid\" size=\"20\" maxlength=\"255\"></td>
      </tr>
      <tr>
        <td align=\"right\">Password:</td>
        <td><input type=\"password\" name=\"pwd\" size=\"20\" maxlength=\"255\"></td>
      </tr>
      <tr>
        <td align=\"center\" colspan=\"2\" height=\"23\"><input type=\"submit\" name=\"login\" value=\"login\"></td>
      </tr>
    </tbody>
  </table>
  </center>
  </form>
</body>
</html>";
}

if ($result == 1) {
  print "
  <h1 style=\"text-align: center;\">Logged in to HotSpot</h1>";

  if ($reply) { 
      print "<center> $reply </BR></BR></center>";
  }

  print "
  <center>
    <a href=\"http://$uamip:$uamport/logoff\">Logout</a>
  </center>
</body>
</html>";
}

if ($result == 5) {
  print "
  <h1 style=\"text-align: center;\">Logged in to HotSpot</h1>
  <center>
    <a href=\"http://$uamip:$uamport/logoff\">Logout</a>
  </center>
</body>
</html>";
}

if ($result == 4) {
  print "
  <h1 style=\"text-align: center;\">Already logged in to HotSpot</h1>
  <center>
    <a href=\"http://$uamip:$uamport/logoff\">Logout</a>
  </center>
</body>
</html>";
}

if ($result == 3) {
    print "
  <h1 style=\"text-align: center;\">Logged out from HotSpot</h1>
  <center>
    <a href=\"http://$uamip:$uamport/prelogin\">Login</a>
  </center>
</body>
</html>";
}


exit(0);

