/* 
 * IP hash functions.
 * Copyright (C) 2003, 2004 Mondru AB.
 * 
 * The contents of this file may be used under the terms of the GNU
 * General Public License Version 2, provided that the above copyright
 * notice and this permission notice is included in all copies or
 * substantial portions of the software.
 * 
 */

/* TODO: This code was copied from ippool.c. Needs cleaning up! */ 

#ifndef _IPHASH_H
#define _IPHASH_H

#define IPHASH_NOIP6

struct iphashm_t;                /* Forward declaration */

struct iphash_t {
  int listsize;                  /* Total number of addresses */
  struct iphashm_t *member;      /* Listsize array of members */
  int hashsize;                  /* Size of hash table */
  int hashlog;                   /* Log2 size of hash table */
  int hashmask;                  /* Bitmask for calculating hash */
  struct iphashm_t **hash;       /* Hashsize array of pointer to member */
  struct iphashm_t *firstdyn;    /* Pointer to first free dynamic member */
  struct iphashm_t *lastdyn;     /* Pointer to last free dyanmic member */
  struct iphashm_t *firststat;   /* Pointer to first free static member */
  struct iphashm_t *laststat;    /* Pointer to last free static member */
};

struct iphashm_t {
#ifndef IPHASH_NOIP6
  struct in6_addr addr;          /* IP address of this member */
#else
  struct in_addr addr;           /* IP address of this member */
#endif
  int inuse;                     /* 0=available; 1= dynamic; 2 = static */
  struct iphashm_t *nexthash;    /* Linked list part of hash table */
  struct iphashm_t *prev, *next; /* Linked list of free dynamic or static */
  void *peer;                    /* Pointer to peer protocol handler */
};

/* The above structures require approximately 20+4 = 24 bytes for
   each address (IPv4). For IPv6 the corresponding value is 32+4 = 36
   bytes for each address. */

/* Hash an IP address using code based on Bob Jenkins lookupa */
extern unsigned long int iphash_hash4(struct in_addr *addr);

/* Create new address pool */
extern 
int iphash_new(struct iphash_t **this, struct iphashm_t *list, int listsize);

/* Delete existing address pool */
extern int iphash_free(struct iphash_t *this);

/* Find an IP address in the pool */
extern int iphash_getip(struct iphash_t *this, struct iphashm_t **member,
		 struct in_addr *addr);

/* Get an IP address. If addr = 0.0.0.0 get a dynamic IP address. Otherwise
   check to see if the given address is available */
extern int iphash_newip(struct iphash_t *this, struct iphashm_t **member,
			struct in_addr *addr);

/* Return a previously allocated IP address */
extern int iphash_freeip(struct iphash_t *this, struct iphashm_t *member);

/* Get net and mask based on ascii string */
extern int iphash_aton(struct in_addr *addr, struct in_addr *mask,
		       char *pool, int number);


#ifndef IPHASH_NOIP6
extern unsigned long int iphash_hash6(struct in6_addr *addr);
extern int iphash_getip6(struct iphash_t *this, struct in6_addr *addr);
extern int iphash_returnip6(struct iphash_t *this, struct in6_addr *addr);
#endif

#endif	/* !_IPHASH_H */
