#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <wait.h>

#include <bcmdevs.h>
#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <utils.h>
#include <cy_conf.h>
#include <code_pattern.h>
#include <rc.h>

static char* get_wshaper_dev(void)
{
  if(nvram_match("wshaper_dev", "WAN"))
    return get_wan_face();
  else
    return "br0";
}

static char* get_mtu_val(void)
{
  if(nvram_match("wshaper_dev", "WAN") && nvram_match("wan_proto", "pppoe"))
    return nvram_safe_get("ppp_mtu");
  else
  if(nvram_match("wshaper_dev", "WAN"))
    return nvram_safe_get("wan_mtu");
  else
    return "1500";
}

int svqos_reset_ports(void)
{

	system("echo 1 > /proc/sys/dev/adm6996/port1/enable 2>&1 > /dev/null");
	system("echo 1 > /proc/sys/dev/adm6996/port2/enable 2>&1 > /dev/null");
	system("echo 1 > /proc/sys/dev/adm6996/port3/enable 2>&1 > /dev/null");
	system("echo 1 > /proc/sys/dev/adm6996/port4/enable 2>&1 > /dev/null");

	system("echo 0 > /proc/sys/dev/adm6996/port1/port-prio-enable 2>&1 > /dev/null");
	system("echo 0 > /proc/sys/dev/adm6996/port2/port-prio-enable 2>&1 > /dev/null");
	system("echo 0 > /proc/sys/dev/adm6996/port3/port-prio-enable 2>&1 > /dev/null");
	system("echo 0 > /proc/sys/dev/adm6996/port4/port-prio-enable 2>&1 > /dev/null");

	system("echo 100 > /proc/sys/dev/adm6996/port1/speed 2>&1 > /dev/null");
	system("echo 100 > /proc/sys/dev/adm6996/port2/speed 2>&1 > /dev/null");
	system("echo 100 > /proc/sys/dev/adm6996/port3/speed 2>&1 > /dev/null");
	system("echo 100 > /proc/sys/dev/adm6996/port4/speed 2>&1 > /dev/null");

	system("echo full > /proc/sys/dev/adm6996/port1/bandwidth 2>&1 > /dev/null");
	system("echo full > /proc/sys/dev/adm6996/port2/bandwidth 2>&1 > /dev/null");
	system("echo full > /proc/sys/dev/adm6996/port3/bandwidth 2>&1 > /dev/null");
	system("echo full > /proc/sys/dev/adm6996/port4/bandwidth 2>&1 > /dev/null");

	return 0;
}

int svqos_set_ports(void)
{
	int loop=1;
	char cmd[255] = {0}, nvram_var[32] = {0}, *level;

	svqos_reset_ports();

	for(loop=1;loop<5;loop++)
	{
		snprintf(nvram_var, 31,"svqos_port%dbw", loop);

		if(strcmp("0", nvram_safe_get(nvram_var)))
			snprintf(cmd, 254, "echo %s > /proc/sys/dev/adm6996/port%d/bandwidth 2>&1 > /dev/null", nvram_safe_get(nvram_var), loop);
		else
			snprintf(cmd, 254, "echo 0 > /proc/sys/dev/adm6996/port%d/enable", loop);
		system(cmd);

		snprintf(cmd, 254, "echo 1 > /proc/sys/dev/adm6996/port%d/port-prio-enable 2>&1 > /dev/null", loop);
		system(cmd);

		snprintf(nvram_var,31,"svqos_port%dprio", loop);
		level = nvram_safe_get(nvram_var);
		snprintf(cmd, 254, "echo %d > /proc/sys/dev/adm6996/port%d/port-prio 2>&1 > /dev/null", atoi(level)/10-1, loop);
		system(cmd);
	}

	return 0;
}

int svqos_iptables(void)
{
   char* qos_svcs=nvram_safe_get("svqos_svcs");
   char* qos_ipaddr=nvram_safe_get("svqos_ips");
   char* qos_mac=nvram_safe_get("svqos_macs");
   char  name[32], type[32], data[32], level[32];
   char  cmd[1024];
   char *dev = get_wshaper_dev();


   system("/usr/sbin/iptables -t mangle -F SVQOS_OUT 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -X SVQOS_OUT 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -N SVQOS_OUT 2>&1 > /dev/null");

   system("/usr/sbin/iptables -t mangle -F SVQOS_IN 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -X SVQOS_IN 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -N SVQOS_IN 2>&1 > /dev/null");


   snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -D PREROUTING -i %s -j SVQOS_IN 2>&1 > /dev/null", dev);
   system(cmd);

   snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -I PREROUTING -i %s -j SVQOS_IN 2>&1 > /dev/null", dev);
   system(cmd);

   // enable IMQ device for ingress policing
   snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -D PREROUTING -i %s -j IMQ --todev 0 2>&1 > /dev/null", dev);
   system(cmd);

   snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -I PREROUTING -i %s -j IMQ --todev 0 2>&1 > /dev/null", dev);
   system(cmd);

   snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -D POSTROUTING -o %s -j SVQOS_OUT 2>&1 > /dev/null", dev);
   system(cmd);

   snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -I POSTROUTING -o %s -j SVQOS_OUT 2>&1 > /dev/null", dev);
   system(cmd);

   system("/usr/sbin/iptables -t mangle -A SVQOS_OUT -j CONNMARK --restore-mark 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -A SVQOS_OUT -m mark ! --mark 0 -j RETURN 2>&1 > /dev/null");

   system("/usr/sbin/iptables -t mangle -A SVQOS_IN -j CONNMARK --restore-mark 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -A SVQOS_IN -m mark ! --mark 0 -j RETURN 2>&1 > /dev/null");

   // if OSPF is active put it into the Express bucket for outgoing QoS
   if(nvram_match("wk_mode", "ospf"))
         system("/usr/sbin/iptables -t mangle -A SVQOS_OUT -p ospf -m mark --mark 0 -j MARK --set-mark 20 2>&1 > /dev/null");

   // non-TCP and TCP ACK packets are all 1:10 for ingress policing
   system("/usr/sbin/iptables -t mangle -A SVQOS_IN -p ! tcp -m mark --mark 0 -j MARK --set-mark 10 2>&1 > /dev/null");
   system("/usr/sbin/iptables -t mangle -A SVQOS_IN -m length --length :64 -m mark --mark 0 -j MARK --set-mark 10 2>&1 > /dev/null");


   /* mac format is "mac level | mac level |" ..etc */
   do{
	if (sscanf(qos_mac, "%31s %31s |", data, level) < 2)
		break;

	if(strcmp(dev, "br0")){
		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -D PREROUTING -m mac --mac-source %s -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A PREROUTING -m mac --mac-source %s -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);
	}
	else{
		snprintf(cmd, 1023, "/usr/sbin/ebtables -t nat -D PREROUTING -s %s -j mark --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/ebtables -t nat -A PREROUTING -s %s -j mark --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/ebtables -t nat -D POSTROUTING -d %s -j mark --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/ebtables -t nat -A POSTROUTING -d %s -j mark --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);
	}

   }while((qos_mac=strpbrk(++qos_mac,"|")) && qos_mac++);

   /* ipaddr format is "ipaddr level | ipaddr level |" ..etc */
   do{

   	if (sscanf(qos_ipaddr, "%31s %31s |", data, level) < 2)
		break;

	snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -s %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
	system(cmd);

	snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -d %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
	system(cmd);

	snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_IN -s %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
	system(cmd);

	snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_IN -d %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
	system(cmd);

   }while((qos_ipaddr=strpbrk(++qos_ipaddr,"|")) && qos_ipaddr++);

   /* services format is "name type data level | name type data level |" ..etc */
   do{

   	if (sscanf(qos_svcs, "%31s %31s %31s %31s ", name, type, data, level) < 4)
		break;

	// udp is managed on egress only
	if(strstr(type, "udp") || strstr(type, "both")){
		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -p udp -m udp --dport %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -p udp -m udp --sport %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);
	}

	// tcp and L7 is managed on both ingress and egress
	if(strstr(type, "tcp") || strstr(type, "both")){
		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -p tcp -m tcp --dport %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -p tcp -m tcp --sport %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_IN -p tcp -m tcp --dport %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_IN -p tcp -m tcp --sport %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", data, level);
		system(cmd);
	}

	if(strstr(type, "l7")){
		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -m layer7 --l7proto %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", name, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_IN -m layer7 --l7proto %s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", name, level);
		system(cmd);
	}

	if(strstr(type, "p2p")){

		char* proto=NULL;

		if(!strcasecmp(name, "gnutella"))
			proto="gnu";
		else if(!strcasecmp(name, "bearshare"))
			proto="gnu";
		else if(!strcasecmp(name, "edonkey"))
			proto="edk";
		else if(!strcasecmp(name, "kazaa"))
			proto="kazaa";
		else if(!strcasecmp(name, "directconnect"))
			proto="dc";
		else if(!strcasecmp(name, "bittorrent"))
			proto="bit";
		else if(!strcasecmp(name, "applejuice"))
			proto="apple";
		else if(!strcasecmp(name, "soulseeker"))
			proto="soul";

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_OUT -p tcp -m ipp2p --%s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", proto, level);
		system(cmd);

		snprintf(cmd, 1023, "/usr/sbin/iptables -t mangle -A SVQOS_IN -p tcp -m ipp2p --%s -m mark --mark 0 -j MARK --set-mark %s 2>&1 > /dev/null", proto, level);
		system(cmd);
	}


   }while((qos_svcs=strpbrk(++qos_svcs,"|")) && qos_svcs++);

  // set port priority and port bandwidth
  svqos_set_ports();

  system("/usr/sbin/iptables -t mangle -A SVQOS_OUT -j CONNMARK --save-mark 2>&1 > /dev/null");
  system("/usr/sbin/iptables -t mangle -A SVQOS_OUT -j RETURN 2>&1 > /dev/null");

  system("/usr/sbin/iptables -t mangle -A SVQOS_IN -j CONNMARK --save-mark 2>&1 > /dev/null");
  system("/usr/sbin/iptables -t mangle -A SVQOS_IN -j RETURN 2>&1 > /dev/null");

  return 0;
}

int start_wshaper(void)
{
  int   ret = 0;
  char* dev_val;
  char* dl_val;
  char* ul_val;
  char  ulcalc1_val[32] = "";
  char  ulcalc2_val[32] = "";
  char* nopriohostsrc_val;
  char* nopriohostdst_val;
  char* noprioportsrc_val;
  char* noprioportdst_val;
  int   ulcalc1 = 0;
  int   ulcalc2 = 0;
  char  *mtu_val="1500";

  stop_wshaper();

  if (!nvram_invmatch("wshaper_enable", "0"))
    return 0;

  dev_val = get_wshaper_dev();

  if((dl_val = nvram_safe_get("wshaper_downlink")) == NULL &&
     atoi(dl_val) > 0)
    return 0;

  if((ul_val = nvram_safe_get("wshaper_uplink")) == NULL &&
    atoi(ul_val) > 0)
    return 0;

  nopriohostsrc_val = nvram_safe_get("wshaper_nopriohostsrc");
  nopriohostdst_val = nvram_safe_get("wshaper_nopriohostdst");
  noprioportsrc_val = nvram_safe_get("wshaper_noprioportsrc");
  noprioportdst_val = nvram_safe_get("wshaper_noprioportdst");

  ulcalc1 = 8*atoi(ul_val)/10;
  ulcalc2 = atoi(ul_val)/12;

  sprintf(ulcalc1_val, "%d", ulcalc1);
  sprintf(ulcalc2_val, "%d", ulcalc2);

  if(nvram_match("wshaper_dev", "WAN"))
  	mtu_val = get_mtu_val();
  else
  	mtu_val = "1500";

#ifdef HAVE_WSHAPER
  ret = eval("/usr/sbin/wshaper", dl_val, ul_val, dev_val, ulcalc1_val, ulcalc2_val, nopriohostsrc_val, nopriohostdst_val, noprioportsrc_val, noprioportdst_val);
#elif defined(HAVE_SVQOS)
  svqos_iptables();
  ret = eval("/usr/sbin/svqos", dl_val, ul_val, dev_val, mtu_val);
#endif
  return ret;
}

int stop_wshaper(void)
{
  int ret = 0;

#ifdef HAVE_WSHAPER
  char script_name[] = "/usr/sbin/wshaper";
#elif defined(HAVE_SVQOS)
  char script_name[] = "/usr/sbin/svqos";
#endif

    ret = eval(script_name,"stop", "XX", "br0");
    ret = eval(script_name,"stop", "XX", "vlan1");
    ret = eval(script_name,"stop", "XX", "eth1");
    ret = eval(script_name,"stop", "XX", "ppp0");

    stop_firewall();
    start_firewall();

  return ret;
}
