/*
 * METAOPS - Implements the operations that can be performed performed on 
 *	     individual or lists of data items described by metadata specs
 *
 * Author:
 * Emile van Bergen, emile@evbergen.xs4all.nl
 *
 * Permission to redistribute an original or modified version of this program
 * in source, intermediate or object code form is hereby granted exclusively
 * under the terms of the GNU General Public License, version 2. Please see the
 * file COPYING for details, or refer to http://www.gnu.org/copyleft/gpl.html.
 *
 * History:
 * 2001/03/17 - EvB - Created
 * 2001/05/08 - EvB - Added ord value and temporary flag to META_AV
 * 2001/05/16 - EvB - Added printav / printavlist debugging functions here
 * 2001/06/04 - EvB - Converted META_AV into a double linked list, to ease
 * 		      their use in the VM (adding before / after etc.)
 * 2001/06/25 - EvB - Added meta_avtomsg / meta_msgtoav
 * 2001/09/11 - EvB - Added meta_addav here; used by job_new, chan_handle_read
 *		      and vm_run (we should, at least).
 */


#ifndef __METAOPS_H
#define __METAOPS_H	1


/*
 * INCLUDES & DEFINES
 */


#include <constants.h>
#include <metatype.h>
#include <platform.h>


/* Values for flags in META_AV below. WARNING: Don't ever change the value of
   AV_USEREP, as flags & AV_USEREP is used as index into an array in langvm.c */

#define AV_USEREP	1	/* use attr from reply instead of request */
#define AV_USEREPVALID	2	/* use the userep flag instead of opcode def. */
#define AV_FREE_P	4	/* p must be freed when freeing this object */
#define AV_FIRST	8	/* use first instead of last atr from req/rep */
#define AV_UNRESOLVED	16	/* p and/or l not initialised from i yet */
#define AV_DEL		32	/* treat this item as deleted */


/* Values for flags parameter in meta_avtomsg - see constants.h for descr. */

#define AVMSG_ONESHOT		C_DV_FLAGS_RESV0 	/* send only one item */

#define AVMSG_ASCII		C_DV_FLAGS_ASCII
#define AVMSG_ADDTAB		C_DV_FLAGS_ADDTAB
#define AVMSG_ADDSPACES		C_DV_FLAGS_ADDSPACES
#define AVMSG_ADDTYPE		C_DV_FLAGS_ADDTYPE
#define AVMSG_HEXVALUE		C_DV_FLAGS_HEXVALUE
#define AVMSG_DBLBACKSLASH	C_DV_FLAGS_DBLBACKSLASH
#define AVMSG_NAMEDCONST	C_DV_FLAGS_NAMEDCONST
#define AVMSG_SHORTATTR		C_DV_FLAGS_SHORTATTR
#define AVMSG_ADDIGNORE		C_DV_FLAGS_ADDIGNORE


/*
 * TYPES
 */


typedef struct meta_av {

	struct meta_av *next;	/* Next item */
	struct meta_av *prev;	/* Previous item - not valid after buildtree */
	struct meta_av *sub;	/* 'Sub'-list for use by buildtree and encode */

	META_ITEM *i;		/* Metadata item */
	char *p;		/* Data */
	META_ORD l;		/* Length or, if p == 0, data in host order */ 
	int flags;		/* Flags */

} META_AV;


/*
 * PROTOTYPES
 */


/* Decoding */

META_AV *meta_decode(META *m, META_SPC *s, META_ORD defvnd, 
		     char *blk, META_ORD blksize, META_AV **rettail);

/* Encoding */

void meta_buildtree(META_AV *srclst, META_AV **dstlst, META_SPC *groundspc);

META_ORD meta_encode(META_SPC *s, char *blk, META_ORD blksize, META_AV *avlst,
		     META_ORD *retvnd);


/* From/to ASCII/binary messages */

int meta_ascmsgtoav(META *m, char *buf, ssize_t len,
		    META_AV **head, META_AV **tail,
		    int flags, META_AV *acl);

int meta_binmsgtoav(META *m, U_INT32_T *buf, ssize_t len,
		    META_AV **head, META_AV **tail,
		    int flags, META_AV *acl);

ssize_t meta_avtomsg(META *m, META_AV *avlst, 
		     char *buf, ssize_t buflen, 
		     int flags, META_AV *acl);

/* Misc */

void meta_addav(META_AV **head, META_AV **tail, META_AV *rel, int before,
		META_AV *av);
void meta_remav(META_AV **head, META_AV **tail, META_AV *av);
void meta_freeavdata(META_AV *av);
void meta_freeavlist(META_AV *avlst);

/* Debugging */

void meta_printav(META *m, META_AV *av, int depth);
void meta_printavlist(META *m, META_AV *avlst, int depth);

#endif
