/*********************************************************
 *   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

/*
 * Broadcom Home Gateway Reference Design
 * Web Page Configuration Support Routines
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 * $Id: broadcom.c,v 1.57 2004/02/19 12:28:05 honor Exp $
 */

#ifdef WEBS
#include <webs.h>
#include <uemf.h>
#include <ej.h>
#else /* !WEBS */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <httpd.h>
#include <errno.h>
#endif /* WEBS */

#include <proto/ethernet.h>
#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <sys/klog.h>
#include <sys/wait.h>
#include <cyutils.h>
#include <support.h>
#include <cy_conf.h>
//#ifdef EZC_SUPPORT
#include <ezc.h>
//#endif
#include <broadcom.h>

int gozila_action = 0;
int error_value = 0;
int browser_method ;
int debug_value = 0;


//static char * rfctime(const time_t *timep);
//static char * reltime(unsigned int seconds);

//#if defined(linux)

#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <sys/klog.h>
#include <sys/wait.h>
#define service_restart() kill(1, SIGUSR1)
#define sys_restart() kill(1, SIGHUP)
#define sys_reboot() kill(1, SIGTERM)
#define sys_stats(url) eval("stats", (url))

/* Example:
 * ISDIGIT("", 0); return true;
 * ISDIGIT("", 1); return false;
 * ISDIGIT("123", 1); return true;
 */
int
ISDIGIT(char *value, int flag)
{
	int i, tag = TRUE;


	if(!strcmp(value,"")){
		if (flag) return 0;   // null
		else	return 1;
	}

	for(i=0 ; *(value+i) ; i++){
		if(!isdigit(*(value+i))){
			tag = FALSE;
			break;
		}
	}
	return tag;
}

/* Example:
 * ISASCII("", 0); return true;
 * ISASCII("", 1); return false;
 * ISASCII("abc123", 1); return true;
 */
int
ISASCII(char *value, int flag)
{
	int i, tag = TRUE;

#if COUNTRY == JAPAN
	return tag;	// don't check for japan version
#endif

	if(!strcmp(value,"")){
		if (flag) return 0;   // null
		else	return 1;
	}

	for(i=0 ; *(value+i) ; i++){
		if(!isascii(*(value+i))){
			tag = FALSE;
			break;
		}
	}
	return tag;
}

/* Example:
 * legal_hwaddr("00:11:22:33:44:aB"); return true;
 * legal_hwaddr("00:11:22:33:44:5"); return false;
 * legal_hwaddr("00:11:22:33:44:HH"); return false;
 */
int
legal_hwaddr(char *value)
{
	unsigned int hwaddr[6];
	int tag = TRUE;
	int i,count;

	/* Check for bad, multicast, broadcast, or null address */
	for(i=0,count=0 ; *(value+i) ; i++){
		if(*(value+i) == ':'){
			if((i+1)%3 != 0){
				tag = FALSE;
				break;
			}
			count++;
		}
		else if(isxdigit(*(value+i))) /* one of 0 1 2 3 4 5 6 7 8 9 a b c d e f A B C D E F */
			continue;
		else{
			tag = FALSE;
			break;
		}
	}

	if (!tag || i != 17 || count != 5)		/* must have 17's characters and 5's ':' */
		tag = FALSE;
	else if (sscanf(value, "%x:%x:%x:%x:%x:%x",
		   &hwaddr[0], &hwaddr[1], &hwaddr[2],
		   &hwaddr[3], &hwaddr[4], &hwaddr[5]) != 6 ){
	    //(hwaddr[0] & 1) ||		// the bit 7 is 1
	    //(hwaddr[0] & hwaddr[1] & hwaddr[2] & hwaddr[3] & hwaddr[4] & hwaddr[5]) == 0xff ){ // FF:FF:FF:FF:FF:FF
	    //(hwaddr[0] | hwaddr[1] | hwaddr[2] | hwaddr[3] | hwaddr[4] | hwaddr[5]) == 0x00){ // 00:00:00:00:00:00
		tag = FALSE;
	}
	else
		tag = TRUE;


	return tag;
}

/* Example:
 * 255.255.255.0  (111111111111111111111100000000)  is a legal netmask
 * 255.255.0.255  (111111111111110000000011111111)  is an illegal netmask
 */
int
legal_netmask(char *value)
{
	struct in_addr ipaddr;
	int ip[4]={0,0,0,0};
	int i,j;
	int match0 = -1;
	int match1 = -1;
	int ret, tag;

	ret=sscanf(value,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]);

	if (ret == 4 && inet_aton(value, &ipaddr)) {
		for(i=3;i>=0;i--){
			for(j=1;j<=8;j++){
				if((ip[i] % 2) == 0)   match0 = (3-i)*8 + j;
				else if(((ip[i] % 2) == 1) && match1 == -1)   match1 = (3-i)*8 + j;
				ip[i] = ip[i] / 2;
			}
		}
	}

	if (match0 >= match1)
		tag = FALSE;
	else
		tag = TRUE;


	return tag;
}


/* Example:
 * legal_ipaddr("192.168.1.1"); return true;
 * legal_ipaddr("192.168.1.1111"); return false;
 */
int
legal_ipaddr(char *value)
{
	struct in_addr ipaddr;
	int ip[4];
	int ret, tag;

	ret = sscanf(value,"%d.%d.%d.%d",&ip[0],&ip[1],&ip[2],&ip[3]);

	if (ret != 4 || !inet_aton(value, &ipaddr))
		tag = FALSE;
	else
		tag = TRUE;


	return tag;
}

/* Example:
 * legal_ip_netmask("192.168.1.1","255.255.255.0","192.168.1.100"); return true;
 * legal_ip_netmask("192.168.1.1","255.255.255.0","192.168.2.100"); return false;
 */
int
legal_ip_netmask(char *sip, char *smask, char *dip)
{
	struct in_addr ipaddr, netaddr, netmask;
	int tag;

	inet_aton(nvram_safe_get(sip), &netaddr);
	inet_aton(nvram_safe_get(smask), &netmask);
	inet_aton(dip, &ipaddr);

	netaddr.s_addr &= netmask.s_addr;

	if (netaddr.s_addr != (ipaddr.s_addr & netmask.s_addr))
		tag = FALSE;
	else
		tag = TRUE;

	
	return tag;
}


/* Example:
 * wan_dns = 1.2.3.4 10.20.30.40 15.25.35.45
 * get_dns_ip("wan_dns", 1, 2); produces "20"
 */
int
get_dns_ip(char *name, int which, int count)
{
        static char word[256];
        char *next;
	int ip;

        foreach(word, nvram_safe_get(name), next) {
                if (which-- == 0){
			ip = get_single_ip(word,count);
                	return ip;
                }
        }
        return 0;
}


/* Example:
 * wan_mac = 00:11:22:33:44:55
 * get_single_mac("wan_mac", 1); produces "11"
 */
int
get_single_mac(char *macaddr, int which)
{
	int mac[6]={0,0,0,0,0,0};
	int ret;

	ret = sscanf(macaddr,"%2X:%2X:%2X:%2X:%2X:%2X",&mac[0],&mac[1],&mac[2],&mac[3],&mac[4],&mac[5]);
	return mac[which];	
}


/* Example:
 * lan_ipaddr_0 = 192
 * lan_ipaddr_1 = 168
 * lan_ipaddr_2 = 1
 * lan_ipaddr_3 = 1
 * get_merge_ipaddr("lan_ipaddr", ipaddr); produces ipaddr="192.168.1.1"
 */
int
get_merge_ipaddr(char *name, char *ipaddr)
{
	char ipname[30];
	int i;
	
	strcpy(ipaddr,"");	

	for(i=0 ; i<4 ; i++){
		snprintf(ipname,sizeof(ipname),"%s_%d",name,i);
		strcat(ipaddr, websGetVar(wp, ipname , "0"));
		if(i<3)	strcat(ipaddr, ".");
	}

	return 1;

}


/* Example:
 * wan_mac_0 = 00
 * wan_mac_1 = 11
 * wan_mac_2 = 22
 * wan_mac_3 = 33
 * wan_mac_4 = 44
 * wan_mac_5 = 55
 * get_merge_mac("wan_mac",mac); produces mac="00:11:22:33:44:55"
 */
int 
get_merge_mac(char *name, char *macaddr)
{
	char macname[30];
	char *mac;
	int i;

	strcpy(macaddr,"");

	for(i=0 ; i<6 ; i++){
		snprintf(macname,sizeof(macname),"%s_%d",name,i);
		mac = websGetVar(wp, macname , "00");
		if(strlen(mac) == 1)	strcat(macaddr,"0");
		strcat(macaddr,mac);
		if(i<5)	strcat(macaddr,":");
	}

	return 1;

}

struct onload onloads[] = {
	//{ "Filters", filter_onload },
	{ "WL_ActiveTable", wl_active_onload },
	{ "MACClone", macclone_onload },
	{ "FilterSummary", filtersummary_onload },
	{ "Ping", ping_onload },
	{ "Traceroute", traceroute_onload },
};

int
ej_onload(int eid, webs_t wp, int argc, char_t **argv)
{
	char *type, *arg;
	int ret = 0;
	struct onload *v;

        if (ejArgs(argc, argv, "%s %s", &type, &arg) < 2) {
             websError(wp, 400, "Insufficient args\n");
             return -1;
        }

	for(v = onloads ; v < &onloads[STRUCT_LEN(onloads)] ; v++) {
   		if(!strcmp(v->name,type)){
      			ret = v->go(wp, arg);
			return ret;
		}
   	}

        return ret;
}

/* Meta tag command that will no allow page cached by browsers.
 * The will force the page to be refreshed when visited.
 */
int
ej_no_cache(int eid, webs_t wp, int argc, char_t **argv)
{
	int ret;

	ret = websWrite(wp,"<meta http-equiv=\"expires\" content=\"0\">\n");
	ret += websWrite(wp,"<meta http-equiv=\"cache-control\" content=\"no-cache\">\n");
	ret += websWrite(wp,"<meta http-equiv=\"pragma\" content=\"no-cache\">\n");
//	ret += websWrite(wp,"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">", HTTP_CHARSET);
 

	return ret;
}
	

/*
 * Example: 
 * lan_ipaddr=192.168.1.1
 * <% prefix_ip_get("lan_ipaddr",1); %> produces "192.168.1."
 */
int
ej_prefix_ip_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name;
	int type;
	int ret = 0;

        if (ejArgs(argc, argv, "%s %d", &name,&type) < 2) {
                websError(wp, 400, "Insufficient args\n");
                return -1;
        }

	
	if(type == 1)
		ret = websWrite(wp,"%d.%d.%d.",get_single_ip(nvram_safe_get("lan_ipaddr"),0),
					       get_single_ip(nvram_safe_get("lan_ipaddr"),1),
					       get_single_ip(nvram_safe_get("lan_ipaddr"),2));

	return ret;
}

/* Deal with side effects before committing */
int
sys_commit(void)
{
	//if (nvram_match("wan_proto", "pppoe") || nvram_match("wan_proto", "pptp") )
	//	nvram_set("wan_ifname", "ppp0");
	//else
	//	nvram_set("wan_ifname", nvram_get("pppoe_ifname"));
	return nvram_commit();
}


char *
rfctime(const time_t *timep)
{
	static char s[201];
	struct tm tm;

	setenv("TZ", nvram_safe_get("time_zone"), 1);
	memcpy(&tm, localtime(timep), sizeof(struct tm));
	//strftime(s, 200, "%a, %d %b %Y %H:%M:%S %z", &tm);
	strftime(s, 200, "%a, %d %b %Y %H:%M:%S", &tm);  // spec for linksys
	return s;
}

static char *
reltime(unsigned int seconds)
{
	static char s[] = "XXXXX days, XX hours, XX minutes, XX seconds";
	char *c = s;

	if (seconds > 60*60*24) {
		c += sprintf(c, "%d days, ", seconds / (60*60*24));
		seconds %= 60*60*24;
	}
	if (seconds > 60*60) {
		c += sprintf(c, "%d hours, ", seconds / (60*60));
		seconds %= 60*60;
	}
	if (seconds > 60) {
		c += sprintf(c, "%d minutes, ", seconds / 60);
		seconds %= 60;
	}
	c += sprintf(c, "%d seconds", seconds);

	return s;
}

/*
 * Example: 
 * lan_ipaddr = 192.168.1.1
 * <% nvram_get("lan_ipaddr"); %> produces "192.168.1.1"
 */
static int
ej_nvram_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *c;
	int ret = 0;

	if (ejArgs(argc, argv, "%s", &name) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

#if COUNTRY == JAPAN
	ret = websWrite(wp, "%s",nvram_safe_get(name));
#else
	for (c = nvram_safe_get(name); *c; c++) {
		if (isprint((int) *c) ) // &&
//		    *c != '"' && *c != '&' && *c != '<' && *c != '>')
 			ret += websWrite(wp, "%c", *c);
		else{
		    if(*c == '"')
		      ret += websWrite(wp, "&quot;");
		    else if(*c == '&')
		      ret += websWrite(wp, "&amp;");
		    else if(*c == '<')
		      ret += websWrite(wp, "&lt;");
		    else if(*c == '>')
		      ret += websWrite(wp, "&gt;");
		    else if(*c == 13)
		      continue;
		    else
		      ret += websWrite(wp, "&#%d", *c);
		}
	}
#endif
	return ret;
}

/*
 * Example: 
 * lan_ipaddr = 192.168.1.1, gozila_action = 0
 * <% nvram_selget("lan_ipaddr"); %> produces "192.168.1.1"
 * lan_ipaddr = 192.168.1.1, gozila_action = 1, websGetVar(wp, "lan_proto", NULL) = 192.168.1.2;
 * <% nvram_selget("lan_ipaddr"); %> produces "192.168.1.2"
 */
static int
ej_nvram_selget(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *c;
	int ret = 0;

	if (ejArgs(argc, argv, "%s", &name) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	if(gozila_action){
		char *buf = websGetVar(wp, name, NULL);
		if(buf)
			return websWrite(wp, "%s", buf);
	}

	for (c = nvram_safe_get(name); *c; c++) {
		if (isprint((int) *c) &&
		    *c != '"' && *c != '&' && *c != '<' && *c != '>')
			ret += websWrite(wp, "%c", *c);
		else
			ret += websWrite(wp, "&#%d", *c);
	}

	return ret;
}

/*
 * Example: 
 * wan_mac = 00:11:22:33:44:55
 * <% nvram_mac_get("wan_mac"); %> produces "00-11-22-33-44-55"
 */
static int
ej_nvram_mac_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *c;
	int ret = 0;
	char *mac;
	int i;

	if (ejArgs(argc, argv, "%s", &name) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	c = nvram_safe_get(name);

	if(c){
		mac = strdup(c);
		for(i=0 ; *(mac+i) ; i++){
			if(*(mac+i) == ':')	*(mac+i) = '-';
		}
		ret = websWrite(wp, "%s",mac );
	}

	return ret;

}

/*
 * Example: 
 * wan_proto = dhcp; gozilla = 0;
 * <% nvram_gozila_get("wan_proto"); %> produces "dhcp"
 *
 * wan_proto = dhcp; gozilla = 1; websGetVar(wp, "wan_proto", NULL) = static;
 * <% nvram_gozila_get("wan_proto"); %> produces "static"
 */
static int
ej_nvram_gozila_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *type;

	if (ejArgs(argc, argv, "%s", &name) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	type = GOZILA_GET(name);

	return websWrite(wp, "%s", type);
}

static int
ej_webs_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *value;
	int ret = 0;

	if (ejArgs(argc, argv, "%s", &name) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	value = websGetVar(wp, name, NULL);

	if(value)
		ret = websWrite(wp, "%s", value);

	return ret;
}

/*
 * Example: 
 * lan_ipaddr = 192.168.1.1
 * <% get_single_ip("lan_ipaddr","1"); %> produces "168"
 */
static int
ej_get_single_ip(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *c;
	int ret = 0;
	int which;

	if (ejArgs(argc, argv, "%s %d", &name, &which) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	c = nvram_safe_get(name);
	if(c){
		if(!strcmp(c, PPP_PSEUDO_IP) || !strcmp(c, PPP_PSEUDO_GW))
			c = "0.0.0.0";
		else if (!strcmp(c, PPP_PSEUDO_NM))
			c = "255.255.255.0";

		ret += websWrite(wp, "%d", get_single_ip(c,which));
	}
	else
		ret += websWrite(wp, "0");

	return ret;
}

/*
 * Example: 
 * wan_mac = 00:11:22:33:44:55
 * <% get_single_mac("wan_mac","1"); %> produces "11"
 */
static int
ej_get_single_mac(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *c;
	int ret = 0;
	int which;
	int mac;

	if (ejArgs(argc, argv, "%s %d", &name, &which) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	c = nvram_safe_get(name);
	if(c){
		mac = get_single_mac(c,which);
		ret += websWrite(wp, "%02X", mac);
	}
	else
		ret += websWrite(wp, "00");

	return ret;
}

/*
 * Example: 
 * wan_proto = dhcp; gozilla = 0;
 * <% nvram_selmatch("wan_proto", "dhcp", "selected"); %> produces "selected"
 *
 * wan_proto = dhcp; gozilla = 1; websGetVar(wp, "wan_proto", NULL) = static;
 * <% nvram_selmatch("wan_proto", "static", "selected"); %> produces "selected"
 */
int
ej_nvram_selmatch(int eid, webs_t wp, int argc, char_t **argv)
{
        char *name, *match, *output;
        char *type;

        if (ejArgs(argc, argv, "%s %s %s", &name, &match, &output) < 3) {
                websError(wp, 400, "Insufficient args\n");
                return -1;
        }

        type = GOZILA_GET(name);

        if (!type){
           if (nvram_match(name, match)){
                return websWrite(wp, output);
           }
        }
        else{
           if(!strcmp(type, match)){
                return websWrite(wp, output);
           }
        }

        return 0;
}       

int
ej_nvram_else_selmatch(int eid, webs_t wp, int argc, char_t **argv)
{
        char *name, *match, *output1, *output2;
        char *type;

        if (ejArgs(argc, argv, "%s %s %s %s", &name, &match, &output1, &output2) < 4) {
                websError(wp, 400, "Insufficient args\n");
                return -1;
        }

        type = GOZILA_GET(name);
        
        if (!type){
           if (nvram_match(name, match)){
                return websWrite(wp, output1);
           }
	   else
                return websWrite(wp, output2);
        }
        else{
           if(!strcmp(type, match)){
                return websWrite(wp, output1);
           }
	   else
                return websWrite(wp, output2);
        }

        return 0;
}       

/*
 * Example: 
 * wan_proto=dhcp
 * <% nvram_else_match("wan_proto", "dhcp", "0","1"); %> produces "0"
 * <% nvram_else_match("wan_proto", "static", "0","1"); %> produces "1"
 */
static int
ej_nvram_else_match(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *match, *output1, *output2;

	if (ejArgs(argc, argv, "%s %s %s %s", &name, &match, &output1, &output2) < 4) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if (nvram_match(name, match))
		return websWrite(wp, output1);
	else
		return websWrite(wp, output2);

	return 0;
}	

/*
 * Example:
 * wan_proto=dhcp
 * <% nvram_match("wan_proto", "dhcp", "selected"); %> produces "selected"
 * <% nvram_match("wan_proto", "static", "selected"); %> does not produce
 */
static int
ej_nvram_match(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *match, *output;

	if (ejArgs(argc, argv, "%s %s %s", &name, &match, &output) < 3) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if (nvram_match(name, match))
		return websWrite(wp, output);

	return 0;
}	

/*
 * Example: 
 * wan_proto=dhcp
 * <% nvram_invmatch("wan_proto", "dhcp", "disabled"); %> does not produce
 * <% nvram_invmatch("wan_proto", "static", "disabled"); %> produces "disabled"
 */
static int
ej_nvram_invmatch(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *invmatch, *output;

	if (ejArgs(argc, argv, "%s %s %s", &name, &invmatch, &output) < 3) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if (nvram_invmatch(name, invmatch))
		return websWrite(wp, output);

	return 0;
}	

/*
 * Example: 
 * HEARTBEAT_SUPPORT = 1
 * <% support_match("HEARTBEAT_SUPPORT", "0", "selected"); %> does not produce
 * <% support_match("HEARTBEAT_SUPPORT", "1", "selected"); %> produces "selected"
 */
static int
ej_support_match(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *value, *output;
	struct support_list *v;

	if (ejArgs(argc, argv, "%s %s %s", &name, &value, &output) < 3) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if(!strcmp(name, "WL_STA_SUPPORT") ||
	   !strcmp(name, "BACKUP_RESTORE_SUPPORT") ||
	   !strcmp(name, "SYSLOG_SUPPORT"))	return 1;
	
	for(v = supports ; v < &supports[SUPPORT_COUNT] ; v++) {
   		if(!strcmp(v->supp_name, name) && !strcmp(v->supp_value, value)){
			return websWrite(wp, output);
		}
   	}
	
	return 1;	
}	


/*
 * Example: 
 * HEARTBEAT_SUPPORT = 1
 * <% support_invmatch("HEARTBEAT_SUPPORT", "1", "<!--"); %> does not produce
 * HEARTBEAT_SUPPORT = 0
 * <% support_invmatch("HEARTBEAT_SUPPORT", "1", "-->"); %> produces "-->"
 */
static int
ej_support_invmatch(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *value, *output;
	struct support_list *v;

	if (ejArgs(argc, argv, "%s %s %s", &name, &value, &output) < 3) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	
	if(!strcmp(name, "WL_STA_SUPPORT") ||
	   !strcmp(name, "BACKUP_RESTORE_SUPPORT") ||
	   !strcmp(name, "SYSLOG_SUPPORT"))
		return websWrite(wp, output);

	for(v = supports ; v < &supports[SUPPORT_COUNT] ; v++) {
   		if(!strcmp(v->supp_name, name)){
			if (strcmp(v->supp_value, value)){
				return websWrite(wp, output);
			}
			else
				return 1;
		}
   	}
	
	return websWrite(wp, output);
}

/*
 * Example: 
 * HEARTBEAT_SUPPORT = 1
 * <% support_elsematch("HEARTBEAT_SUPPORT", "1", "black", "red"); %> procude "black"
 */
static int
ej_support_elsematch(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *value, *output1, *output2;
	struct support_list *v;

	if (ejArgs(argc, argv, "%s %s %s %s", &name, &value, &output1, &output2) < 3) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if(!strcmp(name, "WL_STA_SUPPORT") ||
	   !strcmp(name, "BACKUP_RESTORE_SUPPORT") ||
	   !strcmp(name, "SYSLOG_SUPPORT"))
		return websWrite(wp, output2);
	
	for(v = supports ; v < &supports[SUPPORT_COUNT] ; v++) {
   		if(!strcmp(v->supp_name, name) && !strcmp(v->supp_value, value)){
			return websWrite(wp, output1);
		}
   	}
	
	return websWrite(wp, output2);	
}	

static int
ej_scroll(int eid, webs_t wp, int argc, char_t **argv)
{
	char *type;
	int y;

	if (ejArgs(argc, argv, "%s %d", &type, &y) < 2) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
	if(gozila_action)
		websWrite(wp, "%d", y);
	else
		websWrite(wp, "0");
		
	return 0;
}
/*
 * Example: 
 * filter_mac=00:12:34:56:78:00 00:87:65:43:21:00
 * <% nvram_list("filter_mac", 1); %> produces "00:87:65:43:21:00"
 * <% nvram_list("filter_mac", 100); %> produces ""
 */
static int
ej_nvram_list(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name;
	int which;
	char word[256], *next;
	int ret = 0;

	if (ejArgs(argc, argv, "%s %d", &name, &which) < 2) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	foreach(word, nvram_safe_get(name), next) {
		if (which-- == 0)
			ret += websWrite(wp, word);
	}

	return ret;
}

/* Example: 
 * wan_dns = 168.95.1.1 210.66.161.125 168.95.192.1
 * <% get_dns_ip("wan_dns", "1", "2"); %> produces "161"
 * <% get_dns_ip("wan_dns", "2", "3"); %> produces "1"
 */
int
ej_get_dns_ip(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name;
	int count, which;
	char word[256], *next;

	if (ejArgs(argc, argv, "%s %d %d", &name, &which, &count) < 3) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	foreach(word, nvram_safe_get(name), next) {
		if (which-- == 0)
			return websWrite(wp, "%d", get_single_ip(word,count));
	}

	return websWrite(wp, "0");	// not find
}


static unsigned long
inet_atoul(char *cp)
{
	struct in_addr in;

	(void) inet_aton(cp, &in);
	return in.s_addr;
}

int
valid_wep_key(webs_t wp, char *value, struct variable *v)
{
	int i;

	switch(strlen(value)){
		case 5:
		case 13: 
			for(i=0 ; *(value+i) ; i++){
                                if(isascii(*(value+i))){ 
                                        continue;
                                }
                                else{ 
                                        websDebugWrite(wp, "Invalid <b>%s</b> %s: must be ascii code<br>",
                                            v->longname, value);
                                        return FALSE;
                                }
                         }
			break;
		case 10:
		case 26:
			for(i=0 ; *(value+i) ; i++){
		                if(isxdigit(*(value+i))){ /* one of 0 1 2 3 4 5 6 7 8 9 a b c d e f A B C D E F */
                		        continue;
          		        }
         		        else{   
                    		        websDebugWrite(wp, "Invalid <b>%s</b> %s: must be hexadecimal digits<br>",
                              		    v->longname, value);
                     			return FALSE;
               			}
       			 }
			 break;

		default: websDebugWrite(wp, "Invalid <b>%s</b>: must be 5 or 13 ASCII characters or 10 or 26 hexadecimal digits<br>", v->longname); return FALSE;

	}

/*
	for(i=0 ; *(value+i) ; i++){
		if(isxdigit(*(value+i))){ 
			continue;
		}
		else{
			websDebugWrite(wp, "Invalid <b>%s</b> %s: must be hexadecimal digits<br>",
				  v->longname, value);
			return FALSE;
		}
	}

	if (i != length) {
		websDebugWrite(wp, "Invalid <b>%s</b> %s: must be %d characters<br>",
			  v->longname, value,length);
		return FALSE;
	}
*/
	return TRUE;
}

int
validate_statics(webs_t wp, char *value, struct variable *v)
{

	if(!sv_valid_statics(value)){
		websDebugWrite(wp, "Invalid <b>%s</b> %s: not a legal statics entry<br>",
			  v->longname, value);
		return FALSE;
	}

	nvram_set(v->name, value);

	return TRUE;

}

int
valid_netmask(webs_t wp, char *value, struct variable *v)
{

	if(!legal_netmask(value)){
		websDebugWrite(wp, "Invalid <b>%s</b> %s: not a legal netmask<br>",
			  v->longname, value);
		return FALSE;
	}

	return TRUE;

}

static void
validate_netmask(webs_t wp, char *value, struct variable *v)
{
	if (valid_netmask(wp, value, v))
		nvram_set(v->name, value);
}

static void
validate_merge_netmask(webs_t wp, char *value, struct variable *v)
{
	char *netmask, maskname[30];
	char *mask;
	int i;

	netmask = malloc(20);
	strcpy(netmask,"");
	for(i=0 ; i<4 ; i++){
		snprintf(maskname,sizeof(maskname),"%s_%d",v->name,i);
		mask = websGetVar(wp, maskname , NULL);
		if(mask){
			strcat(netmask,mask);
			if(i<3)	strcat(netmask,".");
		}
		else
			return ;
	}


	if(valid_netmask(wp, netmask, v))
		nvram_set(v->name, netmask);

	if(netmask)	free(netmask);
}

//Added by Daniel(2004-07-29) for EZC
char webs_buf[5000];
int webs_buf_offset=0;

static void
validate_list(webs_t wp, char *value, struct variable *v,
	      int (*valid)(webs_t, char *, struct variable *))
{
	int n, i;
	char name[100];
	char buf[1000] = "", *cur = buf;

	n = atoi(value);

	for (i = 0; i < n; i++) {
		snprintf(name, sizeof(name), "%s%d", v->name, i);
		if (!(value = websGetVar(wp, name, NULL)))
			return;
		if (!*value && v->nullok)
			continue;
		if (!valid(wp, value, v))
			continue;
		cur += snprintf(cur, buf + sizeof(buf) - cur, "%s%s",
			cur == buf ? "" : " ", value);
	}
	nvram_set(v->name, buf);

}	

int
valid_ipaddr(webs_t wp, char *value, struct variable *v)
{
	struct in_addr netaddr, netmask;
	
	if (!legal_ipaddr(value)) {
		websDebugWrite(wp, "Invalid <b>%s</b> %s: not an IP address<br>",
			  v->longname, value);
		return FALSE;
	}

	if (v->argv) {
		if(!strcmp(v->argv[0],"lan")){
			if(*(value+strlen(value)-2)=='.' && *(value+strlen(value)-1)=='0'){
				websDebugWrite(wp, "Invalid <b>%s</b> %s: not an IP address<br>",
			 		 v->longname, value);
				return FALSE;
			}
		}
		
		else if(!legal_ip_netmask(v->argv[0],v->argv[1],value)){
			(void) inet_aton(nvram_safe_get(v->argv[0]), &netaddr);
			(void) inet_aton(nvram_safe_get(v->argv[1]), &netmask);
			websDebugWrite(wp, "Invalid <b>%s</b> %s: not in the %s/",
				  v->longname, value, inet_ntoa(netaddr));
			websDebugWrite(wp, "%s network<br>", inet_ntoa(netmask));
			return FALSE;
		}
	}

	return TRUE;
}

static void
validate_ipaddr(webs_t wp, char *value, struct variable *v)
{
	if (valid_ipaddr(wp, value, v))
		nvram_set(v->name, value);
}

static void
validate_ipaddrs(webs_t wp, char *value, struct variable *v)
{
	validate_list(wp, value, v, valid_ipaddr);
}

int
valid_merge_ip_4(webs_t wp, char *value, struct variable *v)
{
	char *ipaddr;

	if(atoi(value) == 255){
			websDebugWrite(wp, "Invalid <b>%s</b> %s: out of range 0 - 254 <br>",
				  v->longname, value);
			return FALSE;
	}

	ipaddr = malloc(20);
	sprintf(ipaddr,"%d.%d.%d.%s",get_single_ip(nvram_safe_get("lan_ipaddr"),0),
				     get_single_ip(nvram_safe_get("lan_ipaddr"),1),
				     get_single_ip(nvram_safe_get("lan_ipaddr"),2),
				     value);

	if (!valid_ipaddr(wp, ipaddr, v)){
		free(ipaddr);
		return FALSE;
	}
	
	if(ipaddr) free(ipaddr);
	
	return TRUE;
}

static void
validate_merge_ip_4(webs_t wp, char *value, struct variable *v)
{
	if(!strcmp(value,"")){
		nvram_set(v->name, "0");
		return ;
	}	

	if(valid_merge_ip_4(wp, value, v))
		nvram_set(v->name, value);
}

static void
validate_merge_ipaddrs(webs_t wp, char *value, struct variable *v)
{
	char ipaddr[20];

	get_merge_ipaddr(v->name, ipaddr);

	if(valid_ipaddr(wp, ipaddr, v))
		nvram_set(v->name, ipaddr);
}

static void
validate_merge_mac(webs_t wp, char *value, struct variable *v)
{
	char macaddr[20];

	get_merge_mac(v->name, macaddr);

	if(valid_hwaddr(wp, macaddr, v))
		nvram_set(v->name, macaddr);

}

static void
validate_dns(webs_t wp, char *value, struct variable *v)
{
	char buf[100] = "", *cur = buf;
	char ipaddr[20], ipname[30];
	char *ip;
	int i, j;

	for(j=0; j<3 ; j++){
		strcpy(ipaddr,"");
		for(i=0 ; i<4 ; i++){
			snprintf(ipname,sizeof(ipname),"%s%d_%d",v->name,j,i);
			ip = websGetVar(wp, ipname , NULL);
			if(ip){
				strcat(ipaddr,ip);
				if(i<3)	strcat(ipaddr,".");
			}
			else
				return ;
		}

		if(!strcmp(ipaddr,"0.0.0.0"))
			continue;
		if(!valid_ipaddr(wp, ipaddr, v))
			continue;
		cur += snprintf(cur, buf + sizeof(buf) - cur, "%s%s",
				cur == buf ? "" : " ", ipaddr);
	}
	nvram_set(v->name, buf);

	dns_to_resolv();
}

int
valid_choice(webs_t wp, char *value, struct variable *v)
{
	char **choice;

	for (choice = v->argv; *choice; choice++) {
		if (!strcmp(value, *choice))
			return TRUE;
	}

	websDebugWrite(wp, "Invalid <b>%s</b> %s: not one of ", v->longname, value);
	for (choice = v->argv; *choice; choice++)
		websDebugWrite(wp, "%s%s", choice == v->argv ? "" : "/", *choice);
	websDebugWrite(wp, "<br>");
	return FALSE;
}

static void
validate_choice(webs_t wp, char *value, struct variable *v)
{
	if (valid_choice(wp, value, v))
		nvram_set(v->name, value);
}

int
valid_range(webs_t wp, char *value, struct variable *v)
{
	int n, start, end;

	n = atoi(value);
	start = atoi(v->argv[0]);
	end = atoi(v->argv[1]);


	if (!ISDIGIT(value,1) || n < start || n > end) {
		websDebugWrite(wp, "Invalid <b>%s</b> %s: out of range %d-%d<br>",
			  v->longname, value, start, end);
		return FALSE;
	}

	return TRUE;
}

static void
validate_range(webs_t wp, char *value, struct variable *v)
{
	char buf[20];
	int range;
	if (valid_range(wp, value, v)){
		range = atoi(value);
		snprintf(buf, sizeof(buf),"%d", range);
		nvram_set(v->name, buf);
	}
}

int
valid_name(webs_t wp, char *value, struct variable *v)
{
	int n, max;

	n = atoi(value);
	max = atoi(v->argv[0]);


	if (!ISASCII(value,1)){
		websDebugWrite(wp, "Invalid <b>%s</b> %s: NULL or have illegal characters<br>",
			  v->longname, value);
		return FALSE;
	}
	if (strlen(value) > max) {
		websDebugWrite(wp, "Invalid <b>%s</b> %s: out of range 1-%d characters<br>",
			  v->longname, value,max);
		return FALSE;
	}

	return TRUE;
}

static void
validate_name(webs_t wp, char *value, struct variable *v)
{
	if (valid_name(wp, value, v))
	    nvram_set(v->name, value);
}

/* the html always show "d6nw5v1x2pc7st9m"
 * so we must filter it.
 */
static void
validate_password(webs_t wp, char *value, struct variable *v)
{
	if (strcmp(value, TMP_PASSWD) && valid_name(wp, value, v))
	{
		nvram_set(v->name, value);
		// Sveasoft add - remake passwd file
		system("/sbin/setpasswd");
	}	
}


int
valid_hwaddr(webs_t wp, char *value, struct variable *v)
{
	/* Make exception for "NOT IMPLELEMENTED" string */
	if (!strcmp(value,"NOT_IMPLEMENTED")) 
		return(TRUE);

	/* Check for bad, multicast, broadcast, or null address */
	if (!legal_hwaddr(value)){
		websDebugWrite(wp, "Invalid <b>%s</b> %s: not a legal MAC address<br>",
			  v->longname, value);
		return FALSE;
	}

	return TRUE;
}

static void
validate_hwaddr(webs_t wp, char *value, struct variable *v)
{
	if (valid_hwaddr(wp, value, v))
		nvram_set(v->name, value);
}

static void
validate_hwaddrs(webs_t wp, char *value, struct variable *v)
{
	validate_list(wp, value, v, valid_hwaddr);
}

int
ej_get_http_prefix(int eid, webs_t wp, int argc, char_t **argv)
{
	int ret = 0;
	char http[10];
	char ipaddr[20];
	char port[10];

	char *http_enable = websGetVar(wp, "http_enable", NULL);
	char *https_enable = websGetVar(wp, "https_enable", NULL);

	if(do_ssl && !http_enable && !https_enable) {
			strcpy(http, "https");
	}
	else if(do_ssl && http_enable && https_enable) {
		if(atoi(https_enable) && atoi(http_enable))
			strcpy(http, "https");
		else if(atoi(https_enable) && !atoi(http_enable))
			strcpy(http, "https");
		else	// !atoi(https_enable) && atoi(http_enable)
			strcpy(http, "http");
	}
	else if(do_ssl && !http_enable && !https_enable) {
			strcpy(http, "http");
	}
	else if(!do_ssl && http_enable && https_enable) {
		if(atoi(https_enable) && atoi(http_enable))
			strcpy(http, "http");
		else if(atoi(https_enable) && !atoi(http_enable))
			strcpy(http, "https");
		else	// !atoi(https_enable) && atoi(http_enable)
			strcpy(http, "http");
	}	
	else
		strcpy(http, "http");

	if(browser_method == USE_LAN) { // Use LAN to browser
		if(nvram_match("restore_defaults", "1") || nvram_match("sv_restore_defaults", "1")){
			strcpy(ipaddr, "192.168.1.1");	// Deafult IP
			strcpy(http, "http");
		}			
		else
			strcpy(ipaddr, nvram_safe_get("lan_ipaddr"));
		strcpy(port, "");
	}
	else {

		if (nvram_match("wan_proto", "pptp"))
		    strcpy(ipaddr, nvram_safe_get("pptp_get_ip"));
		else if (nvram_match("wan_proto", "l2tp"))
		    strcpy(ipaddr, nvram_safe_get("l2tp_get_ip"));
		else
		strcpy(ipaddr, nvram_safe_get("wan_ipaddr"));
							    		
		sprintf(port, ":%s", nvram_safe_get("http_wanport"));
	}


	ret = websWrite(wp, "%s://%s%s/", http, ipaddr, port);

	return ret;
}

int ej_get_mtu(int eid, webs_t wp, int argc, char_t **argv)
{
	int ret;
	struct mtu_lists *mtu_list;
	char *type;
	char *proto = GOZILA_GET("wan_proto");

	if (ejArgs(argc, argv, "%s", &type) < 1) {
                websError(wp, 400, "Insufficient args\n");
                return -1;
        }

	mtu_list = get_mtu(proto);

	if(!strcmp(type, "min"))
		ret = websWrite(wp, "%s", mtu_list->min);
	else if(!strcmp(type, "max"))
		ret = websWrite(wp, "%s", mtu_list->max);

	return ret;
}

/* 
 * Variables are set in order (put dependent variables later). Set
 * nullok to TRUE to ignore zero-length values of the variable itself.
 * For more complicated validation that cannot be done in one pass or
 * depends on additional form components or can throw an error in a
 * unique painful way, write your own validation routine and assign it
 * to a hidden variable (e.g. filter_ip).
 */
/*
DD-WRT enhancement by seg
This functions parses all /etc/config/xxxxx.nvramconfig files and creates the 
web var tab. so these vars arent defined anymore staticly
*/

#include <stdlib.h>
#include <malloc.h>
#include <dirent.h>
#include <stdlib.h>


int endswith(char *str, char *cmp)
{
	int cmp_len, str_len, i;
	cmp_len = strlen(cmp);
	str_len = strlen(str);
	if (cmp_len > str_len)
		return (0);
	for (i = 0;i < cmp_len;i++)
	{
		if (str[(str_len-1) - i] != cmp[(cmp_len-1) - i])
			return (0);
	}
	return (1);
}

char *toUP(char *a)
{
int i;
for (i=0;i<strlen(a);i++)
   {
   if (a[i]>'a'-1 && a[i] <'z'+1)a[i]-='a'+'A';
   }
return a;
}

int stricmp(char *a,char *b)
{
if (strlen(a)!=strlen(b))
    return -1;
return strcmp(toUP(a),toUP(b));
}
void StringStart(FILE *in) 
{ 
while(getc(in)!='"')
    {
    if (feof(in))return;
    }
}
 
char *getFileString(FILE *in) 
{ 
char *buf; 
int i,b; 
buf = malloc(1024);
StringStart(in); 
for (i=0;i<1024;i++)   
    {   
    b = getc(in);   
    if (b==EOF)return NULL;   
    if (b=='"')      
	{      
	buf[i]=0;     
	buf=realloc(buf,strlen(buf)+1);
	return buf;
	}   
    buf[i]=b;   
    }
return buf; 
}
struct variable **variables; 
void Initnvramtab() 
{ 
struct dirent *entry;
DIR *directory; 
FILE *in; 
int varcount=0,len,i;
unsigned char *buf; 
unsigned char *tmpstr; 
struct variable *tmp; 
variables=NULL;
buf=malloc(1024); 
// format = VARNAME VARDESC VARVALID VARVALIDARGS FLAGS FLAGS 
//open config directory directory =
directory = opendir("/etc/config"); 
if (directory==NULL)
    return;
//list all files in this directory 
while ((entry=readdir(directory))!=NULL)  
    {  
    if(endswith(entry->d_name,".nvramconfig"))     
	{    
	sprintf(buf,"/etc/config/%s",entry->d_name);     
	in=fopen(buf,"rb");    
	if (in==NULL)return;
	while(1)
	    {
	    tmp = (struct variable*)malloc(sizeof(struct variable));   
	    tmp->name = getFileString(in);
	    tmp->validate = NULL;    
	    if (tmp->name==NULL)
		break;
	    tmp->longname = getFileString(in);     
	    tmpstr = getFileString(in);    
	    tmp->argv = NULL;
	    if (!stricmp(tmpstr,"RANGE")) 	
	    { 	
	    tmp->validate = validate_range; 
	    tmp->argv = (char **)malloc(sizeof(char**)*3); 	
	    tmp->argv[0] = getFileString(in);
	    tmp->argv[1] = getFileString(in); 	
	    tmp->argv[2] = NULL;
	    }	
	    if (!stricmp(tmpstr,"CHOICE")) 	
	    { 	
	    tmp->validate = validate_choice; 
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    if (!stricmp(tmpstr,"NAME")) 	
	    { 	
	    tmp->validate = validate_name; 
	    tmp->argv = (char **)malloc(sizeof(char**)*2); 	
	    tmp->argv[0] = getFileString(in);
	    tmp->argv[1] = NULL;
	    }
	    if (!stricmp(tmpstr,"NULL")) 	
	    { 	
	    tmp->validate = NULL; 
	    }
	    if (!stricmp(tmpstr,"PASSWORD")) 	
	    { 	
	    tmp->validate = validate_password; 
	    tmp->argv = (char **)malloc(sizeof(char**)*2); 	
	    tmp->argv[0] = getFileString(in);
	    tmp->argv[1] = NULL;
	    }
	    if (!stricmp(tmpstr,"LANIPADDR")) 	
	    { 	
	    tmp->validate = validate_lan_ipaddr; 
	    tmp->argv = (char **)malloc(sizeof(char**)*2); 	
	    tmp->argv[0] = getFileString(in);
	    tmp->argv[1] = NULL;
	    }
	    if (!stricmp(tmpstr,"WANIPADDR")) 	
	    { 	
	    tmp->validate = validate_wan_ipaddr; 
	    }
	    if (!stricmp(tmpstr,"MERGEIPADDRS")) 	
	    { 	
	    tmp->validate = validate_merge_ipaddrs; 
	    }
	    if (!stricmp(tmpstr,"DNS")) 	
	    { 	
	    tmp->validate = validate_dns; 
	    }
	    if (!stricmp(tmpstr,"SAVEWDS"))
	    { 
	    tmp->validate = save_wds; 
	    }
	    if (!stricmp(tmpstr,"DHCP")) 	
	    { 	
	    tmp->validate = &dhcp_check; 
	    }
	    if (!stricmp(tmpstr,"WPAPSK")) 	
	    { 	
	    tmp->validate = validate_wpa_psk;
	    tmp->argv = (char **)malloc(sizeof(char**)*2); 	
	    tmp->argv[0] = getFileString(in);
	    tmp->argv[1] = NULL;
	    }
	    if (!stricmp(tmpstr,"STATICS")) 	
	    { 	
	    tmp->validate = validate_statics;
	    }
	    if (!stricmp(tmpstr,"IPADDR")) 	
	    { 	
	    tmp->validate = validate_ipaddr;
	    }
	    if (!stricmp(tmpstr,"IPADDRS")) 	
	    { 	
	    tmp->validate = validate_ipaddrs;
	    }
	    if (!stricmp(tmpstr,"NETMASK")) 	
	    { 	
	    tmp->validate = validate_netmask;
	    }
	    if (!stricmp(tmpstr,"MERGENETMASK")) 	
	    { 	
	    tmp->validate = validate_merge_netmask;
	    }
	    if (!stricmp(tmpstr,"WDS")) 	
	    { 	
	    tmp->validate = validate_wds;
	    }
	    if (!stricmp(tmpstr,"STATICROUTE")) 	
	    { 	
	    tmp->validate = validate_static_route;
	    }
	    if (!stricmp(tmpstr,"MERGEMAC")) 	
	    { 	
	    tmp->validate = validate_merge_mac;
	    }
	    if (!stricmp(tmpstr,"FILTERPOLICY")) 	
	    { 	
	    tmp->validate = validate_filter_policy;
	    }
	    if (!stricmp(tmpstr,"FILTERIPGRP")) 	
	    { 	
	    tmp->validate = validate_filter_ip_grp;
	    }
	    if (!stricmp(tmpstr,"FILTERPORT")) 	
	    { 	
	    tmp->validate = validate_filter_port;
	    }
	    if (!stricmp(tmpstr,"FILTERDPORTGRP")) 	
	    { 	
	    tmp->validate = validate_filter_dport_grp;
	    }
	    if (!stricmp(tmpstr,"BLOCKEDSERVICE")) 	
	    { 	
	    tmp->validate = validate_blocked_service;
	    }
	    if (!stricmp(tmpstr,"FILTERMACGRP")) 	
	    { 	
	    tmp->validate = validate_filter_mac_grp;
	    }
	    if (!stricmp(tmpstr,"FILTERWEB")) 	
	    { 	
	    tmp->validate = validate_filter_web;
	    }
	    if (!stricmp(tmpstr,"WLHWADDRS")) 	
	    { 	
	    tmp->validate = validate_wl_hwaddrs;
	    }
	    if (!stricmp(tmpstr,"FORWARDPROTO")) 	
	    { 	
	    tmp->validate = validate_forward_proto;
	    }
	    if (!stricmp(tmpstr,"PORTTRIGGER")) 	
	    { 	
	    tmp->validate = validate_port_trigger;
	    }
	    if (!stricmp(tmpstr,"HWADDR")) 	
	    { 	
	    tmp->validate = validate_hwaddr;
	    }
	    if (!stricmp(tmpstr,"HWADDRS")) 	
	    { 	
	    tmp->validate = validate_hwaddrs;
	    }
	    if (!stricmp(tmpstr,"WLWEPKEY")) 	
	    { 	
	    tmp->validate = validate_wl_wep_key;
	    }
	    if (!stricmp(tmpstr,"MACMODE")) 	
	    { 	
	    tmp->validate = validate_macmode;
	    }
	    
	    if (!stricmp(tmpstr,"WLAUTH")) 	
	    { 	
	    tmp->validate = validate_wl_auth;
	    tmp->argv = (char **)malloc(sizeof(char**)*3); 	
	    tmp->argv[0] = getFileString(in);
	    tmp->argv[1] = getFileString(in); 	
	    tmp->argv[2] = NULL;
	    }
	    if (!stricmp(tmpstr,"WLWEP")) 	
	    { 	
	    tmp->validate = validate_wl_wep;
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    
	    if (!stricmp(tmpstr,"DYNAMICROUTE")) 	
	    { 	
	    tmp->validate = validate_dynamic_route;
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    if (!stricmp(tmpstr,"WLGMODE")) 	
	    { 	
	    tmp->validate = validate_wl_gmode;
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    if (!stricmp(tmpstr,"WLNETMODE")) 	
	    { 	
	    tmp->validate = validate_wl_net_mode;
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    if (!stricmp(tmpstr,"AUTHMODE")) 	
	    { 	
	    tmp->validate = validate_auth_mode;
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    if (!stricmp(tmpstr,"SECURITYMODE")) 	
	    { 	
	    tmp->validate = validate_security_mode;
	    free(tmpstr);
	    tmpstr=getFileString(in);
	    len = atoi(tmpstr); 
	    tmp->argv = (char **)malloc(sizeof(char**)*(len+1));
	    for (i=0;i<len;i++)
		{ 	
		tmp->argv[i] = getFileString(in);
		}
	    tmp->argv[i] = NULL;
	    }
	    	
	    	
	    free(tmpstr);
	    tmpstr = getFileString(in);
	    if (!stricmp(tmpstr,"TRUE"))
	    {
	    tmp->nullok = TRUE;
	    }else
	    {
	    tmp->nullok = FALSE;
	    }
	    free(tmpstr);
	    tmpstr = getFileString(in);
	    tmp->ezc_flags = atoi(tmpstr);
	    free(tmpstr);
	    variables = (struct variables**)realloc(variables,sizeof(struct variable**)*(varcount+2));              
	    variables[varcount++] = tmp;
	    variables[varcount]=NULL;
	    }
	fclose(in);     
	}  
    } 
free(buf); 
}
/*
	{ "lan_ipaddr", "LAN IP Address", validate_lan_ipaddr, ARGV("lan"), FALSE },

	{ "router_name", "Routert Name", validate_name, ARGV("255"), TRUE, 0 },
	{ "wan_hostname","WAN Host Name", validate_name, ARGV("255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wan_domain", "WAN Domain Name", validate_name, ARGV("255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wan_ipaddr", "WAN IP Address", validate_wan_ipaddr, NULL, FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_ipaddr", "WAN IP Address", validate_merge_ipaddrs, NULL, FALSE },
	//{ "wan_netmask", "WAN Subnet Mask", validate_merge_netmask, FALSE },
	//{ "wan_gateway", "WAN Gateway", validate_merge_ipaddrs, ARGV("wan_ipaddr","wan_netmask"), FALSE },
	{ "wan_proto", "WAN Protocol", validate_choice, ARGV("disabled", "dhcp", "static", "pppoe", "pptp", "l2tp", "heartbeat"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "ntp_server", "NTP Server", NULL, NULL, TRUE, 0 },  // not use 
	{ "ntp_mode", "NTP Mode", validate_choice, ARGV("manual","auto"), TRUE, 0 },
	{ "daylight_time", "Daylight", validate_choice, ARGV("0", "1"), TRUE, 0 },
	{ "time_zone", "Time Zone", validate_choice, ARGV("-12 1 0","-11 1 0","-10 1 0","-09 1 1","-08 1 1","-07 1 0","-07 2 1","-06 1 0","-06 2 1","-05 1 0","-05 2 1","-04 1 0","-04 2 1","-03.5 1 1","-03 1 0","-03 2 1","-02 1 0","-01 1 2","+00 1 0","+00 2 2","+01 1 0","+01 2 2","+02 1 0","+02 2 2","+03 1 0","+04 1 0","+05 1 0","+06 1 0","+07 1 0","+08 1 0","+08 2 0","+09 1 0","+10 1 0","+10 2 4","+11 1 0","+12 1 0","+12 2 4"), FALSE, 0 },
	//{ "pptp_server_ip", "WAN Gateway", validate_merge_ipaddrs, ARGV("wan_ipaddr","wan_netmask"), FALSE },
	{ "ppp_username", "Username", validate_name, ARGV("63"), FALSE, 0 },
	{ "ppp_passwd", "Password", validate_password, ARGV("63"), TRUE, 0 },
	{ "ppp_keepalive", "Keep Alive", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "ppp_demand", "Connect on Demand", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "ppp_idletime", "Max Idle Time", validate_range, ARGV("1", "9999"), FALSE, 0 },
	{ "ppp_redialperiod", "Redial Period", validate_range, ARGV("1", "9999"), FALSE, 0 },
	{ "ppp_service", "Service Name", validate_name, ARGV("63"), TRUE, 0 },	// 2003-03-19 by honor
	{ "ppp_static", "Enable /Disable Static IP", validate_choice, ARGV("0", "1"), TRUE, 0 },
	{ "ppp_static_ip", "Static IP", validate_merge_ipaddrs, NULL, FALSE, 0 },
	{ "wan_dns", "WAN DNS Server", validate_dns, NULL, FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "lan_proto", "LAN Protocol", validate_choice, ARGV("dhcp", "static"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "dhcp_check", "DHCP check", dhcp_check, NULL, FALSE, 0 },
	{ "dhcp_start", "DHCP Server LAN IP Address Range", validate_range, ARGV("0","255"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "dhcp_start", "DHCP Server LAN IP Address Range", validate_merge_ip_4, NULL, FALSE },
	{ "dhcp_num", "DHCP Users", validate_range, ARGV("1","253"), FALSE, 0 },
	{ "dhcp_lease", "DHCP Client Lease Time", validate_range, ARGV("0","99999"), FALSE, 0 },
	{ "wan_wins", "WAN WINS Server", validate_merge_ipaddrs, NULL, FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "http_username", "Router Username", validate_name, ARGV("63"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "http_passwd", "Router Password", validate_password, ARGV("63"), TRUE, EZC_FLAGS_WRITE },
	{ "upnp_enable", "UPnP", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "web_wl_filter", "Wireless Access Web", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "http_enable", "HTTP Server", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "https_enable", "HTTPS Server", validate_choice, ARGV("0", "1"), FALSE, 0 },

	{ "samba_mount", "SambaFS Mount", validate_choice, ARGV("0", "1"), FALSE,0 },                  
	{ "samba_share", "SambaFS Share", NULL, NULL, FALSE,0 },
	{ "samba_user" , "SambaFS User" , NULL, NULL, FALSE,0 },
	{ "samba_password", "SambaFS Password", NULL,NULL, FALSE ,0},
	{ "samba_script", "SambaFS StartScript", NULL,NULL, FALSE,0 },
	{ "rflow_enable" , "RFLOW Enable" , validate_choice,ARGV("0","1"), FALSE,0 },
	{ "rflow_ip", "RFLOW IP", NULL,NULL, FALSE,0 },
	{ "rflow_port", "RFLOW PORT", NULL,NULL, FALSE,0 },
	{ "macupd_enable" , "MAC Update Enable" , validate_choice,ARGV("0","1"), FALSE,0 },
	{ "macupd_ip", "MAC Update IP", NULL,NULL, FALSE,0 },
	{ "macupd_port", "MAC update PORT", NULL,NULL, FALSE,0 },
	{ "macupd_interval", "MAC Update Interval", NULL,NULL, FALSE,0 },
	{ "status_auth","Status Site Authentication",NULL,NULL,FALSE,0},

	
	{ "rc_startup", "Startup Script", NULL, NULL, FALSE, 0 },
	{ "rc_firewall", "Firewall Script", NULL, NULL, FALSE, 0 },
	{ "lan_gateway", "LAN Gateway", validate_merge_ipaddrs, NULL, FALSE, 0 },
	{ "sv_localdns", "Local DNS", validate_merge_ipaddrs, NULL, FALSE, 0 },
	{ "lan_domain", "LAN Domain Name", validate_name, ARGV("255"), TRUE, 0 },
	{ "wl_mode", "Wireless Mode", validate_choice, ARGV("ap", "wet", "infra"), FALSE, 0 },
	{ "txpwr", "TX Power", validate_range, ARGV("0","251"),  FALSE, 0 },
	{ "txant", "TX Ant", validate_choice, ARGV("0","1","3"),  FALSE, 0 },
	{ "wl_antdiv", "RX Ant", validate_choice, ARGV("0","1","3"),  FALSE, 0 },
	{ "apwatchdog_enable", "AP Watchdog", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "apwatchdog_interval", "AP Watchdog", validate_range, ARGV("0", "86400"), FALSE, 0 },
	{ "boot_wait", "Boot Wait", validate_choice, ARGV("on", "off"), FALSE, 0 },
	{ "cron_enable", "Cron", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "dhcp_domain", "DHCP Domain", validate_choice, ARGV("wan", "lan"), FALSE, 0 },
	{ "dhcpd_statics", "DHCP", validate_statics, NULL, TRUE, 0 },
	{ "dhcpd_options", "DHCP", NULL, NULL, TRUE, 0 },
	{ "dnsmasq_enable", "DNS Masq", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "dnsmasq_options", "DNS Masq", NULL, NULL, TRUE, 0 },
	{ "httpd_enable", "Httpd", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "httpsd_enable", "Httpsd", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "loopback_enable", "Loopback", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "local_dns", "Local DNS", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "nas_enable", "NAS", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "ntp_enable", "NTP Client", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "pptpd_enable", "PPTPD", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "pptpd_lip", "PPTPD", NULL, NULL, FALSE, 0 },
	{ "pptpd_rip", "PPTPD", NULL, NULL, FALSE, 0 },
	{ "pptpd_auth", "PPTPD", NULL, NULL, FALSE, 0 },
	{ "pptp_encrypt", "PPTP", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "resetbutton_enable", "Resetbuttond", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "telnetd_enable", "Telnetd", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "sshd_enable", "SSHD", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "sshd_port", "SSHD", validate_range, ARGV("1", "65535"), FALSE, 0 },
	{ "sshd_passwd_auth", "SSHD", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "sshd_rsa_host_key", "SSHD", NULL, NULL, TRUE, 0 },
	{ "sshd_authorized_keys", "SSHD", NULL, NULL, TRUE , 0 },
	{ "syslogd_enable", "Syslog", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "syslogd_rem_ip", "Syslog", validate_ipaddr, NULL, TRUE, 0 },

	{ "wshaper_enable", "Bandwidth Mgmt", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "wshaper_dev", "Bandwidth Mgmt", validate_choice, ARGV("WAN", "LAN", "wLAN"), FALSE, 0 },
	{ "wshaper_downlink", "Bandwidth Mgmt", NULL, NULL, TRUE, 0 },
	{ "wshaper_uplink", "Bandwidth Mgmt", NULL, NULL, TRUE, 0 },
	{ "wshaper_nopriohostsrc", "Bandwidth Mgmt", NULL, NULL, TRUE, 0 },
	{ "wshaper_nopriohostdst", "Bandwidth Mgmt", NULL, NULL, TRUE, 0 },
	{ "wshaper_noprioportsrc", "Bandwidth Mgmt", NULL, NULL, TRUE, 0 },
	{ "wshaper_noprioportdst", "Bandwidth Mgmt", NULL, NULL, TRUE, 0 },
	{ "zebra_enable", "Zebra", validate_choice, ARGV("0", "1"), FALSE, 0 },


	// WDS vars
	{ "wl_wds1_enable","WDS separate bridge Enabled", save_wds, NULL, FALSE, 0 },
	{ "wl_wds1_hwaddr","WDS MAC", validate_wds, NULL, FALSE, 0 },
	{ "bird_ospf","Routing", NULL, NULL, TRUE, 0 },

	{ "snmpd_enable", "Snmpd", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "snmpd_syslocation", "Snmpd", NULL, NULL, TRUE, 0 },
	{ "snmpd_syscontact", "Snmpd", NULL, NULL, TRUE, 0 },
	{ "snmpd_sysname", "Snmpd", NULL, NULL, TRUE, 0 },
	{ "snmpd_rocommunity", "Snmpd", NULL, NULL, TRUE, 0 },
	{ "snmpd_rwcommunity", "Snmpd", NULL, NULL, TRUE, 0 },

	{ "wol_enable", "Wol", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "wol_interval", "Wol", validate_range, ARGV("1", "86400"), TRUE, 0 },
	{ "wol_hostname", "Wol", NULL, NULL, TRUE, 0 },
	{ "wol_macs", "Wol", NULL, NULL, TRUE, 0 },
	{ "wol_passwd", "Wol", NULL, NULL, TRUE, 0 },

	{ "chilli_enable", "Enable Chillispot", validate_choice, ARGV("0","1"), TRUE, 0 },
	{ "chilli_url", "Redirect URL", validate_name, ARGV("128"), TRUE, 0 },
	{ "chilli_radius1", "Primary Radius Server", validate_merge_ipaddrs, NULL, FALSE, 0 },
	{ "chilli_radius2", "Backup Radius Server", validate_merge_ipaddrs, NULL, FALSE, 0 },
	{ "chilli_pass", "Radius Password", validate_name, ARGV("128"), TRUE, 0 },
	{ "chilli_dns1", "Chillispot DNS1", validate_merge_ipaddrs, NULL, FALSE, 0 },	
	
	{ "def_whwaddr", "User define wireless MAC Address", validate_merge_mac, NULL, TRUE, 0 },

	{ "log_dropped", "Access log D", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "log_rejected", "Access log R", validate_choice, ARGV("0", "1"), FALSE, 0 },
 	{ "log_accepted", "Access log A", validate_choice, ARGV("0", "1"), FALSE, 0 },	
	
	{ "log_level", "Connection Logging", validate_range, ARGV("0", "3"), FALSE, 0 },
	{ "log_enable", "Access log", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "filter", "Firewall Protection", validate_choice, ARGV("on", "off"), FALSE, 0 },
	{ "filter_policy", "Filter", validate_filter_policy, NULL, FALSE, 0 },
	{ "filter_ip_value", "TCP/UDP IP Filter", validate_filter_ip_grp, NULL, FALSE, 0 },
	{ "filter_port", "TCP/UDP Port Filter", validate_filter_port, NULL, FALSE, 0 },
	{ "filter_dport_value", "TCP/UDP Port Filter", validate_filter_dport_grp, NULL, FALSE, 0 },
	{ "blocked_service", "TCP/UDP Port Filter", validate_blocked_service, NULL, FALSE, 0 },
	{ "filter_mac_value", "TCP/UDP MAC Filter", validate_filter_mac_grp, NULL, FALSE, 0 },
	{ "filter_web", "Website Filter", validate_filter_web, NULL, FALSE, 0 },
	{ "block_wan", "Block WAN Request", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "ident_pass", "IDENT passthrough", validate_choice, ARGV("0", "1"), TRUE, 0 },
	{ "block_loopback", "Filter Internet NAT redirection", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "block_proxy", "Block Proxy", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "block_java", "Block Java", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "block_activex", "Block ActiveX", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "block_cookie", "Block Cookie", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "multicast_pass", "Multicast Pass Through", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "ipsec_pass", "IPSec Pass Through", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "pptp_pass", "PPTP Pass Through", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "l2tp_pass", "L2TP Pass Through", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "remote_management", "Remote Management", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "remote_mgt_https", "Remote Management use https", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "http_wanport", "Router WAN Port", validate_range, ARGV("0", "65535"), TRUE, 0 },
	{ "remote_upgrade", "Remote Upgrade", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "mtu_enable", "MTU enable", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "wan_mtu", "WAN MTU", validate_range, ARGV("576","1500"), FALSE, 0 },
	{ "forward_port", "TCP/UDP Port Forward", validate_forward_proto, NULL, FALSE, 0 },
	{ "port_trigger", "TCP/UDP Port Trigger", validate_port_trigger, NULL, FALSE, 0 },
	{ "static_route", "Static Route", validate_static_route, NULL, FALSE, 0 },
	{ "wk_mode", "Working Mode", validate_dynamic_route, ARGV("gateway", "router", "ospf"), FALSE, 0 },
	//{ "dr_setting", "Dynamic Routing", validate_choice, ARGV("0", "1", "2", "3"), FALSE },
	//{ "dr_lan_tx", "Dynamic Routing LAN TX", validate_choice, ARGV("0","1 2"), FALSE },
	//{ "dr_lan_rx", "Dynamic Routing LAN RX", validate_choice, ARGV("0","1 2"), FALSE },
	//{ "dr_wan_tx", "Dynamic Routing WAN TX", validate_choice, ARGV("0","1 2"), FALSE },
	//{ "dr_wan_rx", "Dynamic Routing WAN RX", validate_choice, ARGV("0","1 2"), FALSE },
	{ "dmz_enable", "DMZ enable", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "dmz_ipaddr", "DMZ LAN IP Address", validate_range, ARGV("0","255"), FALSE, 0 },
	{ "mac_clone_enable", "User define WAN MAC Address", validate_choice, ARGV("0","1"), TRUE, 0 },
	{ "def_hwaddr", "User define WAN MAC Address", validate_merge_mac, NULL, TRUE, 0 },
	{ "upgrade_enable", "Tftp upgrade", validate_choice, ARGV("0", "1"), FALSE, 0 },
	{ "wl_enable", "Enable Wireless", validate_choice, ARGV("0","1"), TRUE, 0 },
	{ "wl_ssid", "Network Name (SSID)", validate_name, ARGV("32"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
        { "wl_closed", "Network Type", validate_choice, ARGV("0", "1"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_country", "Country", validate_choice, ARGV("Worldwide", "Thailand", "Israel", "Jordan", "China", "Japan", "USA", "Europe", "USA Low", "Japan High", "All"), FALSE, 0 },
        { "wl_ap_isolate", "AP Isolate", validate_choice, ARGV("0", "1"), TRUE, 0 },
//        { "wl_mode", "AP Mode", validate_choice, ARGV("ap", "wet", "wds"), FALSE },
        { "wl_lazywds", "Bridge Restrict", validate_choice, ARGV("0", "1"), FALSE, 0 },
        { "wl_wds", "Remote Bridges", validate_hwaddrs, NULL, TRUE, 0 },
        { "wl_WEP_key", "Network Key Index", validate_wl_wep_key, NULL, FALSE, 0 },
        //{ "wl_passphrase", "Network Passphrase", validate_name, ARGV("20"), FALSE },
        //{ "wl_key", "Network Key Index", validate_range, ARGV("1","4"), FALSE },
        //{ "wl_key1", "Network Key 1", validate_wl_key, NULL, TRUE },
        //{ "wl_key2", "Network Key 2", validate_wl_key, NULL, TRUE },
        //{ "wl_key3", "Network Key 3", validate_wl_key, NULL, TRUE },
        //{ "wl_key4", "Network Key 4", validate_wl_key, NULL, TRUE },
        //{ "wl_wep_bit", "WEP Mode", validate_choice, ARGV("64", "128"), FALSE },
        { "wl_wep", "WEP Mode", validate_wl_wep, ARGV("off", "on", "restricted","tkip","aes","tkip+aes"), FALSE , EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_crypto", "Crypto Mode", validate_choice, ARGV("off","tkip","aes","tkip+aes"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
        { "wl_auth", "Authentication Mode", validate_wl_auth, ARGV("0", "1"), FALSE, 0 },
        { "wl_macmode1", "MAC Restrict Mode", validate_macmode, NULL , FALSE, 0 },
        //{ "wl_mac", "Allowed MAC Address", validate_hwaddrs, NULL, TRUE },
	{ "wl_radio", "Radio Enable", validate_choice, ARGV("0", "1"), FALSE, 0 }, //from 11.9
        { "wl_mac_list", "Filter MAC Address", validate_wl_hwaddrs, NULL, FALSE, 0 },
        //{ "wl_active_mac", "Active MAC Address", validate_wl_active_mac, NULL, FALSE },
        { "wl_channel", "802.11g Channel", validate_range, ARGV("0","14"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
        { "wl_rate", "802.11g Rate", validate_choice, ARGV("0", "1000000", "2000000", "5500000", "6000000", "9000000", "11000000", "12000000", "18000000", "24000000", "36000000", "48000000", "54000000"), FALSE, 0 },
        { "wl_rateset", "802.11g Supported Rates", validate_choice, ARGV("all", "default","12"), FALSE, 0 },
        { "wl_frag", "802.11g Fragmentation Threshold", validate_range, ARGV("256", "2346"), FALSE, 0 },
        { "wl_rts", "802.11g RTS Threshold", validate_range, ARGV("0", "2347"), FALSE, 0 },
        { "wl_dtim", "802.11g DTIM Period", validate_range, ARGV("1", "255"), FALSE, 0 },
        { "wl_bcn", "802.11g Beacon Interval", validate_range, ARGV("1", "65535"), FALSE, 0 },
        { "wl_gmode", "802.11g mode", validate_wl_gmode, ARGV("-1", "0", "1", "2", "4", "5"), FALSE, 0 },
        { "wl_net_mode", "802.11g mode", validate_wl_net_mode, ARGV("disabled", "mixed", "b-only", "g-only", "speedbooster"), FALSE, 0 },
	{ "wl_gmode_protection", "54g Protection", validate_choice, ARGV("off", "auto"), FALSE, 0 },
	{ "wl_frameburst", "Frame Bursting", validate_choice, ARGV("off", "on"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_plcphdr", "Preamble Type", validate_choice, ARGV("long", "short"), FALSE, 0 },
	{ "wl_phytype", "Radio Band", validate_choice, ARGV("a", "b", "g"), TRUE, 0 },
	{ "wl_wpa_psk", "WPA Pre-Shared Key", validate_wpa_psk, ARGV("64"), TRUE, EZC_FLAGS_WRITE },
	{ "wl_wpa_gtk_rekey", "WPA GTK Rekey Timer", validate_range, ARGV("0","99999"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_radauth", "RADIUS Server ON", NULL, validate_choice, ARGV("0", "1"), FALSE ,0}, 	
	{ "wl_radius_ipaddr", "RADIUS Server", validate_merge_ipaddrs, NULL, TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_radius_port", "RADIUS Port", validate_range, ARGV("0", "65535"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_radius_key", "RADIUS Shared Secret", validate_name, ARGV("255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_auth_mode", "Auth Mode", validate_auth_mode, ARGV("disabled", "radius", "wpa", "psk"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "security_mode", "Security Mode", validate_security_mode, ARGV("disabled", "radius", "wpa", "psk","wep"), FALSE, 0 },
	{ "wl_unit", "802.11 Instance", wl_unit, NULL, TRUE, 0 },
	{ "wl_ap_ssid", "SSID of associating AP", validate_name, ARGV("32"), TRUE, 0 },
	{ "wl_ap_ip", "Default IP of associating AP", validate_merge_ipaddrs, NULL, TRUE, 0 },

	//{ "ddns_enable", "DDNS", validate_choice, ARGV("0", "1"), FALSE },
	//{ "ddns_username", "DDNS username", validate_name, ARGV("63"), FALSE },
	//{ "ddns_passwd", "DDNS password", validate_password, ARGV("63"), FALSE },
	//{ "ddns_hostname", "DDNS hostname", validate_name, ARGV("255"), TRUE },
        //{ "ddns_server", "DDNS server", validate_choice,ARGV("ath.cx","dnsalias.com","dnsalias.net","dnsalias.org","dyndns.biz","dyndns.info","dyndns.org","dyndns.tv","gotdns.com","gotdns.org","homedns.org","homeftp.net","homeftp.org","homeip.net","homelinux.com","homelinux.net","homelinux.org","homeunix.com","homeunix.net","homeunix.org","kicks-ass.net","kicks-ass.org","merseine.nu","mine.nu","serveftp.net"), FALSE },
	{ "l2tp_server_ip", "L2TP Server", validate_merge_ipaddrs, NULL, FALSE, 0 },
	//{ "hb_server_ip", "Heart Beat Server", validate_merge_ipaddrs, NULL, FALSE },		//by tallest
	{ "hb_server_ip", "Heart Beat Server", validate_name, ARGV("63"), TRUE, 0 },
	{ "hb_server_ip", "Heart Beat Server", validate_merge_ipaddrs, NULL, FALSE, 0 },
	{ "os_server", "OS Server", NULL, NULL, TRUE, 0 },
	{ "stats_server", "Stats Server", NULL, NULL, TRUE, 0 },
	 EZC_SUPPORT
	{ "ezc_enable", "EZConfig", validate_choice, ARGV("0", "1"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE},
//#endif
	//{ "fw_disable", "Firewall", validate_choice, ARGV("0", "1"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "lan_stp", "Spanning Tree Protocol", validate_choice, ARGV("0", "1"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "lan_lease", "DHCP Server Lease Time", validate_range, ARGV("1", "604800"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_desc", "Description", validate_name, ARGV("0", "255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_hwaddr", "MAC Address", validate_hwaddr, NULL, TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_netmask", "Subnet Mask", validate_ipaddr, NULL, FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_gateway", "Default Gateway", validate_ipaddr, NULL, TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_username", "PPPoE Username", validate_name, ARGV("0", "255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_passwd", "PPPoE Password", validate_name, ARGV("0", "255"), TRUE, EZC_FLAGS_WRITE },
	//{ "wan_pppoe_service", "PPPoE Service Name", validate_name, ARGV("0", "255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_ac", "PPPoE Access Concentrator", validate_name, ARGV("0", "255"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_keepalive", "PPPoE Keep Alive", validate_choice, ARGV("0", "1"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_demand", "PPPoE Connect on Demand", validate_choice, ARGV("0", "1"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_idletime", "PPPoE Max Idle Time", validate_range, ARGV("1", "3600"), TRUE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_mru", "PPPoE MRU", validate_range, ARGV("128", "16384"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wan_pppoe_mtu", "PPPoE MTU", validate_range, ARGV("128", "16384"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wl_country_code", "Country Code", validate_country, NULL, FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	{ "wl_afterburner", "AfterBurner Technology", validate_choice, ARGV("on", "off", "auto"), FALSE, EZC_FLAGS_READ | EZC_FLAGS_WRITE },
	//{ "wl_key", "Network Key Index", validate_range, ARGV("1", "4"), FALSE, EZC_FLAGS_WRITE },
	//{ "wl_key1", "Network Key 1", validate_wl_key, NULL, TRUE, EZC_FLAGS_WRITE},
	//{ "wl_key2", "Network Key 2", validate_wl_key, NULL, TRUE, EZC_FLAGS_WRITE},
	//{ "wl_key3", "Network Key 3", validate_wl_key, NULL, TRUE, EZC_FLAGS_WRITE},
	//{ "wl_key4", "Network Key 4", validate_wl_key, NULL, TRUE, EZC_FLAGS_WRITE},

};
*/

//Added by Daniel(2004-07-29) for EZC
int variables_arraysize(void)
{
int varcount=0;
if (variables==NULL)return 0;
while(variables[varcount]!=NULL)
    {
    varcount++;
    }
//	return ARRAYSIZE(variables);
return varcount;
}

static void validate_cgi(webs_t wp)
{
char *value;
int i;
int count=0;
int argcount=0;
struct variable *var;
//FILE *out;
/*
Initnvramtab();
while(variables[count]!=NULL)
{
fprintf(out,"%s %s %d %d ARGS:",variables[count]->name,variables[count]->longname,variables[count]->nullok,variables[count]->ezc_flags);
argcount=0;
var=variables[count];
if (var->argv!=NULL)
 {
 while (var->argv[argcount]!=NULL)
    {
    fprintf(out,"%s;",var->argv[argcount]);
    argcount++;
    }
    fprintf(out,"\n");
 }
count++;
}
    
fclose(out);
*/
//out=fopen("/tmp/dump.nv","wb");
	for (i = 0; i < variables_arraysize(); i++) 
	{
		if (variables[i]==NULL)
		    return;
		value = websGetVar(wp, variables[i]->name, NULL);
		
		if (!value)
			continue;
//		fprintf(out,"name: %s value: %s\n",variables[i]->name,value);
		if ((!*value && variables[i]->nullok) || !variables[i]->validate)
			nvram_set(variables[i]->name, value);
		else
			variables[i]->validate(wp, value, variables[i]);
	} 
//    fclose(out);
}

enum {
	NOTHING,
	REBOOT,
	RESTART,
	SERVICE_RESTART,
	SYS_RESTART,
	REFRESH,
};

struct gozila_action gozila_actions[] = {
	/* bellow for setup page */
	{ "index",		"clone_mac",	"",		1,	REFRESH,		clone_mac},
	{ "WanMAC",		"clone_mac",	"",		1,	REFRESH,		clone_mac},	// for cisco style
	{ "DHCPTable",		"delete",	"",		2,	REFRESH,		delete_leases},
	{ "Status",		"release",	"dhcp_release",	0,	SYS_RESTART,	dhcp_release},
	{ "Status",             "renew",        "",             3,      REFRESH,                dhcp_renew},
	{ "Status",		"Connect",	"start_pppoe",	1,	RESTART,		NULL},
	{ "Status_Router",	"release",	"dhcp_release",	0,	SYS_RESTART,	dhcp_release},	// for cisco style
	{ "Status_Router",      "renew",        "",             3,      REFRESH,                dhcp_renew},	// for cisco style
	{ "Status",		"Disconnect",	"stop_pppoe",	2,	SYS_RESTART,	stop_ppp},
	{ "Status",		"Connect_pppoe",	"start_pppoe",	1,	RESTART,		NULL},
	{ "Status",		"Disconnect_pppoe",	"stop_pppoe",	2,	SYS_RESTART,	stop_ppp},
	{ "Status",		"Connect_pptp",	"start_pptp",	1,	RESTART,		NULL},
	{ "Status",		"Disconnect_pptp",	"stop_pptp",	2,	SYS_RESTART,	stop_ppp},
	{ "Status",		"Connect_heartbeat",	"start_heartbeat",	1,	RESTART,		NULL},
	{ "Status",		"Disconnect_heartbeat",	"stop_heartbeat",	2,	SYS_RESTART,	stop_ppp},
	{ "Status_Router",	"Disconnect",	"stop_pppoe",	2,	SYS_RESTART,	stop_ppp},	// for cisco style
	{ "Status_Router",	"Connect_pppoe",	"start_pppoe",	1,	RESTART,		NULL},	// for cisco style
	{ "Status_Router",	"Disconnect_pppoe",	"stop_pppoe",	2,	SYS_RESTART,	stop_ppp},	// for cisco style
	{ "Status_Router",	"Connect_pptp",	"start_pptp",	1,	RESTART,		NULL},	// for cisco style
	{ "Status_Router",	"Disconnect_pptp",	"stop_pptp",	2,	SYS_RESTART,	stop_ppp},	// for cisco style
	{ "Status_Router",	"Connect_l2tp",	"start_l2tp",	1,	RESTART,		NULL},	// for cisco style
	{ "Status_Router",	"Disconnect_l2tp",	"stop_l2tp",	2,	SYS_RESTART,	stop_ppp},	// for cisco style{ "Status_Router",	"Connect_heartbeat",	"start_heartbeat",	1,	RESTART,		NULL},	// for cisco style
	{ "Status_Router",	"Disconnect_heartbeat",	"stop_heartbeat",	2,	SYS_RESTART,	stop_ppp},	// for cisco style
	{ "Filters",		"save",		"filters",	1,	SYS_RESTART,	save_policy},
	{ "Filters",		"delete",	"filters",	1,	SYS_RESTART,	single_delete_policy},
	{ "FilterSummary",	"delete",	"filters",	1,	SYS_RESTART,	summary_delete_policy},
	{ "Routing",		"del",		"static_route_del",	1,	SYS_RESTART,	delete_static_route},
	{ "RouteStatic",	"del",		"static_route_del",	1,	SYS_RESTART,	delete_static_route},
	{ "WL_WEPTable",	"key_64",	"",		1,	REFRESH,		generate_key_64},
	{ "WL_WEPTable",	"key_128",	"",		1,	REFRESH,		generate_key_128},
	{ "WL_WPATable",	"key_64",	"",		1,	REFRESH,		generate_key_64},
	{ "WL_WPATable",	"key_128",	"",		1,	REFRESH,		generate_key_128},
	{ "WL_ActiveTable",	"add_mac",	"",		1,	REFRESH,		add_active_mac},
	/* Sveasoft addition */
	{ "Wireless_WDS",	"save",	"",			0,	REFRESH,		save_wds},
	{ "Ping",		"startup",	"",		1,	SYS_RESTART,	ping_startup},
	{ "Ping",		"firewall",	"",		1,	SYS_RESTART,	ping_firewall},
	{ "QoS",		"add_svc",	"",		1,	REFRESH,		qos_add_svc},
	{ "QoS",		"add_ip",	"",		1,	REFRESH,		qos_add_ip},
	{ "QoS",		"add_mac",	"",		1,	REFRESH,		qos_add_mac},
	{ "QoS",		"save",		"filters",	1,	SYS_RESTART,	qos_save},
	/* end Sveasoft addition */
	{ "Port_Services",	"save_services","filters",	2,	SYS_RESTART,		save_services_port},
	{ "Ping",		"start",	"start_ping",	1,	SERVICE_RESTART,	diag_ping_start},
	{ "Ping",		"stop",		"",		0,	REFRESH,		diag_ping_stop},
	{ "Ping",		"clear",	"",		0,	REFRESH,		diag_ping_clear},
	{ "Traceroute",		"start",	"start_traceroute",		1,	SYS_RESTART,		diag_traceroute_start},
	{ "Traceroute",		"stop",		"",		0,	REFRESH,		diag_traceroute_stop},
	{ "Traceroute",		"clear",	"",		0,	REFRESH,		diag_traceroute_clear},
};

struct gozila_action *
handle_gozila_action(char *name, char *type)
{
	struct gozila_action *v;

	if(!name || !type)
		return NULL;

	for(v = gozila_actions ; v < &gozila_actions[STRUCT_LEN(gozila_actions)]; v++) {
   		if(!strcmp(v->name, name) && !strcmp(v->type, type)){
			return v;
		}
   	}
        return NULL;
}

char my_next_page[30]="";
int
gozila_cgi(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg, char_t *url, char_t *path, char_t *query)
{
	char *submit_button, *submit_type,*next_page;
	int action = REFRESH;
	int sleep_time;
	struct gozila_action *act;
	int ret;

	gozila_action = 1;
	my_next_page[0]='\0';

	submit_button = websGetVar(wp, "submit_button", NULL);	/* every html must have the name */
	submit_type = websGetVar(wp, "submit_type", NULL);	/* add, del, renew, release ..... */

	nvram_set("action_service","");
	nvram_set("action_service_arg1","");

	cprintf("submit_button=[%s] submit_type=[%s]\n",submit_button, submit_type);
	act = handle_gozila_action(submit_button, submit_type);

	if(act){
		cprintf("name=[%s] type=[%s] service=[%s] sleep=[%d] action=[%d]\n",act->name, act->type, act->service, act->sleep_time, act->action);
		nvram_set("action_service",act->service);
		sleep_time = act->sleep_time;
		action = act->action;
		if(act->go)
			ret=act->go(wp);
	}
	else{
		sleep_time = 0;
		action = REFRESH;
	}

	if(action == REFRESH)
		sleep(sleep_time);
	else if(action == SERVICE_RESTART){
		sys_commit();
		service_restart();
		sleep(sleep_time);
	}
	else if(action == SYS_RESTART){
		sys_commit();
		sys_restart();
	}
	else if (action == RESTART){
		sys_commit();
		sys_restart();
	}
	if (my_next_page[0]!='\0') {
	    	sprintf(path,"%s",my_next_page);
	} else {
	    	next_page = websGetVar(wp, "next_page", NULL);
		if (next_page)
		    	sprintf(path,"%s",next_page);
		else
			sprintf(path,"%s.asp",submit_button);
	}
	do_ej(path,wp);       //refresh
	websDone(wp, 200);

	gozila_action = 0;    //reset gozila_action
	generate_key = 0;
	clone_wan_mac = 0;

	return 1;
}

struct apply_action apply_actions[] = {
	/* bellow for setup page */
//#ifdef OEM == LINKSYS
//	{ "index",		"index",	0,	RESTART		,	NULL},
//#else
	{ "OnePage",		"",		0,	RESTART		,	NULL},	// same as index
	{ "Expose",		"filters",	0,	SYS_RESTART	,	NULL},  // same as DMZ
	{ "VServer",		"forward",	0,	SERVICE_RESTART	,	NULL},	// same as Forward
//#endif
	{ "Security",		"",		1,	RESTART		,	NULL},
	{ "System",		"",		0,	RESTART		,	NULL},
	{ "DHCP",		"dhcp",		0,	SYS_RESTART	,	NULL},
	{ "WL_WEPTable",	"",		0,	RESTART		,	NULL},
	{ "WL_WPATable",	"wireless",	0,	SYS_RESTART	,	NULL},
	/* bellow for advanced page */
	{ "DMZ",		"filters",	0,	SYS_RESTART	,	NULL},	// for cisco style
	{ "Filters",		"filters",	0,	SYS_RESTART	,	NULL},
	{ "FilterIPMAC",	"filters",	0,	SYS_RESTART	,	NULL},
	{ "FilterIP",		"filters",	0,	SYS_RESTART	,	NULL},
	{ "FilterMAC",		"filters",	0,	SYS_RESTART	,	NULL},
	{ "FilterPort",		"filters",	0,	SYS_RESTART	,	NULL},
	{ "VPN",		"filters",	0,	SYS_RESTART	,	NULL},	// for cisco style
	{ "Firewall",		"filters",	0,	SYS_RESTART	,	NULL},	// for cisco style
	{ "Forward",		"forward",	0,	SERVICE_RESTART	,	NULL},
	{ "Routing",		"",		0,	RESTART		,	NULL},
	{ "DDNS",		"ddns",		4,	SYS_RESTART	,	ddns_save_value},
	/* Sveasoft additions */
	{ "Management",		"management",	4,	SYS_RESTART	,	NULL},
	{ "Triggering",		"filters",	0,	SERVICE_RESTART	,	NULL},
	{ "Wireless_WDS",	"",		4,	RESTART	,		NULL},
	{ "QoS",		"filters",	0,	SYS_RESTART	,	NULL},
	{ "Log",		"filters",	0,	SERVICE_RESTART	,	NULL},
	/* end Sveasoft additions*/
	{ "Wireless",		"wireless",	0,	SYS_RESTART	,	NULL},
	{ "Wireless_Basic",	"wireless",	0,	RESTART	,		NULL},
	{ "Wireless_Advanced",	"wireless",	0,	SYS_RESTART	,	NULL},
	{ "Wireless_MAC",	"wireless",	0,	SYS_RESTART	,	NULL},
	{ "WL_FilterTable",	"wireless",	0,	SYS_RESTART	,	NULL},

	/* begin lonewolf additions */
	{ "Vlan",		"",		0,	REFRESH ,		port_vlan_table_save },
	/* end lonewolf additions */
};

struct apply_action *
handle_apply_action(char *name)
{
	struct apply_action *v;

	if(!name)
		return NULL;

	for(v = apply_actions ; v < &apply_actions[STRUCT_LEN(apply_actions)] ; v++) {
   		if(!strcmp(v->name, name)){
			return v;
		}
   	}
        return NULL;
}

int getFileLen(FILE *in)
{
int len;
fseek(in,0,SEEK_END);
len = ftell(in);
rewind(in);
return len;
}

/*
              <TR align=middle>
                <TD width=76 height=30><FONT size=2><INPUT  maxLength=12 size=7 name=name12 onBlur=valid_name(this,"Name") value='<% port_forward_table("name","12"); %>' class=num></FONT></TD>
                <TD width=70 height=30 valign=middle valign=middle><FONT face="Arial, Helvetica, sans-serif"><INPUT  maxLength=5 size=5 value='<% port_forward_table("from","12"); %>' name=from12 onBlur=valid_range(this,0,65535,"Port") class=num><span >&nbsp;</span></FONT></TD>
                <TD width=58 height=30><INPUT  maxLength=5 size=5 value='<% port_forward_table("to","12"); %>' name=to12 onBlur=valid_range(this,0,65535,"Port") class=num></TD>
                <TD align=middle width=78 height=30><FONT face=Arial color=blue>
			<SELECT size=1 name=pro12>
				<OPTION value=tcp <% port_forward_table("sel_tcp","12"); %>>TCP</OPTION>
				<OPTION value=udp <% port_forward_table("sel_udp","12"); %>>UDP</OPTION>
				<OPTION value=both <% port_forward_table("sel_both","12"); %>>Both</OPTION>
			</SELECT></FONT></TD>
                <TD width=96 height=30><FONT style="FONT-SIZE: 8pt" face=Arial><INPUT  maxLength=15 size=11 value='<% port_forward_table("ip","12"); %>' name=ip12  class=num></FONT></TD>
                <TD width=47 height=30><INPUT type=checkbox value=on name=enable12 <% port_forward_table("enable","12"); %>></TD></TR>

*/

static int 
show_forward(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg,
	  char_t *url, char_t *path, char_t *query)
{
FILE *in,*out;
char *buf;
struct dirent *entry;
DIR *directory; 
int i;
int fullsize=0;
in=fopen("/www/Forward.header","rb");
out=fopen("/tmp/Forward.asp","wb");
if (in==NULL)
{
    websWrite(wp,"internal error");
    websDone(wp,200);
    return 1;
}
fullsize = getFileLen(in);
buf = (char *)malloc(fullsize+1);
fread(buf,fullsize,1,in);
fwrite(buf,fullsize,1,out);
buf[fullsize]=0;
free(buf);
fclose(in);
for (i=0;i<FORWARDING_NUM;i++)
{
fprintf(out,"<TR align=middle>\n");
fprintf(out,"<TD width=76 height=30><FONT size=2><INPUT  maxLength=12 size=7 name=name%d onBlur=valid_name(this,\"Name\") value='<%% port_forward_table(\"name\",\"%d\"); %%>' class=num></FONT></TD>\n",i,i);
fprintf(out,"<TD width=70 height=30 valign=middle valign=middle><FONT face=\"Arial, Helvetica, sans-serif\"><INPUT  maxLength=5 size=5 value='<%% port_forward_table(\"from\",\"%d\"); %%>' name=from%d onBlur=valid_range(this,0,65535,\"Port\") class=num><span >&nbsp;</span></FONT></TD>\n",i,i);
fprintf(out,"<TD width=58 height=30><INPUT  maxLength=5 size=5 value='<%% port_forward_table(\"to\",\"%d\"); %%>' name=to%d onBlur=valid_range(this,0,65535,\"Port\") class=num></TD>\n",i,i);
fprintf(out,"<TD align=middle width=78 height=30><FONT face=Arial color=blue>\n");
fprintf(out,"<SELECT size=1 name=pro%d>\n",i);
fprintf(out,"<OPTION value=tcp <%% port_forward_table(\"sel_tcp\",\"%d\"); %%>>TCP</OPTION>\n",i);
fprintf(out,"<OPTION value=udp <%% port_forward_table(\"sel_udp\",\"%d\"); %%>>UDP</OPTION>\n",i);
fprintf(out,"<OPTION value=both <%% port_forward_table(\"sel_both\",\"%d\"); %%>>Both</OPTION>\n",i);
fprintf(out,"</SELECT></FONT></TD>\n");
fprintf(out,"<TD width=96 height=30><FONT style=\"FONT-SIZE: 8pt\" face=Arial><INPUT  maxLength=15 size=11 value='<%% port_forward_table(\"ip\",\"%d\"); %%>' name=ip%d  class=num></FONT></TD>\n",i,i);
fprintf(out,"<TD width=47 height=30><INPUT type=checkbox value=on name=enable%d <%% port_forward_table(\"enable\",\"%d\"); %%>></TD></TR>",i,i);
}


in=fopen("/www/Forward.footer","rb");
if (in==NULL)
{
    websWrite(wp,"internal error");
    websDone(wp,200);
    return 1;
}

fullsize = getFileLen(in);
buf = (char *)malloc(fullsize+1);
fread(buf,fullsize,1,in);
fwrite(buf,fullsize,1,out);
buf[fullsize]=0;
free(buf);
fclose(in);
fclose(out);
do_ej("/tmp/Forward.asp",wp);
unlink("/tmp/Forward.asp");
return 1;
}

//SEG DD-WRT addition
static int 
show_modules(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg,
	  char_t *url, char_t *path, char_t *query)
{
FILE *in,*out;
char *buf;
struct dirent *entry;
DIR *directory; 

int fullsize=0;
in=fopen("/www/header.asp","rb");
out=fopen("/tmp/Management.asp","wb");
if (in==NULL)
{
    websWrite(wp,"internal error");
    websDone(wp,200);
    return 1;
}
fullsize = getFileLen(in);
buf = (char *)malloc(fullsize+1);
fread(buf,fullsize,1,in);
fwrite(buf,fullsize,1,out);
buf[fullsize]=0;
free(buf);
fclose(in);
//display modules
directory = opendir("/etc/config"); 
if (directory==NULL)
    return;
//list all files in this directory 
while ((entry=readdir(directory))!=NULL)  
    {  
    if(endswith(entry->d_name,".webconfig"))     
	{
	buf=malloc(1024);
	sprintf(buf,"/etc/config/%s",entry->d_name);
	in=fopen(buf,"rb");
	if (in==NULL)break;
	free(buf);
	fullsize=getFileLen(in);
	buf = (char *)malloc(fullsize+1);
	fread(buf,fullsize,1,in);
	fwrite(buf,fullsize,1,out);
	buf[fullsize]=0;
	free(buf);
	}
    }
in=fopen("footer.asp","rb");
if (in==NULL)
{
    websWrite(wp,"internal error");
    websDone(wp,200);
    return 1;
}

fullsize = getFileLen(in);
buf = (char *)malloc(fullsize+1);
fread(buf,fullsize,1,in);
fwrite(buf,fullsize,1,out);
buf[fullsize]=0;
free(buf);
fclose(in);
fclose(out);
do_ej("/tmp/Management.asp",wp);
unlink("/tmp/Management.asp");
return 1;
}

static void do_shell_script(char *url, webs_t stream)
{
char *buf;
buf = malloc(1024);
sprintf(buf,"%s >/tmp/shellout.asp",url);
system(buf);
free(buf);
do_ej("/tmp/shellout.asp",stream);
}


static int
apply_cgi(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg,
	  char_t *url, char_t *path, char_t *query)
{
	int action = NOTHING;
	char *value;
	char *submit_button;
	int sleep_time = 0;
	int need_commit = 1;
	int need_reboot = atoi(websGetVar(wp, "need_reboot", "0"));	
	int ret_code;

	error_value = 0;
	ret_code = -1;

        /********************/
        value = websGetVar(wp, "change_action", "");


        if(value && !strcmp(value,"gozila_cgi")){
             gozila_cgi(wp, urlPrefix, webDir, arg, url, path, query);
             return 1;
        }
        /********************/
	submit_button = websGetVar(wp, "submit_button", "");

	if (!query)
		goto footer;

	if(legal_ip_netmask("lan_ipaddr", "lan_netmask", nvram_safe_get("http_client_ip")) == TRUE)
		browser_method = USE_LAN;
	else
		browser_method = USE_WAN;

#if 0
        if(check_hw_type() == BCM4702_CHIP) /* barry add for 4712 or 4702 RF test */
	        {
	          printf("\nBoard is 4702 \n");
	          value = websGetVar(wp, "StartContinueTx", NULL);
	          if(value){
	                    StartContinueTx_4702(value);
	                    goto footer;
	                    }

                  value = websGetVar(wp, "StopContinueTx", NULL);
                  if(value){
                            StopContinueTx_4702(value);
			    goto footer;
			    }
	       }
        else
        {
#endif
		value = websGetVar(wp, "StartContinueTx", NULL);
		// printf("\nBarry StartContinueTx,value=%s\n",value);
		if(value){
			StartContinueTx(value);
			goto footer;
		}

		value = websGetVar(wp, "StopContinueTx", NULL);
		// printf("\nBarry StopContinueTx,value=%s\n",value);
		if(value){
			StopContinueTx(value);
			goto footer;
		}
		/* 1030 */
		value = websGetVar(wp, "WL_atten_bb", NULL);
		// printf("\nBarry WL_atten_bb,value=%s\n",value);
		if(value){
			Check_TSSI(value);
			goto footer;
		}
		/* 1030 */
		value = websGetVar(wp, "WL_tssi_enable", NULL);
		// printf("\nBarry WL_tssi_enable,value=%s\n",value);
		if(value){
			Enable_TSSI(value);
			goto footer;
		}
		/* 1216 */
		value = websGetVar(wp, "ChangeANT", NULL);
		// printf("\nBarry ChangeANT,value=%s\n",value);
		if(value){
			Change_Ant(value);
			goto footer;
		}
#if 0
	}
#endif
	value = websGetVar(wp, "skip_amd_check", NULL);
	if(value){
		if(atoi(value) == 0 || atoi(value) == 1){
			nvram_set("skip_amd_check", value);
			sys_commit();
		}
		goto footer;
	}

	need_commit = atoi(websGetVar(wp, "commit", "1"));

	value = websGetVar(wp, "action", "");

	/* Apply values */
	if (!strcmp(value, "Apply")) {
		struct apply_action *act;
		validate_cgi(wp);

		act = handle_apply_action(submit_button);
	        
		//If web page configuration is changed, the EZC configuration function should be disabled.(2004-07-29)
		nvram_set("is_default", "0");
		nvram_set("is_modified", "1");
		
		if(act){
			cprintf("submit_button=[%s] service=[%s] sleep_time=[%d] action=[%d]\n",
				 act->name, act->service, act->sleep_time, act->action);
			if((act->action == SYS_RESTART) || (act->action == SERVICE_RESTART))
				nvram_set("action_service",act->service);
			else
				nvram_set("action_service","");
			sleep_time = act->sleep_time;
			action = act->action;

			if(act->go)
				ret_code = act->go(wp);
		}
		else{
			nvram_set("action_service","");
			sleep_time = 1;
			action = RESTART;
		}

		if(need_commit){
		        //If web page configuration is changed, the EoU function should be disabled.(2004-05-06)
			nvram_set("eou_configured", "1");
			eval("wl", "custom_ie", "0");
			diag_led(DIAG, STOP_LED);
		        //If web page configuration is changed, the EZC configuration function should be disabled.(2004-07-29)
			//nvram_set("is_default", "0");
			//nvram_set("is_modified", "1");			
			sys_commit();
		}
	}
	/* Restore defaults */
	else if (!strncmp(value, "Restore", 7)) {
		ACTION("ACT_SW_RESTORE");
		//eval("erase","nvram");
		nvram_set("sv_restore_defaults", "1");
		eval("killall", "-9", "udhcpc");
		sys_commit();
		action = REBOOT;
	}

	/* Reboot */
	else if (!strncmp(value, "Reboot", 7)) {
		action = REBOOT;
		do_ej("index.asp",wp);
		sys_reboot();
		return 1;
	}
	/* Invalid action */
	else
		websDebugWrite(wp, "Invalid action %s<br>", value);


 footer:

	{
		if(!error_value){
			if(websGetVar(wp, "small_screen", NULL))
        			do_ej("Success_s.asp",wp);
			else
        			do_ej("Success.asp",wp);
		}
		else{
			if(websGetVar(wp, "small_screen", NULL))
        			do_ej("Fail_s.asp",wp);
			else
        			do_ej("Fail.asp",wp);
		}
	}

	websDone(wp, 200);

	nvram_set("upnp_wan_proto", "");
	
	/* The will let PC to re-get a new IP Address automatically */
	if(lan_ip_changed || need_reboot)	action = REBOOT;	

	if (action == RESTART)
		sys_restart();
	else if (action == REBOOT)
		sys_reboot();
	else if (action == SERVICE_RESTART)
		service_restart();
	else if (action == SYS_RESTART)
		sys_restart();
	
	sleep(sleep_time);

	return 1;
}

#ifdef WEBS

void
initHandlers(void)
{
	websAspDefine("nvram_get", ej_nvram_get);
	websAspDefine("nvram_match", ej_nvram_match);
	websAspDefine("nvram_invmatch", ej_nvram_invmatch);
	websAspDefine("nvram_list", ej_nvram_list);
	websAspDefine("filter_ip", ej_filter_ip);
	websAspDefine("filter_port", ej_filter_port);
	websAspDefine("forward_port", ej_forward_port);
	websAspDefine("static_route", ej_static_route);
	websAspDefine("localtime", ej_localtime);
	websAspDefine("dumplog", ej_dumplog);
	websAspDefine("dumpleases", ej_dumpleases);
	websAspDefine("ppplink", ej_ppplink);

	websUrlHandlerDefine("/Management.asp", NULL, 0, apply_cgi, 0);
	websUrlHandlerDefine("/internal.cgi", NULL, 0, internal_cgi, 0);
	//DD-WRT addition start

	websUrlHandlerDefine("/modules.cgi", NULL, 0, show_modules, 0);
	//DD-WRT addition end
	websSetPassword(nvram_safe_get("http_passwd"));

	websSetRealm("Broadcom Home Gateway Reference Design");
}

#else /* !WEBS */

static void
do_auth(char *userid, char *passwd, char *realm)
{
	strncpy(userid, nvram_safe_get("http_username"), AUTH_MAX);
	strncpy(passwd, nvram_safe_get("http_passwd"), AUTH_MAX);
	//strncpy(realm, MODEL_NAME, AUTH_MAX);
	strncpy(realm, nvram_safe_get("router_name"), AUTH_MAX);
}

//#ifdef EZC_SUPPORT
char ezc_version[128];
//#endif

char post_buf[10000] = { 0 };
extern int post;

static void	// support GET and POST 2003-08-22
do_apply_post(char *url, webs_t stream, int len, char *boundary)
{
   char buf[1024];
   int count;

   if (post==1) {
        /* Get query */
        if (!(count = wfread(post_buf, 1, len, stream)))
                return;
	post_buf[count] = '\0';;
        len -= strlen(post_buf);

        /* Slurp anything remaining in the request */
        while (len--)
	     if(do_ssl)
#ifdef HAVE_OPENSSL
		     BIO_gets((BIO *)stream,buf,1);
#elif defined(HAVE_MATRIXSSL)
		     matrixssl_gets(stream,buf,1);
#else
;
#endif
	     else
	    	     (void) fgetc(stream);
   }
}

static void do_show_modules(char *url, webs_t stream)
{
show_modules(stream,NULL,NULL,0,url,NULL,NULL);
}
static void do_show_forward(char *url, webs_t stream)
{
show_forward(stream,NULL,NULL,0,url,NULL,NULL);
}

static void
do_apply_cgi(char *url, webs_t stream)
{
	char *path, *query;

        if (post==1) {
                query=post_buf;
                path=url;
        }
        else {
                query=url;
                path = strsep(&query, "?") ? : url;
        }

	if(!query)
		return;	

	init_cgi(query);
	apply_cgi(stream, NULL, NULL, 0, url, path, query);
}


int
ej_get_http_method(int eid, webs_t wp, int argc, char_t **argv)
{
	return websWrite(wp, "%s", "post");
}


static char no_cache[] =
"Cache-Control: no-cache\r\n"
"Pragma: no-cache\r\n"
"Expires: 0"
;

struct mime_handler mime_handlers[] = {
	//{ "ezconfig.asp", "text/html", ezc_version, do_apply_ezconfig_post, do_ezconfig_asp, do_auth },
	{ "Management.asp","text/html", no_cache,NULL,do_show_modules,do_auth},
	{ "Forward.asp","text/html", no_cache,NULL,do_show_forward,do_auth},
	{ "**.sh", "text/html", no_cache,NULL,do_shell_script,do_auth},
	{ "**.asp", "text/html", no_cache, NULL, do_ej,do_auth },
	{ "**.JPG", "image/jpeg", no_cache, NULL, do_file, NULL },
	{ "SysInfo.htm*", "text/plain", no_cache, NULL, do_ej, do_auth },
	{ "Info.htm*", "text/html", no_cache, NULL, do_ej, NULL },
	{ "**.htm", "text/html", no_cache, NULL, do_ej, NULL },
	{ "**.html", "text/html", no_cache, NULL, do_ej, NULL },
	{ "**.css", "text/css", NULL, NULL, do_file, NULL },
	{ "**.gif", "image/gif", NULL, NULL, do_file, NULL },
	{ "**.png", "image/png", NULL, NULL, do_file, NULL },
	{ "**.jpg", "image/jpeg", NULL, NULL, do_file, NULL },
	{ "**.js", "text/javascript", NULL, NULL, do_file, do_auth },
	{ "apply.cgi*", "text/html", no_cache, do_apply_post, do_apply_cgi, do_auth },
	{ "upgrade.cgi*", "text/html", no_cache, do_upgrade_post, do_upgrade_cgi, do_auth },
	{ "Gozila.cgi*", "text/html", no_cache, NULL, do_setup_wizard, do_auth },	// for setup wizard
/*	{ "**.cfg", "application/octet-stream", no_cache, NULL, do_backup, do_auth }, */
	{ "restore.cgi**", "text/html", no_cache, do_upgrade_post, do_upgrade_cgi, do_auth },
	{ "test.bin**", "application/octet-stream", no_cache, NULL, do_file, do_auth },
	{ "test.bin**", "application/octet-stream", no_cache, NULL, do_file, do_auth },
	{ "nvrambak.tgz*", "application/octet-stream", no_cache, NULL, nv_file_out, do_auth },
	{ "nvrambak**.tgz*", "application/octet-stream", no_cache, NULL, nv_file_out, do_auth },
	{ "nvram.cgi*", "text/html", no_cache, nv_file_in, sr_config_cgi, do_auth },	
//for ddm
	{ NULL, NULL, NULL, NULL, NULL, NULL }
};

struct ej_handler ej_handlers[] = {
	/* for all */
	{ "nvram_get", ej_nvram_get },
/*	{ "nvram_get_len", ej_nvram_get_len }, */
	{ "nvram_selget", ej_nvram_selget },
	{ "nvram_match", ej_nvram_match },
	{ "nvram_invmatch", ej_nvram_invmatch },
	{ "nvram_selmatch", ej_nvram_selmatch },
	{ "nvram_else_selmatch", ej_nvram_else_selmatch },
	{ "nvram_else_match", ej_nvram_else_match },
	{ "nvram_list", ej_nvram_list },
	{ "nvram_mac_get", ej_nvram_mac_get },
	{ "nvram_gozila_get", ej_nvram_gozila_get },
	{ "nvram_status_get", ej_nvram_status_get },
	{ "webs_get", ej_webs_get },
	{ "support_match", ej_support_match },
	{ "support_invmatch", ej_support_invmatch },
	{ "support_elsematch", ej_support_elsematch },
	{ "get_firmware_version", ej_get_firmware_version },
	{ "get_firmware_title", ej_get_firmware_title },
	{ "get_model_name", ej_get_model_name },
	{ "get_single_ip", ej_get_single_ip },
	{ "get_single_mac", ej_get_single_mac },
	{ "prefix_ip_get", ej_prefix_ip_get },
	{ "no_cache", ej_no_cache },
	{ "scroll", ej_scroll },
	{ "get_dns_ip", ej_get_dns_ip },
	{ "onload", ej_onload },
	{ "get_web_page_name", ej_get_web_page_name },
	{ "show_logo", ej_show_logo },
	{ "get_clone_mac", ej_get_clone_mac },
	/* for index */
	{ "show_index_setting", ej_show_index_setting },
	{ "compile_date", ej_compile_date },
	{ "compile_time", ej_compile_time },
	{ "get_wl_max_channel", ej_get_wl_max_channel },
	{ "get_wl_domain", ej_get_wl_domain },
	/* for status */
	{ "show_status", ej_show_status },
	{ "show_domain", ej_show_wan_domain },	
	{ "show_status_setting", ej_show_status_setting },
	{ "localtime", ej_localtime },
	{ "dhcp_remaining_time", ej_dhcp_remaining_time },
	/* for dhcp */
	{ "dumpleases", ej_dumpleases },
	/* for ddm */
	/* for log */
	{ "dumplog", ej_dumplog },
	/* for filter */
	{ "filter_init", ej_filter_init },
	{ "filter_summary_show", ej_filter_summary_show },
	{ "filter_ip_get", ej_filter_ip_get },
	{ "filter_port_get", ej_filter_port_get },
	{ "filter_dport_get", ej_filter_dport_get },
	{ "filter_mac_get", ej_filter_mac_get },
	{ "filter_policy_select", ej_filter_policy_select },
	{ "filter_policy_get", ej_filter_policy_get },
	{ "filter_tod_get", ej_filter_tod_get },
	{ "filter_web_get", ej_filter_web_get },
	{ "filter_port_services_get", ej_filter_port_services_get },
	/* for forward */
	{ "port_forward_table", ej_port_forward_table },
	{ "port_trigger_table", ej_port_trigger_table },
	/* for route */
	{ "static_route_table", ej_static_route_table },
	{ "static_route_setting", ej_static_route_setting },
	{ "dump_route_table", ej_dump_route_table },
	/* for ddns */
	{ "show_ddns_status", ej_show_ddns_status },
	{ "show_ddns_ip", ej_show_ddns_ip },
	/* for wireless */
	{ "wireless_active_table", ej_wireless_active_table },
	{ "wireless_filter_table", ej_wireless_filter_table },
	{ "show_wl_wep_setting", ej_show_wl_wep_setting },
	{ "get_wep_value", ej_get_wep_value },
	{ "get_wl_active_mac", ej_get_wl_active_mac },
	{ "get_wl_value", ej_get_wl_value },
	{ "show_wpa_setting", ej_show_wpa_setting },
	/* for test */
	{ "wl_packet_get", ej_wl_packet_get },
	{ "wl_ioctl", ej_wl_ioctl },
	{ "dump_ping_log", ej_dump_ping_log },
	{ "dump_traceroute_log", ej_dump_traceroute_log },
        { "show_sysinfo", ej_show_sysinfo },
        { "show_miscinfo", ej_show_miscinfo },
        { "get_http_method", ej_get_http_method },
/*        { "get_backup_name", ej_get_backup_name }, */
/*	{ "per_port_option", ej_per_port_option}, */
	{ "get_http_prefix", ej_get_http_prefix },
	{ "dump_site_survey", ej_dump_site_survey },
	{ "show_meminfo", ej_show_meminfo },
	{ "get_mtu", ej_get_mtu },
	{ "get_url", ej_get_url },
/* Sveasoft additions */
	{ "get_wdsp2p", ej_get_wdsp2p },
	{ "active_wireless", ej_active_wireless },
	{ "active_wds", ej_active_wds },
	{ "get_wds_mac", ej_get_wds_mac },
	{ "get_wds_ip", ej_get_wds_ip },
	{ "get_wds_netmask", ej_get_wds_netmask },
	{ "get_wds_gw", ej_get_wds_gw },
	{ "get_br1_ip", ej_get_br1_ip },
	{ "get_br1_netmask", ej_get_br1_netmask },
	{ "get_curchannel", ej_get_curchannel },
	{ "get_currate", ej_get_currate },
	{ "get_uptime", ej_get_uptime },
	{ "get_qossvcs", ej_get_qossvcs},
	{ "get_qosips", ej_get_qosips},
	{ "get_qosmacs", ej_get_qosmacs},
	{ "get_services_options", ej_get_services_options},
	{ "get_clone_wmac", ej_get_clone_wmac },
/* end Sveasoft additions */

/* lonewolf additions */
	{ "port_vlan_table", ej_port_vlan_table },
/* end lonewolf additions */

	{ NULL, NULL }
};
#endif /* !WEBS */

