<!--
*********************************************************
*   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
*********************************************************

This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
the contents of this file may not be disclosed to third parties,
copied or duplicated in any form without the prior written
permission of CyberTAN Inc.

This software should be used as a reference only, and it not
intended for production use!


THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
-->
<html>

<head>
<title><% nvram_get("router_name"); %> - Setup</title>
<% no_cache(); %>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" type="text/css" href="style.css">
<style fprolloverstyle>
A:hover {color: #00FFFF}
.small A:hover {color: #00FFFF}
</style>
<script src="common.js"></script>
<script language="JavaScript">
var EN_DIS2 = '<% nvram_get("mtu_enable"); %>';
var wan_proto = '<% nvram_get("wan_proto"); %>';
var dhcp_win = null;

function valid_mtu(I)
{
	var start = null;
	var end = null;
	if(wan_proto == "pppoe"){
		start = 576;
		end = 1492;
	}
	else if(wan_proto == "pptp" || wan_proto == "l2tp") {
		start = 1200;
                end = 1400;
	}
	else{
		start = 576;
		end = 1500;
	}

	valid_range(I,start,end,"MTU");
}
function SelMTU(num,F)
{
	mtu_enable_disable(F,num);
}
function mtu_enable_disable(F,I)
{
	EN_DIS1 = I;
	if ( I == "0" ){
		choose_disable(F.wan_mtu);
	}
	else{
		choose_enable(F.wan_mtu);
	}
}


function SelWAN(num,F)
{
        F.submit_button.value = "index";
        F.change_action.value = "gozila_cgi";
        F.wan_proto.value=F.wan_proto.options[num].value;
        F.submit();
}

function SelPPP(num,F)
{
        F.submit_button.value = "index";
        F.change_action.value = "gozila_cgi";
        F.mpppoe_enable.value = F.mpppoe_enable.options[num].value;
        F.submit();
}

function to_submit(F)
{
	if(valid_value(F)){
		if(F._daylight_time.checked == false)
			F.daylight_time.value = 0;
		else
			F.daylight_time.value = 1;
 
		F.submit_button.value = "index";
		F.action.value = "Apply";
        	F.submit();
	}
}
function valid_value(F)
{
	if(F.now_proto.value == "pptp" || F.now_proto.value == "static"){

		pptp_dhcp = "";

		// Sveasoft: allow 0.0.0.0 for pptp. We'll let DHCP take care of it.
		if (F.now_proto.value == "pptp" &&
		    F.wan_ipaddr_0.value == "0" && F.wan_ipaddr_1.value == "0" && F.wan_ipaddr_2.value == "0" && F.wan_ipaddr_3.value == "0")
			pptp_dhcp = "skip";

		if(pptp_dhcp != "skip" && !valid_ip(F,"F.wan_ipaddr","IP",ZERO_NO|MASK_NO))
                        return false;

		if(pptp_dhcp != "skip" && !valid_mask(F,"F.wan_netmask",ZERO_NO|BCST_NO))
			return false;

		if(F.now_proto.value == "static"){
			if(!valid_ip(F,"F.wan_gateway","Gateway",ZERO_NO|MASK_NO))
              		  	return false;
		}

		if(pptp_dhcp != "skip" && F.now_proto.value == "pptp"){
			if(!valid_ip(F,"F.pptp_server_ip","Gateway",ZERO_NO|MASK_NO))
                		return false;
			if(!valid_ip_gw(F,"F.wan_ipaddr","F.wan_netmask","F.pptp_server_ip"))
				return false;
		}

	}
	if(F.now_proto.value == "pppoe" || F.now_proto.value == "pptp" || F.now_proto.value == "l2tp"){
		if(F.ppp_username.value == ""){
			alert("You must input a username!");
			F.ppp_username.focus();
			return false;
		}
		//if(F.ppp_passwd.value == ""){
		//	alert("You must input a passwd!");
		//	F.ppp_passwd.focus();
		//	return false;
		//}
	}

	if(!valid_dhcp_server(F))
		return false;

	if(F.router_name.value == ""){
		alert("You must input a Router Name!");
                F.router_name.focus();
                return false;
	}

	return true;
}
function valid_dhcp_server(F)
{
	if(F.lan_proto.selectedIndex == 0)
                return true;

        a1 = parseInt(F.dhcp_start.value,10);
        a2 = parseInt(F.dhcp_num.value,10);
        if(a1 + a2 > 255){
                alert("Out of range, please adjust start IP address or user's numbers.");
                return false;
        }

        if(!valid_ip(F,"F.wan_dns0","DNS",MASK_NO))
                return false;
        if(!valid_ip(F,"F.wan_dns1","DNS",MASK_NO))
                return false;
        if(!valid_ip(F,"F.wan_dns2","DNS",MASK_NO))
                return false;
        if(!valid_ip(F,"F.wan_wins","WINS",MASK_NO))
                return false;

	return true;
}
function SelDHCP(T,F)
{
	dhcp_enable_disable(F,T);
}

function dhcp_enable_disable(F,T)
{
	var start = '';
	var end = '';
 	var total = F.elements.length;
	for(i=0 ; i < total ; i++){
		if(F.elements[i].name == "dhcp_start")	start = i;
		if(F.elements[i].name == "wan_wins_3")	end = i;
	}
	if(start == '' || end == '')	return true;

	if( T == "static" ) {
		EN_DIS = 0;
		for(i = start; i<=end ;i++)
			choose_disable(F.elements[i]);
	}
	else {
		EN_DIS = 1;
		for(i = start; i<=end ;i++)
			choose_enable(F.elements[i]);
	}
}
function SelTime(num,f)
{
	aaa = f.time_zone.options[num].value.charAt(6);
	daylight_enable_disable(f,aaa);
}

function ppp_enable_disable(F,I)
{
	if( I == "0"){
		choose_disable(F.ppp_idletime);
		choose_enable(F.ppp_redialperiod);
	}
	else{
		choose_enable(F.ppp_idletime);
		choose_disable(F.ppp_redialperiod);
	}
}
function daylight_enable_disable(F,aaa)
{
	if(aaa == 0){
                F._daylight_time.checked = false;
                choose_disable(F._daylight_time);
                F.daylight_time.value = 0;
        }
        else{
                choose_enable(F._daylight_time);                
                F._daylight_time.checked = true;
                F.daylight_time.value = 1;
        }

}
function init()
{
	mtu_enable_disable(document.setup,'<% nvram_get("mtu_enable"); %>');
	aaa = document.setup.time_zone.options[document.setup.time_zone.selectedIndex].value.charAt(6);
	if(aaa == 0){
                document.setup._daylight_time.checked = false;
                choose_disable(document.setup._daylight_time);
                document.setup.daylight_time.value = 0;
        }

	if(document.setup.now_proto.value == "pppoe" || document.setup.now_proto.value == "pptp" || document.setup.now_proto.value == "l2tp" || document.setup.now_proto.value == "heartbeat")
		ppp_enable_disable(document.setup,'<% nvram_get("ppp_demand"); %>');

	dhcp_enable_disable(document.setup,'<% nvram_get("lan_proto"); %>');

}
</script>
</head>

<body onload="init()">

<div align="center">
	<form name="setup" method="<% get_http_method(); %>" action="apply.cgi">
		<input type="hidden" name="submit_button">
		<input type="hidden" name="change_action">
		<input type="hidden" name="submit_type">
		<input type="hidden" name="action">
		<input type="hidden" name="now_proto" value="<% nvram_gozila_get("wan_proto"); %>">
		<input type="hidden" name="daylight_time" value="0">
		<input type="hidden" name="lan_ipaddr" value="4">
		<table cellspacing="0" cellpadding="0" width="809" border="0">
			<tr>
				<td width="95">
				<img src="image/UI_Linksys.gif" border="0" width="165" height="57"></td>
				<td valign="bottom" align="right" width="714" bgcolor="#6666cc">
				<font style="FONT-SIZE: 7pt"><font face="Arial">
				<font color="#AAAAAA"><br>
				Firmware version: </font><font color="#FFFFFF"><% get_firmware_version(); %>&nbsp;&nbsp;
				</font></font></font></td>
			</tr>
			<tr>
				<td width="808" bgcolor="#6666cc" colspan="2">
				<img height="11" src="image/UI_10.gif" width="809" border="0"></td>
			</tr>
		</table>
		<table height="77" cellspacing="0" cellpadding="0" width="809" bgcolor="black" border="0">
			<tr>
				<td style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" bordercolor="#000000" align="middle" width="163" height="49">
				<h3 style="MARGIN-TOP: 1px; MARGIN-BOTTOM: 1px">
				<font style="FONT-SIZE: 15pt" face="Arial" color="#ffffff">Setup</font></h3>
				</td>
				<td style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" valign="center" bordercolor="#000000" width="646" bgcolor="#000000" height="49">
				<table style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; BORDER-COLLAPSE: collapse; FONT-VARIANT: normal" height="33" cellspacing="0" cellpadding="0" bgcolor="#6666cc" border="0">
					<tr>
						<td style="FONT-WEIGHT: bolder; FONT-SIZE: 10pt" align="right" bgcolor="#6666cc" height="33">
						<font color="#ffffff">Wireless-G Broadband Router&nbsp;
						</font></td>
						<td bordercolor="#000000" bordercolorlight="#000000" align="middle" width="109" bgcolor="#000000" bordercolordark="#000000" height="12" rowspan="2">
						<font color="#ffffff"><span style="FONT-SIZE: 8pt"><b><% nvram_get("router_name"); %></b></span></font></td>
					</tr>
					<tr>
						<td style="FONT-WEIGHT: normal; FONT-SIZE: 1pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" width="537" bgcolor="#000000" height="1">&nbsp;</td>
					</tr>
					<tr>
						<td width="646" bgcolor="#000000" colspan="2" height="32">
						<table id="AutoNumber1" style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; BORDER-COLLAPSE: collapse; FONT-VARIANT: normal" height="6" cellspacing="0" cellpadding="0" width="637" border="0">
							<tr style="BORDER-RIGHT: medium none; BORDER-TOP: medium none; FONT-WEIGHT: normal; FONT-SIZE: 1pt; BORDER-LEFT: medium none; COLOR: black; BORDER-BOTTOM: medium none; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" align="middle" bgcolor="#6666cc">
								<td width="83" height="1">
								<img height="10" src="image/UI_07.gif" width="83" border="0"></td>
								<td width="73" height="1">
								<img height="10" src="image/UI_06.gif" width="83" border="0"></td>
								<td width="113" height="1">
								<img height="10" src="image/UI_06.gif" width="83" border="0"></td>
								<td width="103" height="1">
								<img height="10" src="image/UI_06.gif" width="103" border="0"></td>
								<td width="85" height="1">
								<img height="10" src="image/UI_06.gif" width="100" border="0"></td>
								<td width="115" height="1">
								<img height="10" src="image/UI_06.gif" width="115" border="0"></td>
								<td width="74" height="1">
								<img height="10" src="image/UI_06.gif" width="79" border="0"></td>
							</tr>
							<tr>
								<td align="middle" bgcolor="#6666cc" height="20">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="index.asp">
								Setup</a></font></td>
								<td align="middle" bgcolor="#000000" height="20">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="Wireless_Basic.asp">
								Wireless</a></font></td>
								<td align="middle" bgcolor="#000000" height="20">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="Firewall.asp">
								Security</a></font></td>
								<td align="middle" bgcolor="#000000" height="20">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="<% support_elsematch("PARENTAL_CONTROL_SUPPORT", "1", "Parental_Control.asp", "Filters.asp"); %>">
								Access Restrictions</a></font></td>
								<td align="middle" bgcolor="#000000" height="20">
								<p style="MARGIN-BOTTOM: 4px">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="Forward.asp">
								Applications <br>
								&amp; Gaming</a>&nbsp;&nbsp;&nbsp; </font></p>
								</td>
								<td align="middle" bgcolor="#000000" height="20">
								<p style="MARGIN-BOTTOM: 4px">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="Management.asp">
								Administration</a>&nbsp;&nbsp;&nbsp; </font></p>
								</td>
								<td align="middle" bgcolor="#000000" height="20">
								<p style="MARGIN-BOTTOM: 4px">
								<font style="FONT-WEIGHT: 700" color="#ffffff">
								<a style="TEXT-DECORATION: none" href="Status_Router.asp">
								Status</a>&nbsp;&nbsp;&nbsp; </font></p>
								</td>
							</tr>
							<tr>
								<td width="643" bgcolor="#6666cc" colspan="7" height="21">
								<table bordercolor="black" height="21" cellspacing="0" cellpadding="0" width="558">
									<tr align="left">
										<td width="30"></td>
										<td class="small" width="135">
										<font style="COLOR: white">Basic Setup</font></td>
										<td>
										<p class="bar"><font color="white"><b>|</b></font></p>
										</td>
										<td width="30"></td>
										<td class="small" width="50">
										<a href="DDNS.asp">DDNS</a></td>
										<td>
										<p class="bar"><font color="white"><b>|</b></font></p>
										</td>
										<td width="30"></td>
										<td class="small" width="180">
										<a href="WanMAC.asp">MAC Address Clone</a></td>
										<td>
										<p class="bar"><font color="white"><b>|</b></font></p>
										</td>
										<td width="30"></td>
										<td class="small" width="160">
										<a href="Routing.asp">Advanced Routing</a></td>
										<td>
										<p class="bar"><font color="white"><b>|</b></font></p>
										</td>
										<td width="30"></td>
										<td class="small" width="60">
										<a href="Vlan.asp">VLANs</a></td>
										</tr>
								</table>
								</td>
							</tr>
						</table>
						</td>
					</tr>
				</table>
				</td>
			</tr>
		</table>
		<table height="5" cellspacing="0" cellpadding="0" width="806" bgcolor="black" border="0">
			<tr bgcolor="black">
				<td style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" bordercolor="#e7e7e7" width="163" bgcolor="#e7e7e7" height="1">
				<img height="15" src="image/UI_03.gif" width="164" border="0"></td>
				<td style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" width="646" height="1">
				<img height="15" src="image/UI_02.gif" width="645" border="0"></td>
			</tr>
		</table>
		<table id="AutoNumber9" style="BORDER-COLLAPSE: collapse" bordercolor="#111111" height="23" cellspacing="0" cellpadding="0" width="809" border="0">
			<tr>
				<td width="633">
				<table cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td align="right" width="156" bgcolor="#000000" colspan="3" height="25">
						<b>
						<font style="FONT-SIZE: 9pt" face="Arial" color="#ffffff">
						<% nvram_match("wl_mode", "ap", "Internet"); %><% nvram_invmatch("wl_mode", "ap", "Wireless"); %> 
						Setup</font></b></td>
						<td width="8" bgcolor="#000000" height="25">&nbsp;</td>
						<td width="14" height="25">&nbsp;</td>
						<td width="17" height="25">&nbsp;</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="101" height="25">&nbsp;</td>
						<td width="296" height="25">&nbsp;</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#e7e7e7" colspan="3" height="1">
						<b>Internet Connection Type</b></td>
						<td width="8" background="image/UI_04.gif" height="1">&nbsp;</td>
						<td colspan="6">
						<table>
							<tr>
								<td width="16" height="1">&nbsp;</td>
								<td width="28" height="1">&nbsp;</td>
								<td width="396" colspan="3" height="1">
								<select name="wan_proto" onchange="SelWAN(this.form.wan_proto.selectedIndex,this.form)">
								<option value="disabled" <% nvram_selmatch("wan_proto", "disabled", "selected"); %>>
								Disable</option>
								<option value="dhcp" <% nvram_selmatch("wan_proto", "dhcp", "selected"); %>>
								Automatic Configuration - DHCP</option>
								<option value="static" <% nvram_selmatch("wan_proto", "static", "selected"); %>>
								Static IP</option>
								<option value="pppoe" <% nvram_selmatch("wan_proto", "pppoe", "selected"); %>>
								PPPoE</option>
								<option value="pptp" <% nvram_selmatch("wan_proto", "pptp", "selected"); %>>
								PPTP</option>
								<option value="l2tp" <% nvram_selmatch("wan_proto", "l2tp", "selected"); %>>
								L2TP</option>
								<option value="heartbeat" <% nvram_selmatch("wan_proto", "heartbeat", "selected"); %>>
								HeartBeat Signal</option>
								</select></td>
								<td width="15">&nbsp;</td>
							</tr>
						</table>
						</td>
						<td width="15" background="image/UI_05.gif" height="1">&nbsp;</td>
					</tr>
					<% show_index_setting(); %>
					<tr>
						<td width="153" bgcolor="#e7e7e7" colspan="3" height="25">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25" width="41">&nbsp;</td>
						<td width="100" height="25">
						<span style="FONT-SIZE: 8pt">&nbsp;</span><span lang="zh-tw" style="FONT-SIZE: 8pt">STP:</span></td>
						<td width="298" height="25">
						<table id="AutoNumber12" cellspacing="0" cellpadding="0" width="242" border="0">
							<tr>
								<td width="242" height="25">
								<input type="radio" value="1" name="lan_stp" <% nvram_match("lan_stp","1","checked"); %>><b>Enable</b>&nbsp;&nbsp;
								<input type="radio" value="0" name="lan_stp" <% nvram_match("lan_stp","0","checked"); %>>
								<b>Disable<br>
								</b>(disable for COMCAST ISP)</td>
							</tr>
						</table>
						</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="1">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="1">&nbsp;</td>
						<td colspan="6">
						<table>
							<tr>
								<td width="16" height="1">&nbsp;</td>
								<td width="13" height="1">&nbsp;</td>
								<td width="410" colspan="3" height="1">
								<hr color="#b5b5e6" size="1"></td>
								<td width="15" height="1">&nbsp;</td>
							</tr>
						</table>
						</td>
						<td width="15" background="image/UI_05.gif" height="1">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						<p align="right"><font style="FONT-WEIGHT: 700"><b>Optional 
						Settings</b><br>
						<b>(required by some ISPs)</b></font></p>
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Router Name:
						</font></td>
						<td width="296" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">
						<input maxlength="39" name="router_name" size="20" value="<% nvram_get("router_name"); %>" onblur="valid_name(this,&quot;Router%20Name&quot;)"></font></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Host Name:
						</font></td>
						<td width="296" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">
						<input maxlength="39" name="wan_hostname" size="20" value="<% nvram_get("wan_hostname"); %>" onblur="valid_name(this,&quot;Host%20Name&quot;)"></font></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Domain Name:
						</font></td>
						<td width="296" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">
						<input maxlength="79" name="wan_domain" size="20" value="<% nvram_get("wan_domain"); %>" onblur="valid_name(this,&quot;Domain%20name&quot;,SPACE_NO)"></font></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;MTU:</font></td>
						<td width="296" height="25"><b>
						<select name="mtu_enable" onchange="SelMTU(this.form.mtu_enable.selectedIndex,this.form)">
						<option value="0" <% nvram_match("mtu_enable", "0", "selected"); %>>
						<b>Auto</b></option>
						<option value="1" <% nvram_match("mtu_enable", "1", "selected"); %>>
						<b>Manual </b></option>
						</select></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;</font>Size:</td>
						<td width="296" height="25">
						<input class="num" maxlength="4" onblur="valid_mtu(this)" size="5" value="<% nvram_get("wan_mtu"); %>" name="wan_mtu"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="1">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="1">&nbsp;</td>
						<td colspan="6">
						<table>
							<tr>
								<td width="16" height="1">&nbsp;</td>
								<td width="13" height="1">&nbsp;</td>
								<td width="410" colspan="3" height="1">
								<hr color="#b5b5e6" size="1"></td>
								<td width="15" height="1">&nbsp;</td>
							</tr>
						</table>
						</td>
						<td width="15" background="image/UI_05.gif" height="1">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#000000" colspan="3" height="25">
						<b>
						<font style="FONT-SIZE: 9pt" face="Arial" color="#ffffff">
						Network Setup</font></b></td>
						<td width="8" bgcolor="#000000" height="25">&nbsp;</td>
						<td width="14" height="25">&nbsp;</td>
						<td width="17" height="25">&nbsp;</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="101" height="25">&nbsp;</td>
						<td width="296" height="25">&nbsp;</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						<b>Router IP</b></td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">&nbsp;Local IP Address:</td>
						<td width="296" height="25">
						<input class="num" maxlength="3" onblur="valid_range(this,1,223,&quot;IP&quot;)" size="3" value="<% get_single_ip("lan_ipaddr","0"); %>" name="lan_ipaddr_0"> 
						.
						<input class="num" maxlength="3" onblur="valid_range(this,0,255,&quot;IP&quot;)" size="3" value="<% get_single_ip("lan_ipaddr","1"); %>" name="lan_ipaddr_1"> 
						.
						<input class="num" maxlength="3" onblur="valid_range(this,0,255,&quot;IP&quot;)" size="3" value="<% get_single_ip("lan_ipaddr","2"); %>" name="lan_ipaddr_2"> 
						.
						<input class="num" maxlength="3" onblur="valid_range(this,1,254,&quot;IP&quot;)" size="3" value="<% get_single_ip("lan_ipaddr","3"); %>" name="lan_ipaddr_3"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Subnet Mask:</font></td>
						<td width="296" height="25">
						<select class="num" size="1" name="lan_netmask">
						<option value="255.255.255.0" <% nvram_match("lan_netmask", "255.255.255.0", "selected"); %>>
						255.255.255.0</option>
						<option value="255.255.255.128" <% nvram_match("lan_netmask", "255.255.255.128", "selected"); %>>
						255.255.255.128</option>
						<option value="255.255.255.192" <% nvram_match("lan_netmask", "255.255.255.192", "selected"); %>>
						255.255.255.192</option>
						<option value="255.255.255.224" <% nvram_match("lan_netmask", "255.255.255.224", "selected"); %>>
						255.255.255.224</option>
						<option value="255.255.255.240" <% nvram_match("lan_netmask", "255.255.255.240", "selected"); %>>
						255.255.255.240</option>
						<option value="255.255.255.248" <% nvram_match("lan_netmask", "255.255.255.248", "selected"); %>>
						255.255.255.248</option>
						<option value="255.255.255.252" <% nvram_match("lan_netmask", "255.255.255.252", "selected"); %>>
						255.255.255.252</option>
						</select></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Gateway:</font></td>
						<td width="296" height="25">
						<input type="hidden" name="lan_gateway" value="4">
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("lan_gateway","0"); %>" name="lan_gateway_0" onblur="valid_range(this,0,255,&quot;IP&quot;)"> 
						.
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("lan_gateway","1"); %>" name="lan_gateway_1" onblur="valid_range(this,0,255,&quot;IP&quot;)"> 
						.
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("lan_gateway","2"); %>" name="lan_gateway_2" onblur="valid_range(this,0,255,&quot;IP&quot;)"> 
						.
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("lan_gateway","3"); %>" name="lan_gateway_3" onblur="valid_range(this,0,254,&quot;IP&quot;)">
						</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Local DNS:</font></td>
						<td width="296" height="25">
						<input type="hidden" name="sv_localdns" value="4">
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("sv_localdns","0"); %>" name="sv_localdns_0" onblur="valid_range(this,0,255,&quot;IP&quot;)"> 
						.
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("sv_localdns","1"); %>" name="sv_localdns_1" onblur="valid_range(this,0,255,&quot;IP&quot;)"> 
						.
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("sv_localdns","2"); %>" name="sv_localdns_2" onblur="valid_range(this,0,255,&quot;IP&quot;)"> 
						.
						<input class="num" maxlength="3" size="3" value="<% get_single_ip("sv_localdns","3"); %>" name="sv_localdns_3" onblur="valid_range(this,0,254,&quot;IP&quot;)">
						</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="1">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="1">&nbsp;</td>
						<td colspan="6">
						<table>
							<tr>
								<td width="16" height="1">&nbsp;</td>
								<td width="13" height="1">&nbsp;</td>
								<td width="410" colspan="3" height="1">
								<hr color="#b5b5e6" size="1"></td>
								<td width="15" height="1">&nbsp;</td>
							</tr>
						</table>
						</td>
						<td width="15" background="image/UI_05.gif" height="1">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						<b>Network Address</b><br>
						<b>Server Settings (DHCP)</b></td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">&nbsp;DHCP Server:</td>
						<td width="296" height="25">
						<input type="radio" name="lan_proto" value="dhcp" <% nvram_selmatch("lan_proto", "dhcp", "checked"); %> onclick="SelDHCP('dhcp',this.form)"><b><span>Enable</span></b>
						<input type="radio" name="lan_proto" value="static" <% nvram_selmatch("lan_proto", "static", "checked"); %> onclick="SelDHCP('static',this.form)"><b><span>Disable</span></b></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<input type="hidden" name="dhcp_check">
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Starting 
						IP Address:</font></td>
						<td width="296" height="25">&nbsp;<b><% prefix_ip_get("lan_ipaddr",1); %></b><b><input maxlength="3" onblur="valid_range(this,1,254,&quot;DHCP%20starting%20IP&quot;)" size="3" value="<% nvram_get("dhcp_start"); %>" name="dhcp_start" class="num"></b></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Maximum 
						Number of&nbsp; DHCP Users:</font></td>
						<td width="296" height="25">&nbsp;<input maxlength="3" onblur="valid_range(this,1,253,&quot;Number%20of%20DHCP%20users&quot;)" size="3" value="<% nvram_get("dhcp_num"); %>" name="dhcp_num" class="num"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Client Lease 
						Time:</font></td>
						<td width="296" height="25">&nbsp;<input maxlength="4" onblur="valid_range(this,0,9999,&quot;DHCP%20Lease%20Time&quot;)" size="4" value="<% nvram_get("dhcp_lease"); %>" name="dhcp_lease" class="num"> 
						minutes</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<% nvram_selmatch("wan_proto","static","<!--"); %>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Static DNS 
						1: </font></td>
						<td width="296" height="25">&nbsp;<input type="hidden" name="wan_dns" value="4"><input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","0","0"); %>" name="wan_dns0_0" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","0","1"); %>" name="wan_dns0_1" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","0","2"); %>" name="wan_dns0_2" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,254,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","0","3"); %>" name="wan_dns0_3" class="num"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Static DNS 
						2: </font></td>
						<td width="296" height="25">&nbsp;<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","1","0"); %>" name="wan_dns1_0" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","1","1"); %>" name="wan_dns1_1" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","1","2"); %>" name="wan_dns1_2" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,254,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","1","3"); %>" name="wan_dns1_3" class="num"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;Static DNS 
						3: </font></td>
						<td width="296" height="25">&nbsp;<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","2","0"); %>" name="wan_dns2_0" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","2","1"); %>" name="wan_dns2_1" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","2","2"); %>" name="wan_dns2_2" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,254,&quot;DNS&quot;)" size="3" value="<% get_dns_ip("wan_dns","2","3"); %>" name="wan_dns2_3" class="num"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<% nvram_selmatch("wan_proto","static","-->"); %>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">
						<font style="FONT-SIZE: 8pt" face="Arial">&nbsp;WINS:
						</font></td>
						<td width="296" height="25">&nbsp;<input type="hidden" name="wan_wins" value="4"><input maxlength="3" onblur="valid_range(this,0,255,&quot;WINS&quot;)" size="3" value="<% get_single_ip("wan_wins","0"); %>" name="wan_wins_0" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;WINS&quot;)" size="3" value="<% get_single_ip("wan_wins","1"); %>" name="wan_wins_1" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,255,&quot;WINS&quot;)" size="3" value="<% get_single_ip("wan_wins","2"); %>" name="wan_wins_2" class="num"> 
						.
						<input maxlength="3" onblur="valid_range(this,0,254,&quot;WINS&quot;)" size="3" value="<% get_single_ip("wan_wins","3"); %>" name="wan_wins_3" class="num"></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="156" bgcolor="#e7e7e7" colspan="3" height="1">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="1">&nbsp;</td>
						<td colspan="6">
						<table>
							<tr>
								<td width="16" height="1">&nbsp;</td>
								<td width="13" height="1">&nbsp;</td>
								<td width="410" colspan="3" height="1">
								<hr color="#b5b5e6" size="1"></td>
								<td width="15" height="1">&nbsp;</td>
							</tr>
						</table>
						</td>
						<td width="15" background="image/UI_05.gif" height="1">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						<b>Time Setting</b></td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="101" height="25">&nbsp;Time Zone:</td>
						<td width="296" height="25">&nbsp;</td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="397" height="25" colspan="2">&nbsp;<select name="time_zone" onchange="SelTime(this.form.time_zone.selectedIndex,this.form)">
						<option value="-12 1 0" <% nvram_match("time_zone", "-12 1 0", "selected"); %>>
						(GMT-12:00) Kwajalein</option>
						<option value="-11 1 0" <% nvram_match("time_zone", "-11 1 0", "selected"); %>>
						(GMT-11:00) Midway Island, Samoa</option>
						<option value="-10 1 0" <% nvram_match("time_zone", "-10 1 0", "selected"); %>>
						(GMT-10:00) Hawaii</option>
						<option value="-09 1 1" <% nvram_match("time_zone", "-09 1 1", "selected"); %>>
						(GMT-09:00) Alaska</option>
						<option value="-08 1 1" <% nvram_match("time_zone", "-08 1 1", "selected"); %>>
						(GMT-08:00) Pacific Time (USA &amp; Canada)</option>
						<option value="-07 1 0" <% nvram_match("time_zone", "-07 1 0", "selected"); %>>
						(GMT-07:00) Arizona</option>
						<option value="-07 2 1" <% nvram_match("time_zone", "-07 2 1", "selected"); %>>
						(GMT-07:00) Mountain Time (USA &amp; Canada)</option>
						<option value="-06 1 0" <% nvram_match("time_zone", "-06 1 0", "selected"); %>>
						(GMT-06:00) Mexico</option>
						<option value="-06 2 1" <% nvram_match("time_zone", "-06 2 1", "selected"); %>>
						(GMT-06:00) Central Time (USA &amp; Canada)</option>
						<option value="-05 1 0" <% nvram_match("time_zone", "-05 1 0", "selected"); %>>
						(GMT-05:00) Indiana East, Colombia, Panama</option>
						<option value="-05 2 1" <% nvram_match("time_zone", "-05 2 1", "selected"); %>>
						(GMT-05:00) Eastern Time (USA &amp; Canada)</option>
						<option value="-04 1 0" <% nvram_match("time_zone", "-04 1 0", "selected"); %>>
						(GMT-04:00) Bolivia, Venezuela</option>
						<option value="-04 2 1" <% nvram_match("time_zone", "-04 2 1", "selected"); %>>
						(GMT-04:00) Atlantic Time (Canada), Brazil West</option>
						<option value="-03.5 1 1" <% nvram_match("time_zone", "-03.5 1 1", "selected"); %>>
						(GMT-03:30) Newfoundland</option>
						<option value="-03 1 0" <% nvram_match("time_zone", "-03 1 0", "selected"); %>>
						(GMT-03:00) Guyana</option>
						<option value="-03 2 1" <% nvram_match("time_zone", "-03 2 1", "selected"); %>>
						(GMT-03:00) Brazil East, Greenland</option>
						<option value="-02 1 0" <% nvram_match("time_zone", "-02 1 0", "selected"); %>>
						(GMT-02:00) Mid-Atlantic</option>
						<option value="-01 1 2" <% nvram_match("time_zone", "-01 1 2", "selected"); %>>
						(GMT-01:00) Azores</option>
						<option value="+00 1 0" <% nvram_match("time_zone", "+00 1 0", "selected"); %>>
						(GMT) Gambia, Liberia, Morocco</option>
						<option value="+00 2 2" <% nvram_match("time_zone", "+00 2 2", "selected"); %>>
						(GMT) England</option>
						<option value="+01 1 0" <% nvram_match("time_zone", "+01 1 0", "selected"); %>>
						(GMT+01:00) Tunisia</option>
						<option value="+01 2 2" <% nvram_match("time_zone", "+01 2 2", "selected"); %>>
						(GMT+01:00) France, Germany, Italy</option>
						<option value="+02 1 0" <% nvram_match("time_zone", "+02 1 0", "selected"); %>>
						(GMT+02:00) South Africa</option>
						<option value="+02 2 2" <% nvram_match("time_zone", "+02 2 2", "selected"); %>>
						(GMT+02:00) Greece, Ukraine, Romania, Turkey</option>
						<option value="+03 1 0" <% nvram_match("time_zone", "+03 1 0", "selected"); %>>
						(GMT+03:00) Iraq, Jordan, Kuwait</option>
						<option value="+04 1 0" <% nvram_match("time_zone", "+04 1 0", "selected"); %>>
						(GMT+04:00) Armenia</option>
						<option value="+05 1 0" <% nvram_match("time_zone", "+05 1 0", "selected"); %>>
						(GMT+05:00) Pakistan, Russia</option>
						<option value="+06 1 0" <% nvram_match("time_zone", "+06 1 0", "selected"); %>>
						(GMT+06:00) Bangladesh, Russia</option>
						<option value="+07 1 0" <% nvram_match("time_zone", "+07 1 0", "selected"); %>>
						(GMT+07:00) Thailand, Russia</option>
						<option value="+08 1 0" <% nvram_match("time_zone", "+08 1 0", "selected"); %>>
						(GMT+08:00) China, Hong Kong, Australia Western</option>
						<option value="+08 2 0" <% nvram_match("time_zone", "+08 2 0", "selected"); %>>
						(GMT+08:00) Singapore, Taiwan, Russia</option>
						<option value="+09 1 0" <% nvram_match("time_zone", "+09 1 0", "selected"); %>>
						(GMT+09:00) Japan, Korea</option>
						<option value="+09.5 1 4" <% nvram_match("time_zone", "+09.5 1 4", "selected"); %>>
						(GMT+09:30) Australia Central</option>
						<option value="+10 1 0" <% nvram_match("time_zone", "+10 1 0", "selected"); %>>
						(GMT+10:00) Guam, Russia</option>
						<option value="+10 2 4" <% nvram_match("time_zone", "+10 2 4", "selected"); %>>
						(GMT+10:00) Australia Eastern</option>
						<option value="+11 1 0" <% nvram_match("time_zone", "+11 1 0", "selected"); %>>
						(GMT+11:00) Solomon Islands</option>
						<option value="+12 1 0" <% nvram_match("time_zone", "+12 1 0", "selected"); %>>
						(GMT+12:00) Fiji</option>
						<option value="+12 2 4" <% nvram_match("time_zone", "+12 2 4", "selected"); %>>
						(GMT+12:00) New Zealand</option>
						</select></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td align="right" width="156" bgcolor="#e7e7e7" colspan="3" height="25">
						</td>
						<td width="8" background="image/UI_04.gif" height="25">&nbsp;</td>
						<td colspan="3" height="25">&nbsp;</td>
						<td width="397" height="25" colspan="2">
						<input type="checkbox" value="1" name="_daylight_time" <% nvram_match("daylight_time","1","checked"); %>><font face="Arial" style="font-size: 8pt">Automatically 
						adjust clock for daylight saving changes</font></td>
						<td width="13" height="25">&nbsp;</td>
						<td width="15" background="image/UI_05.gif" height="25">&nbsp;</td>
					</tr>
					<tr>
						<td width="44" bgcolor="#e7e7e7" height="5">&nbsp;</td>
						<td width="65" bgcolor="#e7e7e7" height="5">&nbsp;</td>
						<td width="47" bgcolor="#e7e7e7" height="5">&nbsp;</td>
						<td width="8" background="image/UI_04.gif" height="5">&nbsp;</td>
						<td width="454" colspan="6" height="5"></td>
						<td width="15" background="image/UI_05.gif" height="5">&nbsp;</td>
					</tr>
				</table>
				</td>
				<td valign="top" width="176" bgcolor="#6666cc">
				<table cellspacing="0" cellpadding="0" width="176" border="0">
					<tr>
						<td width="11" bgcolor="#6666cc" height="25">&nbsp;</td>
						<td width="156" bgcolor="#6666cc" height="25">
						<font color="#ffffff"><span style="font-family: Arial;">
						<b><br>
						Automatic Configuration - DHCP : </b>This setting is most 
						commonly used by Cable operators.<br>
						<br>
						<b>Host Name : </b>Enter the host name provided by your 
						ISP.<br>
						<br>
						<b>Domain Name : </b>Enter the domain name provided by your 
						ISP.<br>
						<b><a target="_blank" href="help/HSetup.asp">More...</a></b><br>
						<br>
						<b>Local IP Address : </b>This is the address of the router.<br>
						<br>
						<b>Subnet Mask : </b>This is the subnet mask of the router.<b><br>
						<br>
						DHCP Server : </b>Allows the router to manage your IP addresses.<br>
						<br>
						<b>Starting IP Address : </b>The address you would like 
						to start with.<br>
						<br>
						<b>Maximum number of DHCP Users : </b>You may limit the 
						number of addresses your router hands out.<br>
						<b><a target="_blank" href="help/HSetup.asp">More...</a></b><br>
						<br>
						<b>Time Setting : </b>Choose the time zone you are in. The 
						router can also adjust automatically for daylight savings 
						time</font></td>
						<td width="9" bgcolor="#6666cc" height="25">&nbsp;</td>
					</tr>
				</table>
				</td>
			</tr>
			<tr>
				<td width="809" colspan="2">
				<table cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td width="156" bgcolor="#e7e7e7" height="30">&nbsp;</td>
						<td width="8" background="image/UI_04.gif">&nbsp;</td>
						<td width="16">&nbsp;</td>
						<td width="12">&nbsp;</td>
						<td width="411">&nbsp;</td>
						<td width="15"></td>
						<td width="15" background="image/UI_05.gif">&nbsp;</td>
						<td width="176" bgcolor="#6666cc" rowspan="2">
						<img src="image/UI_Cisco.gif" border="0" width="176" height="64"></td>
					</tr>
					<tr>
						<td width="156" bgcolor="#000000">&nbsp;</td>
						<td width="8" bgcolor="#000000">&nbsp;</td>
						<td width="16" bgcolor="#6666cc">&nbsp;</td>
						<td width="12" bgcolor="#6666cc">&nbsp;</td>
						<td width="411" bgcolor="#6666cc">
						<table height="19" cellspacing="0" cellpadding="0" align="right" border="0">
							<tr>
								<td align="middle" width="101"></font>
								<input type="button" value="Save Settings" onclick="to_submit(this.form)"></td>
								<td align="middle" width="8" bgcolor="#6666cc">&nbsp;</td>
								<td align="middle" bgcolor="#6666cc">
								<input type="button" value="Cancel Changes" onclick="window.location.reload()"></td>
							</tr>
						</table>
						</td>
						<td width="15" bgcolor="#6666cc" height="33">&nbsp;</td>
						<td width="15" bgcolor="#000000" height="33">&nbsp;</td>
					</tr>
				</table>
				</td>
			</tr>
		</table>
	</form>
</div>

</body>

</html>
