/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.check_values_local.conf,v 5.1 2003/05/30 23:53:15 hardaker Exp $
 */

/*
    Function from this file are mainly copied from iproute2 project, distrubuted under GPL
    qos_table specific functions are written by Michal Charvat, jaazz@post.cz
    generally I wanted to link libnetlink.a (created by iproute2 package) into snmp daemon,
    but it didn't work well.... I'm not so familiar with library linking.
    what happend when I've tried: compilation and linking ok, but during run relocation error
    occured and program was terminated by kernel.(due to missing functions - but compiler
    didn't say a word about that missing functions ... why????)

*/

/*
 * standard headers
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include "qos_checkfns.h"
#include "qos_enums.h"
#include "qos_checkfns_local.h"
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <asm/types.h>
#include <asm/param.h>
#include <sys/types.h>
#include <resolv.h>
#include <linux/socket.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include "libnetlink.h"
#include "../../../../linux/linux.v23/include/linux/pkt_sched.h"
#include <linux/pkt_cls.h>
#include <syslog.h>
#include <fcntl.h>
#include <net/if_arp.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/uio.h>

#include "ll_map.h"
#include "libnetlink.h"

static int rth_initialized=0;

void add_new_entries_to_table() {
// call dump of netlink qos layer in kernel and adds received object into qos_table 
//(specifically their statistics values & some parts of configuration (htb))
	struct tcmsg t;
	struct rtnl_handle rth;
	extern int rth_initialized;
	char d[16];

	memset(&rth,0,sizeof(struct rtnl_handle));
	memset(&t, 0, sizeof(t));
	t.tcm_family = AF_UNSPEC;
	memset(&d, 0, sizeof(d));
	
	if (rtnl_open(&rth, 0) < 0) {
		snmp_log(LOG_NOTICE, "Cannot open rtnetlink");
		return;
	}

//	if(rth_initialized==0) {
	    ll_init_map(&rth);
//	    rth_initialized=1;
//	}

	if (rtnl_dump_request(&rth, RTM_GETQDISC, &t, sizeof(t)) < 0) {
		snmp_log(LOG_WARNING,"qos-ext: add_new_entries to table: cannot send dump request");
		return;
	}


	if (rtnl_dump_filter(&rth, insert_entry, NULL, NULL, NULL) < 0) {
		snmp_log(LOG_WARNING, "qos-ext: add_new entries to table: qdisc dump terminated");
		return;
	}

	rtnl_close(&rth);

	add_classes();		
}

void add_classes() {
// call dump of classes, these needs to be dumped on per device basis
	struct tcmsg t;
	struct rtnl_handle rth;
	char d[16];

	char line[1024];
	FILE *dev;
	char *p;

	memset(&rth,0,sizeof(struct rtnl_handle));
	memset(&t, 0, sizeof(t));

	t.tcm_family = AF_UNSPEC;
	memset(&d, 0, sizeof(d));
	
	if (rtnl_open(&rth, 0) < 0) {
		snmp_log(LOG_NOTICE, "Cannot open rtnetlink");
		return;
	}


	dev=fopen("/proc/net/dev","r");
	if(dev==NULL) {
	    snmp_log(LOG_WARNING,"qos-ext: cannot open /proc/net/dev for reading, class stats won't be avaiable");
	    return;
	}    
	while(fscanf(dev,"%s",line)!=EOF) {
	//find existing devices
	    p=index(line,':'); if(p==NULL) continue;
	    *p='\0';
	    // line contains device_name.... need to translate name into index
	    t.tcm_ifindex = ll_name_to_index(line);
	
	    if (rtnl_dump_request(&rth, RTM_GETTCLASS, &t, sizeof(t)) < 0) {
		//dump all classes on device with index t.tcm_ifindex
	    	snmp_log(LOG_WARNING,"qos-ext: add_new_entries to table: cannot send dump request");
		fclose(dev);
		return;
	    }
	    if (rtnl_dump_filter(&rth, insert_entry, NULL, NULL, NULL) < 0) {
		//append all classes entris into the internal table
		snmp_log(LOG_WARNING, "qos-ext: add_new entries to table: class dump terminated");
		fclose(dev);
		return;
	    }
	}
	fclose(dev);
	rtnl_close(&rth);
}

int insert_entry(struct sockaddr_nl *who, struct nlmsghdr *n, void *a)
{
	// this function extracts data from netlink message and creates object in qos_table
	extern struct qos_table table;
	qos_table *qos_table_entry;
	qos_table *temp;
	char handle[20]="unset";
	char parent[20]="unset";
	char leaf[20]="leaf";
	char optional[20]="";

	char info[256]="";
	int offset=0;
	//string info 
	
	unsigned int major,minor;
	struct tcmsg *t = NLMSG_DATA(n);
	int len = n->nlmsg_len;
	struct rtattr * tb[TCA_MAX+1];
	char abuf[256];

	len -= NLMSG_LENGTH(sizeof(*t));
	if (len < 0) {
		snmp_log(LOG_NOTICE, "insert_qdisc_entry: Wrong len of tc message:%i", len);
		return(-1);
	}

	memset(tb, 0, sizeof(tb));
	parse_rtattr(tb, TCA_MAX, TCA_RTA(t), len);

	if (tb[TCA_KIND] == NULL) {
		snmp_log(LOG_NOTICE, "insert_qdisc_entry: unknown kind\n");
		return(-1);
	}

	qos_table_entry = create_new_qos_table_entry();
	
	if(qos_table_entry==NULL) {
	    return;
	}

	strcpy(qos_table_entry->data.type,(char*)RTA_DATA(tb[TCA_KIND]));

	qos_table_entry->data.majorhandle = (t->tcm_handle >> 16) & 0x0000ffff;		//major part of handle
	qos_table_entry->data.minorhandle = t->tcm_handle & 0x0000ffff;			//minor part of handle	
	qos_table_entry->data.parent = t->tcm_parent;					//parent

	strcpy(qos_table_entry->data.dev_name, ll_index_to_name(t->tcm_ifindex));
	// sets string qosDeviceName in mib

	set_device_index_and_type(&(qos_table_entry->data.device_index),&(qos_table_entry->data.device_type),qos_table_entry->data.dev_name);
	// function takes string device name as input and separate it to device_index and device_type

	switch(t->tcm_parent) {
	    case TC_H_ROOT:
		strcpy(optional," (root)");
		break;
	    case TC_H_INGRESS:
		strcpy(optional," (ingress)");
		break;
	    default:
	    break;
	}
	minor=t->tcm_parent & 0x0000FFFF;
	major=(t->tcm_parent >> 16) & 0x0000FFFF;   
	sprintf(parent,"%x:%x%s",major,minor,optional);
	strcpy(qos_table_entry->data.text_parent,parent);
	// sets string parent info in mib

	sprintf(info+strlen(info),"%s%s","parent:",parent);
	// one line values reporting
	
	strcpy(optional,"");
	// clear temporary optional variable
		
	switch(t->tcm_handle) {
	    case TC_H_ROOT:
		strcpy(optional," (root)");
		break;
	    case TC_H_INGRESS:
		strcpy(optional," (ingress)");
		break;
	    default:
	    break;
	}
 	minor=t->tcm_handle & 0x0000FFFF;
	major=(t->tcm_handle >> 16) & 0x0000FFFF;   
    	sprintf(handle,"%x:%x%s",major,minor,optional);
	strcpy(qos_table_entry->data.text_handle,handle);
	// sets string handle info in mib
	
	sprintf(info+strlen(info),"%s%s"," handle:",handle);
	// one line values reporting

	if((t->tcm_info >> 16)!=0) {
	    minor=0;
	    major=t->tcm_info >> 16;
	    strcpy(optional," (leaf)");
	    sprintf(leaf,"%x:%x%s",major,minor,optional);
	    strcpy(qos_table_entry->data.text_leaf,leaf);
	    // sets leaf info if any
	    
	    sprintf(info+strlen(info),"%s%s"," leaf:",leaf);
	    // one line values reporting
	}
	
    
	if (tb[TCA_STATS]) {
		if (RTA_PAYLOAD(tb[TCA_STATS]) < sizeof(struct tc_stats))
			snmp_log(LOG_WARNING, "qos-ext: insert into table: statistics truncated\n");
		else {
		    struct tc_stats st;
		    unsigned long long temp;
		    unsigned long long ibytes; // for string info reporting purpose
		    memcpy(&st, RTA_DATA(tb[TCA_STATS]), sizeof(st));
		    ibytes=st.bytes;
		    temp = st.bytes & 0xFFFFFFFF00000000;
		    temp = temp >> 32;
		    temp = (st.bytes << 32) | temp;
		    // this funny action translates from host (x86) representation to network data representation (ASN1)
		    // I know it can be done in one step - but this way it's easy to understand
		    
		    qos_table_entry->data.qosBytes = temp;
		    qos_table_entry->data.qosPackets = st.packets;
		    qos_table_entry->data.qosDropped = st.drops;
		    qos_table_entry->data.qosOverlimit = st.overlimits;
		    qos_table_entry->data.qosBps = st.bps;
		    qos_table_entry->data.qosPps = st.pps;
		    qos_table_entry->data.qosQlen = st.qlen;
		    qos_table_entry->data.qosBacklog = st.backlog;
		    // all standard statistic values
		    // pps/bps value is currently (April 2004) reported only from htb classes
		    
		    sprintf(info+strlen(info),"%s%lli%s%i%s%i%s%i%s%i%s%i%s%i%s%i"," bytes:",ibytes," packets:",st.packets," drops:",st.drops,
			    " overlimit:",st.overlimits," bps:",st.bps," pps:",st.pps," qlen:",st.qlen," backlog:",st.backlog);
		    //one line values reporting (column 35)
		}	
	}
	if (tb[TCA_XSTATS]) {
		if (RTA_PAYLOAD(tb[TCA_XSTATS]) < sizeof(struct xstats)) {
		}
		else {
		    struct xstats st;
		    memcpy(&st,RTA_DATA(tb[TCA_XSTATS]),sizeof(st));
		    //check out, what type of qdisc/class it is and set appropriate values
		    if(strcmp(qos_table_entry->data.type,"red")==0 || strcmp(qos_table_entry->data.type,"gred")==0) {
			qos_table_entry->data.redEarly=st.x1;
			qos_table_entry->data.redPdrop=st.x2;
			qos_table_entry->data.redOther=st.x3;
			qos_table_entry->data.redMarked=st.x4;
			
			sprintf(info+strlen(info),"%s%i%s%i%s%i%s%i"," redearly:",st.x1," redpdrop:",st.x2," redother:",st.x3," redmarked",st.x4);
			//one line values reporting (column 35)
		    }
		    if(strcmp(qos_table_entry->data.type,"cbq")==0) {
			qos_table_entry->data.cbqBorrows=st.x1;
			qos_table_entry->data.cbqOveractions=st.x2;
			qos_table_entry->data.cbqAvgidle=st.x3;
			qos_table_entry->data.cbqUndertime=st.x4;

			sprintf(info+strlen(info),"%s%i%s%i%s%i%s%i"," cbqborrows:",st.x1," cbqoveractions:",st.x2," cbqavgidle:",st.x3," cbqundertime",st.x4);
			//one line values reporting (column 35)
		    }
		    if(strcmp(qos_table_entry->data.type,"htb")==0) {
			struct tc_htb_xstats *st_htb;
			struct rtattr *tb2[TCA_HTB_RTAB+1];
			memset(tb2,0,sizeof(tb2));
			parse_rtattr(tb2,TCA_HTB_RTAB, RTA_DATA(tb[TCA_OPTIONS]),RTA_PAYLOAD(tb[TCA_OPTIONS]));
			// extracts htb specific parameters
			
			st_htb=(struct tc_htb_xstats *)&st;
			qos_table_entry->data.htbLends=st_htb->lends;
			qos_table_entry->data.htbBorrows=st_htb->borrows;
			qos_table_entry->data.htbGiants=st_htb->giants;
			qos_table_entry->data.htbTokens=st_htb->tokens;

			sprintf(info+strlen(info),"%s%i%s%i%s%i%s%i"," htblends:",st_htb->lends," htbborrows:",st_htb->borrows,
				" htbgiants:",st_htb->giants," htbtokens:",st_htb->tokens);
			// one line values reporting (column 35)

			if(RTA_PAYLOAD(tb[TCA_XSTATS]) >= sizeof(*st_htb)) {
    		    	    qos_table_entry->data.htbCTokens=st_htb->ctokens;
			    
			    sprintf(info+strlen(info),"%s%i"," htbctokens:",st_htb->ctokens);
			    // one line values reporting (column 35)

			}
			else {
			    snmp_log(LOG_WARNING,"Ctokens value not avaiable in netlink message\n");
			}

			if(tb2[TCA_HTB_PARMS]) {
			    struct tc_htb_opt *hopt;
			    hopt = RTA_DATA(tb2[TCA_HTB_PARMS]);
			    if(RTA_PAYLOAD(tb2[TCA_HTB_PARMS]) < sizeof(*hopt)) {
				snmp_log(LOG_WARNING,"qos-ext: htb parametrs are not all\n");
			    }
			    else {
				qos_table_entry->data.htbCeil=hopt->ceil.rate;
				qos_table_entry->data.htbRate=hopt->rate.rate;
				qos_table_entry->data.htbPrio=hopt->prio;
				// htb rate, ceil and prio values
			    }
			}
		    }
		}
	}

	strcpy(qos_table_entry->data.info,info);
	// one line values reporting

	temp = get_last_entry_in_list(&table); 
	temp->next = qos_table_entry;
	// add stat structute into linked list
}

void set_device_index_and_type(long *device_index, long *device_type, char *string_device) {
    // takes device name as argument and return 2 values - ex: ppp123 -> ppp & 123 (device type & device index)
    int i=0;
    if(string_device==NULL) {
	// just to be sure
	snmp_log(LOG_WARNING,"qos-ext: set_device_index_and_type: input string is NULL\n");
	*device_index=0;
	*device_type=0;
	return;
    }
    for(i=0;i<DEVICE_COUNT;i++) {
	//finding appropriate device_name
	if(strncmp(devices[i],string_device,strlen(devices[i]))==0) {
	    *device_type=i+1; // +1 because 0.0.0.0 is present everytime - it would otherwise conflit with ppp0 
	    *device_index=atol(string_device+strlen(devices[i]));
	    return;
	}
    }
    snmp_log(LOG_WARNING,"qos-ext: device type not found\n");
    *device_index=0;
    *device_type=0;
}

// futher functions are copied from iproute2 project, because of problems with
// linking libnetlink.a library into snmp daemon
// I've changed only perror calls into snmpd_log calls

void rtnl_close(struct rtnl_handle *rth)
{
	close(rth->fd);
}

int rtnl_open(struct rtnl_handle *rth, unsigned subscriptions)
{
	int addr_len;

	memset(rth, 0, sizeof(rth));

	rth->fd = socket(AF_NETLINK, SOCK_RAW, NETLINK_ROUTE);
	if (rth->fd < 0) {
		snmp_log(LOG_WARNING,"cannot open netlink socket\n");
		return -1;
	}

	memset(&rth->local, 0, sizeof(rth->local));
	rth->local.nl_family = AF_NETLINK;
	rth->local.nl_groups = subscriptions;

	if (bind(rth->fd, (struct sockaddr*)&rth->local, sizeof(rth->local)) < 0) {
//		perror("Cannot bind netlink socket");
		snmp_log(LOG_NOTICE,"cannot bind netlink socket\n");
		return -1;
	}
	addr_len = sizeof(rth->local);
	if (getsockname(rth->fd, (struct sockaddr*)&rth->local, &addr_len) < 0) {
//		perror("Cannot getsockname");
		snmp_log(LOG_NOTICE,"canot getsockname\n");
		return -1;
	}
	if (addr_len != sizeof(rth->local)) {
//		fprintf(stderr, "Wrong address length %d\n", addr_len);
		snmp_log(LOG_NOTICE,"wrong address length\n");
		return -1;
	}
	if (rth->local.nl_family != AF_NETLINK) {
//		fprintf(stderr, "Wrong address family %d\n", rth->local.nl_family);
		snmp_log(LOG_NOTICE,"wrong address family\n");
		return -1;
	}
	rth->seq = time(NULL);
	return 0;
}

int rtnl_dump_request(struct rtnl_handle *rth, int type, void *req, int len)
{
	struct nlmsghdr nlh;
	struct sockaddr_nl nladdr;
	struct iovec iov[2] = { { &nlh, sizeof(nlh) }, { req, len } };
	struct msghdr msg = {
		(void*)&nladdr, sizeof(nladdr),
		iov,	2,
		NULL,	0,
		0
	};

	memset(&nladdr, 0, sizeof(nladdr));
	nladdr.nl_family = AF_NETLINK;

	nlh.nlmsg_len = NLMSG_LENGTH(len);
	nlh.nlmsg_type = type;
	nlh.nlmsg_flags = NLM_F_ROOT|NLM_F_MATCH|NLM_F_REQUEST;
	nlh.nlmsg_pid = 0;
	nlh.nlmsg_seq = rth->dump = ++rth->seq;

	return sendmsg(rth->fd, &msg, 0);
}

int rtnl_wilddump_request(struct rtnl_handle *rth, int family, int type)
{
	struct {
		struct nlmsghdr nlh;
		struct rtgenmsg g;
	} req;
	struct sockaddr_nl nladdr;

	memset(&nladdr, 0, sizeof(nladdr));
	nladdr.nl_family = AF_NETLINK;

	req.nlh.nlmsg_len = sizeof(req);
	req.nlh.nlmsg_type = type;
	req.nlh.nlmsg_flags = NLM_F_ROOT|NLM_F_MATCH|NLM_F_REQUEST;
	req.nlh.nlmsg_pid = 0;
	req.nlh.nlmsg_seq = rth->dump = ++rth->seq;
	req.g.rtgen_family = family;

	return sendto(rth->fd, (void*)&req, sizeof(req), 0, (struct sockaddr*)&nladdr, sizeof(nladdr));
}

int rtnl_dump_filter(struct rtnl_handle *rth,
		     int (*filter)(struct sockaddr_nl *, struct nlmsghdr *n, void *),
		     void *arg1,
		     int (*junk)(struct sockaddr_nl *,struct nlmsghdr *n, void *),
		     void *arg2)
{
	char	buf[8192];
	struct sockaddr_nl nladdr;
	struct iovec iov = { buf, sizeof(buf) };

	while (1) {
		int status;
		struct nlmsghdr *h;

		struct msghdr msg = {
			(void*)&nladdr, sizeof(nladdr),
			&iov,	1,
			NULL,	0,
			0
		};

		status = recvmsg(rth->fd, &msg, 0);

		if (status < 0) {
			if (errno == EINTR)
				continue;
//			perror("OVERRUN");
			snmp_log(LOG_WARNING,"overrun\n");
			continue;
		}
		if (status == 0) {
//			fprintf(stderr, "EOF on netlink\n");
			snmp_log(LOG_NOTICE,"EOF on netlink\n");
			return -1;
		}
		if (msg.msg_namelen != sizeof(nladdr)) {
//			fprintf(stderr, "sender address length == %d\n", msg.msg_namelen);
			snmp_log(LOG_NOTICE,"sender address length\n");
			return(1);
		}

		h = (struct nlmsghdr*)buf;
		while (NLMSG_OK(h, status)) {
			int err;

			if (h->nlmsg_pid != rth->local.nl_pid ||
			    h->nlmsg_seq != rth->dump) {
				if (junk) {
					err = junk(&nladdr, h, arg2);
					if (err < 0)
						return err;
				}
				goto skip_it;
			}

			if (h->nlmsg_type == NLMSG_DONE)
				return 0;
			if (h->nlmsg_type == NLMSG_ERROR) {
				struct nlmsgerr *err = (struct nlmsgerr*)NLMSG_DATA(h);
				if (h->nlmsg_len < NLMSG_LENGTH(sizeof(struct nlmsgerr))) {
//					fprintf(stderr, "ERROR truncated\n");
					snmp_log(LOG_NOTICE,"error struncated\n");
				} else {
					errno = -err->error;
//					perror("RTNETLINK answers");
					snmp_log(LOG_NOTICE,"rtnetlink failed\n");
				}
				return -1;
			}
			err = filter(&nladdr, h, arg1);
			if (err < 0)
				return err;

skip_it:
			h = NLMSG_NEXT(h, status);
		}
		if (msg.msg_flags & MSG_TRUNC) {
//			fprintf(stderr, "Message truncated\n");
			snmp_log(LOG_NOTICE,"message truncated\n");
			continue;
		}
		if (status) {
//			fprintf(stderr, "!!!Remnant of size %d\n", status);
			snmp_log(LOG_NOTICE,"remnant of size\n");
			return(1);
		}
	}
}

int parse_rtattr(struct rtattr *tb[], int max, struct rtattr *rta, int len)
{
	while (RTA_OK(rta, len)) {
		if (rta->rta_type <= max)
			tb[rta->rta_type] = rta;
		rta = RTA_NEXT(rta,len);
	}
	if (len)
//		fprintf(stderr, "!!!Deficit %d, rta_len=%d\n", len, rta->rta_len);
		snmp_log(LOG_WARNING,"deficit of rta_len\n");
	return 0;
}


struct idxmap
{
	struct idxmap * next;
	int		index;
	int		type;
	int		alen;
	unsigned	flags;
	unsigned char	addr[8];
	char		name[16];
};

static struct idxmap *idxmap[16];

int ll_remember_index(struct sockaddr_nl *who, struct nlmsghdr *n, void *arg)
{
	int h;
	struct ifinfomsg *ifi = NLMSG_DATA(n);
	struct idxmap *im, **imp;
	struct rtattr *tb[IFLA_MAX+1];

	if (n->nlmsg_type != RTM_NEWLINK)
		return 0;

	if (n->nlmsg_len < NLMSG_LENGTH(sizeof(ifi)))
		return -1;


	memset(tb, 0, sizeof(tb));
	parse_rtattr(tb, IFLA_MAX, IFLA_RTA(ifi), IFLA_PAYLOAD(n));
	if (tb[IFLA_IFNAME] == NULL)
		return 0;

	h = ifi->ifi_index&0xF;

	for (imp=&idxmap[h]; (im=*imp)!=NULL; imp = &im->next)
		if (im->index == ifi->ifi_index)
			break;

	if (im == NULL) {
		im = malloc(sizeof(*im));
		if (im == NULL)
			return 0;
		im->next = *imp;
		im->index = ifi->ifi_index;
		*imp = im;
	}

	im->type = ifi->ifi_type;
	im->flags = ifi->ifi_flags;
	if (tb[IFLA_ADDRESS]) {
		int alen;
		im->alen = alen = RTA_PAYLOAD(tb[IFLA_ADDRESS]);
		if (alen > sizeof(im->addr))
			alen = sizeof(im->addr);
		memcpy(im->addr, RTA_DATA(tb[IFLA_ADDRESS]), alen);
	} else {
		im->alen = 0;
		memset(im->addr, 0, sizeof(im->addr));
	}
	strcpy(im->name, RTA_DATA(tb[IFLA_IFNAME]));
	return 0;
}

const char *ll_idx_n2a(int idx, char *buf)
{
	struct idxmap *im;

	if (idx == 0)
		return "*";
	for (im = idxmap[idx&0xF]; im; im = im->next)
		if (im->index == idx)
			return im->name;
	snprintf(buf, 16, "if%d", idx);
	return buf;
}


const char *ll_index_to_name(int idx)
{
	static char nbuf[16];

	return ll_idx_n2a(idx, nbuf);
}

int ll_name_to_index(char *name)
{
	static char ncache[16];
	static int icache;
	struct idxmap *im;
	int i;

	if (name == NULL)
		return 0;
	if (icache && strcmp(name, ncache) == 0)
		return icache;
	for (i=0; i<16; i++) {
		for (im = idxmap[i]; im; im = im->next) {
			if (strcmp(im->name, name) == 0) {
				icache = im->index;
				strcpy(ncache, name);
				return im->index;
			}
		}
	}
	return 0;
}

int ll_init_map(struct rtnl_handle *rth)
{
	if (rtnl_wilddump_request(rth, AF_UNSPEC, RTM_GETLINK) < 0) {
//		perror("Cannot send dump request");
		snmp_log(LOG_WARNING,"cannot send dump request\n");
		return(-1);
//		exit(1);
	}

	if (rtnl_dump_filter(rth, ll_remember_index, &idxmap, NULL, NULL) < 0) {
//		fprintf(stderr, "Dump terminated\n");
		snmp_log(LOG_WARNING,"dump terminated\n");
//		exit(1);
		return(-1);
	}
	return 0;
}
