/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.iterate_access.conf,v 1.6 2003/09/29 22:30:36 hardaker Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "qos.h"
#include "qos_checkfns.h"
#include "qos_access.h"

/* 
    As said in first lines, this file is partly autogenerated - functions had to be
    modified to fit needs into my extension - that means that specific function 
    for walking going through qos statistics table in memory are wrriten
    
    Default comments from mib2c compiler are self-explanatory - I was only info 
    I had during developement, so it should be sufficient also to you :-)

*/
struct qos_table table;

static netsnmp_oid_stash_node *undoStorage = NULL;
static netsnmp_oid_stash_node *commitStorage = NULL;

struct undoInfo {
    void           *ptr;
    size_t          len;
};

struct commitInfo {
    void           *data_context;
    int             have_committed;
    int             new_row;
};

void
qos_free_undoInfo(void *vptr)
{
    struct undoInfo *ui = vptr;
    if (!ui)
        return;
    SNMP_FREE(ui->ptr);
    SNMP_FREE(ui);
}

/** Initialize the qosObjectTable table by defining its contents and how it's structured */
void
initialize_table_qosObjectTable(void)
{
    static oid      qosObjectTable_oid[] = { 1, 3, 6, 1, 4, 1, 18756, 1 };
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /** create the table registration information structures */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /** if your table is read only, it's easiest to change the
        HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("qosObjectTable",
                                                     qosObjectTable_handler,
                                                     qosObjectTable_oid,
                                                     OID_LENGTH
                                                     (qosObjectTable_oid),
                                                     HANDLER_CAN_RWRITE);

    if (!my_handler || !table_info || !iinfo) {
        snmp_log(LOG_ERR,
                 "malloc failed in initialize_table_qosObjectTable");
        return; /** Serious error. */
    }

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info, 
				     ASN_INTEGER,
				    		/** index: qosDeviceType */
				     ASN_INTEGER,
                                               /** index: qosDeviceIndex */
                                     ASN_UNSIGNED,
                                               /** index: qosMajorHandle */
				     ASN_UNSIGNED,
						/* index: qosMinorHandle */
                                     0);

    /** Define the minimum and maximum accessible columns.  This
        optimizes retrival. */
    table_info->min_column = 1;
    table_info->max_column = 35;

    /** iterator access routines */
    iinfo->get_first_data_point = qosObjectTable_get_first_data_point;
    iinfo->get_next_data_point = qosObjectTable_get_next_data_point;

    /** tie the two structures together */
    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_qosObjectTable",
                "Registering table qosObjectTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);
}

/** Initializes the qos module */
void
init_qos(void)
{
  /** here we initialize all the tables we're planning on supporting */
    initialize_table_qosObjectTable();
    initialize_qos_table(&table);
}

/** handles requests for the qosObjectTable table, if anything else needs to be done */
int
qosObjectTable_handler(netsnmp_mib_handler *handler,
                       netsnmp_handler_registration *reginfo,
                       netsnmp_agent_request_info *reqinfo,
                       netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    struct commitInfo *ci = NULL;

    void           *data_context = NULL;

    oid            *suffix;
    size_t          suffix_len;

    /** column and row index encoded portion */
    suffix = requests->requestvb->name + reginfo->rootoid_len + 1;
    suffix_len = requests->requestvb->name_length -
        (reginfo->rootoid_len + 1);

    for (request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        switch (reqinfo->mode) {
        case MODE_GET:
        case MODE_SET_RESERVE1:
            data_context = netsnmp_extract_iterator_context(request);
            if (data_context == NULL) {
                if (reqinfo->mode == MODE_GET) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
            }
            break;

        default:               /* == the other SET modes */
            ci = netsnmp_oid_stash_get_data(commitStorage,
                                            suffix + 1, suffix_len - 1);
            break;

        }

        /** extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /** table_info->colnum contains the column number requested */
        /** table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info == NULL) {
            continue;
        }

        switch (reqinfo->mode) {
        case MODE_GET:
            switch (table_info->colnum) {

            case COLUMN_QOSDEVICETYPE:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosDeviceIndex(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSDEVICEINDEX:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosDeviceIndex(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSMAJORHANDLE:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosMajorHandle(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSMINORHANDLE:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosMinorHandle(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSTEXTHANDLE:
                {
                    char *retval;
                    size_t          retval_len = 0;
                    retval = get_qosTextHandle(data_context, &retval_len);
                    snmp_set_var_typed_value(var,ASN_OCTET_STR,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSTEXTLEAF:
                {
                    char *retval;
                    size_t          retval_len = 0;
                    retval = get_qosTextLeaf(data_context, &retval_len);
                    snmp_set_var_typed_value(var,ASN_OCTET_STR,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSPARENT:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosParent(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSTEXTPARENT:
                {
                    char *retval;
                    size_t          retval_len = 0;
                    retval = get_qosTextParent(data_context, &retval_len);
                    snmp_set_var_typed_value(var,ASN_OCTET_STR,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSDEVICENAME:
                {
                    char *retval;
                    size_t          retval_len = 0;
                    retval = get_qosDeviceName(data_context, &retval_len);
                    snmp_set_var_typed_value(var,ASN_OCTET_STR,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;


            case COLUMN_QOSTYPE:
                {
                    char *retval;
                    size_t          retval_len = 0;
                    retval = get_qosType(data_context, &retval_len);
                    snmp_set_var_typed_value(var,ASN_OCTET_STR,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSBYTES:
                {
                    unsigned long long     *retval;
//		    u_long		*retval;
                    size_t          retval_len = 0;
                    retval = get_qosBytes(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER64,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSPACKETS:
                {
                    u_long         *retval;
                    size_t          retval_len = 0;
                    retval = get_qosPackets(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSDROPPED:
                {
                    u_long         *retval;
                    size_t          retval_len = 0;
                    retval = get_qosDropped(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSOVERLIMIT:
                {
                    u_long         *retval;
                    size_t          retval_len = 0;
                    retval = get_qosOverlimit(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSBPS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosBps(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSPPS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosPps(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSQLEN:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosQlen(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSBACKLOG:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_qosBacklog(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSREDEARLY:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_redEarly(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSREDPDROP:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_redPdrop(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSREDOTHER:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_redOther(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSREDMARKED:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_redMarked(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBLENDS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbLends(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBBORROWS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbBorrows(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBGIANTS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbGiants(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBTOKENS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbTokens(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBCTOKENS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbCTokens(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBRATE:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbRate(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBCEIL:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbCeil(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSHTBPRIO:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_htbPrio(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_UNSIGNED,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;
		
            case COLUMN_QOSCBQBORROWS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_cbqBorrows(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;
		
            case COLUMN_QOSCBQOVERACTIONS:
                {
                    u_long           *retval;
                    size_t          retval_len = 0;
                    retval = get_cbqOveractions(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_COUNTER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSCBQAVGIDLE:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_cbqUndertime(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;

            case COLUMN_QOSCBQUNDERTIME:
                {
                    long           *retval;
                    size_t          retval_len = 0;
                    retval = get_cbqUndertime(data_context, &retval_len);
                    snmp_set_var_typed_value(var, ASN_INTEGER,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;
            case COLUMN_QOSINFO:
                {
                    char *retval;
                    size_t          retval_len = 0;
                    retval = get_qosInfo(data_context, &retval_len);
                    snmp_set_var_typed_value(var,ASN_OCTET_STR,
                                             (const u_char *) retval,
                                             retval_len);
                }
                break;
		
            default:
                /** We shouldn't get here */
                snmp_log(LOG_ERR,
                         "problem encountered in qosObjectTable_handler: unknown column\n");
            }
            break;

        case MODE_SET_RESERVE1:
            ci = netsnmp_oid_stash_get_data(commitStorage,
                                            suffix + 1, suffix_len - 1);

            if (!ci) {
                    /** create the commit storage info */
                ci = SNMP_MALLOC_STRUCT(commitInfo);
                if (!data_context) {
                    ci->data_context =
                        qosObjectTable_create_data_context(table_info->
                                                           indexes);
                    ci->new_row = 1;
                } else {
                    ci->data_context = data_context;
                }
                netsnmp_oid_stash_add_data(&commitStorage,
                                           suffix + 1, suffix_len - 1, ci);
            }
            break;

        case MODE_SET_RESERVE2:
            switch (table_info->colnum) {
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_ERR_NOTWRITABLE);
                break;
            }
            break;

        case MODE_SET_ACTION:
            /** save a variable copy */
            switch (table_info->colnum) {
            }
            break;

        case MODE_SET_COMMIT:
            if (!ci->have_committed) {
                    /** do this once per row only */
                qosObjectTable_commit_row(&ci->data_context, ci->new_row);
                ci->have_committed = 1;
            }
            break;

        case MODE_SET_UNDO:
             /** save a variable copy */
            switch (table_info->colnum) {
            }
            break;

        case MODE_SET_FREE:
            break;

        default:
            snmp_log(LOG_ERR,
                     "problem encountered in qosObjectTable_handler: unsupported mode\n");
        }
    }

    /** clean up after all requset processing has ended */
    switch (reqinfo->mode) {
    case MODE_SET_UNDO:
    case MODE_SET_FREE:
    case MODE_SET_COMMIT:
        /** clear out the undo cache */
        netsnmp_oid_stash_free(&undoStorage, qos_free_undoInfo);
        netsnmp_oid_stash_free(&commitStorage, netsnmp_oid_stash_no_free);
    }


    return SNMP_ERR_NOERROR;
}
