/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: msg.h,v 1.10 2004/01/13 11:01:37 vida Exp $
 */

//! file: msg.h
//!  Basic macros to handle translation messages from language module
//! cvs_version: $Id: msg.h,v 1.10 2004/01/13 11:01:37 vida Exp $

#ifndef __MSG_H
#define __MSG_H

/*
 * CAMAS Translation macros
 */

//! method: string MSG(int m)
//!  Get the string from the message number m of the language module
//! returns:
//!  Message from language module
//! arg: int m
//!  The symbolic name of the message
#define MSG(m) CAMAS_LANGUAGE->msg (CSESSION, m)

//! method: string MSG(int m, mixed a)
//!  Get the string from the message number m of the language module
//! returns:
//!  Message from language module
//! arg: int m
//!  The symbolic name of the message
//! arg: mixed a
//!  Optional arguments passed to the sprintf(...) function
#define MSGA(m,a) CAMAS_LANGUAGE->msg (CSESSION, m, a)

#endif //__MSG_H
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

