/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_layout_default.pike,v 1.25.2.2 2004/02/18 13:08:59 vida Exp $
 */

#include <module.h>

inherit "module";
inherit "caudiumlib";
inherit "camas_layout_fs";

//
//! module: CAMAS: Default Layout
//!  This module handle default layout (e.g. skin) for CAMAS.<br />
//!  <b>This module is automatically selected if you select "CAMAS: Main
//!  module".</b>
//! inherits: module
//! inherits: caudiumlib
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_layout_default.pike,v 1.25.2.2 2004/02/18 13:08:59 vida Exp $
//

constant cvs_version = "$Id: camas_layout_default.pike,v 1.25.2.2 2004/02/18 13:08:59 vida Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Default Layout";
constant module_doc  = "This module handle default layout (e.g. skin) for "
                       "CAMAS Tags. These screens are the screens used "
                       "in Camas 1.2 versions. "
                       "<br /><b>This module is automatically selected if "
                       "you select \"CAMAS: Main module\".</b><br/>" + _module_doc;
constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)
// this is a default Camas layout
constant is_default = 1;

void create () {
#ifdef CAMAS_DEBUG
  defvar ("debug", 0, "Debug", TYPE_FLAG, "Sends debug information into Caudium error log");
#endif
   defvar("loginlayout", 1, "Default layout for the login prompt",
     TYPE_FLAG, "Is this layout the layout used for the login prompt ?<br />"
     "Obviously only one layout can have this flag set to yes.<br/>"
     "<i>Note</i>: You need to reload this module or restart Caudium once you "
     "modify the login layout");

   defvar ("update_method", "FileWatch", "Layout reload method", TYPE_STRING_LIST,
          "The method we use to reload the layout files if they are modified "
          "<ul><li>Filewatch: The files are reloaded after at most 60 seconds</li>"
          "<li>Fstat: The files are reloaded automatically and instantaneously</li>"
          "<li>None: The files are reloaded when you reload this module or restart the server</li></ul>"
          "<br/>All methods have their drawbacks, Fstat use more resources but is usefull when "
          "developping a template. Filewatch uses less ressources than Fstat but is not as fast as None "
          "and None is the fastest.",
          ({ "FileWatch", "Fstat", "None" }));

   defvar ("location", "etc/include/camas/layouts/default/", "Layout path",
           TYPE_DIR, "The path to search for layout files.");

  defvar("configfilename", "config.xml", "Config file name", TYPE_LOCATION|VAR_EXPERT,
          "This is the file name of the config file. CAMAS will use this file for configuring your layout.");
}

void set_layout_name()
{
  layout_name = "Caudium WWW";
}

// this module should not be stopped and unregistring from camas layout manager
// or we chances are, will get warnings from the CIF
void stop()
{
}

/*
 * If you visit a file that doesn't contain these lines at its end, please     
 * cut and paste everything from here to that file.                            
 */                                                                            

/*
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: loginlayout
//! Is this layout the layout used for the login prompt ?<br />Obviously only one layout can have this flag set to yes.
//!  type: TYPE_FLAG
//!  name: Default layout for the login prompt
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

