#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  IMPORTADDRESS screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "<!-- Beginning of screen_IMPORTADDRESS -->\n";
  CSESSION->screen = "importaddress";	// Admin screen name

  contents = CAMAS.Parse.parse_html(contents,
                        ([
                            "camas_input_import": tag_camas_input_import,
                            "camas_submit_import": tag_camas_submit_import,
                            "camas_select_selectaddressbook": tag_camas_select_addressbook,
                         ]),
                        ([
                         ]),
                        id);
  if(!id->misc->_xml_parser && QUERY(ent_parse))
    contents = parse_scopes(contents,cb_scopes,id);

  args->method = "post";
  args->enctype = "multipart/form-data";
  args->name = "camasuploadaddressform";

  args = CAMAS.Tools.set_target(id, args);
 
  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<!-- End of screen_IMPORTADDRESS -->";
  return out;
}

string tag_camas_input_import(string tag_name, mapping args, object id)
{
  return CAMAS.Tools.make_tag("input", ([ "type":"file", "name":"file" ]));
}

string tag_camas_submit_import(string tag_name, mapping args, object id)
{
  return CAMAS.Tools.formdrawbutton(id,"m_import", "actionimportaddress", MSG(M_UPLOADANDIMPORT)+"...");
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
