#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
// LOGIN screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out = "";
  CDEBUG("Login SCREEN");
  CSESSION->screen = "login";	// Admin Screen name

  mapping tags =
    ([
      "camas_inputlogin"      : tag_login_cinput, // Login input
      "camas_inputpassword"   : tag_login_cinput, // Password input
      "camas_inputimapserver" : tag_login_cinput, // IMAP server input
      "camas_inputimapport"   : tag_login_cinput, // IMAP port input
      "camas_buttonlogin"     : tag_login_cinput,   // Button for login in
      "camas_selectlayout"    : tag_login_cinput,   // popup list for choosing layout
    ]);
  
  contents = CAMAS.Parse.parse_html(contents, tags, ([ ]), id); 
 
  if (!id->misc->_xml_parser)
    if (QUERY(ent_parse))
      contents = parse_scopes( contents, cb_scopes, id);
  
  contents += CAMAS.Tools.make_tag("input", ([ "type":"hidden", "name":"actionlogin", "value":"1" ]));

  args -> method = "post";
  args -> name   = "camasloginform";
  
  args = CAMAS.Tools.set_target(id, args);
 
  out += CAMAS.Tools.make_container("form", args, contents);

  return out;
}

string tag_login_cinput(string tag_name, mapping args, object id, object f, mapping defines)
{
  string out = "";   // string to output

  object camas_main = CAMAS_MODULE;
  if(!objectp(camas_main))
  {
    report_error("CAMAS tags: tag_login_cinput: module camas_main is not present");
    return "foo";
  }
  
  object features = id->conf->get_provider("camas_features");
  if(!objectp(features))
  {
    report_error("CAMAS tags: tag_login_cinput: module camas_features is not present");
    return "foo";
  }
  
  object layout_mngr = id->conf->get_provider("camas_layout_manager"); // Layouts
  if(!objectp(layout_mngr))
  {
    report_error("CAMAS tags: tag_login_cinput: module camas_layout_manager is not present");
    return "foo";
  }
  
  switch ( tag_name )
  {
  case "camas_inputlogin":
    //! tag: camas_inputlogin
    //!  Input login field
    //! attribute: js
    //!  Automatically give the focus to the password field when the login field has been filled in
    //! attribute: all attributes applicable to <input />
    //! note: screen: login
    args -> name = "login";
    args -> type = "text";
    
    if (args -> js && id -> supports -> javascript)
      args->onChange = "this.form.passwd.focus()";
    m_delete(args, "js");
    
    out += CAMAS.Tools.make_tag("input", args);
    break;
    
  case "camas_inputpassword":
    //! tag: camas_inputpassword
    //!  Input password field
    //! attribute: js
    //!  Automatically logs the user in when the password field has been filled in
    //! attribute: all attributes applicable to <input />
    //! note: screen: login
    args -> name = "passwd";
    
    // only type="hidden" or type="password" are allowed here
    if (args -> type != "hidden")
      args -> type="password";
    
    if (args -> js && id -> supports -> javascript)
    {
      args -> onChange = "this.form.submit()";
      m_delete(args, "js");
    }
    
    out += CAMAS.Tools.make_tag("input", args);
    break;
    
  case "camas_buttonlogin":
    //! tag: camas_buttonlogin
    //!  Button for login in
    //! note: screen: login
    out += CAMAS.Tools.formdrawbutton(id, "m_login_ok", "OK", MSG(M_LOGIN_OK), args);
    break;
    
  case "camas_selectlayout":
    //! tag: camas_selectlayout
    //!  List of layout the user can choose
    //! attribute: All attributes applicable to <select></>
    //! attribute: option_*
    //!  All attributes applicable to <option></>
    //! attribute: deftheme
    //!  Name of the default theme. A theme of this name will be selected in the
    //!  generated select box instead of the 'From Preferences' option
    //! note: screen: login
    if (objectp (layout_mngr) && (sizeof(layout_mngr->list_layouts())>1))
    {
      array layouts = layout_mngr -> list_layouts();
      
      mapping optionargs = CAMAS.Tools.extract_html_attributes (args, "option");
      
      string selectcontents = "";
      
      optionargs -> value = "__user";
      optionargs -> selected = "selected";
      
      string frompref_default = args -> deftheme ? "0" : "1";
      selectcontents += CAMAS.Tools.make_container ("option", 
						    ([ "value":"__user",
						       "selected": frompref_default
						    ]), 
						    MSG(M_SAVEDUSERINTERFACE));
      
      m_delete(optionargs, "selected");
      
      foreach (layouts, string lay)
      {
	optionargs -> value = lay;
	if (args -> deftheme && 
	    lower_case (lay) == lower_case (args -> deftheme))
	  optionargs -> selected = "1";
	
	selectcontents += CAMAS.Tools.make_container ("option", optionargs, lay );
	if (optionargs -> selected)
	  m_delete (optionargs, "selected");
      }
      
      // Remove attributes from <camas_selectlayout></> not applicable to <select></>
      m_delete (args, "deftheme");
      
      args->name = "layout";
      out += CAMAS.Tools.make_container ("select", args, selectcontents);
    }
    else
      out = "";
    break;
    
  default:
    out = "<!-- "+tag_name+" is not supported yet -->" ;
  }
  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
