(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the command line tool. *)

let _ = Dbf_args.parse ()

let _ = match !Dbf_args.file with
  None ->
    prerr_endline Dbf_messages.usage ;
    exit 1
| Some file ->
    try
      let sch = Dbf_types.read file in
      match !Dbf_args.html_dbms with
	[] ->
	  (
	   let gen_opt = 
	     match !Dbf_args.gen_code with
	       Some Dbf_types.Current.Odbc -> Some (new Dbf_odbc.odbc_gen Dbf_odbc.spec)
	     | Some Dbf_types.Current.Mysql -> Some (new Dbf_mysql.mysql_gen Dbf_mysql.spec)
	     | Some Dbf_types.Current.Postgres -> Some (new Dbf_postgres.postgres_gen Dbf_postgres.spec)
	     | None -> None
	   in
	   match gen_opt with
	     Some g ->
	       let output_ml = 
		 match !Dbf_args.output with
		   None ->
		     (
		      try Filename.chop_extension file
		      with _ -> file
		     )^
		     ".ml"
		 | Some p -> p^".ml"
	       in
	       let output_mli = output_ml^"i" in
	       let chanout = open_out output_ml in
	       let fmt = Format.formatter_of_out_channel chanout in
	       g#generate fmt sch;
	       close_out chanout;
	       let chanout = open_out output_mli in
	       let fmt = Format.formatter_of_out_channel chanout in
	       g#i_generate fmt sch;
	       close_out chanout
	   | None -> 
	       ()
	  );
	  (
	   match !Dbf_args.gen_objects_code with
	   | Some dbms ->
	       let (prefix, output_ml) = 
		 match !Dbf_args.output with
		   None ->
		     let p =
		       (
			try Filename.chop_extension file
			with _ -> file
		       )
		     in
		     (Filename.basename p, p^"_obj.ml")
		 | Some p -> 
		     (Filename.basename p, p^"_obj.ml")
	       in
	       let interface_module = String.capitalize prefix in
	       let chanout = open_out output_ml in
	       let fmt = Format.formatter_of_out_channel chanout in
	       Dbf_objects.generate fmt interface_module dbms sch;
	       close_out chanout;

	   | None ->
	       ()
	  )
      | l ->
	  let output_html = 
	    match !Dbf_args.output with
	      None ->
		(
		 try Filename.chop_extension file
		      with _ -> file
		)^
		".html"
	    | Some p -> p^".html"
	  in
	  Dbf_html.generate_doc output_html l sch
    with
    | Sys_error s -> prerr_endline s ; exit 1
    | Failure s -> prerr_endline s ; exit 1
