(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the standalone GUI tool. *)

let _ = Dbf_args.parse_gui ()

let _ = match !Dbf_args.file with
  None ->
    prerr_endline Dbf_messages.usage ;
    exit 1
| Some file ->
    let _ = GMain.Main.init () in
    let app = new Dbforge.dbforge_app file in
    let window = GWindow.window 
	~width: 600
	~height: 400
	~title: (Dbf_messages.software^" : "^file) () 
    in
    let _ = window#add app#box#coerce in
    let _ = app#box#connect#destroy window#destroy in
    let _ = window#connect#destroy GMain.Main.quit in
    let _ = app#init_window window in
    let _ = window#show () in
    GMain.Main.main ()
