(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Messages and string constants. *)

let software_version = "1.3"
let software = "DBForge"
let author = "Maxence Guesdon (maxence.guesdon@inria.fr)"

let about = Printf.sprintf
    "%s %s\n\n%s\n%s\n\n%s\n%s\n\n%s"
    software
    software_version
    author
    "http://www.maxence-g.net"
    "Copyright (c) 2002 by"
    "Institut National de Recherche en Informatique et en Automatique."
    "Distributed under licence GPL (see LICENSE file)."


(** {2 Command line} *)

let usage = 
  let e = Filename.basename Sys.argv.(0) in
  e^" [options] <file>\n"


let usage_gui = (Filename.basename Sys.argv.(0))^" [options] <file>\n"
let options_are = "Options are :"

let op_gen_odbc = " Generate code for OCamlODBC"
let op_gen_mysql = " Generate code for OCaml-MySQL"
let op_gen_postgres = " Generate code for Postgres"

let op_gen_objodbc = " Generate classes code for OCamlODBC"
let op_gen_objmysql = " Generate classes code for OCaml-MySQL"
let op_gen_objpostgres = " Generate classes code for Postgres"

let op_gen_html = "<lib1,lib2,...>  Generate HTML doc for the given libraries (odbc, mysql, pg, or all)"
let op_noheader = "  Do not generate header in the generated html document"
let op_output = "<prefix>  Generate code or doc in <prefix>.ml{,i} or <prefix>.html"
let op_debug = " Generate debug code"
let op_title = "<title>  Use <title> in generated code and documentation."
let op_dbmanifest = " define the db type with its manifest"
let op_remove_table_prefix = "<prefix>  remove this prefix from table names to get (simpler) module names"

let unknown_target_lib s = "Unknown target library "^s
let incorrect_target_lib_spec s = "Incorrect target library specification "^s

(** {2 Common messages} *)

let no = "No"
let yes = "Yes"
let error = "Error"
let tables = "Tables"
let name = "Name"
let comment = "Comment"
let sql_type = "SQL type"
let ml_type = "OCaml type"
let table_exists t = "Table "^t^" exists"
let column_exists c = "Column "^c^" exists"
let q_remove_table t = "Remove table "^t^" ?"
let q_remove_column c = "Remove column "^c^" ?"
let schema = "Schema"
let queries = "Queries"
let sql_type = "SQL type"
let nullable = "Nullable"
let index = "Index"
let sql_default = "Default SQL value"
let ml_funs = "Conversion functions"
let fun_2ml = "sql -> ocaml"
let fun_ml2 = "ocaml -> sql"
let common_props = "Common"
let optional_args = "Optional args"
let incorrect_type_definition = "Incorrect type definition"
let generated_by = "Generated by "^software^" version "^software_version
let optional_key = "Optional key type"
let table_copy t = t^" copy"

let error_at_location s e =
  Printf.sprintf "Error at location %d -> %d" s e
let error_incorrect_file_header = "Incorrect file header."

(** {2 Menu labels} *)

let mnFile = "File"
let mnQuit = "Quit"
let mnSave = "Save"
let mnAbout = "About "^software^"..."
let mnAdd = "Add"
let mnRemove = "Remove"
let mnEdit = "Edit"
let mnTables = "Tables"
let mnColumns = "Columns"
let mnCopy = "Copy"

(** {2 For the generation of ocaml code} *)

let mFormatError = "Wrong format returned by the query "
let mExecError = "Error while executing the query "

(** {2 For HTML generation} *)

let class_column_name = "column_name"
let class_dbms_name = "dbms_name"
let class_ml_type = "mltype"
let class_nullable = "nullable"
let class_index = "index"
let class_comment = "comment"
let class_odd = "odd"
let class_even = "even"
let class_header = "header"

let columns = "Columns"

let html_header s = 
"<html>\n"^
"<head>\n"^
"<style type=\"text/css\">\n"^
"  A:visited {color : green; text-decoration : none; }\n"^
"  A:link {color : blue; text-decoration : none;}\n"^
"  A:hover {color : red; text-decoration : underline; }\n"^
"  A:active {color : red; text-decoration : underline; }\n"^
"  table { border-collapse: separate ; empty-cells: show; border-style: solid ; "^
	    " spacing: 3; border-width: 1 ; caption-side: top}\n"^
"  tr { border-style: solid ; border-width: 3; cell-spacing: 3;}\n"^
"  td { border-style: solid ; border-width: 1 ; padding: 3}\n"^
"  caption { text-align: left ; font-weight: bold }\n"^
"  body { background-color: white }\n"^
(*
"  ."^class_column_name^" { background-color: yellow}\n"^
"  ."^class_dbms_name^" { background-color: lime }\n"^
"  ."^class_ml_type^" { background-color: blue; color: white}\n"^
*)
"  ."^class_nullable^" { text-align: center}\n"^
"  ."^class_index^" { text-align: center}\n"^
"  ."^class_comment^" { font-style: italic}\n"^
"  ."^class_odd^" { background-color: #a0d0f0  }\n"^
"  ."^class_even^" { background-color: #a0d0d0  }\n"^
"  ."^class_header^" { background-color: #f0d0b0 ; font-weight: bold }\n"^
"</style>\n"^
"<title>"^s^"</title>\n"^
"</head>\n\n"^
"<body>\n"^
"<center><h1>"^s^"</h1></center>\n"

let html_footer = "</body></html>"

