(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

module O = Options 
module V = Omom_variables 

let id x =
  let rec id_list = function
    | (x, _)::t ->
	" " ^ x ^ " " ^ (id_list t)
    | [] -> "" in
    match x with
      | V.V_String (x, _) -> x
      | V.V_List x -> id_list x 

let includes x =    
  let rec includes_list = function
    | (x, _)::t ->
	"-I " ^ x ^ " " ^ (includes_list t)
    | [] -> "" in
    match x with
      | V.V_String (x, _) -> "-I " ^ x
      | V.V_List x -> includes_list x 
	  
let actions = Hashtbl.create 8 

let action_of_string str =
  try
    Hashtbl.find actions str
  with 
      Not_found -> id 

let actions_list = [
  "", id; 
  "includes", includes ;
] 

let default_action = "" (* id *)

let _ = List.iter (fun (s,f) -> Hashtbl.add actions s f) actions_list

let actions_names = List.map fst actions_list 
