/**************************************************************************/
/*                   Cameleon                                             */
/*                                                                        */
/*      Copyright (C) 2002 Institut National de Recherche en Informatique et   */
/*      en Automatique. All rights reserved.                              */
/*                                                                        */
/*      This program is free software; you can redistribute it and/or modify  */
/*      it under the terms of the GNU General Public License as published by  */
/*      the Free Software Foundation; either version 2 of the License, or  */
/*      any later version.                                                */
/*                                                                        */
/*      This program is distributed in the hope that it will be useful,   */
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of    */
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     */
/*      GNU General Public License for more details.                      */
/*                                                                        */
/*      You should have received a copy of the GNU General Public License  */
/*      along with this program; if not, write to the Free Software       */
/*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          */
/*      02111-1307  USA                                                   */
/*                                                                        */
/*      Contact: Maxence.Guesdon@inria.fr                                */
/**************************************************************************/

%{
(***********************************************************************)
(*                               Zoggy                                 *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the GNU General Public License version 2.       *)
(*                                                                     *)
(***********************************************************************)

open Zog_types
%}

%token EOF NAME SUP ENTITY_START ENTITY_END 
%token <string> WIDGET_START WIDGET_END IDENT VALUE

%type <string * (string list)> entity_start
%type <string * string * Zog_types.property list * bool> widget_start
%type <string * string> property 
%type <(string * string) list> property_list
%type <Zog_types.gui_element> widget 
%type <Zog_types.gui_element option> widget_opt
%type <Zog_types.entity> entity
%type <Zog_types.entity list> entity_list project

%start project
%start entity
%start widget

%%
project: entity_list EOF        { List.rev $1 }

entity_list:
  { [] }
| entity_list entity { $2 :: $1 }
; 

entity:
 entity_start widget_opt ENTITY_END 
  { 
    let (name, params) = $1 in
    { en_name = name ;
      en_params = params ;
      en_ele = $2;
    } 
  } 
;

entity_start:
      ENTITY_START NAME IDENT params SUP   { $3, $4 }
;

params:
      { [] }
| IDENT params { $1 :: $2 }
;

widget_opt: 
  { None }
| widget { Some $1 }
;

children:
  { [] }
| children widget   { $1 @ [$2] }
;

widget: 
  widget_start children WIDGET_END
  { 
    let name, classe, props, expanded = $1 in
    if classe <> $3 then raise (Failure "");
    { 
      name = name ;
      name_loc = 0, 0 ;
      classe = Zog_misc.class_of_class_name classe ;
      props = props ;
      children = $2 ;
      expanded = expanded ;
    } 
  } 
;

widget_start:
  WIDGET_START NAME IDENT property_list SUP   
  {
    let proplist, expanded =
      List.fold_right
        (fun (id, v) (proplist, expanded) ->
           if id = "expanded" then proplist, v <> "false"
           else
             let prop =
	       { prop_kind = Zog_misc.property_kind_of_property_name id ;
                 prop_value = (Zog_misc.decode v) ;
                 prop_value_loc = 0, 0 }
             in
             prop :: proplist, expanded)
        $4 ([], true)
    in
    $3, $1, proplist, expanded
  }
;

property_list:
  { [] }
| property_list property  { $1 @ [$2] }
;

property: 
  IDENT  VALUE       
  { $1, $2 }
;
