/*
 *  CaSU - communications & status utilities.
 *  Copyright (C) 1992, 1993, 1994 Luke Mewburn <lm@rmit.edu.au>
 *	incorporating:
 *	   flon - lists your friends who are logged on.
 *	   to - send a short message to a friend
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define _MAIN_
#include "casu.h"

#ifdef M_SYSV
    utmp_s	Kludge;
#endif /* for SCO */


/*
 *	flon main
 */

void
flon_main(argc, argv)
    int argc;
    char *argv[];
{
    char	*ffile_path=NULL, *format_str=NULL;
    char	*yes_str=NULL, *no_str=NULL;
    int		origargc = argc;

    add_envopt(&argc, &argv, STRflon);
    parse_options(origargc, argc, argv, &ffile_path, &format_str,
		    &yes_str, &no_str);
    parse_format(format_str);
    get_utmp(1);			/* need it sorted/filtered */
    if (flags & NEED_FFILE)
    	get_friends(ffile_path);
#if !USE_GETPWENT
    if ((flags & (NEED_PASSWD | BEST_NAME)) && (flags & ALL_ON))
	get_passwd(_PATH_PASSWD);
#endif /* !USE_GETPWENT */
    print_output(yes_str, no_str);
} /* flon_main */


/*
 *	who main
 */

void
who_main(argc, argv)
    int argc;
    char *argv[];
{
    if (argc > 2)
    {
	if (	(strcmp(argv[1], "am")) ||
		(argv[2][1] != '\0') ||
		( (argv[2][0] != 'i') &&
		  (argv[2][0] != 'I')) ||
		(argc > 3) )
	{
	    fprintf(stderr, "Usage: %s [ file ]\n      %s am { i , I }\n",
			argv[0], argv[0]);
	    exit(1);
	}
	get_utmp(1);			/* needed for who_am_I() - filter it */
	who_am_I();
	return;
    }
    if (argc == 2)
	utmp_file=argv[1];		/* emulate  who <file>  */

    flags = NO_HEADER + NO_TAILER + ALL_ON;
					/* no head or tail, & list all */
    get_utmp(0);			/* don't filter utmp file */
    parse_format(WHO_FORMAT);

    print_output(" ", "*");
} /* who_main */


/*
 *	main
 */

int
main(argc, argv)
    int argc;
    char *argv[];
{
    char *p;
    if (argv[0] == NULL)
	exit(1);

    min_idle = MINIDLE;
    max_idle = MAXIDLE;
    utmp_file = PATH_UTMP;

    progname = argv[0];
    if ((p = strrchr(progname, '/')) != NULL)
	progname = ++p;
    if (strcmp(progname, WHO_PROG) == 0)
	who_main(argc, argv);
    else
	flon_main(argc, argv);
    exit(0);
    return 0;	/* shut the compiler up */
} /* main */
