/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class HttpInputStream
extends ServletInputStream {
    protected InputStream in;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int total;
    protected int limit;
    protected int length;

    public HttpInputStream(int n) {
        this.buf = new byte[n];
    }

    public HttpInputStream() {
        this(512);
    }

    public void init(InputStream inputStream) throws IOException {
        this.in = inputStream;
    }

    public void next() {
        this.length = -1;
        this.limit = Integer.MAX_VALUE;
        this.total = 0;
        this.count = 0;
        this.pos = 0;
    }

    public void finish() throws IOException {
        if (this.length != -1) {
            int n = this.limit - this.total;
            while (n > 0) {
                int n2 = (int)this.skip(n);
                if (n2 == 0) {
                    throw new IOException("invalid content length");
                }
                n -= n2;
            }
        }
    }

    public void resets() {
        this.in = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setContentLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid content length");
        }
        this.length = n;
        if (Integer.MAX_VALUE - this.total > n) {
            this.limit = this.total + n;
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public int read() throws IOException {
        if (this.total >= this.limit) {
            return -1;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        ++this.total;
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.total >= this.limit) {
            return -1;
        }
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        if (n3 < n2) {
            n2 = n3;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        this.total += n2;
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public int readLine(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this.total >= this.limit) {
            return -1;
        }
        var6_4 = 0;
        var6_4 = var3_3;
        var4_5 = this.count - this.pos;
        if (var4_5 <= 0) {
            this.fill();
            var4_5 = this.count - this.pos;
            if (var4_5 <= 0) {
                return -1;
            }
        }
        var5_6 = var4_5 < var3_3 ? var4_5 : var3_3;
        var7_7 = HttpInputStream.copyLine(this.buf, this.pos, var1_1, var2_2, var5_6);
        this.pos += var7_7;
        this.total += var7_7;
        var6_4 -= var7_7;
        var8_8 = var7_7;
        if (var8_8 != 0) ** GOTO lbl29
        return -1;
lbl-1000:
        // 1 sources

        {
            this.fill();
            var4_5 = this.count - this.pos;
            if (var4_5 <= 0) {
                return var8_8;
            }
            var5_6 = var4_5 < var6_4 ? var4_5 : var6_4;
            var7_7 = HttpInputStream.copyLine(this.buf, this.pos, var1_1, var2_2 + var8_8, var5_6);
            this.pos += var7_7;
            this.total += var7_7;
            var6_4 -= var7_7;
            var8_8 += var7_7;
lbl29:
            // 2 sources

            ** while (var6_4 > 0 && var1_1[var2_2 + var8_8 - 1] != 10)
        }
lbl30:
        // 1 sources

        return var8_8;
    }

    private static int copyLine(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n;
        while (n3-- > 0 && byArray[n4++] != 10) {
        }
        System.arraycopy(byArray, n, byArray2, n2, n4 - n);
        return n4 - n;
    }

    public long skip(long l) throws IOException {
        if (this.total >= this.limit) {
            return 0L;
        }
        long l2 = l;
        while (l2 > 0L) {
            int n = this.count - this.pos;
            if (n <= 0) {
                this.fill();
                n = this.count - this.pos;
                if (n <= 0) {
                    return l - l2;
                }
            }
            if (l2 < (long)n) {
                n = (int)l2;
            }
            l2 -= (long)n;
            this.pos += n;
            this.total += n;
        }
        return l;
    }

    public int available() throws IOException {
        return Math.min(this.count - this.pos + this.in.available(), this.limit - this.total);
    }

    public void close() throws IOException {
        this.finish();
    }

    protected void fill() throws IOException {
        int n = Math.min(this.buf.length, this.limit - this.total);
        if (n > 0 && (n = this.in.read(this.buf, 0, n)) > 0) {
            this.pos = 0;
            this.count = n;
        }
    }
}

