(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

type t

val print: Format.formatter -> t -> unit

val explain: Types.t -> Types.t -> Value.t -> t option
  (** [explain t0 t v] 
    Return a path on [v] that explains why [v] is not of type [t],
    or [None] if [v] has type [t].
    [v] is assumed to have type [t0].
  *)
