#
# 	Gestion et interfaces des utilitaires d'analyse csound
# 	(c) 1996-7 Jean Piche
# 	v. 1.80a (10/08/97)
#

##########################################
#########CONVERSION VALEURS DE SLIDERS POUR ANALYSIS PROGRAM
##########################################
proc doPVanal {what val} {
	global pvdata
	switch $what 	{
		frameSize	{set pvdata($what)  [expr pow(2,($val/10)+4)]}
		windowFactor	{set pvdata($what)  [expr ($val/10.)+1]}
	
	}
}
proc doLPCanal {what val} {
	global lpcdata son
	switch $what 	{
		begin		{ set lpcdata($what)  [expr ($val/1000.)*$son(duree)] }
		duration	{ set lpcdata($what)  [expr ($val/1000.)*$son(duree)] }
		npoles		{ set lpcdata($what)  [expr $val/20]                  }
		hopsize		{ set lpcdata($what)  [expr $val]                     }
		mincps		{ set lpcdata($what)  [expr $val+50]                  }
		maxcps		{ set lpcdata($what)  [expr $val+200]                 }
	}
}
proc doCVanal {what val} {
	global cvdata son
	switch $what 	{
		begin		{set cvdata($what)   [expr ($val/1000.)*$son(duree)] }
		duration	{set cvdata($what)   [expr ($val/1000.)*$son(duree)] }
	}
}
proc doHetroanal {what val} {
	global hetrodata son
	switch $what 	{
		begin		{set hetrodata($what)   [expr ($val/1000.)*$son(duree)] }
		duration	{set hetrodata($what)   [expr ($val/1000.)*$son(duree)] }
		fundamental	{set hetrodata($what)  [expr ($val)+30]}
		partials	{set hetrodata($what)  [expr ($val/20)]}
		maxamp		{set hetrodata($what)  [expr $val*32.787]}
		minamp		{set hetrodata($what)  [expr ($val/5)+1 ]}
		segments	{set hetrodata($what)  [expr $val+1]}
		butterworth(Hz)	{set hetrodata($what)  $val }
	}
}


##########################################
#########SELECT SOUND FOR ANALYSIS PROGRAMS
##########################################
proc selectSound {} {
    global utilframe fileselect currentdir  lan module son nchnls
         set types {
			{{AIFF files}   {.aiff .aif .AIFF}  }
			{{All files}   {*}  }
       }
    set son(path) [chooseOpen "Choose an aiff soundfile for analysis" $currentdir $types]
    	if {$son(path) == ""} {return}	
   	set son(nom) [file tail $son(path)]
 	if {[set fs [getSoundFileInfo $son(path)]] == ""} {
		 errFile2 "$lan(nom86)"
		 selectSound
	}
	if { [lindex $fs 2 ] != "aiff" } {
		errFile2 "Sorry, I can't analyse this kind of file. AIFF format only..."
		return
	}
		
        set son(sr)  [lindex $fs 1]
	set son(nchnls)  $nchnls([lindex $fs 3])
	set son(duree) [lindex $fs 0]
}


##########################################
#########PRESENT SLIDERS FOR ANALYSIS PROGRAMS
##########################################

proc analFrames {kind} {
    global color ffont fffont fileselect son lan analent
	selectSound
	if {$son(path) == ""} {return}	
	set win [regexp {([0-9]+)x([0-9]+)([+-]+[0-9]+)([+-]+[0-9]+)} [winfo geometry .] match rest1 rest2 rest3 rest4]
	catch {destroy .analysis}
	set t [toplevel .analysis  -bd 0 ]
	wm geometry $t +[expr 240+$rest3]+[expr 120+$rest4]
	message $t.msg -aspect 800 -justify center -text "$kind\n\n $son(path)" 
	set potframe [frame $t.pot ]
	pack $t.msg $potframe -side top -fill x -pady 10 -expand 1


	set nam [frame $t.nam   -bd 2 -relief groove]
	label $t.nam.lab   -text $lan(nom85) 
	set analent [entry	$t.nam.ent -width 24 -relief sunken   -textvariable newsound ]
	pack $t.nam.lab $t.nam.ent -side left  -pady 2
		$analent delete 0 end


	set bou	[frame $t.bout   -bd 2 -relief groove]
	button $bou.quit -text OK  \
		   \
		 -bd 3 -width 8 -command "doAnal $kind;grab release $t;catch {destroy $t}"
	pack $bou.quit -side left  -anchor w -padx 5
  
	button $bou.cancel -text $lan(nom70)  \
		   \
		 -bd 3 -width 8 -command "grab release $t;catch {destroy $t}"
	pack $bou.cancel -side left  -anchor e -padx 5 -pady 5
	
	switch $kind {
#-----------PVanal frame---------------
	vocoder {
	set pv  [frame $potframe.pvanal  -bd 3]
	pack  $pv -side top -padx 0 -pady 0 -fill x -expand 1
	foreach ssi {frameSize windowFactor} {
		frame $pv.$ssi
		pack  $pv.$ssi -side top -padx 0 -pady 3  -fill x -expand 1
		scale $pv.$ssi.sca -from 0 -to 100 -length 300   -showvalue 0 \
			-orient horizontal  -bd 2 -width 14 \
			-command "doPVanal $ssi"
		label $pv.$ssi.scalab    -bd 1 -pady 2\
			-textvariable pvdata($ssi) -width 7  -justify right -relief sunken
		label $pv.$ssi.lab    -bd 1 -pady 2 -text $ssi -width 15 -justify right -relief sunken
		pack  $pv.$ssi.lab  -side left -padx 0 -pady 0 -expand 0
		pack   $pv.$ssi.sca -side left -padx 0 -pady 0 -fill x -expand 1	
		pack   $pv.$ssi.scalab -side left -padx 0 -pady 0 -expand 0
	}
	$analent insert 0 "$son(nom).pv"
	$pv.frameSize.sca set 60
	$pv.windowFactor.sca set 30
	
	}
#-----------LPCanal frame---------------
	lpc {
	set lpc  [frame $potframe.lpc  -bd 3]
	pack  $lpc -side top -padx 0 -pady 0 -fill x -expand 1
	foreach ssi {begin duration npoles hopsize mincps maxcps} {
		frame $lpc.$ssi 
		pack  $lpc.$ssi -side top -padx 0 -pady 3 -fill x -expand 1
		scale $lpc.$ssi.sca -from 0 -to 1000 -length 300   -showvalue 0 \
			-orient horizontal  -bd 2  -width 14 \
			-command "doLPCanal $ssi"
		label $lpc.$ssi.scalab    -bd 1 -pady 2\
			-textvariable lpcdata($ssi) -width 7  -justify right -relief sunken
		label $lpc.$ssi.lab    -bd 1 -pady 2 -text $ssi -width 15 -justify right -relief sunken
		pack  $lpc.$ssi.lab  -side left -padx 0 -pady 0 -expand 0
		pack   $lpc.$ssi.sca -side left -padx 0 -pady 0 -fill x -expand 1	
		pack   $lpc.$ssi.scalab -side left -padx 0 -pady 0 -expand 0
	}
	$analent insert 0 "$son(nom).lpc"	
	$lpc.begin.sca set 0
	$lpc.duration.sca set 1000
	$lpc.npoles.sca set 1000
	$lpc.hopsize.sca set 200
	$lpc.mincps.sca set 200
	$lpc.maxcps.sca set 500
	}	

#-----------Hetroanal frame---------------
	hetrodyne {
	set hetro  [frame $potframe.hetro  -bd 3]
	pack  $hetro -side top -padx 0 -pady 0 -fill x -expand 1
	foreach ssi {begin duration fundamental partials maxamp minamp segments butterworth(Hz)} {
		frame $hetro.$ssi 
		pack  $hetro.$ssi -side top -padx 0 -pady 3 -expand 1 -fill x
		scale $hetro.$ssi.sca -from 0 -to 1000 -length 300   -showvalue 0 \
			-orient horizontal  -bd 2  -width 14 \
			-command "doHetroanal $ssi"
		label $hetro.$ssi.scalab    -bd 1 -pady 2\
			-textvariable hetrodata($ssi) -width 7  -justify right -relief sunken
		label $hetro.$ssi.lab    -bd 1 -pady 2 -text $ssi -width 15 -justify right -relief sunken
		pack  $hetro.$ssi.lab  -side left -padx 0 -pady 0 -expand 0
		pack   $hetro.$ssi.sca -side left -padx 0 -pady 0 -fill x -expand 1	
		pack   $hetro.$ssi.scalab -side left -padx 0 -pady 0 -expand 0
	}
	$analent insert 0 "$son(nom).het"	
	$hetro.begin.sca set 0
	$hetro.duration.sca set 1000
	$hetro.fundamental.sca set 80
	$hetro.partials.sca set 699
	$hetro.maxamp.sca set 1000
	$hetro.minamp.sca set 499
	$hetro.segments.sca set 255
	$hetro.butterworth(Hz).sca set 0
	}	


#-----------Cvanal frame---------------
	convolution {
	set cv  [frame $potframe.cv  -bd 3]
	pack  $cv -side top -padx 0 -pady 0 -fill x -expand 1
	foreach ssi {begin duration} {
		frame $cv.$ssi 
		pack  $cv.$ssi -side top -padx 0 -pady 3 -fill x -expand 1
		scale $cv.$ssi.sca -from 0 -to 1000 -length 300   -showvalue 0 \
			-orient horizontal  -bd 2  -width 14 \
			-command "doCVanal $ssi"
		label $cv.$ssi.scalab    -bd 1 -pady 2\
			-textvariable cvdata($ssi) -width 7  -justify right -relief sunken
		label $cv.$ssi.lab    -bd 1 -pady 2 -text $ssi -width 15 -justify right -relief sunken
		pack  $cv.$ssi.lab  -side left -padx 0 -pady 0 -expand 0
		pack   $cv.$ssi.sca -side left -padx 0 -pady 0 -fill x -expand 1	
		pack   $cv.$ssi.scalab -side left -padx 0 -pady 0 -expand 0
	}
	$cv.begin.sca set 0
	$cv.duration.sca set 1000
	$analent insert 0 "$son(nom).cv"	
	}	
    }
    pack $nam -pady 10 -padx 5 -fill x  
    pack $bou -pady 10 -padx 5 -fill x  
}

##########################################
#########RUN THE ANALYSIS PROGRAM
##########################################
proc doAnal {kind} {
    global  pvdata lpcdata hetrodata tcl_platform cvdata lan andir  commande son analent prefs
    set analName [$analent get]	
    switch $kind {
    	vocoder {
			set commande "csound -U pvanal  -n$pvdata(frameSize) -w$pvdata(windowFactor) \"$son(path)\" \
				\"[file join $prefs(SADIR) $analName]\""
    	}
   	 	lpc {
			set commande "csound -U lpanal -v2 -P$lpcdata(mincps) -Q$lpcdata(maxcps) -b$lpcdata(begin) \
		 		-d$lpcdata(duration)  -h$lpcdata(hopsize) -p$lpcdata(npoles)   \"$son(path)\" \
				\"[file join $prefs(SADIR) $analName]\""
    	}
    	hetrodyne {
			set commande "csound -U hetro  -b$hetrodata(begin)  -l$hetrodata(butterworth\(Hz\)) -d$hetrodata(duration) -n$hetrodata(segments) \
				-M$hetrodata(maxamp) -m$hetrodata(minamp) -f$hetrodata(fundamental) -h$hetrodata(partials)   \"$son(path)\" \
				\"[file join $prefs(SADIR) $analName]\""
    	}
    	convolution {
			set commande "csound -U cvanal -b$cvdata(begin) -c1 -d$cvdata(duration)  \"$son(path)\" \
				\"[file join $prefs(SADIR) $analName]\""
		}
    }
    set prefs(wind) 1
    if {$tcl_platform(platform) != "macintosh"} {Run Csound anal} {Run Csound}
}
