/* -*- mode: C; c-file-style: "bsd"; tab-width: 4 -*- */
/* strokedata.h - character data included by bootdata.c.
 * JStroke 1.x - Japanese Kanji handwriting recognition technology demo.
 * Copyright (C) 1997  Robert E. Wells
 * http://wellscs.com/pilot
 * mailto:robert@wellscs.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.html); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * See readme.txt, changelo, and gpl.html for more information.
 *
 * Commentary:
 *
 * The data in this file was generated via an earlier version of the
 * compact.pl perl script, from the StrokeDic.txt file from Todd Rudick.

 * Character data. This is a special header file that is included
 * in "bootdata.c" to create the Pilot database, but is also parsed
 * directly by a Perl script in KanjiPad to create its database. For this
 * reason, all lines with the first character '"' _must_ be character
 * data. In the future, maybe change KanjiPad to work from StrokeDic.txt
 * directly. owt 090497.
 *
 * ------------------------------------------------------------------------- */
#ifndef __STROKEDATA_H__
#define __STROKEDATA_H__

#ifdef FOR_STROKEDIC_CREATE_1

CharPtr LoadStrokeDicPtr(void) {
    return 
    "A\322\273F\n"
    "A\322\322Faf\n"
    "B\276\305JFl\n"
    "B\306\337FL\n"
    "B\312\256FB|b1-y2\n"
    "B\310\313JC|y2-y1! x1-x2!\n"
    "B\266\241FB|b2-b1\n"
    "B\265\266MgJ|b2-y1\n"
    "B\266\376FF\n"
    "B\310\353AC|x1-x2! y1-y2!\n"
    "B\260\313AC|x2-x1! y1-y2\n"
    "B\323\326FaC\n"
    "B\301\313FaBg\n"
    "B\301\246MgJ|y1-y2\n"
    "C\317\302FBC|i3-x2\n"
    "C\270\311FFB\n"
    "C\315\350JFlC|x1-x2\n"
    "C\276\303AFaC|x3-x2\n"
    "C\274\260JFafaC\n"
    "C\271\255MFBmg\n"
    "C\274\272MFL\n"
    "C\277\332BMF\n"
    "C\271\244FBF|b2-b1 l3-l1\n"
    "C\262\305FBA\n"
    "C\310\375FFF\n"
    "C\311\275BLB\n"
    "C\312\277FBF|b1-y2 l1-l3\n"
    "C\327\323FaBgF\n"
    "C\311\327AMgC\n"
    "C\305\256AcJF\n"
    "C\320\241BAC\n"
    "C\311\317BFF\n"
    "C\325\311FJC|x2-x3\n"
    "C\310\320MgJC\n"
    "C\264\347FBC|x2-i3\n"
    "C\307\247AFB\n"
    "C\264\250JBB\n"
    "C\264\363FJC|x3-i2\n"
    "C\315\301FBF|b1-y2 l3-l1\n"
    "C\315\366BFL\n"
    "C\267\262JFlC|x3-x1\n"
    "C\315\362FMgJ\n"
    "C\322\262MgBL\n"
    "C\317\246AFaC|l1-l3\n"
    "C\323\353FBmgF\n"
    "D\276\256FFJB\n"
    "D\322\375MFBfbdB\n"
    "D\324\306FFAfC\n"
    "D\315\365FBFF\n"
    "D\273\257ABAL\n"
    "D\273\360CAJC\n"
    "D\275\351ACJB\n"
    "D\330\327ACBB\n"
    "D\305\243AFFB|b1-y4\n"
    "D\320\327ACLB\n"
    "D\275\357AJFB|a1-x2\n"
    "D\307\370FACL\n"
    "D\307\267AFaJC\n"
    "D\324\302JMFF|j2-y4! j1-y4! x1-i1 j1-b4 j2-b4\n"
    "D\310\256FJCC|b1-b4\n"
    "D\324\252FFJL\n"
    "D\273\303AcAfCM\n"
    "D\273\247FMFJ\n"
    "D\316\345FBMF\n"
    "D\316\347AFFB|b4-b2\n"
    "D\271\253ACAfC\n"
    "D\277\327FaBgIL\n"
    "D\272\305BMFFbmg\n"
    "D\275\361ACFFa\n"
    "D\326\247FBFaC\n"
    "D\326\271BFBF\n"
    "D\312\317ABiFK\n"
    "D\263\337MFJC\n"
    "D\312\326AFFB|a1-x2\n"
    "D\311\375AJFB|x2-i1\n"
    "D\311\331BACA\n"
    "D\310\337BFaJFl\n"
    "D\320\304ALCC\n"
    "D\310\312ABFF\n"
    "D\313\256FaBAC\n"
    "D\307\320FLFjJ\n"
    "D\313\253FjCFjK\n"
    "D\314\253FJCC|b4-b1\n"
    "D\265\244JMCF\n"
    "D\326\320BMFB\n"
    "D\314\354FFJC|l1-l2\n"
    "D\266\267CCFB\n"
    "D\315\315ALBL\n"
    "D\304\332BMJC\n"
    "D\310\325BMFF|y4-b1! j4-b2!\n"
    "D\267\264FJFaC|a1-x2\n"
    "D\261\310FLAL\n"
    "D\306\245FJLL\n"
    "D\262\273FABC\n"
    "D\267\362FFJC|b1-y3\n"
    "D\270\270ACJC\n"
    "D\267\326ACMgJ\n"
    "D\316\304BFJK|x3-x4!\n"
    "D\306\254JBFM\n"
    "D\267\275BFMgJ\n"
    "D\267\246ABFaCf\n"
    "D\267\246ABFaIcf\n"
    "D\303\253AFFL\n"
    "D\304\276FBAC\n"
    "D\266\362FJMgL\n"
    "D\323\321FJFaC|b1-y2 x2-x1\n"
    "D\323\350FaCFaBg\n"
    "D\301\371BFAC|x4-x3!\n"
    "D\330\354ABMJ\n"
    "E\322\324BICAC\n"
    "E\323\322JFBMF\n"
    "E\323\300CFbFaAC\n"
    "E\260\274MfBFLB\n"
    "E\321\353BMFJC|x5-i4\n"
    "E\274\323FjJBMF\n"
    "E\277\311FBMFB\n"
    "E\315\342JFjCBC\n"
    "E\307\322BMFFF|l5-l4 i1-x5! i5-i2!\n"
    "E\277\257FFBBB\n"
    "E\270\312FBBFF\n"
    "E\307\360ABFBF\n"
    "E\276\311BBMFF\n"
    "E\310\245FBFAfC\n"
    "E\276\336BFMFF\n"
    "E\323\361FBFFC\n"
    "E\276\344AMgBMF\n"
    "E\320\326BMFJL\n"
    "E\321\250BBFaAC\n"
    "E\320\376BFAcAfC\n"
    "E\271\305FBBMF\n"
    "E\271\246FBIFaJ\n"
    "E\307\311FBIFBmg|y3-j2\n"
    "E\274\327BMFFB|b5-y3\n"
    "E\327\363FJFBF|b4-b3\n"
    "E\262\341BMBBF|j1-y5\n"
    "E\324\375FBACL\n"
    "E\303\363BMBBF|y5-b1\n"
    "E\312\313ABFBF|y5-y3\n"
    "E\313\276MFBMF\n"
    "E\312\267BMFJC|x4-x5 y5-y3\n"
    "E\313\304BMJLF\n"
    "E\312\320BFBMB\n"
    "E\312\276FFBAC|l2-l1 y3-y1\n"
    "E\337\263BMFAL\n"
    "E\312\247AFFJC|y2-y4\n"
    "E\320\264BFaFBmgF\n"
    "E\326\367CFBFF\n"
    "E\307\364BMJCF\n"
    "E\326\255CCIFB\n"
    "E\263\366BLBLB\n"
    "E\325\331MgJBMF\n"
    "E\345\352MFJJFl\n"
    "E\311\352BMFFB|y1-y5\n"
    "E\312\300FBBFL\n"
    "E\325\375FBFBF\n"
    "E\311\372AFBFF\n"
    "E\263\342AJFBC\n"
    "E\312\257FJBMF\n"
    "E\317\311ABBLB\n"
    "E\325\274BFBMF\n"
    "E\313\373ABMBL|y3-y5\n"
    "E\264\362FBIFB|j2-y3 y1-y2\n"
    "E\264\372ABFKC\n"
    "E\314\250AfCBMF\n"
    "E\314\357BMBFF|b3-y1\n"
    "E\305\253BcJFFjC\n"
    "E\266\254AFaCCC\n"
    "E\315\271FBMfLB\n"
    "E\304\341MFJAL\n"
    "E\260\327ABMFF\n"
    "E\260\353CAFFB\n"
    "E\267\270ACbAML\n"
    "E\306\244JFaBFaC\n"
    "E\261\330CALAC\n"
    "E\270\266ABFBC\n"
    "E\262\274JFBMB\n"
    "E\261\373FBMJC\n"
    "E\306\275FCAFB\n"
    "E\261\337MgJCFacaCf\n"
    "E\333\315AfCFJB\n"
    "E\304\270AcMCCF\n"
    "E\260\374AMgMFL\n"
    "E\261\261FBIAL\n"
    "E\261\276FBACF\n"
    "E\304\251FFBAC|l1-l2\n"
    "E\316\264FFBAC|l2-l1\n"
    "E\303\361MFBiFK\n"
    "E\303\254FaCFaBA\n"
    "E\303\373AFaBMF\n"
    "E\304\277BMFFF\n"
    "E\312\270AFFJC|b4-y2\n"
    "E\323\311BMBFF|y1-y3\n"
    "E\323\327AcAfCFjJ\n"
    "E\323\303JMFFB\n"
    "E\301\242BFCAF\n"
    "E\301\356ACCFaC\n"
    "E\301\356ACFMgB\n"
    "E\300\361BFaBCL\n"
    "F\260\262BBFaBcJF\n"
    "F\322\302BFABiAC\n"
    "F\323\363FBBFFB\n"
    "F\323\241ABFFMB\n"
    "F\322\362BMFJCF\n"
    "F\323\356BBFaFFB\n"
    "F\323\360MCIMCI\n"
    "F\276\312ABMFFF|x3-x2\n"
    "F\316\333CCIFFBm\n"
    "F\273\341ACFFAfC\n"
    "F\273\330BMBMFF\n"
    "F\270\367AFaCBMF\n"
    "F\272\271CCIFFB\n"
    "F\363\276AFFBLB\n"
    "F\306\363ACBFBF\n"
    "F\316\243AFaFJMgL\n"
    "F\273\372FBACJFl\n"
    "F\274\252FBFBMF\n"
    "F\320\335ABFBAC\n"
    "F\316\374BMFJFafaC\n"
    "F\320\340FBACFBmg\n"
    "F\271\262FBBFAC\n"
    "F\275\320BMFBFB\n"
    "F\321\366ABABiMB\n"
    "F\307\372BMBBFF\n"
    "F\320\314FFJBBB\n"
    "F\321\252ABMBBF\n"
    "F\274\376ABAFFB\n"
    "F\275\273BFACAC|b6-b1!\n"
    "F\271\342BCAFJL\n"
    "F\317\362ABMBMF\n"
    "F\272\363AJFBMF\n"
    "F\272\303BcJFFaBF\n"
    "F\320\242FBFAFabgF\n"
    "F\275\255CCIFBF\n"
    "F\277\274FBFAALbg\n"
    "F\320\320AABFFB\n"
    "F\272\317ACFBMF\n"
    "F\324\331FBMBFF\n"
    "F\324\332FJBFBF\n"
    "F\326\274ALBMFF\n"
    "F\313\300FAFaCAL\n"
    "F\364\351AcAfCBAC\n"
    "F\326\301FAfCFBF\n"
    "F\327\326BBFaFaBgF\n"
    "F\313\302FBFFBC\n"
    "F\264\316CIAFaJK\n"
    "F\266\370FABMBB\n"
    "F\266\372FBFFIB\n"
    "F\327\324ABMFFF|y5-y4\n"
    "F\312\275FFBIKC\n"
    "F\326\245FBBBFaCf\n"
    "F\326\245FBBBFaIcf\n"
    "F\312\330BBFaFBC\n"
    "F\326\354AFFBAC|b6-b1!\n"
    "F\326\335AJCBCB\n"
    "F\326\333AJMCBF\n"
    "F\263\344BFAfCJL\n"
    "F\321\256AMgBMFF\n"
    "F\321\262AcAcAcCFacaCf\n"
    "F\275\263FAJFBL\n"
    "F\327\257BFJFBF\n"
    "F\311\253AFaMBFL\n"
    "F\276\241MFJCCC\n"
    "F\321\270FkFBCFacaCf\n"
    "F\263\311JFMgKAC\n"
    "F\316\367FBMJLF\n"
    "F\311\340AFBBMF\n"
    "F\317\310AFBFJL\n"
    "F\310\253ACFBFF\n"
    "F\327\263BCIFBF\n"
    "F\324\347BMFFFB\n"
    "F\325\371AFaMFFB\n"
    "F\264\346FJBFaBgF\n"
    "F\266\340AFaCAFaC\n"
    "F\325\254BBFaAFL\n"
    "F\315\305BMFBCF\n"
    "F\265\330FBFMBL\n"
    "F\263\330CCIFbBL\n"
    "F\326\361AFBAFB\n"
    "F\326\331ABBMFB\n"
    "F\263\346BMFBIC\n"
    "F\325\327JCILAC\n"
    "F\315\302BMFFBF\n"
    "F\265\306BIJCFBg\n"
    "F\265\261BCAMFF\n"
    "F\315\254BMFBMF\n"
    "F\310\342BMJCAC\n"
    "F\310\347BcJFBMF\n"
    "F\310\316ABAFBF\n"
    "F\304\352AFFBFB\n"
    "F\274\241JMFFJFl\n"
    "F\267\245ABFCAC\n"
    "F\267\253BMBJFlC\n"
    "F\345\372BcJFMFL\n"
    "F\260\331FABMFF\n"
    "F\267\374ABFJCC\n"
    "F\303\327CAFBAC\n"
    "F\303\246BACBFL\n"
    "F\306\323FBACBC\n"
    "F\303\277AFAfMBF\n"
    "F\322\340BFJBAC|b6-b1!\n"
    "F\315\375BFLAcJF\n"
    "F\323\320JFBMFF\n"
    "F\321\362CAFFFB\n"
    "F\300\364FBMFJC\n"
    "F\301\320FJFaCBB\n"
    "F\301\323BACAMgJ\n"
    "F\330\250FBMFFF\n"
    "G\316\273ABBFCAF\n"
    "G\322\275FAFFJCL\n"
    "G\272\316ABFBMFB\n"
    "G\273\250FBBABAL\n"
    "G\316\322AFBIKAC\n"
    "G\277\354BACMFJC\n"
    "G\275\344FFJBKAC\n"
    "G\270\304MFLAFJK\n"
    "G\275\307AFaJMBFF\n"
    "G\315\352BBFaFFJL\n"
    "G\270\316JMFFFFB\n"
    "G\272\254ACFFaBMF\n"
    "G\341\252BLBFBFaC\n"
    "G\317\243ACAFBMB\n"
    "G\274\311MFLALCC\n"
    "G\306\373CCIAFFFk\n"
    "G\274\274FBIFBFaC|j2-y3\n"
    "G\310\264FBFAfCMgB\n"
    "G\307\363FBCIACC\n"
    "G\276\277BBFaJLJFl\n"
    "G\277\361ABgAFBFF\n"
    "G\276\326MFJMgBMF\n"
    "G\276\371FBIJMCI\n"
    "G\275\374AJFBCFacaCf\n"
    "G\322\367BMFACFM\n"
    "G\276\375MFFJBMF\n"
    "G\320\316FFJBAAA\n"
    "G\317\265AAcAfCBAC\n"
    "G\334\277FBBFFAfC\n"
    "G\323\255ABiMgBCFacaCf\n"
    "G\316\342BMFBmFAC\n"
    "G\277\323FBIBFJFl\n"
    "G\272\352BBFaFJAfC\n"
    "G\277\271FBIBFJFl|j2-y3\n"
    "G\271\245FBIAFJK\n"
    "G\270\374FBMFFJC\n"
    "G\277\313FBBMFJL\n"
    "G\270\346AFBFBMF\n"
    "G\300\247BMFBACF\n"
    "G\327\364ABFJFBF\n"
    "G\262\304FBACFBA\n"
    "G\333\340FBIFJFaC\n"
    "G\332\346FaCaBFJFaC\n"
    "G\327\367ABAFBFF\n"
    "G\313\305ABMFBMF\n"
    "G\326\276FBFALCC\n"
    "G\313\275AFBACAfC|y6-y7 i6-x7!\n"
    "G\313\306ABBICJC\n"
    "G\311\347BFaBCFBF\n"
    "G\312\331FFFJFBC\n"
    "G\320\343AFBACJMmg\n"
    "G\327\241ABCFBFF\n"
    "G\263\365BFaBACMgA\n"
    "G\326\372BMFFIMgJ\n"
    "G\320\362BFJFaCFaBg\n"
    "G\264\262BFJFBAC\n"
    "G\263\255FBIBACA|j2-y3\n"
    "G\320\244BACBMFF\n"
    "G\314\365AFaCFBAC\n"
    "G\327\264BCIFJCC\n"
    "G\311\354ABBMFFB\n"
    "G\263\274BFBMFBF\n"
    "G\311\355ABMFFIA\n"
    "G\320\301BFCAFFB\n"
    "G\264\265BMFAFaJK\n"
    "G\311\274FBACAAA\n"
    "G\311\371FBFMBFJ\n"
    "G\263\340FBFJBAC\n"
    "G\325\333FBIAJFB|j2-y3\n"
    "G\327\337FBFBFJC\n"
    "G\274\264MFFBiCMgB\n"
    "G\312\370FBMFBAC\n"
    "G\327\343BMFBFJC\n"
    "G\264\345FBACFBC\n"
    "G\315\327ACCAAcJF\n"
    "G\314\345ABFBACF\n"
    "G\265\253ABBMFFF\n"
    "G\271\310ACACBMF\n"
    "G\304\320BMBFFMgJ\n"
    "G\356\256BMBFFFBg\n"
    "G\311\362CCIBFaJL\n"
    "G\265\315ABABiFKF\n"
    "G\263\312BMFFBFF|y4-j2\n"
    "G\315\242AFBFFaFaCf\n"
    "G\265\334CAMFBmgBA\n"
    "G\305\254AcAFFaCMgJ\n"
    "G\315\266FBIJFlFaC|j2-y3\n"
    "G\266\271FBMFCAF\n"
    "G\304\307MFFJFaCdB\n"
    "G\304\362MFJBFaAC\n"
    "G\310\321BcJFAFBF\n"
    "G\310\314MgJCALCC\n"
    "G\260\321FBIMBFL|j2-y3\n"
    "G\262\256ABABMFF\n"
    "G\302\363FBFFAFaC\n"
    "G\260\351ABCAFFB\n"
    "G\305\320CAFFBBB\n"
    "G\267\361FABCBMF\n"
    "G\305\372FBIFBiAL|j2-y3\n"
    "G\267\312JMFFMBL\n"
    "G\316\262MFJAFFL\n"
    "G\267\366FBIFFJC|j2-y3\n"
    "G\261\370ABFBFAC\n"
    "G\261\360BMFMgABB\n"
    "G\267\265FJFaCCFacaCf\n"
    "G\270\246FBMFFBC\n"
    "G\267\274FBBBFMgJ\n"
    "G\260\356FFFJFaCdB\n"
    "G\267\273FBIBFFbgJ\n"
    "G\267\301BcJFBFFbgJ\n"
    "G\315\374BFLBLCC\n"
    "G\267\300FaCaBBFFbgJ\n"
    "G\303\273CCIJFlFaC\n"
    "G\306\371AFFlCCFacaCf\n"
    "G\303\356BcJFBACA\n"
    "G\322\333AABJFlFaC\n"
    "G\323\340ACFFBAC\n"
    "G\322\326FBIABiMB|j2-y3\n"
    "G\300\264FCAFBAC\n"
    "G\302\322AFBBMFL\n"
    "G\300\373AFBACBB|y7-y6 x7-i6!\n"
    "G\300\357BMFFBFF|j2-y3\n"
    "G\301\274BMFFBiAC\n"
    "G\300\344CIACCFaC\n"
    "G\300\344CIACFMB\n"
    "G\300\370FJFMgJMgJ\n"
    "G\270\330JMFFFBF\n"
    "H\315\360BBFaAFaCML\n"
    "H\322\300ABBFABiAK\n"
    "H\316\257AFBACAcJF\n"
    "H\322\327BMFFAMgAA\n"
    "H\323\375BFAfCBMFF\n"
    "H\323\352FBMBCCCC\n"
    "H\323\276CCICFbgFaAC\n"
    "H\323\242FBBBMFJC\n"
    "H\321\323ABFBFFaFaC\n"
    "H\321\330CCIACBMF\n"
    "H\321\327CAJCCAJC\n"
    "H\324\267FBBJFaCML\n"
    "H\315\371AABCFBFF\n"
    "H\321\272FBIBMFFB|j2-y3\n"
    "H\305\267FJCLAFaJC\n"
    "H\305\271FJCLJLFaC\n"
    "H\274\321ABFBFFBF\n"
    "H\271\373BMFFFBAC|y5-y3\n"
    "H\272\323CCIFBMFB\n"
    "H\273\255FBMBFFLB\n"
    "H\321\277FBBFBFBA\n"
    "H\271\326ACBFaCFBF\n"
    "H\271\325FBIBMFFbgJ|j2-y3\n"
    "H\333\300BFAcAACMgJ\n"
    "H\321\247CCABFaFaBgF\n"
    "H\324\300ABFBFBLB\n"
    "H\271\331BBFaBMFMF\n"
    "H\260\266BLBFJFFB\n"
    "H\321\322BLBFJBMF\n"
    "H\306\346FJCFBMFB\n"
    "H\306\355BFaBCAJFB\n"
    "H\274\276AFBACFaBgF\n"
    "H\322\313BBFaBMFFF\n"
    "H\306\374CCIBFCAF\n"
    "H\276\323MFJFBBMF\n"
    "H\276\334FBIBFMFF|j2-y3\n"
    "H\317\355BFBMFFaBgC\n"
    "H\276\251BFBMFBAC\n"
    "H\271\251ABFBBFAC\n"
    "H\317\277BLBFCAJC\n"
    "H\275\360ACFFBCAF\n"
    "H\277\340FBBFBBMF\n"
    "H\276\337BMFFFFAC\n"
    "H\277\325BBFaJLFBF\n"
    "H\307\374MFJBLBLB\n"
    "H\276\266AABFaCFBF\n"
    "H\276\245FBBFaCFBF\n"
    "H\310\257CAFFJCMgJ\n"
    "H\274\347FMFJBMFF\n"
    "H\317\322MFLbgBFAcAfC\n"
    "H\272\364BMFACAFBg\n"
    "H\271\314BMFBBMFF\n"
    "H\273\242BFJFaFLJL\n"
    "H\320\322FBFCAFFB\n"
    "H\276\320FBIAMgBMF|j2-y3\n"
    "H\260\272BMFFABiMgB\n"
    "H\277\317BFBFBMFF\n"
    "H\277\314BFAcAACBB\n"
    "H\271\372BMFBFFCF\n"
    "H\300\245BMFFFBiAL\n"
    "H\306\336FMFFBAcJF\n"
    "H\332\346BcJFAfCBMF\n"
    "H\313\242MFJBMBBB\n"
    "H\262\316AfCFJCAAA\n"
    "H\312\271ABFBMFJC\n"
    "H\264\314FBMBACBB\n"
    "H\326\246FBACFBFjK\n"
    "H\354\355BFaBCBFBF\n"
    "H\326\253JMFFFBFaC\n"
    "H\312\302FBMFMFFB\n"
    "H\312\314ABFBFFBC\n"
    "H\326\316CCIAfCBMF\n"
    "H\311\341ACFBFBMF\n"
    "H\325\337FBFABMFF\n"
    "H\320\260FBFBAFaCdB\n"
    "H\310\364FBBJFBMF\n"
    "H\310\241FBFFIBFaC\n"
    "H\312\334ACCABFaFaC\n"
    "H\326\334JMFBFBMF\n"
    "H\327\332BBFaFFBAC\n"
    "H\312\345BFFBACFjK\n"
    "H\312\366FBACCCFacaCf\n"
    "H\313\371FMFJAJFB\n"
    "H\311\320BCABMBMF\n"
    "H\263\320FaBFFFFaAC\n"
    "H\325\320FBIFbgJBMF|j2-y3\n"
    "H\313\311FBACACAfC\n"
    "H\325\323CCIMJBMF\n"
    "H\264\271AFFBBFBF\n"
    "H\264\266CAJCAFaJC\n"
    "H\312\340FBACFACL\n"
    "H\326\306AFFBMBBB\n"
    "H\320\325BcJFAFBFF\n"
    "H\325\367AABFBFBF\n"
    "H\320\324ACBAFBFF\n"
    "H\307\340FBFFBMFF\n"
    "H\316\364FBBFBMFF\n"
    "H\316\366FBACAJFB\n"
    "H\327\276FBIBLBLB|j2-y3\n"
    "H\327\350FaCdBBMFFF\n"
    "H\327\344BFACACFB\n"
    "H\327\277BFBMFFFB\n"
    "H\315\330FBIFJBMF|j2-y3\n"
    "H\265\243FBIBMFFF|j2-y3\n"
    "H\326\252AFFJCBMF\n"
    "H\326\346BBFaBMBFF\n"
    "H\326\322BMFBALCC\n"
    "H\263\351FBIBMBFF|j2-y3\n"
    "H\327\242CCICFBFF\n"
    "H\306\272FBIFCAFB\n"
    "H\266\250BBFaFBFJC\n"
    "H\265\327BFJABiFCF\n"
    "H\265\326FBIABiFCF|j2-y3\n"
    "H\333\241ABiFCFFaCdB\n"
    "H\304\340CCIMFJAL\n"
    "H\265\304ABMFFAMgC\n"
    "H\265\374AFFJCCFacaCf\n"
    "H\265\344BMBBFFAC\n"
    "H\265\352BFJBFBMF\n"
    "H\265\275FAfCFBIBB\n"
    "H\266\276FBFFAfMBF\n"
    "H\315\273BBFaJLFJK\n"
    "H\275\354MFJBMBFF\n"
    "H\310\351ACCAFaBgIL\n"
    "H\304\356ACFFaBLCC\n"
    "H\262\250CCIJFaBFaC\n"
    "H\261\255FBACFABC\n"
    "H\305\304FBIABMFF|j2-y3\n"
    "H\262\264CCIABMFF\n"
    "H\306\310ABMFFCFacaCf\n"
    "H\260\345FBACFJFjK\n"
    "H\260\346JBFMFJFaC\n"
    "H\261\313AABJFaBFaC\n"
    "H\305\373FBIJFaBFaC|j2-y3\n"
    "H\303\332CCICJKCC\n"
    "H\267\307JFFIBFFF\n"
    "H\261\355FBFFABiAC\n"
    "H\303\347FBBBMBFF\n"
    "H\270\256BFJABFBC\n"
    "H\262\300ACBAFBMB\n"
    "H\270\275FaCdBABFBC\n"
    "H\316\352ABAFLMFB\n"
    "H\316\344FFBFBIKC\n"
    "H\267\376JMFFBMFaC\n"
    "H\267\320CCIMFBmgJB\n"
    "H\316\357AFBIAMgAA\n"
    "H\267\356FFFJCFFB\n"
    "H\261\246BBFaFBFFC\n"
    "H\261\247FBIAMgMFL|j2-y3\n"
    "H\267\305BFMgJAFJK\n"
    "H\267\250CCIFBFAfC\n"
    "H\305\335CCIAMMFL\n"
    "H\267\277FMFJBFMgJ\n"
    "H\267\276JMFFBFMgJ\n"
    "H\304\301AFBIAFJC\n"
    "H\261\274FJCFBFJB\n"
    "H\303\303BcJFFFBAC\n"
    "H\303\266FBACAFJK\n"
    "H\304\250FBIFFBAC|j2-y3\n"
    "H\316\266BMFFFBAC|a6-a3\n"
    "H\341\265BLBBMFFB\n"
    "H\303\374ACFBMFMB\n"
    "H\303\367BMFFJMFF\n"
    "H\303\342AFaBMBFJL\n"
    "H\303\257FBBJFKAC\n"
    "H\303\244BFLBMFFF\n"
    "H\322\271BFABAFaCC\n"
    "H\323\315CCIBMBFF\n"
    "H\301\326FBACFBAC\n"
    "H\300\375ABFJFaCBB\n"
    "H\302\257CAJCFMFJ\n"
    "H\272\315AFBACBMF\n"
    "H\265\317BMBFFCFacaCf\n"
    "I\260\247BFBMFABiAC\n"
    "I\315\376JFFAcAFKAC\n"
    "I\316\270BMBFFBMFF\n"
    "I\322\366BcJFBMFJCF\n"
    "I\323\263BMFFBMFJC\n"
    "I\322\337BFJCIJFlFaC\n"
    "I\316\335MFJFAfCFBF\n"
    "I\320\266AFFBFBIMB\n"
    "I\322\364BFCAFBMFF\n"
    "I\277\306AFBACCCFB\n"
    "I\274\334MgJBMFFBAC\n"
    "I\273\332ACBAFJfMJF\n"
    "I\272\243CCIAFBfFjJF\n"
    "I\275\347BMBFFACJB\n"
    "I\275\324FBiALABMFF\n"
    "I\324\253FBIFBMFFF\n"
    "I\270\357FBBFBMFFB\n"
    "I\300\250FBIAFBBMF|j2-y3\n"
    "I\273\356CCIAFBBMF\n"
    "I\271\332BFaFFJLFBC\n"
    "I\276\355CAFFJCMFL\n"
    "I\277\264AFFJBMFFF\n"
    "I\274\315AcAfCBACMFL\n"
    "I\277\315BBFaAFaCBMF\n"
    "I\305\260BFJFaFLFFL\n"
    "I\304\346CAFLBJCFacaCf\n"
    "I\274\261AFaMFFALCC\n"
    "I\274\266AcAfCBACJFafaC\n"
    "I\276\300AcAfCBACBFB\n"
    "I\320\256FBIFCAFJC|j2-y3\n"
    "I\317\301ABgAFCAFJC\n"
    "I\320\315FFJBBBFBF\n"
    "I\306\365FBFIMgJFJC\n"
    "I\275\250MFFFFBFaFaCf\n"
    "I\321\320FJBMFFFJB\n"
    "I\317\336FaCdBMFFBiAC\n"
    "I\271\302FaBgIAJBICK\n"
    "I\273\241MFBmgAJBICK\n"
    "I\271\312FBBMFACJK\n"
    "I\277\335FBACFBBMF\n"
    "I\341\341AABAcAfCJFaC\n"
    "I\272\356ABMFAFFJK\n"
    "I\272\361FJBMFFFaBgF\n"
    "I\272\343ACBFBMFFF\n"
    "I\273\316BMFFBCAJL\n"
    "I\272\351CCIFBBFAC\n"
    "I\273\312ABMFFFBFF\n"
    "I\273\304FBBBFLJBL\n"
    "I\275\274BFACJCFaCdB\n"
    "I\317\343AFBACBMFF\n"
    "I\277\275FBIFBFAABmg|j2-y3\n"
    "I\272\336ACBMFFBiAC|a5-a3\n"
    "I\262\351FBACBMFFF|b5-b2\n"
    "I\311\260FJBMFBACA\n"
    "I\317\367BCABMFFBB\n"
    "I\327\362BMFFAFMFF\n"
    "I\327\313CIAFaJCAcJF\n"
    "I\313\274BMBFFALCC\n"
    "I\326\270FBIALBMFF|j2-y3\n"
    "I\312\251BFJMgAFMBL\n"
    "I\263\326FBIFBFFBC|j2-y3\n"
    "I\312\322BBFaFAfCFBF\n"
    "I\341\367ABgABBFaFBC\n"
    "I\312\327CAFABMFFF\n"
    "I\312\260FBIACFBMF|j2-y3\n"
    "I\307\357AFBACCAJC\n"
    "I\310\341FaCFaBAFBAC\n"
    "I\326\330AFBMFFBFF\n"
    "I\327\243BFaBCBMFJL\n"
    "I\277\241ABAbCJLJFjC\n"
    "I\264\272FFFJCBMFF\n"
    "I\266\334AJFBBMFFF\n"
    "I\320\360ACFFBACFjC\n"
    "I\325\321BMFFMJBMF\n"
    "I\312\241BACABMFFF\n"
    "I\263\307FBIJFFbgCAC\n"
    "I\312\263ACBMFFBiAC|b6-y1\n"
    "I\320\305ABCFFFBMF\n"
    "I\307\326ABMFFAFaFaC\n"
    "I\311\361BFaBCBMFFB\n"
    "I\311\365FBBFFFJLL\n"
    "I\312\307BMFFFBFJC\n"
    "I\325\376FBFBIAFJC\n"
    "I\320\307BMFFAFBFF\n"
    "I\311\374AFBIAFBFF\n"
    "I\307\324BBFaJLALMgJ\n"
    "I\320\373BBFaFBMFFF\n"
    "I\310\252ABMFFBFaAC\n"
    "I\307\263CCIFFFKAC\n"
    "I\317\264CCIAFBFJL\n"
    "I\310\276CCIJFlFBAC\n"
    "I\307\260CAFBMFFBB\n"
    "I\327\346BFaBCBMFFF\n"
    "I\327\340FFFJCFFJC\n"
    "I\317\340FBACBMFFF|a5-a2\n"
    "I\262\335FBBBMFFFB\n"
    "I\313\315CAFFJCCFacaCf\n"
    "I\264\331ABBMFBFJK\n"
    "I\313\327ABACACBMF\n"
    "I\304\315FABMBBFBC\n"
    "I\264\375AABFBFFBC\n"
    "I\265\241AfCBMFALCC\n"
    "I\314\245JMFFAfCBMF\n"
    "I\315\313MFFBiACCFacaCf\n"
    "I\314\277BMBFJCAJC\n"
    "I\265\250JMFFBMFFF\n"
    "I\266\316ABFFFJFlFaC\n"
    "I\262\350FBBACFBAC\n"
    "I\326\347MFJCBMFFF\n"
    "I\326\371FBACCFBFF\n"
    "I\326\324FBMFBABiAC\n"
    "I\314\364FBIJCILAC|j2-y3\n"
    "I\353\267FBMFBACMgJ\n"
    "I\325\344FBFIACAAA\n"
    "I\275\362CCIMFFFFB\n"
    "I\327\267ABMFMFCFacaCf\n"
    "I\315\244BFBMFBFaFB\n"
    "I\265\333BFCABFaBMB\n"
    "I\265\343BFBMFACCC\n"
    "I\266\310BFJFBBFFaC\n"
    "I\305\255AcJFFaCALCC\n"
    "I\314\323JCILACCFacaCf\n"
    "I\266\264CCIBMFBMF\n"
    "I\304\344FFBBABMFL\n"
    "I\266\300ABgABMFBIC\n"
    "I\304\317FBBMCAFFB\n"
    "I\305\311CCIAJAJAC\n"
    "I\261\263FBIALBMFF\n"
    "I\267\316JMFFBFBMB\n"
    "I\261\260ABMBFFAFB\n"
    "I\303\300CAFBFFFJC\n"
    "I\303\353AFBACBACA\n"
    "I\306\267BMFBMFBMF\n"
    "I\270\260FBFBFACBC\n"
    "I\267\342FBFFBIFBC\n"
    "I\267\333CABACACMgJ\n"
    "I\261\372FBACFBMJC\n"
    "I\261\343ABFBMFFJC\n"
    "I\261\243ABBMFFBAC\n"
    "I\260\373JMFFAMMFL\n"
    "I\304\263FBBFFFBAC\n"
    "I\303\260BMFFBMFFF\n"
    "I\305\350ACMgABMBBF\n"
    "I\303\324CAFBACCFacaCf\n"
    "I\303\346FABMBBFFF\n"
    "I\301\370FBACABiJMgB\n"
    "I\323\302FaCBMBFFMgJ\n"
    "I\323\304BAcAfCAcAfCLB\n"
    "I\321\363CCICAFFFB\n"
    "I\322\252FBMBBFAcJF\n"
    "I\324\241CCIACACbMF\n"
    "I\302\311AABMFFFFB\n"
    "I\301\317CABACCCFB\n"
    "I\300\345FJBMFFBFF\n"
    "I\301\341FBFIACCFaC\n"
    "I\301\341FBFIACFMgB\n"
    "I\300\311BMFFBiCFaCdB\n"
    "I\344\255CCIAMgBMFF\n"
    "J\260\270BBFaAcJFFBAC\n"
    "J\324\272FaCdBBBFaFFJL\n"
    "J\306\326CCIFBMFFBC\n"
    "J\322\346CAFACBMBBF\n"
    "J\324\303ACBCABMFJL\n"
    "J\321\347BBFaBMFFAcJF\n"
    "J\316\314ACAfCMCIMCI\n"
    "J\260\263ABFJCBMFFL\n"
    "J\266\367BMFJCFALCC\n"
    "J\317\304FABMFFFAFaC\n"
    "J\274\322BBFaFACbgAAAC\n"
    "J\272\311FBBABFBMFB\n"
    "J\316\303BMFBICBFJK\n"
    "J\272\246BBFaFBFFBMF\n"
    "J\270\361FBACAFaCBMF\n"
    "J\272\313FBACBFAcAAC\n"
    "J\326\352FBACAFFBAC\n"
    "J\274\310MFFBiCFBFJL\n"
    "J\306\360FBFBFACMFL\n"
    "J\271\355ABMBFFJLAfC\n"
    "J\276\331CCAFACAFFBg\n"
    "J\277\326FBIJFlCALCC\n"
    "J\271\247FBBFACBACC\n"
    "J\320\330JMFFAMgACLB\n"
    "J\300\365FBMBBFFBAC\n"
    "J\311\243FaCFaCFaCFBAC\n"
    "J\277\244MFFJBMFFaCdB\n"
    "J\274\346CAFMFFBBAC\n"
    "J\324\255FJABMFFBAC\n"
    "J\316\362ACBFBMFBMF\n"
    "J\272\362ABBMFAFFJK\n"
    "J\320\243FBACBFACJK\n"
    "J\270\373FFFBACFFJB\n"
    "J\272\275AJMCBIBFJFl\n"
    "J\275\265FaCdBAFaCFBFB\n"
    "J\270\337BFBMFBMBMF\n"
    "J\271\307BMBFBFaBMFF\n"
    "J\270\371FBACMFFBiAC\n"
    "J\313\364BMFAfCALAFaC\n"
    "J\262\356CAFBFFAFBF\n"
    "J\327\371BFJACACFBF\n"
    "J\324\327BBFaBFCAFFB\n"
    "J\324\324FBFFBACKAC\n"
    "J\313\367FBBFaAcAfCBAC\n"
    "J\325\273FBACFFFCAC\n"
    "J\262\317FFJCBMFBFC\n"
    "J\262\320FJFjCFFFCAC\n"
    "J\326\254JMFFALBMFF\n"
    "J\274\262BFJCIAFFJC\n"
    "J\311\344ABMFFIIFBC\n"
    "J\275\350ABFBBFBMFF\n"
    "J\327\303FBMJLFFAMgC\n"
    "J\310\365MFBmgCIMFBmgCI\n"
    "J\312\342FJFjCAFFBAC\n"
    "J\326\351FBFIAFFBAC\n"
    "J\276\306CCIFBMJLFF\n"
    "J\320\336ABBAFACAAA\n"
    "J\327\274CIABAFBFFF\n"
    "J\321\263FJFjCAMgBMFF\n"
    "J\320\354AABACFFBAC\n"
    "J\263\375FaCdBACFFBAC\n"
    "J\317\374BBFaBCABMFF\n"
    "J\317\373CCIBCABMFF\n"
    "J\326\242BFJCIFBFBF\n"
    "J\317\351BFaBCCAFBFF\n"
    "J\263\306AFBACAFBAC\n"
    "J\320\246AFBAFBAFJC\n"
    "J\310\350FJFFBiACFBC\n"
    "J\264\275FJFFBiACBMF\n"
    "J\311\357BcJFFJFFBiAC\n"
    "J\325\361FBIFJFFBiAC|j2-y3\n"
    "J\275\372FBBCAFBMFF\n"
    "J\275\376CCIMFFBFaFaC\n"
    "J\325\346FBBMFFFFAC\n"
    "J\313\245BFBMFFABiAC\n"
    "J\312\305FBIAJFBCFacaCf\n"
    "J\317\257BFJFBBFBMB\n"
    "J\311\310FMFJMCIMCI\n"
    "J\313\250FBACACFBFF\n"
    "J\327\342AFBACBMFFF\n"
    "J\313\330FBFFAcAfCBAC\n"
    "J\313\321FBIBMFFBFaC|j2-y3\n"
    "J\324\354AFBFBMFCFacaCf\n"
    "J\317\242ABMFFFALCC\n"
    "J\313\331FBMFBACCFacaCf\n"
    "J\320\344BFaBACBMBFF\n"
    "J\264\370FBBBFBFaBMB\n"
    "J\314\251FFFJCBCIAC\n"
    "J\326\302FAfCFBIAFJK\n"
    "J\320\363BFAcAfCBMBFF\n"
    "J\326\360FACbgAAACCFacaCf\n"
    "J\326\310AFBACAFFJC\n"
    "J\353\336JMFFCAFFJC\n"
    "J\315\250FaCBMFFBCFacaCf\n"
    "J\315\245BFJAFBFFaFaCf\n"
    "J\325\271MFJFBBFBiAC\n"
    "J\315\275AABFBFBFAC\n"
    "J\315\276ACFFBACCFacaCf\n"
    "J\265\271ABFAfCFBIBB\n"
    "J\265\263BCABFaBMFJL\n"
    "J\314\306BFJMFFBBMF\n"
    "J\314\322FBACJCILAC\n"
    "J\315\270AFBACAMmgCFacaCf\n"
    "J\353\330JMFFBMFBMF\n"
    "J\314\330AFBIFBFFBC\n"
    "J\304\334AfCBMFFALAL\n"
    "J\306\306FJBMFJFaBFaC\n"
    "J\331\275ABJFFFBFFF\n"
    "J\305\344FBMJLFFMFL\n"
    "J\261\266ABBFCAFBMF\n"
    "J\303\267FBACAFLMBF\n"
    "J\260\340FBFIBJFBFF\n"
    "J\305\317BMBFFCAFFB\n"
    "J\260\343AJMCBIJFlFaC\n"
    "J\306\243BFJCIJFaBFaC\n"
    "J\303\330AFBACCALBC\n"
    "J\261\273BFaBACJFaBFaC\n"
    "J\274\247BcJFBFBMFBF\n"
    "J\262\241BFJCIFBMJC\n"
    "J\344\272CCIABFBFAC\n"
    "J\303\364AFLMBFAFJK\n"
    "J\306\277CAFFJBFBiFlC\n"
    "J\270\241CCIACCAFaBgF\n"
    "J\261\335FaCdBFBiALFBF\n"
    "J\303\343AFaBMBFJLMgJ\n"
    "J\262\266FBIFBMFFBC|j2-y3\n"
    "J\331\272ABFFFJCFFB\n"
    "J\267\345BLBAFaCFFFB\n"
    "J\306\312BFCAFBMFBB\n"
    "J\302\361FBIBMFFBFF\n"
    "J\303\337BMFFFMFBiFC\n"
    "J\304\357BcJFBMFFBiAC\n"
    "J\272\304FFFBACAFFL\n"
    "J\310\335BBFaACACBMF\n"
    "J\301\367CCIBFAfCJBL\n"
    "J\301\364ABiCMgJBMBFF\n"
    "J\302\303BFMgJAFABAC\n"
    "J\301\322FAFaCBBACCC\n"
    "J\301\265BFJBACALCC\n"
    "J\300\312BMFFBiCJMFF\n"
    "J\300\313CCIBMFFBiAC\n"
    "K\350\367FBACBFCAFFB\n"
    "K\316\276MFJFFBACFBC\n"
    "K\322\306AFBACAFaCAFaC\n"
    "K\323\362FBIFBMFICAC\n"
    "K\322\272CCIBFABAFaCC\n"
    "K\273\306FBBFBMBFFAC\n"
    "K\320\265FBACFFJBKJC\n"
    "K\321\304CCIFJFBFFBF\n"
    "K\271\371BFBMFFaBgIFaCdB\n"
    "K\271\322FBIFBFFBIBC|j2-y3\n"
    "K\272\310BMFBMFFAMgAL\n"
    "K\277\312CCIBMFFAMgAL\n"
    "K\307\254FBBMFFFBAFFaf\n"
    "K\277\261FBBFFFJLLMgJ\n"
    "K\273\274BMFBMFBALCC\n"
    "K\321\333BMFFFMFFBiAC\n"
    "K\273\371FBBFFFACFBF\n"
    "K\274\304BBFaFJCFBMFB\n"
    "K\276\325FBBAMgCAFBAC\n"
    "K\275\305JMFFFBFAfCMgB\n"
    "K\276\310FBCIACCAFAC\n"
    "K\307\362FBFIFBCIACC\n"
    "K\320\351BFJFaFLBBCAF\n"
    "K\275\314FBFAFaBgIAFAC\n"
    "K\276\372FBBBMAFBACF\n"
    "K\305\274ABBMFFBMBFC\n"
    "K\276\362FBIMFJFLBLB|j2-y3\n"
    "K\275\322FBIBMFFAMgAL|j2-y3\n"
    "K\275\241ABMFFFFBFaFaC\n"
    "K\277\265BFJMFFBCIAC\n"
    "K\277\330FBIBBFaJLFBF|j2-y3\n"
    "K\272\332BMFFBFFACCC\n"
    "K\273\351BcJFABiFKBMFF\n"
    "K\273\354CCIBMFFFBiAL\n"
    "K\327\356BMFFFBFFIFaC\n"
    "K\262\312ACCAFBACAAA\n"
    "K\274\300AFaCCFaCFFBAC\n"
    "K\262\313FBBACCAFBAC\n"
    "K\306\351BLBFJCFBMFBg\n"
    "K\262\322ACBAfCFACAAA\n"
    "K\311\342FBFJBBCAFJK\n"
    "K\320\261ACFFBACCCFB\n"
    "K\311\337BMFBICBBFaAL\n"
    "K\274\305BBFaBFFBACFaC\n"
    "K\312\332FBIACCABFaFaC|j2-y3\n"
    "K\313\336BBFaABFABMFF\n"
    "K\312\347CCIFBFBACFjK\n"
    "K\312\374BFJFBBFACCC\n"
    "K\311\314BFCABMJLBMF\n"
    "K\263\252BMFBMFFBMFF\n"
    "K\325\302BFCAFBMFFFB\n"
    "K\263\243BCABFaBMFBMB\n"
    "K\307\351ACBFBFFBMFF\n"
    "K\311\356CCIBFaJLFBAC\n"
    "K\315\306FBIABAFBFFF|j2-y3\n"
    "K\263\347BLBBBFaFFBAC\n"
    "K\276\335FBIMFJFBBMF|j2-y3\n"
    "K\310\270BACABAFBFFF\n"
    "K\307\345CCIFBFFBMFF\n"
    "K\317\247ACBFBBFBMFF\n"
    "K\275\323FBIBFCAFAcJF|j2-y3\n"
    "K\321\251FBFaBCCCCMFF\n"
    "K\320\375BFMgJAFFaBFJC\n"
    "K\264\254AJMCBIACBMF\n"
    "K\264\353FBIFBBFBMFF|j2-y3\n"
    "K\264\326CAFBACBMFFF\n"
    "K\311\250FBIMFFBFaBMB|j2-y3\n"
    "K\262\334FBMBBFFBMFF\n"
    "K\263\262CCABMFFFBAC\n"
    "K\327\345BFMgJACAFFJC\n"
    "K\264\374ABFCCBFABiAC\n"
    "K\264\376MFFBCIACCFacaCf\n"
    "K\265\332AFBAFBMFBmgBA\n"
    "K\315\321JMFFCABMFJL\n"
    "K\314\275FBIBFaJLFBAC|j2-y3\n"
    "K\265\255CCIBIJKBIJK\n"
    "K\266\317CAFBACLAJFB\n"
    "K\326\317BBFaJLFAfCFBF\n"
    "K\326\370FBBFBFABMFF\n"
    "K\314\367BMFFFJCILAC\n"
    "K\315\243ABBFBMFBFaFB\n"
    "K\265\321AFBAFBBMBFF\n"
    "K\314\355CCIAFJCBACC\n"
    "K\266\274FBFABMFFFaCdB\n"
    "K\265\277ACBBFBMFFFB\n"
    "K\265\301CIAFaJCBMBBF\n"
    "K\314\325FaCdBAMAFFBLB\n"
    "K\314\303BCABFaBMFFBF\n"
    "K\265\303AABBMFFFFBC\n"
    "K\353\340JMFFFACbgAAAC\n"
    "K\303\250ABgAFBBBMBFF\n"
    "K\325\263CAFBACBFBMF\n"
    "K\306\305CCIJFaBFaCAfJF\n"
    "K\305\305FBIJFFFBFFF|j2-y3\n"
    "K\305\340FBIBFCAFBMF\n"
    "K\305\343FaCdBBFCAFBMF\n"
    "K\262\260AJMCBIABMFF\n"
    "K\306\261FBMBBFFFBAC\n"
    "K\303\350FBIFBBBMBFF|j2-y3\n"
    "K\267\373AFBAFBABFBC\n"
    "K\262\277BFCAFBMFFaCdB\n"
    "K\270\261FBMFBMBFFBB\n"
    "K\306\253ABFMFJBMFBB\n"
    "K\261\300BLBJMFFJMFF\n"
    "K\303\310FBBBMFFJMFF\n"
    "K\315\373BFLJMFFFBFF\n"
    "K\334\245FBIMFJBLBLB\n"
    "K\302\351BFJFBACFBAC\n"
    "K\303\334BBFaBALBCBLB\n"
    "K\303\315ABgCFaBgFBMBBF\n"
    "K\322\260BMFFBFIFaCFaBg\n"
    "K\316\250BMFABAFBFFF\n"
    "K\323\306ABBAFACALCC\n"
    "K\323\271BFJMFFBMFFB\n"
    "K\310\334CCIBBFaACBMF\n"
    "K\323\373ACACBMFAFaJC\n"
    "K\322\356MCIMCIBFCAF\n"
    "K\300\355FBFIBMFFBFF\n"
    "K\302\312BFAcAfCCIACFB\n"
    "K\302\324BMBFFAFaCBMF\n"
    "K\301\243CAFBACBFCAF\n"
    "K\302\241FaCdBAFaCAFBFF\n"
    "K\301\352FaCdBFBFALAFaC\n"
    "K\300\333BMBFFAcAfCBAC\n"
    "L\277\373FBBFaCACAFFJC\n"
    "L\316\325FBIMFJFAfCFBF|j2-y3\n"
    "L\323\252CCABFaBMFABMF\n"
    "L\347\370FBFIFBBBMFJC\n"
    "L\324\275FBFBFACBiFKAC\n"
    "L\324\256FBIACCAFFJFaC|j2-y3\n"
    "L\260\302ABMCAFBACFJC\n"
    "L\316\302CCIBMFFBMBBF\n"
    "L\274\336BcJFBBFaACbgAAAC\n"
    "L\275\326AABFBFFBIFFB\n"
    "L\270\356BBFaFBFFBMFBB\n"
    "L\272\256BBFaFBBFFACCC\n"
    "L\277\260FBIFBBFFFALL\n"
    "L\270\322FBFBFFIBAFJC\n"
    "L\271\327FBACBBFaBMFMF\n"
    "L\277\356FBFFFBACAFaJC\n"
    "L\317\262FBFBMFCAFBMF\n"
    "L\306\332FBBFFFACJMFF\n"
    "L\306\345FBACFBBFFFAC\n"
    "L\306\333FBBFFFACAFaJC\n"
    "L\276\340BMFBFBIBFMFF\n"
    "L\307\332FBBBMFBFFIMgJ\n"
    "L\307\331FBFIFBFFACFFa\n"
    "L\275\356AFBAFBJMFFMgJ\n"
    "L\323\366BMFFBMBICCFacaCf\n"
    "L\323\347FaCdBBMFFBMFFC\n"
    "L\276\264FBBAFmgBMFAFJC\n"
    "L\276\260BMFFBFBMFBAC\n"
    "L\310\246BMCAFFJCMFLF\n"
    "L\272\376CCIFBBMFJMFF\n"
    "L\271\315FMFJABBFBFFF\n"
    "L\323\371AABAFFBFBIMgB\n"
    "L\273\305ACBFBBBFLJBL\n"
    "L\270\333CCIFBBFACMFL\n"
    "L\323\262FJBMFFBMFFJC\n"
    "L\262\303FBFBFABiACKAC\n"
    "L\262\337AFBAFBFBMBAC\n"
    "L\311\242FBBFBMFFAFJC\n"
    "L\327\317BFBIALAcAfCBAC\n"
    "L\327\314CCICAFAcAfCAcAfC\n"
    "L\312\252CCIBMFFBBCAF\n"
    "L\326\363FBFABMFFACCC\n"
    "L\276\315BFBMFBACFJLC\n"
    "L\274\257ABAFBFFFFBAC\n"
    "L\321\255AABAJFBBMFFF\n"
    "L\312\356BMFFFBFABMFF\n"
    "L\325\306BCABFaBMFAFFBg\n"
    "L\276\247BMFFBMFFBMFF|y5-y1\n"
    "L\275\271ABAFBFFFACCC\n"
    "L\317\365FJBMFBCABMFF\n"
    "L\317\363AFaBMBFACbgAAAC\n"
    "L\311\255FBACFBACFBAC\n"
    "L\365\241FBMJLFFAFBFF\n"
    "L\313\354CAFACbgAAACCFacaCf\n"
    "L\313\346FaCdBAFBMFFCFacaCf\n"
    "L\307\347BMFFFBFFBMFF\n"
    "L\313\260AFBACCABMFJL\n"
    "L\311\306CAFFFBCAFBMF\n"
    "L\310\273AFaCCFJCCACCC\n"
    "L\324\341FBBFAFaCALFJB\n"
    "L\327\260BCIFBFBFABiAC\n"
    "L\312\364MFJABMFBMBIC\n"
    "L\327\360CAFBMJLFFFBC\n"
    "L\266\351FaCdBJFBMFFFBF\n"
    "L\266\350ACBFJFBFBMFF\n"
    "L\314\346FFJCFFJCBMFF\n"
    "L\305\357FBACJMFFJMFF\n"
    "L\266\314AFFJCFBMFCAF\n"
    "L\326\307AFFJCBMFBMFF\n"
    "L\327\305CAFBFFABMFFF\n"
    "L\263\257FBBMFFFBJMFF\n"
    "L\263\254FBFBFACMgABMF\n"
    "L\315\264BFJCIFaCBMFFB\n"
    "L\265\314FBIBMFFFBFJC\n"
    "L\314\341FBIBMFFFBFJC|j2-y3\n"
    "L\263\314AFBACBMFFBFF\n"
    "L\265\356MJFBBFACJFlFaC\n"
    "L\266\311CCIBFJFBBFFaC\n"
    "L\265\307FaCACAFBMFCAF\n"
    "L\313\376FBIFBBACFBMF\n"
    "L\264\356FBIFBBACFBMF|j2-y3\n"
    "L\266\273BFJCIFBMFCAF\n"
    "L\265\310AFBAFBFBFFBC\n"
    "L\264\360AFBAFBACFBMF\n"
    "L\315\262AFBAFBBMFBMF\n"
    "L\315\257BFCAFBMFFBFF\n"
    "L\265\300CAFABMFFFCFacaCf\n"
    "L\303\275BcJFFBBFFFBAC\n"
    "L\262\251FBFBMFFBCFBC\n"
    "L\315\355BMFFAFaBMBFJL\n"
    "L\267\254ACAFBACBMBFF\n"
    "L\302\371BFJBACBMFBIC\n"
    "L\261\257JFFFBFFFALCC\n"
    "L\354\351FMFJJFFIBFFF\n"
    "L\270\273BBFaFBMFBMBFF\n"
    "L\306\325CAFBBCAFBMFF\n"
    "L\267\371BMBFBMFBMBFF\n"
    "L\261\351FMFJBMFBBCFacaCf\n"
    "L\304\274FBBBMFFFACMgJ\n"
    "L\260\370ABBFCABFaBFFbgA\n"
    "L\303\261BMBBMFFBMFFF\n"
    "L\260\364FBACFFFJCFFB\n"
    "L\320\366BcJFFaBFJCBMFF\n"
    "L\323\344ACBACFBMFFBB\n"
    "L\324\243BFaBACACACBMF\n"
    "L\323\316BFMgJAFFaBgFCFacaCf\n"
    "L\320\333FJAfCABAFBFFF\n"
    "L\322\241FBIACCAFFBLB|j2-y3\n"
    "L\302\344FBBCCIAFaCBMF\n"
    "L\301\241BFJCIAFBACBB\n"
    "L\301\362FJBMFBFAfCJBL\n"
    "L\301\277BMFFFBMFFBFF\n"
    "L\301\321FAFaCBBBFABiAC\n"
    "L\300\310BFJBMFFBiCFaCbgB\n"
    "L\273\363FBMFIKACALCC\n"
    "L\315\345CCIBFJBACMFBmg\n"
    "L\315\363JMFFBBFaJFjCML\n"
    "M\260\265BMFFBFCAFBMFF\n"
    "M\322\342BFCAFBMFFALCC\n"
    "M\324\263ABgAFBFBMFABiAC\n"
    "M\317\276BMFFMFBFFMFFaC\n"
    "M\321\305FBFBAABAFBFFF\n"
    "M\275\342AFaJMBFFMgAAFFB\n"
    "M\277\256ACBMFFBiCFBFJL\n"
    "M\270\364FaCdBFBMFBMALFB\n"
    "M\273\254CCIBMBFBFaBLFF\n"
    "M\272\326BFaBACBMFFAMgAL\n"
    "M\270\320JFFBMFKACALCC\n"
    "M\275\373FBACFBACFFBAC\n"
    "M\323\336BMFFBMBICALCC\n"
    "M\321\245FBBFBMFFBABAL\n"
    "M\310\272MFFJBMFCAFFFB\n"
    "M\320\257FBIABBFBFFFAFafag|j2-y3\n"
    "M\317\323BcJFCAFMFFBBAC\n"
    "M\317\327FBBMCAFFBFJCC\n"
    "M\276\356AcAfCBACBMFBMFF\n"
    "M\307\262BMFBFBMFMFCFacaCf\n"
    "M\324\264CCIFJBBMFFBAC\n"
    "M\271\304FBFBMFCAIFBFaC\n"
    "M\321\374JMFFFBMBBFAcJF\n"
    "M\264\337ABBLBABBFBFFF\n"
    "M\327\357BMBBFJFFIBFFF\n"
    "M\325\245FBIBBFaJLAFBFF|j2-y3\n"
    "M\313\303BMFBMFBBMFBMF\n"
    "M\264\310CAFAcAfCAcAfCALCC\n"
    "M\264\307AFBBMFBFCAFFB\n"
    "M\263\356AFBACBAJCALCC\n"
    "M\263\352FBMJLFFAJCBCB\n"
    "M\312\360BMBBFFBFABMFF\n"
    "M\325\325BMFFMgABMFACCC\n"
    "M\325\364FBBFaBgFaAFFACCC\n"
    "M\264\245AFaJMBFFBMFBIC\n"
    "M\307\336BBFaBCIMFFBFaFaC\n"
    "M\311\367ACBFBBMFFFFAC\n"
    "M\320\302BFCAFFBACAJFB\n"
    "M\313\257BMFFFAFFBBFBF\n"
    "M\312\375CAFBACAcJFAFJK\n"
    "M\317\331JMFFABMFFBFaAC\n"
    "M\274\371BMFBFBIFFFKAC\n"
    "M\354\370BFaBCCCABMFFFB\n"
    "M\313\334CAFLBJJMFFFBF\n"
    "M\311\256ABCABMBFFBMFF\n"
    "M\317\353FBACBMFFFALCC\n"
    "M\326\315CCIFBBBFBFaBMB\n"
    "M\305\257BMFFACCAFFJFaC\n"
    "M\263\325BFJCIAFFJCBMF\n"
    "M\326\311AFBACABAFBFFF\n"
    "M\320\356FBBBFAcAfCBMBFF\n"
    "M\314\370BMFBFBIJCILAC\n"
    "M\315\247AJMCBIAFBFFaFjC\n"
    "M\266\275BFFBACFaCBMFFF\n"
    "M\304\256CCIFBBBMFFFJC|j7-y9\n"
    "M\260\341FBIAJMCBIAFlFaC|j2-y3\n"
    "M\316\242AABBLBFJBiAFJK\n"
    "M\270\243BFaBCFBMFBMBFF\n"
    "M\270\271JMFFAFBMFFAFaC\n"
    "M\304\271FBBBMFFFACFBF\n"
    "M\304\273FBBBMFFFACBMB\n"
    "M\303\313BMFFJMFFBMBBF\n"
    "M\323\376CCAFACCFFFBMF\n"
    "M\310\330FBBBBFaACACBMF\n"
    "M\302\343BFaBACBMFFFBAC\n"
    "M\300\327FBFaBCCCCBMBFF\n"
    "M\300\322FBMJLFFAFaCBMF\n"
    "M\301\343FBFaBCCCCACCFaC\n"
    "M\301\343FBFaBCCCCACFMgB\n"
    "M\301\256BFJCAFMFFBBAC\n"
    "M\302\267BMFBFBIAFaCBMF\n"
    "M\302\245FBACCAFBACAcJF\n"
    "N\321\335CCIBBFaFBMBFFAC\n"
    "N\271\321BBFaFBBMFFFACMgA\n"
    "N\270\350FBMFBFBMFBAFaJC\n"
    "N\270\305FBACMFFBiCFBFJL\n"
    "N\271\334AFBAFBBBFaBMFMF\n"
    "N\306\354BFMgJAFFBBFFFAC\n"
    "N\322\311ALAFFJCFaCFaBFJC\n"
    "N\323\346CCIAFaBMBFFACCC\n"
    "N\276\263FBIBFCAFBMFFJL\n"
    "N\275\315FBMJLFFFBFAFaBgF\n"
    "N\272\300BFBMFBFaFACbgAAAC\n"
    "N\277\341FBMJLFFAFBFBMF\n"
    "N\273\352FFAfCABMBFFJLAfC\n"
    "N\262\354BBFaAFaCCFaCFFBAC\n"
    "N\313\343AFBAFBBMFFFFJB\n"
    "N\313\341FBMJLFFAfCJLAFaC\n"
    "N\264\306BFBIALABAFBFFF\n"
    "N\264\305FJBMFCAFAcAfCAcAfC\n"
    "N\306\341CCIFBACACBCAAC\n"
    "N\325\332BFJFBBFACCCCFacaCf\n"
    "N\320\350FBFaBCCCCFABMBB\n"
    "N\333\323BFBMFFaBgIJFlCFBF\n"
    "N\312\354BFBMFFaBgIJFlACCC\n"
    "N\325\303BFCAFBMFFFBAAA\n"
    "N\325\317FaCdBBFCAFBMFFFB\n"
    "N\276\253CAFBACFBFFBMFF\n"
    "N\312\304FBIAJFBCFFFBMF\n"
    "N\276\262FBFFBMFFAFaMFFB\n"
    "N\324\342FBMBBFFBMFFCFacaCf\n"
    "N\317\361ABAFaBMBFACbgAAAC\n"
    "N\324\366FBICABMBFFBMFF\n"
    "N\324\367ACBCABMBFFBMFF\n"
    "N\266\313BFCAIBLBFABMBB\n"
    "N\265\325BcJFBFCABMFBBMF\n"
    "N\341\347AABBLBFBFIAFJK\n"
    "N\325\252FBIBFCABMFBBMF|j2-y3\n"
    "N\265\316CCIBFCABMFBBMF\n"
    "N\261\256FJBMFABMBFFAFB\n"
    "N\261\307ABMFFFBMBFFFJK\n"
    "N\306\257CCIFBMBBFFFBAC\n"
    "N\270\257BFJABFBCBMACAC\n"
    "N\261\314FBFIABMFFFABMF\n"
    "N\304\275FBBBMFFFJCBACC\n"
    "N\304\272FBBBMFFFACBMFF\n"
    "N\304\253BMFFBFFACCCFBF\n"
    "N\304\244JMFFFBBBMFFFJC\n"
    "N\302\375ACBBMFFBMBBFFaC\n"
    "N\302\376CCIBMFFBMBBFFaC\n"
    "N\304\243FBACFBBBMFFFJC\n"
    "N\323\273BMFBFBIFaCBMFFB\n"
    "N\301\305ABFJCCABMFFBAC\n"
    "N\302\251CCIMFJFBMBCCCC\n"
    "O\316\277MFJFFBACFBCALCC\n"
    "O\323\260BMFFBFBMFBACAAA\n"
    "O\274\332AFBACBBFaFACbgAAAC\n"
    "O\273\272AcAfCBACACCAFFJFaC\n"
    "O\306\367BMFBMFFJCBMFBMF\n"
    "O\346\322BcJFFBFBMFCAFBMF\n"
    "O\270\345AFBACBFBMFBMBMF\n"
    "O\264\351FBIBMFFFBFFIBFaC|j2-y3\n"
    "O\324\335FBMFFFBAJFBBMFF\n"
    "O\310\244FBFBFACFBFFIBFaC\n"
    "O\327\361CAFBMJLFFFBCCFacaCf\n"
    "O\326\366BMFMFJABMFBMBFC\n"
    "O\325\360FBFaBCCCCFJFFBiAC\n"
    "O\263\316CCIFaCACAFBMFCAF\n"
    "O\307\261CCIFFJCFFJCBMFF\n"
    "O\262\333FBACFBBMBBFBMFF\n"
    "O\262\330FBBJFBFBMFBFKAC\n"
    "O\263\261CCIFBBMFFFBJMFF\n"
    "O\263\267FBIBFAfCBMFFAFJK|j2-y3\n"
    "O\314\307CAFBACBFJFbFFBMF\n"
    "O\314\244BMFBFBIBFaACBMFF\n"
    "O\317\344AFBAFBFBACBMFFF\n"
    "O\267\363FBMFFBCBFMgJAFJK\n"
    "O\270\263BMFFFACFFBFBIKC\n"
    "O\316\350AFFBBBBFAFaCFBFB\n"
    "O\261\327BCABMBACAFACFJB\n"
    "O\260\375BFABBMFFBACABiAC\n"
    "O\261\251BMFFFBBFACBCIAC\n"
    "O\304\246BFJFBACFBACAFFBg\n"
    "O\367\310ABMBFFJLAfCFFBAC\n"
    "O\304\254BMFFBFIFJCCACCC\n"
    "O\302\304MFJAABAFBMFFAFaC\n"
    "O\345\274BBFaFJCCABMFFBAC\n"
    "P\272\266ACBJFFBMFCACACfCC\n"
    "P\304\375CIALAFFJCFaCFaBFJK\n"
    "P\336\271FBBAFBMFFBFFACCC\n"
    "P\355\254AFBBMFABMFFFALCC\n"
    "P\274\244CCIABMFFBFMgJAFJK\n"
    "P\272\342AABAFaBMBFFFJCFFBg\n"
    "P\310\345ABFAFaBCCCCFABMBB\n"
    "P\310\300FBIBFACFBBFFABiAC\n"
    "P\320\275FBBBFCAFFBACAJFB\n"
    "P\325\373FBMFBACAFACFBFBF\n"
    "P\262\331FBIBMFBMFBMFFBAC|j2-y3\n"
    "P\326\376AFBAFBFBIJFlCFBAC\n"
    "P\310\274CAJCJFjCCFJCCACCC\n"
    "P\261\241FBBCCIFBMFFBCFBC\n"
    "P\267\261AFAcMBFAFACAcAfCBAC\n"
    "P\261\334MFJBMFBFCAFFBCFacaCf\n"
    "P\261\332MFJBMFBFCAFFBFBF\n"
    "P\305\362JMFFFBFBMFCAIAAA\n"
    "P\304\245BFJFBACFBACFABMF\n"
    "P\310\332FBMFBMJLFBBMFBIC\n"
    "Q\262\301FBIBBFaAFaCCFaCFFBAC|j2-y3\n"
    "Q\276\364ACCABMBBFMFFBiCFBC\n"
    "Q\275\270FJBMFABAFBFFFACCC\n"
    "Q\324\357CAJCBMFBMFBMFFBAC\n"
    "Q\313\252FBFaBCCCCFBACBMFFF\n"
    "Q\345\252CCIMFFMFFABAFBFFF\n"
    "Q\315\253BMFFFBFCAFBMFFBFF\n"
    "Q\322\355MCIMCIBMBFFFBBFAC\n"
    "R\275\363BFaBACFBACFBACFFBAC\n"
    "R\313\262BMFFFACCABFaJFjCFBFB\n"
    "R\264\367FBFBMBFFFBFBFACKAC\n"
    "R\267\252FBBCCIACAFBACBMBFF\n"
    "R\270\262FBMBBFAABAFBMFFAFaC\n"
    "R\361\261BFJCIMFJBMFBFCAFFB\n"
    "R\262\276AFBAFBCCIFBMFFBFBC\n"
    "R\267\255ACAFBACBMBFFMCIMCI\n"
    "R\352\327BMFFMFFMFFABAFBFFF\n"
    "S\276\257FBBAMgBMFAFACCFFFBMF\n"
    "S\313\350BMBFBFaBMFFAFBMFFCFacaC\n"
    "S\324\345FBBCCIBMFBMFBMFFBAC\n"
    "S\260\324FBMBBFFBBFBMFFBJMFF\n"
    "S\261\254CAJCBMFFFBBFACBCIAC\n"
    "S\304\247BFJFBACFBACABMBFFAL\n"
    "T\274\256AFBAFBFFFBACFBBFBMFF\n"
    ;
}
#endif /* FOR_STROKEDIC_CREATE_2 */
#endif /*__STROKEDATA_H__*/
/* ----- End of strokedata.h ---------------------------------------------- */
