/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc.
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/
#define MAX_CONNECT 20000

typedef struct {
    XRectangle	area;		/* area */
    XRectangle	area_needed;	/* area needed */
    XPoint	spot_location;	/* spot location */
    Colormap	cmap;		/* colormap */
    CARD32	foreground;	/* foreground */
    CARD32	background;	/* background */
    Pixmap	bg_pixmap;	/* background pixmap */
    char	*base_font;	/* base font of fontset */
    XFontSet    fs;		/* fontset */
    GC		gc;		/* graphics context */
    CARD32	line_space;	/* line spacing */
    Cursor	cursor;		/* cursor */
} PreeditAttributes;

typedef struct {
    XRectangle	area;		/* area */
    XRectangle	area_needed;	/* area needed */
    Colormap	cmap;		/* colormap */
    CARD32	foreground;	/* foreground */
    CARD32	background;	/* background */
    Pixmap	bg_pixmap;	/* background pixmap */
    char	*base_font;	/* base font of fontset */
    XFontSet	fs;		/* fontset */
    GC		gc;		/* graphics context */
    CARD32	line_space;	/* line spacing */
    Cursor	cursor;		/* cursor */
} StatusAttributes;

typedef struct _IC {
    CARD16	id;		/* ic id */
    CARD16	connect_id;	/* connect id */
    INT32	input_style;	/* input style */
    Window	client_win;	/* client window */
    Window	focus_win;	/* focus window */
    Window	status_win;	/* status window(offthespot) */
    Window	preedit_win;	/* preedit window(offthespot) */
    int		reparented;	/* reparented to the client window */
    char	encoding;	/* connection encoding */
    char	*resource_name;	/* resource name */
    char	*resource_class;/* resource class */
    int		len;		/* preedit area string length(onthespot) */
    PreeditAttributes pre_attr; /* preedit attributes */
    StatusAttributes sts_attr;  /* status attributes */
    struct _IC	*next;
} IC;
