
(use-package :gl)

(defvar spin 0.0)
(defvar window)

(ff:defun-c-callable display-callback ()
 ;(format t "Callback DISPLAY.~%") 
 (display))

(defun display ()
 (glClear GL_COLOR_BUFFER_BIT)
 (glPushMatrix)
 (glRotatef spin 0.0 0.0 1.0)
 (glRectf -25.0 -25.0 25.0 25.0)
 (glPopMatrix)
 (glutSwapBuffers))

(ff:defun-c-callable mouse-callback ((button :fixnum) (state :fixnum)
				     (x :fixnum) (y :fixnum))
 ;(format t "Callback MOUSE. BUTTON:~a, STATE:~a, X:~a, Y:~a~%" button state x y)
 (when (eq button GLUT_MIDDLE_BUTTON)
  (glutIdleFunc 0))
 (when (eq button GLUT_LEFT_BUTTON)
  (glutIdleFunc idle-callback))
 (when (eq button GLUT_RIGHT_BUTTON)
  (glutDestroyWindow window)
  (break)))

(ff:defun-c-callable idle-callback ()
 ;(format t "Callback IDLE.~%")
 (incf spin 2.0)
 (when (> spin 360.0) (decf spin 360.0))
 (glutPostRedisplay))

(defun myinit ()
 (glClearColor 0.0 0.0 0.0 1.0)
 (glColor3f 1.0 1.0 1.0)
 (glShadeModel GL_FLAT))

(ff:defun-c-callable reshape-callback ((w :fixnum) (h :fixnum))
 ;(format t "Callback RESHAPE. W:~a, H:~a~%" w h)
 (reshape w h))

(defun reshape (w h)
 (glViewport 0 0 w h)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 (if (<= w h) 
     (glOrtho -50d0 50d0 (* -50d0 (/ h w)) (* 50d0 (/ h w)) -1d0 1d0)
     (glOrtho (* -50d0 (/ h w)) (* 50d0 (/ h w)) -50d0 50d0 -1d0 1d0))
 (glMatrixMode GL_MODELVIEW)
 (glLoadIdentity))

(setq display-callback (ff:register-function 'display-callback))
(setq idle-callback (ff:register-function 'idle-callback))
(setq mouse-callback (ff:register-function 'mouse-callback))
(setq reshape-callback (ff:register-function 'reshape-callback))

(defun main ()
 (glutInitDisplayMode (+ GLUT_DOUBLE GLUT_RGB))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize 500 500)
 (setq window (glutCreateWindow "Double"))
 (myinit)

 ;(reshape 500 500)
 (glutDisplayFunc display-callback)
 (glutReshapeFunc reshape-callback)
 (glutMouseFunc mouse-callback)
 (glutIdleFunc idle-callback)

 (glutMainLoop))
