
(use-package :gl)
(require 'pnm)

(defvar movie)
(defvar movie-length)
(defvar frame-interval)
(defvar frame)
(defvar window)
(defvar width)
(defvar height)
(defvar xzoom)
(defvar yzoom)

(defvar display-callback)
(ff:defun-c-callable display ()
 (let ((begin-time (glutGet GLUT_ELAPSED_TIME))
       (end-time nil)
       (elapsed-time nil))
  (format t "Redrawing~%")
  (glClear GL_COLOR_BUFFER_BIT)
  (glRasterPos2i 0 0)
  (glPixelZoom xzoom yzoom)
  (glDrawPixels width height
		GL_LUMINANCE GL_UNSIGNED_BYTE 
		(pnm:pgm-xels (aref movie frame)))
  (glutswapbuffers)
  (incf frame)
  (when (= frame movie-length) (setf frame 0))
  (setf end-time (glutGet GLUT_ELAPSED_TIME))
  (setf elapsed-time (- end-time begin-time))
  ;;(format t "Begin-time:~a, Elapsed-time:~a~%" begin-time elapsed-time)
  (cond
    ((> elapsed-time frame-interval)
     (format t "Lagging at frame ~a by ~a ms.~%"
	     frame (- elapsed-time frame-interval))
     (glutTimerFunc 0 timer-callback frame))
    (t
     (glutTimerFunc (- frame-interval elapsed-time)
		    timer-callback frame)))))
(setf display-callback (ff:register-function 'display))

(defun read-pgm-movie (pathname start-frame movie-length)
 (let ((movie (make-array movie-length)))
  (dotimes (frame movie-length)
   (format t "Read ~a~%" frame)
   (let ((filename (format nil "~a_~5,'0d.pgm" pathname
			   (+ frame start-frame))))
    (setf (aref movie frame) (pnm:read-pnm filename))
    (pnm:pgm-flip! (aref movie frame))))
  movie))

(defvar keyboard-callback)
(ff:defun-c-callable keyboard
    ((k :unsigned-byte) (x :fixnum) (y :fixnum))
 ;; Called after any keypress
 ;;(format t "Callback KEYBOARD.  K:~a, X:~a, Y:~a~%" k x y)
 (case (character k)
   (#\Escape
    (glutTimerFunc 0 0 0) ; try to turn off timer func
    (glutDestroyWindow window)
    (break))))
(setf keyboard-callback (ff:register-function 'keyboard))

(defvar timer-callback)
(ff:defun-c-callable timer ((value :fixnum))
 ;;(format t "Callback TIMER. VALUE:~a~%" value)
 (cond ((> value frame)
        (format t "Ignoring event:~a~%" value))
       (t
        (glutPostRedisplay))))
(setf timer-callback (ff:register-function 'timer))

(defvar reshape-callback)
(ff:defun-c-callable reshape ((window-width :fixnum) (window-height :fixnum))
 (format t "Resizing~%")
 (glviewport 0 0 window-width window-height)
 (glmatrixmode GL_PROJECTION)
 (glloadidentity)
 (glortho 0d0 (coerce window-width 'double-float)
          0d0 (coerce window-height 'double-float) -1d0 1d0)
 (glmatrixmode GL_MODELVIEW)
 (setf xzoom (coerce (/ window-width width) 'single-float))
 (setf yzoom (coerce (/ window-height height) 'single-float)))
(setf reshape-callback (ff:register-function 'reshape))

(defun main ()
 (format t "Movie name:")
 (let ((pathname (read-line *standard-input*)))
  ;;
  (format t "Movie length:")
  (setf movie-length (read *standard-input*))
  (setf movie (read-pgm-movie pathname 1 movie-length)))
 (setf width (pnm:pgm-width (aref movie 0)))
 (setf height (pnm:pgm-height (aref movie 0)))
 ;;
 (glutInitDisplayMode (+ GLUT_RGB GLUT_DOUBLE))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize width height)
 (setf window (glutCreateWindow "glmovie"))
 ;;
 (glClearIndex 0.0)
 (glShadeModel GL_FLAT)
 (glclearcolor 0.0 0.0 0.0 1.0)
 ;;
 (setf frame 0)
 (setf frame-interval 33)
 (setf xzoom 1.0)
 (setf yzoom 1.0)
 ;;
 (glutReshapeFunc reshape-callback)
 (glutDisplayFunc display-callback)
 (glutKeyboardFunc keyboard-callback)
 ;;
 (glutMainLoop))
