
(use-package :gl)

;;;
;;; Translation of sphere.c by Brian Paul.
;;;

(ff:defun-c-callable display-callback ()
 ;; Called each time screen is redisplayed
 (format t "Callback DISPLAY.~%")
 (display))

(defun display ()
 (glClear GL_COLOR_BUFFER_BIT)
 (glColor3f 1.0 1.0 1.0)
 (glPushMatrix)
 (glTranslatef 0.0 0.0 -5.0)
 ;; Note: first argument must be double.
 (glutWireSphere 1d0 20 20)
 (glPopMatrix)
 (glFlush))

(ff:defun-c-callable idle-callback ()
 (format t "Callback IDLE.~%"))

(defun myinit ()
 ;; Initialize geometry and/or viewing paramaters.
 (glShadeModel GL_FLAT))

(ff:defun-c-callable keyboard-callback
    ((k :unsigned-byte) (x :fixnum) (y :fixnum))
 ;; Called after any keypress
 (format t "Callback KEYBOARD.  K:~s, X:~s, Y:~s~%" k x y)
 (case (character k)
   (#\Escape
    (glutDestroyWindow *window*)
    (break))))

(ff:defun-c-callable reshape-callback ((w :fixnum) (h :fixnum))
 ;; Called after reshape/expose event (also called when window first
 ;; created?)
 (format t "Callback RESHAPE.~%")
 (reshape w h))

(defun reshape (w h)
 (glViewport 0 0 w h)
 (glMatrixMode GL_PROJECTION)
 (glLoadIdentity)
 ;; Note: all arguments must be double.
 (gluPerspective 60d0 (coerce (/ w h) 'double-float) 1d0 20d0)
 (glMatrixMode GL_MODELVIEW)
 (glutPostRedisplay))

(setq display-callback (ff:register-function 'display-callback))
;;(setq idle-callback (ff:register-function 'idle-callback))
(setq keyboard-callback (ff:register-function 'keyboard-callback))
(setq reshape-callback (ff:register-function 'reshape-callback))

(defun main ()
 (glutInitDisplayMode (+ GLUT_SINGLE  GLUT_RGB))
 (glutInitWindowPosition 0 0)
 (glutInitWindowSize 400 400)
 (setq *window* (glutCreateWindow "sphere"))
 (myinit)

 (glutReshapeFunc reshape-callback)
 (glutDisplayFunc display-callback)
 ;; Idle callback is not needed unless we want to do something like animation.
 ;;(glutIdleFunc idle-callback)
 (glutKeyboardFunc keyboard-callback)

 (glutMainLoop))
