;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: odcl -*-
;;; $Id: index.lisp,v 1.6 2003/03/24 21:51:31 adam Exp $
;;;
;;; Copyright (c) 2002 - 2003 onShore Development, Inc.

(in-package :odcl)

(defvar *indexing-mode* :run)

(defun create-indexed-value (class index-spec &optional cold-boot)
  (destructuring-bind (name index-fn index-args (type &key args (handle-nil :match-all)))
      index-spec
    (let ((index (make-instance type :class class
                                :name name
                                :index-fn index-fn
                                :index-args index-args
                                :handle-nil handle-nil)))
      (init-index index args cold-boot)
      index)))

;; ------------------------------------------------------------
;; indexed-value

(defclass indexed-value ()
  ((index-name :initarg :name
         :initform nil
         :type symbol)
   (class :initarg :class
         :type symbol)
   (handle-nil :initarg :handle-nil
               :initform :match-all)
   (index-fn :initarg :index-fn
             :initform nil)
   (index-args :initarg :index-args
             :initform nil)
   (hash :initform nil)))

(defmethod print-object ((self indexed-value) stream)
  (print-unreadable-object
   (self stream :type t)
   (format stream "~A" (slot-value self 'index-name))))

(defmethod destroy-indexed-value ((self indexed-value))
  nil)

(defmethod init-index ((self indexed-value) initargs cold-boot)
  (declare (ignore initargs cold-boot))
  ;; default (empty) implementation for custom index types
  self)

(defmethod index-set ((self indexed-value) foreign-oid index-value)
  (declare (ignore foreign-oid index-value))
  (error "implement index set for ~s" self)
  nil)

(defmethod index-clear ((self indexed-value) foreign-oid &optional index-value)
  (declare (ignore foreign-oid index-value))
  nil)

(defmethod index-entry-children ((self indexed-value) (index-oid integer))
  nil)

(defmethod index-entry-values ((self indexed-value) (index-oid integer))
  nil)

(defmethod index-browse ((self indexed-value) type query)
  (declare (ignore type query))
  nil)
