#!/bin/sh

echo "making group.";
	niutil -create . /groups/mailtransport;
	niutil -createprop . /groups/mailtransport gid 30;

echo "making user.";
	niutil -create . /users/mailtransport;
	niutil -createprop . /users/mailtransport uid 30;
	niutil -createprop . /users/mailtransport gid 30;
	niutil -createprop . /users/mailtransport shell /bin/tcsh;
	niutil -createprop . /users/mailtransport home /tmp;
	niutil -createprop . /users/mailtransport passwd "*";

echo "making folders and setting permissions.";
	mkdir /var/amavis;
	mkdir /var/amavis/tmp;
	mkdir /var/amavis/db;
	mkdir /var/clamav;
	mkdir /var/log/mailtransport;
	mkdir /var/virusmails;
	touch /var/amavis/whitelist_sender;
	touch /var/log/mailtransport/clamd.log;
	touch /var/log/mailtransport/freshclam.log;
	touch /var/log/mailtransport/amavis.log;
	chown -R mailtransport:mailtransport /var/amavis;
	chmod -R 0750 /var/amavis;
	chown mailtransport:mailtransport /var/virusmails;
	chmod 0750 /var/virusmails;
	chown mailtransport:mailtransport /var/clamav;
	chmod 0750 /var/clamav;
	chown mailtransport /var/log/mailtransport/*;
	chmod 0644 /var/log/mailtransport/*;

echo "moving Log-Roll Item into place.";
	mv logroll/mailtransport /etc/periodic/mailtransport;
	chown -R root:wheel /etc/periodic/mailtransport;
	chmod -R 0755 /etc/periodic/mailtransport;

echo "making Log-Roll link";
	pushd /etc
	ln -s periodic/mailtransport/500.pailtransport mailtransport
	popd

echo "moving Startup Item into place.";
	mv MAILTRANSPORT /System/Library/StartupItems/;
	chown -R root:wheel /System/Library/StartupItems/MAILTRANSPORT;
	chmod -R 0755 /System/Library/StartupItems/MAILTRANSPORT;

echo "Done...";
echo "";

echo "You still need to move and edit your config and postfix files.";
echo "";
