use Language::INTERCAL;
use Language::INTERCAL::Runtime::Library;

my $prog = '
@K@L`@{
@z@L`@{
@@@z
@@@K
@@
';

print "1..24\n";

fiddle Language::INTERCAL 'bug=0', 'ubug=0';
my @foo;

compile Language::INTERCAL 'prog', $prog;
@foo = ();
eval { prog(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 1\n";
print @foo == 2 ? "" : "not ", "ok 2\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 3\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 4\n");

compile Language::INTERCAL 'prog_o', $prog, 'opt';
@foo = ();
eval { prog_o(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 5\n";
print @foo == 2 ? "" : "not ", "ok 6\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 7\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 8\n");

compile Language::INTERCAL 'prog_q', $prog, 'quantum';
@foo = ();
eval { prog_q(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 9\n";
print @foo == 2 ? "" : "not ", "ok 10\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 11\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 12\n");

compile Language::INTERCAL 'prog_p', $prog, 'post';
@foo = ();
eval { prog_p(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 13\n";
print @foo == 2 ? "" : "not ", "ok 14\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 15\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 16\n");

compile Language::INTERCAL 'prog_qp', $prog, 'quantum', 'post';
@foo = ();
eval { prog_qp(0, \&foo) };
print STDERR $@;
print $@ ? "not " : "", "ok 17\n";
print @foo == 2 ? "" : "not ", "ok 18\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 19\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 20\n");

compile Language::INTERCAL 'prog_d', $prog, 'dbhook';
@foo = ();
_run_db(prog_d(0, \&foo));
print STDERR $@;
print $@ ? "not " : "", "ok 21\n";
print @foo == 2 ? "" : "not ", "ok 22\n";
print (shift(@foo) eq "CC\n" ? "" : "not ", "ok 23\n");
print (shift(@foo) eq "XLII\n" ? "" : "not ", "ok 24\n");

sub foo {
    push @foo, join('', @_);
}

