// mkf_extract().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_I_byte.h"


// Implementation.

#include "cln/integer.h"
#include "cl_I.h"
#include "cl_DS.h"

namespace cln {

const cl_I mkf_extract (const cl_I& x, uintL p, uintL q)
{
      CL_ALLOCA_STACK;
      var const uintD* MSDptr;
      var uintC len;
      var const uintD* LSDptr;
      I_to_NDS_nocopy(x, MSDptr=,len=,LSDptr=,cl_true, { return 0; } ); // NDS zu x bilden
      // MSDptr erhhen und len erniedrigen, so da len = ceiling(q/intDsize) wird:
      { var uintL qD = ceiling(q,intDsize); // ceiling(q/intDsize)
        // wegen q<=l ist qD = ceiling(q/intDsize) <= ceiling((l+1)/intDsize) = len, also
        // pat qD ebenso wie len in ein uintC.
        MSDptr = MSDptr mspop ((uintL)len - qD); // MSDptr um len-qD Digits erhhen
        len = qD; // len um len-qD erniedrigen
      }
      // Platz (len Digits) fr die neue UDS bereitstellen:
      var uintD* newMSDptr;
      num_stack_alloc_1((uintL)len, newMSDptr = ,); // Platz belegen
      {var uintL pD = p/intDsize; // floor(p/intDsize), pat in ein uintC
       // Kopiere len-pD Digits aus der DS zu x heraus:
       var uintD* midptr = copy_loop_msp(MSDptr,newMSDptr,len-(uintC)pD);
       // Lsche p-intDsize*floor(p/intDsize) Bits im Digit unterhalb von midptr:
       {var uintL p_D = p%intDsize;
        if (!(p_D==0)) { lspref(midptr,0) &= minus_bit(p_D); }
       }
       // Lsche pD Digits darber:
       clear_loop_msp(midptr,pD);
      }
      // Lsche intDsize*ceiling(q/intDsize)-q Bits im ersten Digit:
      {var uintL q_D = q%intDsize;
#ifdef HAVE_FAST_LONGLONG
       if (!(q_D==0))
         mspref(newMSDptr,0) &= (uintD)((1LL<<q_D)-1); // erase intDsize-q_D bits
#else
       if (!(q_D==0))
         mspref(newMSDptr,0) &= (uintD)((1L<<q_D)-1); // erase intDsize-q_D bits
#endif
      }
      // Jetzt enthlt die UDS newMSDptr/len/.. die extrahierten Bits.
      return UDS_to_I(newMSDptr,len);
}

}  // namespace cln
