/* File: cint.h
 * Description: An interpreter for a small subset of C: type definitions
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef __CMIX
#  define __CMIX(X)
#endif

#ifndef NULL
#  define NULL 0
#endif
#ifndef true
#  define true  (0 == 0)
#  define false (0 != 0)
#endif
#define error printf

typedef int Value;
typedef int boolean;

typedef struct Result {
  Value value;
  boolean  returnAction;
} Result;

typedef const char* Name;

typedef struct Nams {
  const char*  name;
  struct Nams* next;
} Nams;

typedef struct Vals {
  Value        value;
  struct Vals* next;
} Vals;

/*typedef enum ExpTag { Const, Var, UnOp, BinOp } ExpTag;*/
#define ExpTag int
#define Const 0
#define Var   1
#define UnOp  2
#define BinOp 3

/*typedef enum OpTag {
  UnMinus, UnNeg,
  Plus, Minus, Times, Divide,
  EQ, NE, GT, LT, GE, LE,
  Assign
  } OpTag;*/
#define OpTag int
#define UnMinus 0
#define UnNeg   1
#define Plus    2
#define Minus   3
#define Times   4
#define Divide  5
#define EQ      6
#define NE      7
#define GT      8
#define LT      9
#define GE     10
#define LE     11
#define Assign 12

typedef struct Exp {
  ExpTag      tag;
  Value       constValue;
  const char* varName;
  OpTag       operat;
  struct Exp* exp1;
  struct Exp* exp2;
} Exp;

Exp* CONST(Value constValue);

Exp* VAR(const char* varName);

Exp* UNOP(OpTag operat, Exp* exp1);

Exp* BINOP(OpTag operat, Exp* exp1, Exp* exp2);

typedef struct Decl { const char* name; struct Decl* next; } Decl;

Decl* DECL(const char* name, Decl* next);  

/*typedef enum StmtTag {
  Expression, IfElse, While, Return, Compound
  } StmtTag;*/
#define StmtTag int
#define Expression 0
#define IfElse     1
#define While      2
#define Return     3
#define Compound   4

typedef struct Stmt {
  StmtTag tag;
  Exp*    exp;
  Decl*   decls;
  struct Stmt* ifStmt;
  struct Stmt* elseStmt;
  struct Stmt* whileStmts;
  struct Stmt* stmts;
  struct Stmt* next;
} Stmt;

Stmt* EXPRESSION(Exp* exp, Stmt* next);

Stmt* IFELSE(Exp* exp, Stmt* ifStmt, Stmt* elseStmt, Stmt* next);

Stmt* WHILE(Exp* exp, Stmt* whileStmts, Stmt* next);

Stmt* RETURN(Exp* exp, Stmt* next);

Stmt* COMPOUND(Decl* decls, Stmt* stmts, Stmt* next);

typedef struct Formal {
  const char*    name;
  struct Formal* next;
} Formal;

Formal* FORMAL(const char* name, Formal* next);

typedef struct Actual {
  Value          value;
  struct Actual* next;
} Actual;

typedef struct Func {
  char*        name;
  Formal*      params;
  Stmt*        stmts;
  struct Func* next;
} Func;

Func* FUNC(const char* name, Formal* params, Stmt* stmts, Func* next);

typedef struct Prog {
  Func* funcs;
} Prog;

Prog* PROG(Func* funcs);

#pragma cmix pure: DELPROG()
void DELPROG(Prog* p);

#pragma cmix pure: val2boolean()
boolean val2boolean(Value v);
#pragma cmix pure: val2int()
int  val2int (Value v);
#pragma cmix pure: int2val()
Value int2val(int i)  ;

#pragma cmix pure: uminus()
Value uminus  (Value v)           ;
#pragma cmix pure: negate()
Value negate  (Value v)           ;
#pragma cmix pure: plus()
Value plus    (Value v1, Value v2);
#pragma cmix pure: minus()
Value minus   (Value v1, Value v2);
#pragma cmix pure: multiply()
Value multiply(Value v1, Value v2);
#pragma cmix pure: divide()
Value divide  (Value v1, Value v2);
#pragma cmix pure: eq()
Value eq      (Value v1, Value v2);
#pragma cmix pure: ne()
Value ne      (Value v1, Value v2);
#pragma cmix pure: gt()
Value gt      (Value v1, Value v2);
#pragma cmix pure: lt()
Value lt      (Value v1, Value v2);
#pragma cmix pure: ge()
Value ge      (Value v1, Value v2);
#pragma cmix pure: le()
Value le      (Value v1, Value v2);

/*#pragma cmix pure: assign()
Value assign(const char* name, Value v, Nams* names, Vals* values);*/
