/*
 * Time-stamp: <98/10/29 13:38:12 panic>
 * Author:	The C-Mix Project <cmix@diku.dk>
 *              Arne John Glenstrup  <panic@diku.dk>
 * Contents:	Interface between main() and the residual drawscene_res()
 *              whose arity is lower than the source drawscene()
 */

#include <stdio.h>

extern char prg_name[];

int lastscene = 15; /* included only to satisfy main.c */

void drawscene_res(int image_x, int image_y, int use_color);

static void usage() {
  fprintf(stderr,
	  "This ray tracer has been specialized to a specific scene.\n");
  fprintf(stderr,
	  "usage: %s "
#ifdef HAVE_LIBTIFF
	  "[-o filename] [-z] [-p] "
#endif
#ifdef HAVE_LIBSRGP
	  "[-s] "
#endif
	  "[-S size] [-c]\n"
	  "           [-e x,y,z] [-l x,y,z] [-u x,y,z] [-f angle]\n"
#ifdef HAVE_LIBTIFF
	  "       -z: use LZW TIFF file compression\n"
	  "       -p: use PackBits TIFF file compression\n"
#endif
#ifdef HAVE_LIBSRGP
	  "       -s: do not output to screen\n"
#endif
	  "       -c: use colours\n"
	  "       -e: eyepoint\n"
	  "       -l: lookpoint\n"
	  "       -u: up direction\n"
	  "       -f: field of view\n",
	  prg_name);
  exit(-1);
}

void drawscene(int image_x, int image_y, int use_scene, int use_color) {
  if (use_scene == -1)
    drawscene_res(image_x, image_y, use_color);
  else
    usage();
}
