/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      ConnectionView : NSObject <PrefsViewProtocol>
 *
 *  Description:  Connection preferences (name, run on startup, phones, etc.)
 *
 * pppd options:
 *  
 * - call
 * - holdoff
 * connect -------------- Use the executable or shell command specified by
 *                       script to set up the serial line
 * disconnect ----------- Run the executable or shell command specified by
 *                        script after pppd has terminated the link
 * init ----------------- Run  the  executable or shell command specified by
 *                        script to initialize the serial line
 * passive -------------- If no reply is received from the peer, pppd will
 *                        then just wait passively for a valid LCP packet
 *                        from the peer, instead of exiting, as it would
 *                        without this option
 * connect-delay -------- Wait for up n milliseconds after the connect script
 *                        finishes  for a valid PPP packet from the peer
 * idle n --------------- Specifies that pppd should disconnect if the link
 *                        is idle for n seconds
 * maxfail n ------------ Terminate after n consecutive failed attempts.
 *                        0 means no limit.
 * maxconnect n --------- Terminate the connection when it has been available
 *                        for  network  traffic for n seconds
 * ipcp-accept-local
 * ipcp-accept-remote
 * ipcp-max-configure
 * ipcp-max-failure
 * ipcp-max-terminate
 * ipcp-restart
 * llcp-echo-failure
 * lcp-echo-interval
 * lcp-max-configure
 * lcp-max-failure
 * lcp-max-terminate
 * lcp-restart
 * linkname
 * nodetach
 * nopersist
 * persist
 */

#import <Foundation/NSObject.h>

#import "PrefsViewProtocol.h"

@class NSView;
@class NSWindow;
@class NSBox;
@class NSButton;
@class NSTextField;
@class NSPopUpButton;
@class NSImage;
@class NSScrollView;
@class NSTableView;
@class NSTableColumn;
@class NSOpenPanel;

@interface ConnectionView : NSObject <PrefsViewProtocol>
{
  NSView        *view;

  NSTextField         *nameLabel;
  NSTextField         *nameTF;
  NSTextField         *typeLabel;
  NSPopUpButton       *typePop;

  NSBox               *phonesFrame;
  NSScrollView        *phonesScroll;
  NSTableView         *phonesList;
  NSTableColumn       *phonesColumn;
  NSMutableArray      *phonesArray;
  NSButton            *addPhoneButton;
  NSButton            *removePhoneButton;
  NSButton            *upPhoneButton;
  NSButton            *downPhoneButton;
                      
  NSBox               *actionsFrame;
  NSTextField         *onConnectLabel;
  NSTextField         *onConnectTF;
  NSTextField         *onDisconnectLabel;
  NSTextField         *onDisconnectTF;
  NSTextField         *idleLabel;
  NSTextField         *idleTF;
  NSTextField         *secondsLabel;
  NSButton            *advancedButton;
                      
  NSBox               *runFrame;
  NSTextField         *runTF;
  NSButton            *runBrowseButton;
                      
  NSString            *currentType;

  NSMutableDictionary *prefs;
}

- (void) typePopAction: (id)sender;

- (void) setSectionsStatus: (BOOL)enable 
                  forPopUp: (NSPopUpButton *)popup;
                  
//- (void) defaultButtonAction: (id)sender;

@end
